package com.digiwin.athena.semc.service.news;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.dto.news.ThirdNewsAnnouncementReq;
import com.digiwin.athena.semc.entity.news.NewsAnnouncement;
import com.digiwin.athena.semc.vo.news.NewsAnnouncementVO;

import java.util.List;

import io.vavr.Tuple3;

public interface ThirdNewsAnnouncementService {
    /**
     * 校验新闻格式是否正确
     *
     * @param thirdNewsAnnouncementReqs
     * @return
     */
    String checkNewsDateIsValid(List<ThirdNewsAnnouncementReq> thirdNewsAnnouncementReqs);

    /**
     * 保存三方公告
     * @param thirdNewsAnnouncementReqs
     * @param appId
     * @param appCode
     * @param tenantId
     */
    void saveNewsList(List<ThirdNewsAnnouncementReq> thirdNewsAnnouncementReqs,String appId,String appCode,String tenantId, ApplicationTypeEnum applicationType);

    /**
     * 校验三方数据
     *
     * @param thirdNewsAnnouncementReqs
     * @return
     */
    String checkNewsIsValid(List<ThirdNewsAnnouncementReq> thirdNewsAnnouncementReqs);


    /**
     * 查询三方公告
     *
     * @param condition
     * @param pageSize
     * @param pageNum
     * @return
     */
    PageInfoResp<NewsAnnouncementVO> queryThirdNewsListByPage(QueryWrapper<NewsAnnouncement> condition, Integer pageSize, Integer pageNum);

    /**
     * 检查appCode是否存在有效
     *
     * @param appCode
     * @return
     */
    Tuple3<String,String, ApplicationTypeEnum> checkAppCode(String appId, String appCode);

    /**
     * 批量获取当前登录人的三方通告的id
     * @return
     */
    List<NewsAnnouncement> getThirdNewsList(NewsAnnouncement newsAnnouncement);

    /**
     * 三方公告组装SSO，和校验前台能否看到
     * @param newsAnnouncements
     * @return
     */
    List<NewsAnnouncement> buildThirdNewSWithSSO(List<NewsAnnouncement> newsAnnouncements);
}
