package com.digiwin.athena.semc.service.portal;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.FineReportQueryReq;
import com.digiwin.athena.semc.dto.portal.SaveReportUrlParamReq;
import com.digiwin.athena.semc.entity.common.Folder;
import com.digiwin.athena.semc.entity.portal.FineReport;
import com.digiwin.athena.semc.service.common.IFolderDataService;
import com.digiwin.athena.semc.vo.common.BizObjAuthRelVo;
import com.digiwin.athena.semc.vo.common.FolderViewVo;
import com.digiwin.athena.semc.vo.portal.FineReportVo;

import java.util.List;

/**
 * @description: 帆软报表操作接口
 * @createDate: 2023/5/26 13:24
 * @author: sunyfa
 */
public interface IFineReportService extends IFolderDataService, IService<FineReport> {
    /**
     * @description: 新增/修改报表
     * @param
     * @return
     * @author: sunyfa
     */
    void addOrModFineReport(FineReport fineReport, List<BizObjAuthRelVo> org, List<BizObjAuthRelVo> role, List<BizObjAuthRelVo> user);

    /**
     * @description: 删除报表
     * @param
     * @return
     * @author: sunyfa
     */
    void delFineReport(Long id);

    /**
     * @description: 查询当前目录下的所有报表
     * @param
     * @return
     * @author: sunyfa
     */
    List<FineReportVo> qryFineReport(Long folderId);

    /**
     * @description: 查询当前目录下当前用户有权限的帆软报表，需要在链接中拼接用户信息
     * @param
     * @return 
     * @author: sunyfa
     */
    List<FineReportVo> qryCurrentUserFineReport(Long folderId, String empId);

    /**
     * @description: 校验报表是否存在
     * @param
     * @return
     * @author: sunyfa
     */
    boolean isReportExist(int type, FineReportVo fineReportVo);

    /**
     * @description: 查询当前目录下报表的最大顺序
     * @param
     * @return
     * @author: sunyfa
     */
    Integer queryMaxOrder(Long folderId, String tenantId);

    /**
     * @param
     * @return
     * @description: 查询帆软报表的目录
     * @author: sunyfa
     */
    List<FolderViewVo> qryFineReportFolder(Integer scene);

    /**
     * @description: 保存帆软报表链接后缀
     * @param saveReportUrlParamReq 链接后置配置入参
     * @return
     * @author: sungqz
     */
    void saveReportUrlParam(SaveReportUrlParamReq saveReportUrlParamReq);

    /**
     * 构建报表返回列表
     *
     * @param folderList 目录列表
     * @param fineReportList 报表列表
     * @return
     */
    List<FineReportVo> buildFineReportVoList(List<Folder> folderList, List<FineReport> fineReportList);


    /**
     * 帆软报表搜索
     * @param tenantId
     * @param reportPageQueryReq
     * @return
     */
    ResultPageBean fineReportSearch(String tenantId, FineReportQueryReq reportPageQueryReq);

    /**
     * 根据报表id查询具体的报表
     *
     * @param reportId 报表id
     * @param scene 场景
     * @return
     */
    FineReport queryFineReportById(Long reportId, Integer scene);
}
