package com.digiwin.athena.semc.service.portal;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.dto.portal.QueryImportRecordReq;
import com.digiwin.athena.semc.entity.common.ImportRecord;
import com.digiwin.athena.semc.vo.common.ImportRecordResp;
import com.digiwin.athena.semc.vo.portal.ImportExcelVo;
import com.digiwin.athena.semc.vo.portal.ImportLabelExcelVo;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;

import java.io.File;
import java.util.List;

/**
 * @description: 报表导入记录
 * @createDate: 2023/8/15
 * @author: sungqz
 */
public interface IImportRecordService extends IService<ImportRecord> {

    /**
     * 导入记录
     *
     * @param importRecord 导入记录对象
     */
    void insertImportRecord(ImportRecord importRecord);

    /**
     * 下载文件
     *
     * @param fileId 文件id
     * @return
     */
    List<ImportExcelVo> readExcel(String fileId);

    /**
     * 下载用户组件文件
     *
     * @param fileId 文件id
     * @return
     */
    List<ImportLabelExcelVo> readLabelExcel(String fileId);

    /**
     * 上传文件
     *
     * @param file 文件
     * @return
     */
    ShareInfo uploadExcel(File file);

    /**
     * 查询导入记录的操作人列表
     *
     * @return
     */
    List<ImportRecord> queryOperatorList();

    /**
     * 查询导入记录列表
     *
     * @param queryImportRecordReq 查询参数
     * @param  sceneFlag 业务场景标识
     * @return
     */
    PageInfoResp<ImportRecordResp> queryImportRecord(QueryImportRecordReq queryImportRecordReq, Integer sceneFlag);
}