package com.digiwin.athena.semc.service.portal;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.dto.portal.LabelResp;
import com.digiwin.athena.semc.dto.portal.QueryLabelReq;
import com.digiwin.athena.semc.entity.portal.Label;

import java.util.List;


public interface ILabelService extends IService<Label> {

    /**
     * 查询组件列表
     *
     * @param queryLabelReq 请求实体
     * @return
     */
     List<LabelResp> queryLabelList(QueryLabelReq queryLabelReq);

    /**
     * 查询单个组件信息
     *
     * @param labelId 组件id
     * @return
     */
     Label queryLabelInfo(long labelId);

    /**
     * 修改生效状态
     *
     * @param labelId 组件d
     * @param status 状态
     * @return
     */
    int updateLabelStatus(Long labelId, Integer status);
}