package com.digiwin.athena.semc.service.portal;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.dto.portal.AddLogoReq;
import com.digiwin.athena.semc.dto.portal.LogoReq;
import com.digiwin.athena.semc.entity.common.PlatformConfig;
import com.digiwin.athena.semc.entity.portal.Logo;


public interface ILogoService extends IService<Logo> {

    /**
     * 首页添加logo图片
     *
     * @param req 请求实体
     * @return 返回值
     */
    int addLogoPic(AddLogoReq req);

    /**
     * 根据语言环境查询首页logo图片
     *
     * @return logo列表
     */
     String queryLogoByCondition(Integer sceneFlag);

    /**
     * 保存企业标识设置
     * @param req
     * @return
     */
     int saveSett(LogoReq req);

    /**
     * 查询企业标识设置
     * @return
     */
    LogoReq getSett();


    /**
     * 查询登录后企业标识信息
     * @return
     */
    LogoReq querySettInfo();

    /**
     * 查询平台信息
     * @param channel 渠道（平台：platform、地端用户：ground）
     * @return
     */
    PlatformConfig getPlatformConfig(String channel);

    /**
     * 查询登录前平台logo信息
     * @return
     */
    LogoReq queryLoginLogo(String locale,String channel);
}