package com.digiwin.athena.semc.service.portal;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.dto.portal.PreinstalledApplicationConfigUpdateDto;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplication;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplicationInstance;

import java.util.List;
import java.util.Map;

/**
 * @Author: sunyfa
 * @CreateTime: 2023/1/29 10:01
 * @Description: 预装应用service
 * @Version: 1.0
 */
public interface IPreinstalledApplicationService {

    /**
     * 查询预设应用列表
     *
     * @param user 当前登录用户信息
     * @return
     */
    List<PreinstalledApplication> queryPreinstalledAppList(AuthoredUser user);

    /**
     * 查询预设应用详情
     *
     * @param user 当前登录用户信息
     * @param applicationType 应用类型
     * @param preinstalledApplicationId 预设应用id
     * @return
     */
    JSONObject queryPreinstalledAppDetail(AuthoredUser user, String applicationType, long preinstalledApplicationId);

    /**
     * 更新特殊应用的配置详情
     *
     * @param user 当前登录用户信息
     * @param preinstalledApplicationConfigUpdateDto 更新请求体
     */
    void updatePreinstalledAppConfig(AuthoredUser user, PreinstalledApplicationConfigUpdateDto preinstalledApplicationConfigUpdateDto);

    /**
     * 查询所有预设应用列表
     *
     * @param idList 应用id列表
     * @return
     */
    List<PreinstalledApplication> queryPreinstalledApplicationList(List<Long> idList);

    /**
     * 更新应用信息
     *
     * @param idList          应用id列表
     * @param userBindFlag    归户模式
     * @param linkDisplayFlag 是否显示在友情链接 0:否；1:是
     * @return
     */
    public void updateAppInfo(List<Long> idList, Integer userBindFlag, Integer linkDisplayFlag);

    /**
     * 根据应用编码获取预设应用
     * @param applicationCode
     * @return
     */
    PreinstalledApplication  getPreByCode(String applicationCode,String appId);

    /**
     * 查询租户下预设明细信息
     * @param preinstalledId
     */
    PreinstalledApplicationInstance getPreINstance(Long preinstalledId,String extConfig,String appId);


    /**
     * 查询所有预设转map
     * @return
     */
    Map<Long, PreinstalledApplication> getPreInfoMap();


    /**
     * 根据主键查询预设主表信息
     * @param id
     * @return
     */
    PreinstalledApplication getPreApp(Long id);

    /**
     * 删除数据
     *
     * @param idList 主键id
     * @return 返回
     */
    Integer delApplicationInstance (List<Long> idList);

}
