package com.digiwin.athena.semc.service.portal;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.dto.portal.KnowledgeApplicationListReq;
import com.digiwin.athena.semc.dto.portal.KnowledgeApplicationNewDataReq;
import com.digiwin.athena.semc.entity.common.BizObjAuthRel;
import com.digiwin.athena.semc.entity.portal.KnowledgeApplicationRef;

import java.util.List;


public interface IknowledgeApplicationService extends IService<KnowledgeApplicationRef> {

    ResponseBody getKnowledgeApplicationList(KnowledgeApplicationListReq req);

    void batchInsertRecord(List<KnowledgeApplicationNewDataReq> reqList);

    /**
     * 批量给用户授权（取消授权）应用权限
     *
     * @param result 应用列表
     * @param actionType 操作行为，1-删除授权，0-新增授权
     */
    void authorizeUserApp(List<KnowledgeApplicationRef> result, Integer actionType);
}