package com.digiwin.athena.semc.service.portal;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.entity.portal.LabelSystemAuth;
import com.digiwin.athena.semc.vo.common.AuthSystemLabelReq;
import com.digiwin.athena.semc.vo.common.BizObjAuthRelBatchSystemReq;
import com.digiwin.athena.semc.vo.common.UserAuthSystemLabelVo;
import com.digiwin.athena.semc.vo.common.UserSystemLabelVo;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;


public interface LabelSystemAuthService extends IService<LabelSystemAuth> {

    /**
     * 部分操作保存组件权限
     * @param req
     * @return
     */
   Integer saveSystemAuth(BizObjAuthRelBatchSystemReq req);

    /**
     * 全量保存组件权限
     * @param req
     * @return
     */
    Integer saveSystemAuthAll(AuthSystemLabelReq req);


    /**
     * 分页查询组件权限列表
     * @param req
     * @return
     */
    ResultPageBean pageListAuthSystem(AuthSystemLabelReq req) throws ExecutionException, InterruptedException;
    /**
     *查询首页用户组件
     * @return
     */
   List<UserSystemLabelVo>  queryUserLayout();

    /**
     * 获取用户权限内的自定义组件ID
     * @return
     */
   List<Long> getSystemCustom();


    /**
     * 获取登录用户权限sid
     * @param cond
     * @return
     */
    QueryWrapper getUserAuthCon(QueryWrapper cond);

    /**
     * 根据sid获取登录用户权限
     * @param cond
     * @return
     */
    QueryWrapper getUserAuthSidCon(QueryWrapper cond);

    /**
     * 查询对应权限类型的组件列表
     *
     * @param authTypeList 权限类型：1.组织 2.角色 3.用户
     * @return
     */
    List<LabelSystemAuth> queryAuthListByCondition(List<Integer> authTypeList);

    /**
     * 融合权限集合
     *
     * @param labelSystemAuthMap 权限配置表中的权限
     * @param authSystemLabelVo 额外权限
     */
    void addAuthLabelMap(Map<String, LabelSystemAuth> labelSystemAuthMap, UserAuthSystemLabelVo  authSystemLabelVo);
}