package com.digiwin.athena.semc.service.portal;

import com.digiwin.athena.semc.dto.portal.QueryGroupReq;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.vo.portal.GroupRuleResp;
import com.digiwin.athena.semc.vo.portal.GroupRuleValueResp;

import java.util.List;

/**
 * 业务待办处理类
 *
 * @author sungqz
 * @since 2024-07-31
 */
public interface LabelSystemBusinessTodoService {

    /**
     * 查询雅典娜智驱平台分组条件或分组条件值
     *
     * @param queryGroupReq 入参
     * @return 返回
     */
    List<GroupRuleResp> queryAgileGroupList(QueryGroupReq queryGroupReq);

    /**
     * 查询三方应用的分组条件
     *
     * @param queryGroupReq 入参
     * @return 返回
     */
    List<GroupRuleResp> queryThirdGroupList(QueryGroupReq queryGroupReq);

    /**
     * 查询雅典娜智驱平台业务待办数
     *
     * @param clientId 客户端id
     * @param labelSystemData 入参
     * @return 返回
     */
    List<GroupRuleValueResp> queryAgileGroupValueList(String clientId, LabelSystemData labelSystemData);

    /**
     * 查询三方应用的分组条件待办数
     *
     * @param labelSystemData 入参
     * @return 返回
     */
    GroupRuleValueResp queryThirdGroupValueList(LabelSystemData labelSystemData);
}
