package com.digiwin.athena.semc.service.portal;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.semc.dto.fineReport.QueryFineReportUrlReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemCountDataDTO;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;


public interface LabelSystemClickService {


    /**
     * 查询自自定义组件 跳转链接
     *
     * @param systemId 自定义组件id
     * @return 返回对象
     */
    AppLinkDTO queryCustomJumpLink(Long systemId);

    AppLinkDTO buildCustomApp(LabelSystemData systemData);

    /**
     * 获取统计类型跳转链接
     *
     * @param labelSystemCountDataDTO 请求入参
     * @return 返回
     */
    AppLinkDTO queryCountLink(LabelSystemCountDataDTO labelSystemCountDataDTO);

    /**
     * 获取帆软报表链接
     * 调用处：
     * 1、小AI全部报表页面点击，deviceType传1，表示pc端触发
     * 2、移动端后端，deviceType传2，表示移动端触发
     *
     * @param queryFineReportUrlReq 请求入参
     * @return 查询结果
     */
    JSONObject queryFineReportUrl(QueryFineReportUrlReq queryFineReportUrlReq);
}