package com.digiwin.athena.semc.service.portal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.portal.LabelSystemCustomQueryReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemCustomSaveReq;
import com.digiwin.athena.semc.dto.portal.QueryImportRecordReq;
import com.digiwin.athena.semc.entity.portal.LabelSystemCustom;
import com.digiwin.athena.semc.entity.portal.LabelSystemCustomImport;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.vo.common.AuthSystemLabelReq;
import com.digiwin.athena.semc.vo.common.BizObjAuthRelBatchSystemVo;
import com.digiwin.athena.semc.vo.portal.ImportExcelResp;
import com.digiwin.athena.semc.vo.portal.LabelSystemAllVo;
import com.digiwin.athena.semc.vo.portal.SystemCustomExportVo;
import com.digiwin.athena.semc.vo.portal.SystemCustomImportVo;
import org.springframework.http.ResponseEntity;

import java.util.List;


public interface LabelSystemCustomService extends IService<LabelSystemCustom> {

    /**
     * 查询自定义组件列表
     * @param labelSystemCustomQueryReq
     * @return
     */
    ResultPageBean pageQuery(LabelSystemCustomQueryReq labelSystemCustomQueryReq);


    /**
     * 保存自定义组件
     * @param labelSystemCustomSaveReq
     * @return
     */
    ResponseEntity<?> save(LabelSystemCustomSaveReq labelSystemCustomSaveReq);

    /**
     * 删除自定义组件
     * @param idList
     * @return
     */
    ResponseEntity<?> delete(List<Long> idList,Integer clientType);

    /**
     * 查询所有自定义组件
     * @param req
     * @return
     */
    List<LabelSystemCustom> queryCustomSystem(LabelSystemAllVo req);


    /**
     * 导入自定义组件--读取excel数据
     * @param fileId
     * @return
     */
    List<SystemCustomImportVo> readExcel(String fileId);


    /**
     * 导入自定义组件
     * @param customImportVoList
     * @return
     */
    ImportExcelResp importReport(List<SystemCustomImportVo> customImportVoList);

    /**
     * 查询组件导入记录
     * @param queryImportRecordReq
     * @return
     */
    PageInfoResp<LabelSystemCustomImport> queryImportRecord(QueryImportRecordReq queryImportRecordReq);


    /**
     * 导出自定义组件
     * @return
     */
    List<SystemCustomExportVo> exportReport();

    /**
     * 条件查询自定义组件
     * @param req
     * @return
     */
    List<LabelSystemCustom> queryCustomList(LabelSystemAllVo req);

    /**
     * 分页查询预设组件
     * @param idList
     * @param req
     * @return
     */
    Page<BizObjAuthRelBatchSystemVo> pageListCustom(List<Long> idList, AuthSystemLabelReq req,List<Long> permSystemIdList);

    /**
     * 查询源应用为【鼎捷雅典娜APP】的数据源和组件信息
     *
     * @param systemIds 组件id集合
     * @param appCode 【鼎捷雅典娜APP】的应用编码
     * @return 返回
     */
    List<LabelSystemData> queryAthenaAppList(List<Long> systemIds,String appCode);

    ResponseEntity<?> updateState(LabelSystemCustomSaveReq labelSystemCustomSaveReq);

    ResponseEntity<?> query(Integer clientType,Integer isLayout);

}