package com.digiwin.athena.semc.service.portal;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.dto.portal.LabelSystemDataDto;
import com.digiwin.athena.semc.dto.portal.QueryImportRecordReq;
import com.digiwin.athena.semc.dto.portal.QueryLabelSystemReq;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.entity.portal.LabelSystemDataImport;
import com.digiwin.athena.semc.proxy.km.service.model.AppJobDTO;
import com.digiwin.athena.semc.vo.portal.*;
import org.springframework.http.ResponseEntity;

import java.util.List;
import java.util.Map;


public interface LabelSystemDataService extends IService<LabelSystemData> {


    /**
     * 条件查询数据源信息
     * @param req
     * @return
     */
    PageInfoResp<LabelSystemData> queryDataList(QueryLabelSystemReq req);

    /**
     *启用停用数据源
     * @param req
     * @return
     */
    ResponseEntity<?> updateValidStatus(QueryLabelSystemReq req);


    /**
     *删除数据源
     * @param req
     * @return
     */
    ResponseEntity<?> delData(QueryLabelSystemReq req);


    /**
     *保存数据源
     * @param req
     * @return
     */
    ResponseEntity<?> saveData(LabelSystemData req);


    /**
     * 根据ID批量查询数据源信息
     * @param
     * @return
     */
    List<LabelSystemData> queryByIds(List<Long> ids);


    /**
     * 获取SSO中应用被数据源引用的数据源名称集合
     * @return
     */
    List<String>  getDataNameList(Integer dataType,String appCode);


    /**
     * 根据ID批量查询数据源信息
     * @param ids 数据源iD
     * @param isCount 是否需要统计待办数量，true：需要
     * @return
     */
    List<LabelSystemData> queryDataInfoBy(List<Long> ids,Boolean isCount);


    /**
     * 获取数据源和sso信息
     * @param id
     * @return
     */
    LabelSystemDataDto getSystemDataSso(Long id);

    /**
     * 根据应用查询应用下作业信息
     * @param appCode 
     * @param dataSource
     * @param isToGet 是否需要请求三方系统查询
     * @return
     */
    List<AppJobDTO.Job> getAppJobList(String appCode,Integer dataSource,Boolean isToGet,Integer type);

    /**
     * 从sso中获取配置信息
     * @param id 对应id
     * @param dataSource 数据来源 1:b/s 表 2:c/s 表 3:预设表应用 4:IAM接口应用，默认查询4
     * @return
     */
    Map<String,String> getSSoInfo(Long id,Integer dataSource);

    /**
     * 获取数据源涉及的源应用map
     * @return
     */
    LabelSystemDataAppVo getSsoAppMap(List<LabelSystemData> systemDataList);



    /**
     * 获取数据源涉及的源应用map---忽略租户
     * @return
     */
    LabelSystemDataAppVo getSsoAppMapTemp(List<LabelSystemData>  systemDataList);


    /**
     * 导入数据源--读取excel数据
     * @param fileId
     * @return
     */
    List<SystemDataImportVo> readExcel(String fileId);


    /**
     * 导入数据源
     * @param dataImportVoList
     * @return
     */
    ImportExcelResp importReport(List<SystemDataImportVo> dataImportVoList);

    /**
     * 查询数据源导入记录
     * @param queryImportRecordReq
     * @return
     */
    PageInfoResp<LabelSystemDataImport> queryImportRecord(QueryImportRecordReq queryImportRecordReq);


    /**
     * 导出数据源
     * @return
     */
    List<SystemDataExportVo> exportReport();

    /**
     * 导出已对接的作业
     * @return
     */
     List<SystemDataJobExportVo> exportJobList();

    /**
     * 查询作业被引用的数据源
     * @param dataType
     * @param appCode
     * @param workCodeList
     * @return
     */
    List<LabelSystemData> getDataByWork(Integer dataType, String appCode,List<String> workCodeList);

    /**
     * 根据组件id查询数据源信息
     *
     * @param componentSource 组件来源  0：自定义组件 1：预设组件
     * @param systemId 组件id
     * @param tenantId 租户id
     * @return 返回
     */
    List<LabelSystemData> querySystemDataBySystemId(Integer componentSource, List<Long> systemId, String tenantId);
}