package com.digiwin.athena.semc.service.portal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.portal.LabelSystemPreQueryReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemDataSourceUpdateReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemUpdateValidReq;
import com.digiwin.athena.semc.entity.portal.LabelSystemPre;
import com.digiwin.athena.semc.vo.common.AuthSystemLabelReq;
import com.digiwin.athena.semc.vo.common.BizObjAuthRelBatchSystemVo;
import com.digiwin.athena.semc.vo.portal.LabelSystemAllVo;
import com.digiwin.athena.semc.vo.portal.LabelSystemPreCustomVo;
import com.digiwin.athena.semc.vo.portal.ValidLabelRelVO;
import org.springframework.data.mongodb.core.aggregation.ArrayOperators;
import org.springframework.http.ResponseEntity;

import java.util.List;



public interface LabelSystemPreService extends IService<LabelSystemPre> {

    /**
     * 查询预设组件列表
     * @param labelSystemPreQueryReq
     * @return
     */
    ResultPageBean pageQuery(LabelSystemPreQueryReq labelSystemPreQueryReq);

    /**
     *  更新组件数据源
     * @param labelSystemUpdateReq
     * @return
     */
    ResponseEntity<?> updateDataSource(LabelSystemDataSourceUpdateReq labelSystemUpdateReq);


    /**
     * 更新启用停用状态
     * @param id
     * @param validStatus
     * @param componentSource
     * @return
     */
    ResponseEntity<?> updateValidStatus(Long id, Integer validStatus, Integer componentSource,Integer clientType);

    /**
     * 校验自定义组件是否关联门户、菜单、作业工作台
     *
     * @param labelSystemUpdateValidReq 请求入参
     * @return 返回
     */
    ValidLabelRelVO validLabelRel(LabelSystemUpdateValidReq labelSystemUpdateValidReq);

    /**
     * 根据租户初始化租户的预设组件
     *
     * @param clientType 门户端 PC端：0，移动端：1
     * @return 返回
     */
    List<LabelSystemPre> initPreData(Integer clientType);


    /**
     *
     * @param dataType 数据类型（0：待办、1：三方报表、2：新闻公告、3：邮件、4：常用、
     *                 5：收藏、6：全局资讯、7：绩效、8：作业工作台、9：行事历）
     * @return
     */
    LabelSystemPre getPreSystemID(Integer dataType);


    /**
     * 查询预设组件和自定义组件列表
     * @param req
     * @return
     */
    LabelSystemPreCustomVo queryAllSystem(LabelSystemAllVo req);

    /**
     * 根据条件查询预设组件和自定义组件列表
     * @param req 请求入参
     * @return 返回
     */
    LabelSystemPreCustomVo queryAllSystemLabel(LabelSystemAllVo req);

    /**
     * 初始化默认布局涉及的组件
     *
     * @param clientType 门户端 PC端：0，移动端：1
     * @return 返回
     */
    List<LabelSystemPre> initDefPortal(List<Integer> dataCategoryList, Integer clientType);


    /**
     * 修改预设组件待办数据和数据源关联关系
     * @return
     */
    Integer editToDoData(LabelSystemPre req);

    /**
     * 分页查询预设组件
     * @param idList
     * @param req
     * @return
     */
    Page<BizObjAuthRelBatchSystemVo> pageListPre(List<Long> idList,AuthSystemLabelReq req);

    /**
     * 初始化移动端预设组件
     * @return
     */
    List<LabelSystemPre> initMobileLabelSystemPre();
}