package com.digiwin.athena.semc.service.portal;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.entity.portal.LabelSystemSource;

import java.util.List;


public interface LabelSystemSourceService extends IService<LabelSystemSource> {


    /**
     * 查询组件关联的数据源
     * @param systemId
     * @param componentSource
     * @return 数据源id
     */
    List<Long> selectBySystem(Long systemId, Integer componentSource);


    /**
     * 查询预设组件关联的数据源
     * @param dataType
     * @param componentSource
     * @return 数据源id
     */
    List<Long> selectPreSystem(Integer dataType, Integer componentSource);
}