package com.digiwin.athena.semc.service.portal;


import com.digiwin.athena.semc.dto.message.EmailCompanyMappingDeleteReq;
import com.digiwin.athena.semc.dto.message.EmailCompanyMappingReq;
import com.digiwin.athena.semc.dto.message.EmailCompanyMappingSaveOrUpdateReq;
import org.springframework.http.ResponseEntity;



public interface MessageEmailConfigService {

    /**
     *  查询智奇邮件配置列表
     * @param emailCompanyMappingReq
     * @return
     */
    ResponseEntity<?> listMailMessageConfig(EmailCompanyMappingReq emailCompanyMappingReq);

    /**
     *  新增或者编辑智奇邮件配置
     * @param emailCompanyMappingSaveReq
     * @return
     */
    ResponseEntity<?> saveOrUpdate(EmailCompanyMappingSaveOrUpdateReq emailCompanyMappingSaveReq);

    /**
     * 删除智奇邮件配置数据
     * @param deleteReq
     * @return
     */
    ResponseEntity<?> delete(EmailCompanyMappingDeleteReq deleteReq);


    /**
     * 获取邮件未读数
     * @return
     */
    ResponseEntity<?> getUnreadCount();
}
