package com.digiwin.athena.semc.service.portal;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.portal.LabelSystemPreReq;
import com.digiwin.athena.semc.dto.portal.NewsPageQueryResp;
import com.digiwin.athena.semc.dto.portal.NoticePageQueryReq;
import com.digiwin.athena.semc.entity.portal.News;

import java.util.List;
import java.util.Map;

/**
 * 公司新闻(News)表服务接口
 *
 * @author sunyfa
 * @since 2022-12-06 13:38:38
 */
public interface NewsService extends IService<News> {
    /**
     * 处理ESP返回的公司新闻结果
     * 
     * @param result esp返回结果
     * @param eaiSysInfo 系统信息
     * @param newsPageQueryResp 公司新闻响应对象
     * @param qryCondition 查询条件
     * @return 当前系统匹配的公司新闻数据
     */
    List<News> handleEspResult(Map<String, Object> result, NoticePageQueryReq.EaiSysInfo eaiSysInfo,
                               NewsPageQueryResp newsPageQueryResp, String qryCondition);

    /**
     * 查询通知公告数据
     *
     * @param noticePageQueryReq 请求参数
     * @return 返回对象
     */
    ResultPageBean pageQueryNews(LabelSystemPreReq noticePageQueryReq);
}
