package com.digiwin.athena.semc.service.portal;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.portal.LabelSystemPreReq;
import com.digiwin.athena.semc.dto.portal.NoticePageQueryReq;
import com.digiwin.athena.semc.dto.portal.NoticePageQueryResp;
import com.digiwin.athena.semc.entity.portal.Notice;

import java.util.List;
import java.util.Map;

/**
 * 公告服务接口
 *
 * @author sunyfa
 * @since 2022-12-06 13:38:38
 */
public interface NoticeService extends IService<Notice> {
    /**
     * 处理ESP返回的通知公告结果
     * 
     * @param result ESP查询结果
     * @param eaiSysInfo 系统消息
     * @param qryCondition 查询条件
     * @param noticePageQueryResp 通知公告响应对象
     * @return 当前系统的所有的通知公告数据
     */
    List<Notice> handleEspResult(Map<String, Object> result, NoticePageQueryReq.EaiSysInfo eaiSysInfo,
        String qryCondition, NoticePageQueryResp noticePageQueryResp);

    /**
     * 查询公司新闻数据
     *
     * @param noticePageQueryReq 请求参数
     * @return 返回对象
     */
    ResultPageBean pageQueryNotice(LabelSystemPreReq noticePageQueryReq);
}
