package com.digiwin.athena.semc.service.portal;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.portal.*;
import com.digiwin.athena.semc.entity.portal.PortalInfo;
import com.digiwin.athena.semc.entity.portal.PortalInfoUse;
import com.digiwin.athena.semc.vo.portal.PortalInfoAuthReq;
import com.digiwin.athena.semc.vo.portal.PortalInfoAuthResp;
import com.digiwin.athena.semc.vo.portal.PortalUserAuthResp;
import org.springframework.http.ResponseEntity;

import java.util.List;

public interface PortalInfoService extends IService<PortalInfo> {

    /**
     * 条件查询
     *
     * @param req
     * @return
     */
    List<PortalInfo> checkPortal(PortalInfo req);

    boolean checkISVPortal(List<Long> portalIds);


    /**
     * 保存
     *
     * @param req
     * @return
     */
    Integer savePortal(PortalInfo req);

    /**
     * 分页查询门户列表
     *
     * @param req
     * @return
     */
    ResultPageBean pageQuery(PortalInfoQueryReq req);


    /**
     * 批量更新
     *
     * @param req
     * @return
     */
    Integer updateBat(PortalInfoQueryReq req);

    /**
     * 批量删除
     *
     * @param req
     * @return
     */
    Integer delBat(PortalInfoQueryReq req);

    /**
     * 保存权限
     *
     * @param req
     * @return
     */
    Integer savePortalAuth(PortalInfoAuthReq req);

    /**
     * 获取门户权限信息
     *
     * @param portalId
     * @return
     */
    PortalInfoAuthResp selectByPortalAuth(Long portalId);

    /**
     * 查询用户权限内的职能门户
     *
     * @param clientType 客户端类型 PC端：0，移动端：1
     * @return
     */
    List<PortalUserAuthResp> selectUserPortal(Integer clientType);


    /**
     * 获取门户详情
     *
     * @param portalInfo
     * @return
     */
    ResponseEntity<?> getPortalInfo(PortalInfo portalInfo);

    /**
     * 获取门户详情
     *
     * @param portalInfo
     * @return
     */
    ResponseEntity<?> getPortalDetail(PortalInfo portalInfo);

    /**
     * 获取门户详情-忽略租户
     *
     * @return
     */
    PortalInfo getTempPortal(Long id);

    /**
     * 校验门户权限
     *
     * @param portalInfo
     * @return
     */
    ResponseEntity<?> checkPortalInfo(PortalInfo portalInfo);

    /**
     * 查询菜单模板关联的门户
     *
     * @param menuTempIdList 菜单模板id
     * @return 返回
     */
    List<PortalInfo> queryPortalByMenuTempId(List<Long> menuTempIdList);

    /**
     * 查询用户最近使用的门户
     * @param clientType 客户端类型 PC端：0，移动端：1
     *
     * @return
     */
    public PortalInfoUse getUserUsePortal(Integer clientType);

    /**
     * 记录用户使用门户记录
     *
     * @param portId 门户 主键Id或 设计时Id
     * @param clientType 客户端类型 PC端：0，移动端：1
     * @param portalTypeSource 门户类型来源，0：租户门户，1：ISV门户
     */
    void addUseRecord(Long portId, Integer clientType, Integer portalTypeSource);

    /**
     * 记录用户使用门户记录
     *
     * @param req
     */
    void addUseRecordByMobile(AddUseRecordRequest req);

    /**
     * 查询门户中轮播图关联跳转的目标下拉框值
     *
     * @param isvDesign 0：租户门户，1：ISV门户
     * @return
     */
    List<PortalSelectOptionRespDTO> queryLinkList(Integer isvDesign);

    /**
     * 校验链接选项的权限
     *
     * @param req
     * @return
     */
    WebLinkPermissionDTO checkLinkPerm(WebLinkPermissionDTO req);

    /**
     * 根据ISV设计时门户id查询门户信息
     *
     * @param designerId isv设计时门户id
     * @return 返回
     */
    PortalInfo queryPortalInfoByDesignerId(Long designerId);

    /**
     * 复制门户
     *
     * @param portalId 旧门户id
     * @param oldPortalFlag 是否是旧移动门户
     * @return
     */
    ResponseEntity<?> copyPortal(Long portalId, Boolean oldPortalFlag);

    /**
     * 获取用户移动门户信息
     *
     * @param req
     * @return
     */
    PortalInfo getUserMobilePortalInfo(UserPortalInfoRequest req);

    /**
     * 获取用户移动门户详情
     *
     * @param portalInfo
     * @return
     */
    PortalInfo getUserMobilePortalDetail(PortalInfo portalInfo);

    /**
     * 获取预览门户信息
     *
     * @param previewId 预览id
     * @return
     */
    PortalInfo getPreMobilePortal(Long previewId);

    /**
     * 获取pc门户详情
     *
     * @param portalInfo 门户信息
     * @return
     */
    PortalInfo getMobilePortalDetail(PortalInfo portalInfo);

    PortalInfoUse getUserPortal();

    /**
     * 获取默认门户
     */
    PortalInfo getDefaultPortal();
}