package com.digiwin.athena.semc.service.portal;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.common.ResultBean;
import com.digiwin.athena.semc.dto.portal.PortalLayoutCustomReq;
import com.digiwin.athena.semc.entity.portal.PortalLayoutCustom;
import org.springframework.http.ResponseEntity;

import java.util.List;


public interface PortalLayoutCustomService extends IService<PortalLayoutCustom> {

    /**
     *  查询门户布局
     * @return
     */
    ResultBean queryPortalLayout();

    /**
     * 保存布局组件
     * @param portalLayoutCustomReq
     * @return
     */
    ResponseEntity<?> save(PortalLayoutCustomReq portalLayoutCustomReq);


    /**
     * 删除组件
     * @param id
     * @return
     */
    ResponseEntity<?> delete(Long  id);

    /**
     * 初始化租户门户布局（待办、收藏、常用）
     * @return
     */
    List<PortalLayoutCustom> initPortalLayout();

}