package com.digiwin.athena.semc.service.portal;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.dto.portal.VisitPortalReq;
import com.digiwin.athena.semc.entity.portal.PortalVisit;

import java.util.List;

/**
 * 门户访问记录接口
 *
 * @author sungqz
 * @since 2025-09-18
 */
public interface PortalVisitService extends IService<PortalVisit> {

    /**
     * 查询门户访问记录
     *
     * @param clientType 客户端类型 0：PC端 1：移动端
     * @param visitType 访问类型，0：访问首页门户 1：访问管理后台门户
     * @return 返回
     */
    List<PortalVisit> queryPortalVisitList(Integer clientType, Integer visitType);

    /**
     * 记录ISV门户的访问记录
     *
     * @param visitPortalReq 请求对象
     */
    void recordVisit(VisitPortalReq visitPortalReq);
}
