package com.digiwin.athena.semc.service.portal;

import com.digiwin.athena.semc.proxy.cac.service.CacService;
import com.digiwin.athena.semc.proxy.cac.service.dto.TenantAppDTO;
import com.digiwin.athena.semc.proxy.cac.service.dto.TenantAuthAppDTO;
import com.digiwin.athena.semc.proxy.km.service.KmService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Service
public class RelatedAppServiceWrapper {
    @Autowired
    private RelatedAppService relatedAppService;

    @Autowired
    private KmService kmService;

    @Autowired
    private CacService cacService;

    /**
     * 查询当前租户购买应用集合所关联的门户设计时ID集合
     *
     * @param version 数据版本
     * @return 门户设计时ID集合
     */
    public List<Long> queryCurrTenantPortalList(String version) {
        // 查询租户购买的应用列表
        TenantAuthAppDTO tenantAuthApp = cacService.queryTenantApp(0);
        if (null == tenantAuthApp || CollectionUtils.isEmpty(tenantAuthApp.getAuthorizations())) {
            return new ArrayList<>();
        }

        String tenantVersion = StringUtils.isEmpty(version) ? kmService.queryTenantVersionWithDefault() : version;
        Set<String> appCodes = tenantAuthApp.getAuthorizations().stream().map(TenantAppDTO::getCode).collect(Collectors.toSet());
        // 去workbench_related_app表中查询工作台应用列表
        return relatedAppService.queryPortalList(appCodes, tenantVersion);
    }
}
