package com.digiwin.athena.semc.service.portal;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.dto.message.DeleteMessageConfigReq;
import com.digiwin.athena.semc.dto.message.QueryThirdMessageConfigReq;
import com.digiwin.athena.semc.entity.portal.ThirdTodoConfig;


public interface ThirdTodoConfigService extends IService<ThirdTodoConfig> {


    /**
     * 保存/编辑待办配置
     * @param req
     * @return
     */
    Integer saveThirdToDo(ThirdTodoConfig req);



    /**
     * 删除待办配置
     * @param req
     * @return
     */
    Integer delThirdToDo(DeleteMessageConfigReq req);



    /**
     * 查询异构系统的作业配置
     *
     * @param queryImportRecordReq 查询参数
     * @return
     */
    PageInfoResp<ThirdTodoConfig> queryConfigPage(QueryThirdMessageConfigReq queryImportRecordReq);



    /**
     * 校验应用是否已经存在
     *
     * @param req 请求入参
     * @return
     */
    boolean validConfigExist(ThirdTodoConfig req);



    /**
     * 查询应用配置信息
     * @param appCode 应用编码
     * @param appId 应用注册时生成的appId
     * @return
     */
    ThirdTodoConfig getToDoConfigBy(String appCode,String appId);
}