package com.digiwin.athena.semc.service.portal;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.dto.portal.*;
import com.digiwin.athena.semc.dto.portal.todo.TodoFounderDto;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.entity.portal.TodoList;
import org.springframework.http.ResponseEntity;
import com.digiwin.athena.semc.vo.maycur.MaycurTodoNoticeReq;

import javax.validation.Valid;
import java.util.List;
import java.util.Map;

/**
 * 待办列表(TodoList)表服务接口
 *
 * @author sunyfa
 * @since 2022-12-06 13:48:51
 */
public interface TodoListService extends IService<TodoList> {
    /**
     * 1.根据待办人查询上次待办的数据
     * 2.根据待办ID标识本次查询的待办哪些是新增
     * 3.删除上次待办数据，插入本地待办数据
     * 4.当前在待办页签，更新最新的浏览时间
     * 
     * @param eaiSys 注册的应用
     * @param result 调用ESP返回的数据结果
     * @return 待办返回对象
     */
    TodoListResp handleEspResult(AuthoredUser user, TodoListReq.EaiSys eaiSys, Map<String, Object> result, String qryCondition, LabelSystemDataDto labelSystemDataDto);

    /**
     * @description: 帅选带条件时，根据条件查询本地数据做过滤
     * @param eaiSys 查询的系统
     * @param condition 条件
     * @return 筛选过的待办返回对象
     * @author: sunyfa
     */
    TodoListResp localSearch(AuthoredUser user, TodoListReq.EaiSys eaiSys, String condition);


    /**
     * 通过接口查询三方待办数据
     * @param todoListReq
     * @return
     */
    TodoListResp pageQueryTodo(LabelSystemPreReq todoListReq);



    /**
     * 查询数据库中三方待办数据
     * @param req
     * @return
     */
    TodoListResp selectTodoList(PreSystemToDoReq req);


    /**
     * 获取跳转的 url
     * @param reimburseReq
     * @return
     */
    ResponseEntity<?> getTodoListUrl(ReimburseReq reimburseReq);

    /**
     * 接收三方待办数据
     * @param receiveDto
     * @return
     */
    Integer toDoReceive(TodoReceiveDto receiveDto);


    /**
     * 接收每刻报销待办通知
     * @param req
     * @return
     */
    Integer approvalsNotice(MaycurTodoNoticeReq req);

    /**
     * 查询三方待办未处理数及未读数
     *
     * @param systemDataList 数据源信息
     * @return
     */
    JSONObject queryToDoCount(List<LabelSystemData> systemDataList);

    /**
     * 同步三方待办数据
     * @param req
     * @return
     */
    ResponseEntity<?> syncThirdTodoData(PreSystemToDoUpdateReq req);

    TodoCountResp selectTodoCount(PreSystemToDoCountReq req);

    List<LabelSystemData> searchTodoApp(@Valid PreSystemToDoSearchAppReq req);

}
