package com.digiwin.athena.semc.service.portal.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.semc.entity.common.CompanyFactory;
import com.digiwin.athena.semc.entity.machine.UserCompanyFactory;
import com.digiwin.athena.semc.mapper.portal.CompanyFactoryMapper;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.iam.service.model.OrgAspectDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.UserOrgDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.UserOrgInfoDTO;
import com.digiwin.athena.semc.proxy.trans.service.TranslateService;
import com.digiwin.athena.semc.service.portal.CloudNavigationService;
import com.digiwin.athena.semc.util.Utils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.digiwin.athena.semc.util.Utils.getTenantId;

@Service
public class CloudNavigationServiceImpl implements CloudNavigationService {

    @Resource
    private CompanyFactoryMapper companyFactoryMapper;

    @Resource
    private IamService iamService;

    @Resource
    private TranslateService translateService;


    @Override
    public List<JSONObject> getCompanyFactoryList() {
        String userId = Utils.getUserId();
        List<JSONObject> resultList = new ArrayList<>();
        //先查询本地
        CompanyFactory companyFactoryVo = getCompanyFactory(userId);
        //本地是否有数据
        Boolean flag = false;
        if (!ObjectUtils.isEmpty(companyFactoryVo)) {
            flag = true;
        }
        //从iam获取数据
        com.alibaba.fastjson.JSONArray defaultOrgAspect = iamService.getCompanyFactory();
        //finalFlag代表本地，本地若无数据，则所有selected都未false。
        Boolean finalFlag = flag;
        //提取加工数据
        defaultOrgAspect.forEach(x -> {
            JSONObject data = JSONObject.fromObject(x);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", data.get("id").toString());
            jsonObject.put("type", data.get("type").toString());
            String title = translateService.translateTextCache(data.get("title").toString(), org.apache.commons.lang3.StringUtils.EMPTY);
            jsonObject.put("title", StringUtils.isEmpty(title) ? data.get("title").toString() : title);
            if (finalFlag) {
                if (StringUtils.hasText(companyFactoryVo.getCompany()))
                    jsonObject.put("selected", companyFactoryVo.getCompany().equals(jsonObject.get("id")) ? true : false);
            } else {
                jsonObject.put("selected", false);
            }
            if (data.containsKey("children")) {
                JSONArray children = data.getJSONArray("children");
                JSONArray jsonArray = new JSONArray();
                children.forEach(item -> {
                    JSONObject childData = (JSONObject) item;
                    JSONObject childJson = new JSONObject();
                    childJson.put("id", childData.get("id").toString());
                    childJson.put("type", childData.get("id").toString());
                    String childTitle = translateService.translateTextCache(childData.get("title").toString(), org.apache.commons.lang3.StringUtils.EMPTY);
                    childJson.put("title", StringUtils.isEmpty(childTitle) ? childData.get("title").toString() : childTitle);
                    //若公司别没有被选中，则无需判断厂别，直接设置为false
                    if (Boolean.TRUE == jsonObject.get("selected")) {
                        if (finalFlag) {
                            if (StringUtils.hasText(companyFactoryVo.getFactory()))
                                childJson.put("selected", companyFactoryVo.getFactory().equals(childJson.get("id")) ? true : false);
                        } else {
                            childJson.put("selected", false);
                        }
                    } else {
                        childJson.put("selected", false);
                    }
                    jsonArray.add(childJson);
                });
                jsonObject.put("children", jsonArray);
            }
            resultList.add(jsonObject);
        });

        return resultList;
    }

    @Override
    public List<UserCompanyFactory> getCompanyFactoryList2() {
        String userId = Utils.getUserId();
        String userToken = Utils.getUserToken();
        List<UserCompanyFactory> resultList = new ArrayList<>();

        // 获取租户的全部组织信息
        List<OrgAspectDTO> allOrgAspect = iamService.getOrgAspect();
        if (CollectionUtils.isEmpty(allOrgAspect)) {
            return resultList;
        }

        // 查询用户所在组织
        UserOrgInfoDTO userOrgInfoDTO = iamService.qryUserOrgInfo(userId, userToken);
        if (ObjectUtils.isEmpty(userOrgInfoDTO) || CollectionUtils.isEmpty(userOrgInfoDTO.getUserInOrgs())) {
            return resultList;
        }

        // 构建 OrgAspect 映射，便于快速查找
        Map<Long, OrgAspectDTO> orgAspectMap = allOrgAspect.stream().collect(Collectors.toMap(OrgAspectDTO::getSid, Function.identity(), (v1, v2) -> v1));

        // 用户所在的所有组织
        List<UserOrgDTO> userInOrgs = userOrgInfoDTO.getUserInOrgs();
        // 过滤出用户拥有的公司和工厂
        List<UserOrgDTO> userCompanies = userInOrgs.stream()
                .filter(org -> "drn:iam:orgtype:defaultOrgCatalog:company".equals(org.getOrgTypeUri()))
                .collect(Collectors.toList());
        List<UserOrgDTO> userFactories = userInOrgs.stream()
                .filter(org -> "drn:iam:orgtype:defaultOrgCatalog:factory".equals(org.getOrgTypeUri()))
                .collect(Collectors.toList());

        // 公司 -> 工厂映射
        Map<Long, List<UserCompanyFactory>> companyToFactories = new HashMap<>();

        // 第一步：处理用户直接拥有权限的公司及其下属工厂
        for (UserOrgDTO company : userCompanies) {
            List<UserCompanyFactory> factories = new ArrayList<>();
            for (OrgAspectDTO org : allOrgAspect) {
                if ("drn:iam:orgtype:defaultOrgCatalog:factory".equals(org.getTypeUri())
                        && company.getOrgSid().equals(org.getParentSid())) {
//                    String title = translateService.translateTextCache(org.getName(), "");
//                    title = StringUtils.hasLength(title) ? title : org.getName();
                    factories.add(new UserCompanyFactory(org.getSid(), org.getLabel(), org.getLabel(), org.getName()));
                }
            }
            if (!factories.isEmpty()) {
                companyToFactories.put(company.getOrgSid(), factories);
            }
        }

        // 第二步：处理用户直接拥有权限的工厂，并关联其所属公司
        for (UserOrgDTO factory : userFactories) {
            // 工厂
            OrgAspectDTO factoryOrg = orgAspectMap.get(factory.getOrgSid());
            if (factoryOrg == null) {
                continue;
            }
            // 公司
            OrgAspectDTO parentOrg = orgAspectMap.get(factoryOrg.getParentSid());
            if (parentOrg == null || !"drn:iam:orgtype:defaultOrgCatalog:company".equals(parentOrg.getTypeUri())) {
                continue;
            }
            // 关联 company -> factory 去重
            List<UserCompanyFactory> factories = companyToFactories.computeIfAbsent(parentOrg.getSid(), k -> new ArrayList<>());
            if (factories.stream().noneMatch(f -> f.getSid().equals(factoryOrg.getSid()))) {
//                String title = translateService.translateTextCache(factoryOrg.getName(), "");
//                title = StringUtils.hasLength(title) ? title : factoryOrg.getName();
                factories.add(new UserCompanyFactory(factoryOrg.getSid(), factoryOrg.getLabel(), factoryOrg.getLabel(), factoryOrg.getName()));
            }
        }

        // 构造最终结果
        for (Map.Entry<Long, List<UserCompanyFactory>> entry : companyToFactories.entrySet()) {
            OrgAspectDTO companyOrg = orgAspectMap.get(entry.getKey());
            if (companyOrg == null) {
                continue;
            }
            List<UserCompanyFactory> factories = entry.getValue();
//            String title = translateService.translateTextCache(companyOrg.getName(), "");
//            title = StringUtils.hasLength(title) ? title : companyOrg.getName();
            resultList.add(new UserCompanyFactory(companyOrg.getSid(), companyOrg.getLabel(), companyOrg.getLabel(), companyOrg.getName(), factories));
        }
        // 排序 按 ID（编号） 升序
        resultList.sort(Comparator.comparing(UserCompanyFactory::getId));
        resultList.forEach(company -> company.getChildren().sort(Comparator.comparing(UserCompanyFactory::getId)));

        // 用户选择的公司别/厂别
        CompanyFactory companyFactoryVo = getCompanyFactory(userId);
        if (!ObjectUtils.isEmpty(companyFactoryVo)) {
            resultList.forEach(company -> {
                if (company.getId().equals(companyFactoryVo.getCompany())) {
                    company.setSelected(true);
                    company.getChildren().forEach(factory -> {
                        if (factory.getId().equals(companyFactoryVo.getFactory())) {
                            factory.setSelected(true);
                        }
                    });
                }
            });
        }
        return resultList;
    }

    /***
     * 保存或者更新公司别产别
     * @param companyFactoryVO
     */
    @Override
    public void saveOrUpdateCompanyOrFactory(CompanyFactory companyFactoryVO) {
//        flag为false则为新增，否则问修改
        boolean flag = false;
        LambdaQueryWrapper<CompanyFactory> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(CompanyFactory::getTenantId, getTenantId())
                .eq(CompanyFactory::getCreateUserId, Utils.getUserId());
        CompanyFactory cfv = companyFactoryMapper.selectOne(wrapper);
        if (null != cfv) {
            flag = true;
            companyFactoryVO.setId(cfv.getId());
        }
        if (flag) {
            //修改
            companyFactoryMapper.updateById(companyFactoryVO);
        } else {
            //新增
            companyFactoryMapper.insert(companyFactoryVO);
        }
    }

    /***
     * 查询数据库的公司别/厂别
     * @param createUserId
     * @return
     */
    public CompanyFactory getCompanyFactory(String createUserId) {
        if (!StringUtils.hasText(createUserId))
            return null;
        LambdaQueryWrapper<CompanyFactory> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(CompanyFactory::getCreateUserId, createUserId);
        return companyFactoryMapper.selectOne(wrapper);
    }


}
