package com.digiwin.athena.semc.service.portal.impl;


import com.digiwin.athena.semc.proxy.eoc.service.model.UserDeptDTO;
import com.digiwin.athena.semc.proxy.eoc.service.model.UserInfoDetailDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.RoleDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.UserOrgDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.UserOrgInfoDTO;
import com.digiwin.athena.semc.proxywrapper.IamUserService;
import com.digiwin.athena.semc.proxywrapper.dto.IamUserAuthInfo;
import com.google.common.base.Joiner;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.MaycurCodeEnum;
import com.digiwin.athena.semc.common.enums.PreinstalledApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.VirtualApplicationEnum;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.erpsso.QuerySsoListReq;
import com.digiwin.athena.semc.entity.applink.TenantAppDTO;
import com.digiwin.athena.semc.entity.portal.LabelSystemAuth;
import com.digiwin.athena.semc.entity.portal.LabelSystemCustom;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.entity.portal.LabelSystemPre;
import com.digiwin.athena.semc.entity.portal.LabelSystemSource;
import com.digiwin.athena.semc.entity.portal.PortalLayoutCustom;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplication;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplicationInstance;
import com.digiwin.athena.semc.entity.sso.ErpSsoInfo;
import com.digiwin.athena.semc.entity.sso.ThirdSsoInfo;
import com.digiwin.athena.semc.mapper.portal.LabelSystemAuthMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemCustomMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemDataMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemPreMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemSourceMapper;
import com.digiwin.athena.semc.mapper.portal.PreinstalledApplicationMapper;
import com.digiwin.athena.semc.mapper.sso.ErpSsoInfoMapper;
import com.digiwin.athena.semc.mapper.sso.ThirdSsoInfoMapper;
import com.digiwin.athena.semc.proxy.athena.service.atmc.AtmcService;
import com.digiwin.athena.semc.proxy.athena.service.atmc.model.GroupRuleDTO;
import com.digiwin.athena.semc.proxy.eoc.service.EocService;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.trans.service.TranslateService;
import com.digiwin.athena.semc.service.mobile.MobileUserAuthService;
import com.digiwin.athena.semc.service.portal.IPreinstalledApplicationService;
import com.digiwin.athena.semc.service.portal.LabelSystemAuthService;
import com.digiwin.athena.semc.service.portal.LabelSystemCustomService;
import com.digiwin.athena.semc.service.portal.LabelSystemPreService;
import com.digiwin.athena.semc.service.portal.PortalLayoutCustomService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.common.AuthSystemLabelReq;
import com.digiwin.athena.semc.vo.common.BizObjAuthRelBatchSystemReq;
import com.digiwin.athena.semc.vo.common.BizObjAuthRelBatchSystemVo;
import com.digiwin.athena.semc.vo.common.UserAuthSystemLabelVo;
import com.digiwin.athena.semc.vo.common.UserSystemLabelVo;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;


@Slf4j
@Service
public class LabelSystemAuthServiceImpl extends ServiceImpl<LabelSystemAuthMapper, LabelSystemAuth> implements LabelSystemAuthService {

    @Autowired
    LabelSystemAuthMapper labelSystemAuthMapper;

    @Resource
    private TranslateService translateService;

    @Resource
    private LabelSystemPreService labelSystemPreService;

    @Resource
    private LabelSystemCustomService labelSystemCustomService;

    @Autowired
    LabelSystemPreMapper labelSystemPreMapper;
    @Resource
    LabelSystemCustomMapper labelSystemCustomMapper;
    @Resource
    LabelSystemSourceMapper labelSystemSourceMapper;
    @Resource
    LabelSystemDataMapper labelSystemDataMapper;
    @Resource
    private IamService iamService;
    @Resource
    private EocService eocService;
    @Resource
    private PortalLayoutCustomService portalLayoutCustomService;

    @Resource
    ErpSsoInfoMapper erpSsoInfoMapper;
    @Resource
    ThirdSsoInfoMapper thirdSsoInfoMapper;
    @Resource
    PreinstalledApplicationMapper preinstalledApplicationMapper;
    @Resource
    IPreinstalledApplicationService preinstalledApplicationService;
    @Resource
    private AtmcService atmcService;

    @Resource(name = "semcAsyncExecutor")
    private Executor asyncTaskExecutor;

    @Autowired
    private MobileUserAuthService mobileUserAuthService;

    @Resource
    private IamUserService iamUserService;

    @Override
    @Transactional
    public Integer saveSystemAuth(BizObjAuthRelBatchSystemReq req) {

        List<BizObjAuthRelBatchSystemReq.AuthVO> authList = req.getAuthList();
        // 插入权限对象绑定的组件
        List<LabelSystemAuth> bizObjAuthRelList = new ArrayList<>();
        authList.forEach(authVO -> {
            for (BizObjAuthRelBatchSystemReq.LabelVO labelVO : req.getLabelList()) {
                LabelSystemAuth bizObjAuthRel = new LabelSystemAuth();
                bizObjAuthRel.setAuthId(authVO.getAuthId());
                bizObjAuthRel.setAuthType(authVO.getAuthType());
                bizObjAuthRel.setAuthName(authVO.getAuthName());
                bizObjAuthRel.setLabelId(labelVO.getLabelId());
                bizObjAuthRel.setLabelType(labelVO.getLabelType());
                //需要删除的组件
                if (null != labelVO.getIsRelated() && !labelVO.getIsRelated()) {
                    delSystemAuth(authVO.getAuthId(), authVO.getAuthType(), labelVO.getLabelId(), labelVO.getLabelType());
                    continue;
                }
                //查询是否存在
                List<LabelSystemAuth> dbSystemAuthList = getSystemAuth(authVO.getAuthId(), authVO.getAuthType(), labelVO.getLabelId(), labelVO.getLabelType());
                //需要新增的数据
                if ((null == labelVO.getIsRelated() || labelVO.getIsRelated()) && CollectionUtils.isEmpty(dbSystemAuthList)) {
                    bizObjAuthRelList.add(bizObjAuthRel);
                }

            }
        });
        if (CollectionUtils.isNotEmpty(bizObjAuthRelList)) {
            saveBatch(bizObjAuthRelList);
        }
        return null;
    }

    @Override
    public Integer saveSystemAuthAll(AuthSystemLabelReq req) {
        //全部解除关联
        if(!req.getIsRelated()){
            return labelSystemAuthMapper.delLabelAuth(req.getAuthId());
        }
        //批量关联组件
        //查询预设组件 和自定义组件
        List<BizObjAuthRelBatchSystemVo> systemVoList = labelSystemAuthMapper.selectByLabelList(Utils.getTenantId());
        if(CollectionUtils.isEmpty(systemVoList)){
            return null;
        }
        //查询已存在的关联
        List<LabelSystemAuth> systemAuthList=labelSystemAuthMapper.selectByAuth(req.getAuthId());
        //key：组件类型_组件ID，val：组件权限
        Map<String,List<LabelSystemAuth>> systemAuthMap=new HashMap<>();
        if(CollectionUtils.isNotEmpty(systemAuthList)){
            systemAuthMap=systemAuthList.stream().collect(Collectors.groupingBy(x -> x.getLabelType() + "-" + x.getLabelId()));
        }
        //待插入的权限
        List<LabelSystemAuth> insertAuthList=new ArrayList<>();
        for(BizObjAuthRelBatchSystemVo systemVo:systemVoList){
            LabelSystemAuth bizObjAuthRel = new LabelSystemAuth();
            bizObjAuthRel.setAuthId(req.getAuthId());
            bizObjAuthRel.setAuthType(req.getAuthType());
            bizObjAuthRel.setAuthName(req.getAuthName());
            bizObjAuthRel.setCreateTime(DateUtils.getNowTime(""));
            bizObjAuthRel.setCreateUserId(Utils.getUserId());
            bizObjAuthRel.setTenantId(Utils.getTenantId());
            bizObjAuthRel.setLabelId(systemVo.getLabelId());
            bizObjAuthRel.setLabelType(systemVo.getLabelType());
            List<LabelSystemAuth> authList=systemAuthMap.get(systemVo.getLabelType()+ "-" + systemVo.getLabelId());
            //数据库中不存在该组件的关联关系
            if(CollectionUtils.isEmpty(authList)){
                insertAuthList.add(bizObjAuthRel);
            }
        }
        //需要插入的权限不为空，批量入库
        if(CollectionUtils.isNotEmpty(insertAuthList)){
            labelSystemAuthMapper.batchSaveAuth(insertAuthList);
        }
        return null;
    }


    /**
     * 查询权限对象关联的组件
     *
     * @param authId
     * @param authType
     * @param labelId
     * @param labelType
     */
    public List<LabelSystemAuth> getSystemAuth(Long authId, Integer authType, Long labelId, Integer labelType) {
        //查询权限对象关联的组件
        QueryWrapper<LabelSystemAuth> condition = new QueryWrapper<>();
        condition.eq("auth_id", authId);
        condition.eq("auth_type", authType);
        condition.eq("label_id", labelId);
        condition.eq("label_type", labelType);
        return labelSystemAuthMapper.selectList(condition);
    }

    /**
     * 删除权限对象关联的组件
     *
     * @param authId
     * @param authType
     * @param labelId
     * @param labelType
     */
    public void delSystemAuth(Long authId, Integer authType, Long labelId, Integer labelType) {
        //删除权限对象关联的组件
        QueryWrapper<LabelSystemAuth> condition = new QueryWrapper<>();
        condition.eq("auth_id", authId);
        condition.eq("auth_type", authType);
        condition.eq("label_id", labelId);
        condition.eq("label_type", labelType);
        labelSystemAuthMapper.delete(condition);
    }


    @Override
    public ResultPageBean pageListAuthSystem(AuthSystemLabelReq req) throws ExecutionException, InterruptedException {
        ResultPageBean resultPageBean;
        //初始化该租户的预设组件
        labelSystemPreService.initPreData(req.getClientType());
        //查询有权限的组件
        List<LabelSystemAuth> labelSystemAuthList = new ArrayList<>();
        //组件权限map,key:组件id_组件类型，组件关联性信息
        Map<String, LabelSystemAuth> labelSystemAuthMap = new HashMap<>();
        if (null != req.getAuthId()) {
            QueryWrapper<LabelSystemAuth> condition = new QueryWrapper<>();
            condition.in("auth_id", req.getAuthId());
            labelSystemAuthList = labelSystemAuthMapper.selectList(condition);
            labelSystemAuthMap = labelSystemAuthList.stream()
                    .collect(Collectors.toMap(value -> value.getLabelId() + "-" + value.getLabelType(), value -> value, (key1, key2) -> key1));
        }
        //预设组件关联关系
        List<LabelSystemSource> systemSourcePreList = new ArrayList<>();
        //自定义组件组件关联关系
        List<LabelSystemSource> systemSourceCustomList = new ArrayList<>();
        //源应用查询
        if (CollectionUtils.isNotEmpty(req.getAppCodeList())) {
            List<LabelSystemSource> systemSourceList = labelSystemSourceMapper.listSourceByData(req.getAppCodeList());
            //根据源应用查询结果为空
            if (CollectionUtils.isEmpty(systemSourceList)) {
                resultPageBean = ResultPageBean.success(ResponseBody.getInstance(systemSourceList, PageInfo.getPageInfo(
                        req.getPageNum(), req.getPageSize(), systemSourceList.size())));
                return resultPageBean;
            }
            systemSourcePreList = systemSourceList.stream().filter(x -> Constants.LabelTypeEnum.SYSTEM_PRE.getVal().equals(x.getComponentSource())).collect(Collectors.toList());
            systemSourceCustomList = systemSourceList.stream().filter(x -> Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal().equals(x.getComponentSource())).collect(Collectors.toList());
        }
        //分页查询组件信息
        Page<BizObjAuthRelBatchSystemVo> authLabelPageList = pageListAuthLabel(req, systemSourcePreList, systemSourceCustomList);
        //组装源应用名称/是否关联
        if (null != authLabelPageList && CollectionUtils.isNotEmpty(authLabelPageList.getRecords())) {
            List<BizObjAuthRelBatchSystemVo> systemVoList = packageLabel(authLabelPageList.getRecords(), labelSystemAuthMap);
            authLabelPageList.setRecords(systemVoList);
        }
        resultPageBean = ResultPageBean.success(ResponseBody.getInstance(authLabelPageList.getRecords(), PageInfo.getPageInfo(
                req.getPageNum(), req.getPageSize(), Integer.parseInt(authLabelPageList.getTotal() + ""))));
        return resultPageBean;
    }
    /**
     * 组装源应用名称和关联关系
     * @param authLabelList
     * @param labelSystemAuthMap
     * @return
     * @throws ExecutionException
     * @throws InterruptedException
     */
    public List<BizObjAuthRelBatchSystemVo> packageLabel(List<BizObjAuthRelBatchSystemVo> authLabelList,
                                                         Map<String, LabelSystemAuth> labelSystemAuthMap)
            throws ExecutionException, InterruptedException {
        //查询组件涉及数据源关联关系
        List<LabelSystemSource> systemSourceList = labelSystemSourceMapper.listSourceByLabel(authLabelList);
        //源应用信息map
        Map<String, String> appNameMap = new HashMap<>();
        //组件和数据源关系map，key：类型+组件id，val:数据源ID
        Map<String, Long> sourceDataMap = new HashMap<>();
        //数据源信息map，key：数据源id，val:数据源信息
        Map<Long, LabelSystemData> systemDataMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(systemSourceList)) {
            sourceDataMap = systemSourceList.stream().collect(Collectors.toMap(value -> value.getSystemId()+ "-" +value.getComponentSource()  , value -> value.getDataId(), (key1, key2) -> key1));
            List<Long> dataIdList = systemSourceList.stream().map(LabelSystemSource::getDataId).collect(Collectors.toList());
            List<LabelSystemData> labelSystemDataList = labelSystemDataMapper.selectBatchIds(dataIdList);
            systemDataMap = labelSystemDataList.stream().collect(Collectors.toMap(LabelSystemData::getId, y -> y, (a, b) -> a));
            //CS应用
            List<LabelSystemData> csList = labelSystemDataList.stream().filter(item -> ApplicationTypeEnum.CS_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
            //BS应用
            List<LabelSystemData> bsList = labelSystemDataList.stream().filter(item -> ApplicationTypeEnum.BS_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
            //雅典娜应用
            List<LabelSystemData> athenaList = labelSystemDataList.stream().filter(item -> ApplicationTypeEnum.IAM_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
            AuthoredUser user=AppAuthContextHolder.getContext().getAuthoredUser();
            //异步查询
            CompletableFuture<Map<String, String>> erpSsoInfo = CompletableFuture.supplyAsync(() -> getErpInfoMap(user,csList),asyncTaskExecutor);
            CompletableFuture<Map<String, String>> queryThirdSsoInfo = CompletableFuture.supplyAsync(() -> getSsoInfoMap(user,bsList),asyncTaskExecutor);
            CompletableFuture<Map<String, String>> queryPerInstallApp = CompletableFuture.supplyAsync(() -> getPreInfoMap(),asyncTaskExecutor);
            CompletableFuture<Map<String, String>> queryDefaultGroup = CompletableFuture.supplyAsync(() -> getAthenaInfoMap(user,athenaList),asyncTaskExecutor);
            CompletableFuture.allOf(erpSsoInfo, queryThirdSsoInfo, queryPerInstallApp, queryDefaultGroup);
            Map<String, String> erpSsoInfoAppMap = erpSsoInfo.get();
            if(null !=erpSsoInfoAppMap){
                appNameMap.putAll(erpSsoInfoAppMap);
            }
            Map<String, String> thirdSsoInfoAppMap = queryThirdSsoInfo.get();
            if(null !=thirdSsoInfoAppMap){
                appNameMap.putAll(thirdSsoInfoAppMap);
            }
            Map<String, String> preAppMap = queryPerInstallApp.get();
            if(null !=preAppMap){
                appNameMap.putAll(preAppMap);
            }
            Map<String, String> iamAppLinkMap = queryDefaultGroup.get();
            if(null !=iamAppLinkMap){
                appNameMap.putAll(iamAppLinkMap);
            }
            for (VirtualApplicationEnum virtualApplicationEnum : VirtualApplicationEnum.values()){
                appNameMap.put(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType() + "_" + virtualApplicationEnum.getPrimaryId(), virtualApplicationEnum.getName());
            }
        }
        for (BizObjAuthRelBatchSystemVo authLabel : authLabelList) {
            //判断是否关联
            String key = authLabel.getLabelId() + "-" + authLabel.getLabelType();
            Boolean isRelated = labelSystemAuthMap.get(key) == null ? false : true;
            authLabel.setIsRelated(isRelated);
            //获取组件关联的数据源
            Long dataId=sourceDataMap.get(key);
            if(null  == dataId){
                continue;
            }
            //获取数据源信息
            LabelSystemData systemData=systemDataMap.get(dataId);
            if(null  == systemData){
                continue;
            }
            //获取源应用名称
            String appName=appNameMap.get(systemData.getDataType()+"_"+systemData.getAppCode());
            authLabel.setAppName(appName);
        }
        return authLabelList;
    }

    /**
     * 分页查询组件信息
     * @param req
     * @param systemSourcePreList 预设组件关联关系
     * @param systemSourceCustomList 自定义组件组件关联关系
     * @return
     */
    public Page<BizObjAuthRelBatchSystemVo> pageListAuthLabel(AuthSystemLabelReq req,List<LabelSystemSource> systemSourcePreList,List<LabelSystemSource> systemSourceCustomList){
        //查询源应用为【鼎捷雅典娜APP】的数据源和组件信息
        List<LabelSystemData> permSystemDataList=labelSystemDataMapper.queryAthenaAppList(new ArrayList<>(),VirtualApplicationEnum.ATHENA_APP.getPrimaryId());
        List<Long> permSystemIdList=new ArrayList<>();
        //源应用为【鼎捷雅典娜APP】的组件ID集合
        if(CollectionUtils.isNotEmpty(permSystemDataList)){
            permSystemIdList=permSystemDataList.stream().map(LabelSystemData::getSystemId).collect(Collectors.toList());
        }
        Page<BizObjAuthRelBatchSystemVo> relBatchSystemVoPage=new Page<>();
        //没有根据源应用查询 或者根据源应用查询后预设组件和自定义组件中都存在 则需要从预设组件和自定义组件中查询
        if(CollectionUtils.isEmpty(req.getAppCodeList())
                || (CollectionUtils.isNotEmpty(systemSourcePreList)
                &&CollectionUtils.isNotEmpty(systemSourceCustomList))
        ){
            //分页查询组件
            Integer startNum = (req.getPageNum() - 1) * req.getPageSize();
            List<BizObjAuthRelBatchSystemVo> relBatchSystemVoList = new ArrayList<>();
            Long totalNum = null;
            String locale = LocaleContextHolder.getLocale().toString();
            if (Constants.ZH_TW_LOCALE.equals(locale)) {
                relBatchSystemVoList = labelSystemAuthMapper.pageSelectAuthList(startNum,req.getPageSize(),null ,req.getName(),Utils.getTenantId(),systemSourcePreList,systemSourceCustomList,permSystemIdList);
                totalNum=labelSystemAuthMapper.countAuthList(startNum,req.getPageSize(),null, req.getName(),Utils.getTenantId(),systemSourcePreList,systemSourceCustomList,permSystemIdList);
                relBatchSystemVoList.forEach(item-> {
                    if(StringUtils.isNotEmpty(item.getLabelNameTw())){
                        item.setLabelName(item.getLabelNameTw());
                    }
                });
            }else {
                relBatchSystemVoList = labelSystemAuthMapper.pageSelectAuthList(startNum,req.getPageSize(),req.getName(),null ,Utils.getTenantId(),systemSourcePreList,systemSourceCustomList,permSystemIdList);
                totalNum=labelSystemAuthMapper.countAuthList(startNum,req.getPageSize(),req.getName(),null ,Utils.getTenantId(),systemSourcePreList,systemSourceCustomList,permSystemIdList);
            }
            relBatchSystemVoPage.setRecords(relBatchSystemVoList);
            relBatchSystemVoPage.setTotal(totalNum);
            return relBatchSystemVoPage;
        }
        //从预设组件中查询
        if(CollectionUtils.isNotEmpty(req.getAppCodeList())
                && CollectionUtils.isNotEmpty(systemSourcePreList)
                &&CollectionUtils.isEmpty(systemSourceCustomList)
        ){
            List<Long> preIdList=systemSourcePreList.stream().map(LabelSystemSource::getSystemId).collect(Collectors.toList());
            relBatchSystemVoPage=labelSystemPreService.pageListPre(preIdList,req);
            return relBatchSystemVoPage;
        }
        //从自定义组件中查询
        if(CollectionUtils.isNotEmpty(req.getAppCodeList())
                && CollectionUtils.isEmpty(systemSourcePreList)
                &&CollectionUtils.isNotEmpty(systemSourceCustomList)
        ){
            List<Long> customIdList=systemSourceCustomList.stream().map(LabelSystemSource::getSystemId).collect(Collectors.toList());
            relBatchSystemVoPage=labelSystemCustomService.pageListCustom(customIdList,req,permSystemIdList);
            return relBatchSystemVoPage;
        }
        return  relBatchSystemVoPage;
    }




    /**
     * 查询平台预设应用
     *
     * @param
     * @return
     */
    public Map<String, String> getPreInfoMap() {
        List<PreinstalledApplication> preinstalledAppList = preinstalledApplicationMapper.selectList(new QueryWrapper<PreinstalledApplication>());
        Map<String, String> preInfoMap = preinstalledAppList.stream().collect(Collectors.toMap(value -> ApplicationTypeEnum.PRESET_APPLICATION.getType()+"_"+value.getId(), value -> value.getApplicationName(), (key1, key2) -> key1));
        return preInfoMap;
    }

    /**
     * 查询CS应用
     *
     * @param csList
     * @return
     */
    public Map<String, String> getErpInfoMap(AuthoredUser user,List<LabelSystemData> csList) {
        AppAuthContextHolder.getContext().setAuthoredUser(user);
        Map<String, String> erpInfoMap = new HashMap<>();
        if (CollectionUtils.isEmpty(csList)) {
            return erpInfoMap;
        }
        List<String> thirdFolderIdList = csList.stream().map(LabelSystemData::getAppCode).collect(Collectors.toList());
        QuerySsoListReq querySsoListReq = new QuerySsoListReq();
        List<Long> idList = thirdFolderIdList.stream().map(Long::parseLong).collect(Collectors.toList());
        querySsoListReq.setIdList(idList);
        List<ErpSsoInfo> erpInfoList = erpSsoInfoMapper.querySsoListByScope(querySsoListReq);
        erpInfoMap = erpInfoList.stream().collect(Collectors.toMap(value -> ApplicationTypeEnum.CS_APPLICATION.getType()+"_"+value.getId(), value -> value.getName(), (key1, key2) -> key1));
        return erpInfoMap;
    }

    /**
     * 查询BS应用
     *
     * @param bsList
     * @return
     */
    public Map<String, String> getSsoInfoMap(AuthoredUser user,List<LabelSystemData> bsList) {
        AppAuthContextHolder.getContext().setAuthoredUser(user);
        Map<String, String> thirdSsoInfoMap = new HashMap<>();
        if (CollectionUtils.isEmpty(bsList)) {
            return thirdSsoInfoMap;
        }
        List<String> thirdFolderIdList = bsList.stream().map(LabelSystemData::getAppCode).collect(Collectors.toList());
        QuerySsoListReq querySsoListReq = new QuerySsoListReq();
        List<Long> idList = thirdFolderIdList.stream().map(Long::parseLong).collect(Collectors.toList());
        querySsoListReq.setIdList(idList);
        List<ThirdSsoInfo> thirdSsoInfoList = thirdSsoInfoMapper.queryThirdListByScope(querySsoListReq);
        thirdSsoInfoMap = thirdSsoInfoList.stream().collect(Collectors.toMap(value -> ApplicationTypeEnum.BS_APPLICATION.getType()+"_"+value.getId(), value -> value.getAppName(), (key1, key2) -> key1));
        return thirdSsoInfoMap;
    }


    /**
     * 查询IAM应用
     *  @param user
     * @param athenaList
     * @return
     */
    public Map<String, String> getAthenaInfoMap(AuthoredUser user,List<LabelSystemData> athenaList) {
        AppAuthContextHolder.getContext().setAuthoredUser(user);
        Map<String, String> athenaInfoMap = new HashMap<>();
        if (CollectionUtils.isEmpty(athenaList)) {
            return athenaInfoMap;
        }
        List<TenantAppDTO> allTenantApps = iamService.queryTenantApps();
        athenaInfoMap = allTenantApps.stream().collect(Collectors.toMap(value -> ApplicationTypeEnum.IAM_APPLICATION.getType()+"_"+value.getId(), value -> value.getName(), (key1, key2) -> key1));
        return athenaInfoMap;
    }


    public String addAppIDName(Map<Long, ErpSsoInfo> erpInfoMap, Map<Long, ThirdSsoInfo> thirdSsoInfoMap, Map<Long, PreinstalledApplication> preInfoMap, Map<String, String> athenaInfoMap, LabelSystemData systemData, Boolean type) {
        String appName = "";
        String appCode = "";
        String appId = "";
        String systemType = "";
        String appToken = "";
        String callBackUrl = "";
        int isNeedSsoUrl = 0;
        int isFixedRefresh = 0;
        if (StringUtils.isEmpty(systemData.getAppCode())) {
            return appName;
        }
        if (null == systemData.getDataType()) {
            return appName;
        }
        //cs
        if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(systemData.getDataType())) {
            ErpSsoInfo erpSsoInfo = erpInfoMap.get(Long.parseLong(systemData.getAppCode()));
            if (null != erpSsoInfo) {
                appName = erpSsoInfo.getName();
                appCode = erpSsoInfo.getCode();
                appId = erpSsoInfo.getAppId();
                systemType = Constants.SYSTEM_TYPE_WT;
                appToken = erpSsoInfo.getAppToken();
                systemData.setProtocolType(erpSsoInfo.getProtocolType());
                callBackUrl = erpSsoInfo.getCallBackUrl();
            }
        }
        //bs
        if (ApplicationTypeEnum.BS_APPLICATION.getType().equals(systemData.getDataType())) {
            ThirdSsoInfo thirdSsoInfo = thirdSsoInfoMap.get(Long.parseLong(systemData.getAppCode()));
            if (thirdSsoInfo != null) {
                appName = thirdSsoInfo.getAppName();
                appCode = thirdSsoInfo.getAppCode();
                appId = thirdSsoInfo.getAppId();
                systemType = Constants.SYSTEM_TYPE_MT;
                appToken = thirdSsoInfo.getAppToken();
                systemData.setProtocolType(thirdSsoInfo.getProtocolType());
                callBackUrl = thirdSsoInfo.getCallBackUrl();
            }
        }
        //预设
        if (ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(systemData.getDataType())) {
            AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
            List<PreinstalledApplication> preInstalledAppList = preinstalledApplicationService.queryPreinstalledAppList(user);
            Map<Long, PreinstalledApplication> preinstalledApplicationMap = preInstalledAppList.stream().collect(Collectors.toMap(PreinstalledApplication::getId, Function.identity(), (a, b) -> a));
            PreinstalledApplication preinstalledApplication = preinstalledApplicationMap.get(Long.parseLong(systemData.getAppCode()));
            if (null != preinstalledApplication) {
                appName = preinstalledApplication.getApplicationName();
                appCode = preinstalledApplication.getApplicationCode();

                PreinstalledApplicationInstance applicationInstance = preinstalledApplicationService.getPreINstance(preinstalledApplication.getId(), "", "");
                appId = applicationInstance.getAppId();
                systemType = getPreSystem(preinstalledApplication);
                appToken = preinstalledApplication.getAppToken();
                systemData.setProtocolType(preinstalledApplication.getProtocolType());
                JSONObject jsonObject = Optional.ofNullable(JSONObject.parseObject(preinstalledApplication.getApplicationConfig())).orElse(new JSONObject());
                callBackUrl = String.format(Constants.CS_APP_CALLBACK_URL, jsonObject.getString("applicationCode"));
                //每刻报销和每刻云票需要重新获取sso地址
                if (MaycurCodeEnum.MAYCUR_APPROVALS.getType().equals(preinstalledApplication.getApplicationCode())) {
                    isNeedSsoUrl = 1;
                    isFixedRefresh = 1;
                    //取回调地址
                    net.sf.json.JSONObject instanceObject = applicationInstance.getApplicationExtConfig();
                    callBackUrl = instanceObject.getString("callBackUrl");
                    appId = instanceObject.getString("appId");
                }

            }

        }
        //雅典娜应用
        if (ApplicationTypeEnum.IAM_APPLICATION.getType().equals(systemData.getDataType())) {
            appName = athenaInfoMap.get(systemData.getAppCode());
            appCode = systemData.getAppCode();
        }
        systemData.setAppId(appId);
        if (type) {
            systemData.setAppCode(appCode);
            systemData.setSystemType(systemType);
            systemData.setAppToken(appToken);
            systemData.setCallBackUrl(callBackUrl);
            systemData.setIsNeedSsoUrl(isNeedSsoUrl);
            systemData.setIsFixedRefresh(isFixedRefresh);
        }
        systemData.setAppName(appName);
        return appName;
    }


    public String getPreSystem(PreinstalledApplication preinstalledApplication) {
        String systemType = "";
        if (null == preinstalledApplication.getSystemType()) {
            return systemType;
        }
        //bs = mt
        if (preinstalledApplication.getSystemType().equals(Integer.parseInt(PreinstalledApplicationTypeEnum.BS_APPLICATION.getValue()))) {
            systemType = Constants.SYSTEM_TYPE_MT;
        }
        //cs = wt
        if (preinstalledApplication.getSystemType().equals(Integer.parseInt(PreinstalledApplicationTypeEnum.CS_APPLICATION.getValue()))) {
            systemType = Constants.SYSTEM_TYPE_WT;
        }
        return systemType;
    }

    @Override
    public List<UserSystemLabelVo> queryUserLayout() {
        List<UserSystemLabelVo> userSystemLabelVoList = new ArrayList<>();
        QueryWrapper cond = new QueryWrapper<LabelSystemAuth>();
        //查询租户下用户的权限内组件
        List<LabelSystemAuth> bizObjAuthRelList = labelSystemAuthMapper.selectList(getUserAuthCon(cond));
        //查询租户下布局组件
        List<PortalLayoutCustom> portalLayoutCustomList = portalLayoutCustomService.initPortalLayout();
        if (CollectionUtils.isEmpty(portalLayoutCustomList)) {
            return userSystemLabelVoList;
        }
        Map<String, LabelSystemAuth> labelSystemAuthMap = bizObjAuthRelList.stream()
                .collect(Collectors.toMap(value -> value.getLabelId() + "-" + value.getLabelType(), value -> value, (key1, key2) -> key1));

        //获取首页布局中组件且是用户权限内的
        userSystemLabelVoList = getUserSystemLabel(labelSystemAuthMap, portalLayoutCustomList);
        return userSystemLabelVoList;
    }

    @Override
    public List<Long> getSystemCustom() {
        //查询租户下用户的权限内组件
        QueryWrapper cond = new QueryWrapper<LabelSystemAuth>();
        List<LabelSystemAuth> bizObjAuthRelList = labelSystemAuthMapper.selectList(getUserAuthCon(cond));
        //过滤获取自定义组件id
        List<Long> customIdList = bizObjAuthRelList.stream().filter(x -> Objects.equals(0, x.getLabelType())).map(LabelSystemAuth::getLabelId).collect(Collectors.toList());
        return customIdList;
    }

    /**
     * 查询当前用户有权限的组件
     *
     * @param cond 条件
     * @return 返回
     */
    @Override
    public QueryWrapper getUserAuthCon(QueryWrapper cond) {
        // 查询用户所属的组织、角色、部门
        String userId = Utils.getUserId();
        String tenantId = Utils.getTenantId();
        String userToken = Utils.getUserToken();
        IamUserAuthInfo iamUserAuthInfo = iamUserService.getUserAuthSids(userId, tenantId, userToken);
        // 拼接组织条件
        StringBuilder authCond = new StringBuilder();
        if(ObjectUtils.isNotEmpty(iamUserAuthInfo) && CollectionUtils.isNotEmpty(iamUserAuthInfo.getOrgSids())){
            List<Long> orgSidList = iamUserAuthInfo.getOrgSids();
            authCond.append("(auth_type = 1 and auth_id in(" + Joiner.on(",").join(orgSidList) + "))");
        }
        // 拼接角色条件
        if (ObjectUtils.isNotEmpty(iamUserAuthInfo) && CollectionUtils.isNotEmpty(iamUserAuthInfo.getRoleSids())) {
            List<Long> roleSidList = iamUserAuthInfo.getRoleSids();
            if (StringUtils.isNotEmpty(authCond.toString())) {
                authCond.append("or (auth_type = 2 and auth_id in(" + Joiner.on(",").join(roleSidList) + "))");
            } else {
                authCond.append("(auth_type = 2 and auth_id in(" + Joiner.on(",").join(roleSidList) + "))");
            }
        }
        // 拼接部门条件
        if (ObjectUtils.isNotEmpty(iamUserAuthInfo) && CollectionUtils.isNotEmpty(iamUserAuthInfo.getDeptSids())) {
            List<Long> deptSidList = iamUserAuthInfo.getDeptSids();
            if (StringUtils.isNotEmpty(authCond.toString())) {
                authCond.append("or (auth_type = 5 and auth_id in(" + Joiner.on(",").join(deptSidList) + "))");
            } else {
                authCond.append("(auth_type = 5 and auth_id in (" + Joiner.on(",").join(deptSidList) + "))");
            }
        }
        // 拼接用户条件
        Long userSid = Utils.getUserSid();
        if (Objects.nonNull(userSid)) {
            if (StringUtils.isNotEmpty(authCond.toString())) {
                authCond.append("or (auth_type = 3 and auth_id = " + userSid + ")");
            } else {
                authCond.append("(auth_type = 3 and auth_id = " + userSid + ")");
            }
        }
        if (StringUtils.isNotEmpty(authCond.toString())) {
            cond.apply("(" + authCond + ")");
        }
        return cond;
    }

    @Override
    public QueryWrapper getUserAuthSidCon(QueryWrapper cond) {
        String userId = Utils.getUserId();
        String userToken = Utils.getUserToken();
        Long userSid = AppAuthContextHolder.getContext().getAuthoredUser().getSid();

        // 查询用户所在组织
        UserOrgInfoDTO userOrgInfoDTO = iamService.qryUserOrgInfo(userId, userToken);
        // 查询用户所在角色
        List<RoleDTO> roleDTOList = iamService.queryUserRoles(userId, userToken);
        // 查询用户所在部门
        UserInfoDetailDTO userInfoDetailDTO = eocService.queryUserInfoDetail(userId);

        // 拼接组织条件
        StringBuilder authCond = new StringBuilder();
        if (Objects.nonNull(userOrgInfoDTO) && CollectionUtils.isNotEmpty(userOrgInfoDTO.getUserInOrgs())) {
            List<Long> orgSidList = userOrgInfoDTO.getUserInOrgs().stream().map(UserOrgDTO::getOrgSid).collect(Collectors.toList());
            authCond.append("(auth_type = 1 and auth_sid in(" + Joiner.on(",").join(orgSidList) + "))");
        }
        // 拼接角色条件
        if (CollectionUtils.isNotEmpty(roleDTOList)) {
            List<Long> roleSidList = roleDTOList.stream().map(RoleDTO::getSid).collect(Collectors.toList());
            if (StringUtils.isNotEmpty(authCond.toString())) {
                authCond.append("or (auth_type = 2 and auth_sid in(" + Joiner.on(",").join(roleSidList) + "))");
            } else {
                authCond.append("(auth_type = 2 and auth_sid in(" + Joiner.on(",").join(roleSidList) + "))");
            }
        }
        // 拼接部门条件
        if(ObjectUtils.isNotEmpty(userInfoDetailDTO) && CollectionUtils.isNotEmpty(userInfoDetailDTO.getDepts())){
            List<Long> deptSidList = userInfoDetailDTO.getDepts().stream().map(UserDeptDTO::getSid).collect(Collectors.toList());
            if (StringUtils.isNotEmpty(authCond.toString())) {
                authCond.append("or (auth_type = 5 and auth_sid in(" + Joiner.on(",").join(deptSidList) + "))");
            } else {
                authCond.append("(auth_type = 5 and auth_sid in (" + Joiner.on(",").join(deptSidList) + "))");
            }
        }
        // 拼接用户条件
        if (Objects.nonNull(userSid)) {
            if (StringUtils.isNotEmpty(authCond.toString())) {
                authCond.append("or (auth_type = 3 and auth_sid = " + userSid + ")");
            } else {
                authCond.append("(auth_type = 3 and auth_sid = " + userSid + ")");
            }
        }
        if (StringUtils.isNotEmpty(authCond.toString())) {
            cond.apply("(" + authCond + ")");
        }
        return cond;
    }


    /**
     * 获取首页布局中组件且是用户权限内的
     *
     * @param labelSystemAuthMap     用户权限组件
     * @param portalLayoutCustomList 布局组件
     * @return
     */
    public List<UserSystemLabelVo> getUserSystemLabel(Map<String, LabelSystemAuth> labelSystemAuthMap, List<PortalLayoutCustom> portalLayoutCustomList) {
        List<UserSystemLabelVo> userSystemLabelVoList = new ArrayList<>();
        //查询自定义组件信息
        Map<Long, LabelSystemCustom> systemCustomMap = new HashMap<>();
        List<Long> sysetemCustomIdList = portalLayoutCustomList.stream().filter(x -> Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal().equals(x.getLabelType())).map(PortalLayoutCustom::getLabelId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(sysetemCustomIdList)) {
            List<LabelSystemCustom> systemCustomList = labelSystemCustomMapper.selectBatchIds(sysetemCustomIdList);
            systemCustomMap = systemCustomList.stream().collect(Collectors.toMap(LabelSystemCustom::getId, Function.identity(), (a, b) -> a));
        }
        //组件中的数据源
        List<LabelSystemData> systemDataList=new ArrayList<>();
        if (MapUtils.isNotEmpty(systemCustomMap)) {
            // 根据组件id查询数据源信息
            Set<Long> systemIdList = systemCustomMap.keySet();
            systemDataList = labelSystemDataMapper.queryBySystemIdList(systemIdList);
        }
        //判断业务待办类型数据源配置的智驱平台分组（三方应用暂未处理）是否禁用，如果禁用则首页不返回该组件,返回有权限的组件
        List<Long> effectSystemIdList = buildEffectSystemId(systemDataList);
        //过滤【鼎捷雅典娜APP】的作业权限，返回没有权限的组件ID
        UserAuthSystemLabelVo  authSystemLabelVo = mobileUserAuthService.buildSystemIdApp(systemDataList);
        //组装有权限的【鼎捷雅典娜APP】的组件
        addAuthLabelMap(labelSystemAuthMap,authSystemLabelVo);
        //查询预设组件信息
        Map<Long, LabelSystemPre> systemPreMap = new HashMap<>();
        List<Long> sysetemPreIdList = portalLayoutCustomList.stream().filter(x -> Constants.LabelTypeEnum.SYSTEM_PRE.getVal().equals(x.getLabelType())).map(PortalLayoutCustom::getLabelId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(sysetemPreIdList)) {
            List<LabelSystemPre> labelSystemPreList = labelSystemPreMapper.selectBatchIds(sysetemPreIdList);
            systemPreMap = labelSystemPreList.stream().collect(Collectors.toMap(LabelSystemPre::getId, Function.identity(), (a, b) -> a));
        }
        for (PortalLayoutCustom portalLayoutCustom : portalLayoutCustomList) {
            String key = portalLayoutCustom.getLabelId() + "-" + portalLayoutCustom.getLabelType();
            LabelSystemAuth systemAuth = labelSystemAuthMap.get(key);
            //预设组件判断--当前布局中组件 不在用户权限范围内,且不是默认的待办，常用，收藏、数智视图
            if (null == systemAuth && portalLayoutCustom.getDefaultFlag().equals(0)
                    && Constants.LabelTypeEnum.SYSTEM_PRE.getVal().equals(portalLayoutCustom.getLabelType())) {
                continue;
            }
            UserSystemLabelVo userSystemLabelVo = new UserSystemLabelVo();
            userSystemLabelVo.setLabelId(portalLayoutCustom.getLabelId());
            userSystemLabelVo.setLabelType(portalLayoutCustom.getLabelType());
            userSystemLabelVo.setLabelIndex(portalLayoutCustom.getLabelIndex());

            //组装自定义组件信息
            if (portalLayoutCustom.getLabelType().equals(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal())) {
                LabelSystemCustom labelSystemCustom = systemCustomMap.get(portalLayoutCustom.getLabelId());
                if (null == labelSystemCustom) {
                    continue;
                }

                // 自定义组件-业务待办的校验，业务待办 + 没有权限
                if (Constants.DataCategoryEnum.BUSINESS_TODO.getVal().equals(labelSystemCustom.getDataCategory())
                        && !effectSystemIdList.contains(labelSystemCustom.getId())) {
                    continue;
                }

                // 自定义组件-应用、自定义组件-作业、自定义组件-内嵌网页、自定义组件-报表需要校验权限，自定义组件-业务待办上步已经校验过
                if (null == systemAuth && !Constants.DataCategoryEnum.BUSINESS_TODO.getVal().equals(labelSystemCustom.getDataCategory())) {
                    continue;
                }
                userSystemLabelVo.setDataCategory(labelSystemCustom.getDataCategory());
                userSystemLabelVo.setIcon(labelSystemCustom.getIcon());
                userSystemLabelVo.setShowType(labelSystemCustom.getShowType());
                //根据字体翻译
                String labelName = translateService.translateTextCache(labelSystemCustom.getNameZh(), StringUtils.EMPTY);
                userSystemLabelVo.setLabelName(labelName);
                userSystemLabelVo.setValidStatus(labelSystemCustom.getValidStatus());
            }
            //组装预设组件信息
            if (portalLayoutCustom.getLabelType().equals(Constants.LabelTypeEnum.SYSTEM_PRE.getVal())) {
                LabelSystemPre labelSystemPre = systemPreMap.get(portalLayoutCustom.getLabelId());
                if (null != labelSystemPre) {
                    userSystemLabelVo.setDataType(labelSystemPre.getDataType());
                    userSystemLabelVo.setDataCategory(labelSystemPre.getDataCategory());
                    //根据字体翻译
                    String labelName = translateService.translateTextCache(labelSystemPre.getName(), StringUtils.EMPTY);
                    userSystemLabelVo.setLabelName(labelName);
                    userSystemLabelVo.setValidStatus(labelSystemPre.getValidStatus());
                }

            }
            //如果是预设组件待办，则加入
            if (null != userSystemLabelVo.getDataType() && userSystemLabelVo.getDataType().equals(Constants.DataTypeEnum.TYPE_TODO.getVal())) {
                userSystemLabelVoList.add(userSystemLabelVo);
                continue;
            }
            //组件是启用状态
            if (Constants.VALID_STATUS_ENABLE.equals(userSystemLabelVo.getValidStatus())) {
                userSystemLabelVoList.add(userSystemLabelVo);
            }
        }
        return userSystemLabelVoList;
    }

    /**
     * 将有权限的【鼎捷雅典娜APP】组件加入权限map
     * @param labelSystemAuthMap 用户有权限的组件map
     * @param authSystemLabelVo
     */
    @Override
    public void addAuthLabelMap(Map<String, LabelSystemAuth> labelSystemAuthMap, UserAuthSystemLabelVo  authSystemLabelVo){
         if(CollectionUtils.isEmpty(authSystemLabelVo.getPermSystemIdList())){
             return;
         }
         for(Long sysTemId:authSystemLabelVo.getPermSystemIdList()){
             String key = sysTemId + "-" + Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal();
             LabelSystemAuth systemAuth=labelSystemAuthMap.get(key);
             if(null == systemAuth){
                 systemAuth=new LabelSystemAuth();
                 systemAuth.setLabelId(sysTemId);
                 systemAuth.setLabelType(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal());
                 labelSystemAuthMap.put(key,systemAuth);
             }
         }
    }

    /**
     * 构建智驱平台业务待办的有效组件（三方应用暂未处理）
     *
     * @param systemDataList 组件中的数据源
     * @return 返回有权限的自定义组件ID
     */
    private List<Long> buildEffectSystemId(List<LabelSystemData> systemDataList) {
        List<Long> effectSystemIdList = Lists.newArrayList();
        if(CollectionUtils.isEmpty(systemDataList)){
            return effectSystemIdList;
        }
        // 过滤出配置了智驱平台业务待办的数据源
        Map<Long, LabelSystemData> systemDataMap = systemDataList.stream().filter(x -> Constants.DataCategoryEnum.BUSINESS_TODO.getVal().equals(x.getDataCategory())
                && ApplicationTypeEnum.VIRTUAL_APPLICATION.getType().equals(x.getDataType())).collect(Collectors.toMap(LabelSystemData::getSystemId, Function.identity(), (a, b) -> a));
        if (MapUtils.isNotEmpty(systemDataMap)) {
            // 查询智驱平台最新的分组数据（返回的分组都是启用的）
            List<GroupRuleDTO> groupRuleList = atmcService.queryGroupRule();
            List<String> groupCodeList = groupRuleList.stream().map(GroupRuleDTO::getCode).collect(Collectors.toList());
            systemDataMap.forEach((k, v) -> {
                if (groupCodeList.contains(v.getCountCode())) {
                    effectSystemIdList.add(k);
                }
            });
        }
        List<Long> thirdSystemIdList = systemDataList.stream().filter(x -> Constants.DataCategoryEnum.BUSINESS_TODO.getVal().equals(x.getDataCategory())
                && !ApplicationTypeEnum.VIRTUAL_APPLICATION.getType().equals(x.getDataType())).map(LabelSystemData::getSystemId).collect(Collectors.toList());
        effectSystemIdList.addAll(thirdSystemIdList);
        return effectSystemIdList;
    }

    /**
     * 查询对应权限类型的组件列表
     *
     * @param authTypeList 权限类型：1.组织 2.角色 3.用户
     * @return
     */
    @Override
    public List<LabelSystemAuth> queryAuthListByCondition(List<Integer> authTypeList) {
        QueryWrapper<LabelSystemAuth> wrapper = new QueryWrapper<>();
        wrapper.in("auth_type", authTypeList);
        return labelSystemAuthMapper.selectList(wrapper);
    }
}