package com.digiwin.athena.semc.service.portal.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.MaycurCodeEnum;
import com.digiwin.athena.semc.common.enums.PreinstalledApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.VirtualApplicationEnum;
import com.digiwin.athena.semc.dto.erpsso.ErpSsoSpecialDTO;
import com.digiwin.athena.semc.dto.erpsso.ThirdSsoInfoDto;
import com.digiwin.athena.semc.dto.fineReport.FineReportConfigDTO;
import com.digiwin.athena.semc.dto.fineReport.QueryFineReportUrlReq;
import com.digiwin.athena.semc.dto.mobile.MobileSSOReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemCountDataDTO;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.bench.SyncJobInfo;
import com.digiwin.athena.semc.entity.fineReport.FineReportAuth;
import com.digiwin.athena.semc.entity.fineReport.FineReportUserMapping;
import com.digiwin.athena.semc.entity.portal.LabelSystemCustom;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplication;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplicationInstance;
import com.digiwin.athena.semc.entity.sso.ErpSsoInfo;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.bench.SyncJobInfoMapper;
import com.digiwin.athena.semc.proxy.eoc.service.EocService;
import com.digiwin.athena.semc.proxy.fineReport.model.resp.FineReportTreeVO;
import com.digiwin.athena.semc.proxy.fineReport.service.FineReportProxyService;
import com.digiwin.athena.semc.proxy.km.service.KmService;
import com.digiwin.athena.semc.proxy.km.service.model.AppJobDTO;
import com.digiwin.athena.semc.proxy.maycur.MayCurService;
import com.digiwin.athena.semc.service.applink.AppLinkService;
import com.digiwin.athena.semc.service.fineReport.FineReportAuthService;
import com.digiwin.athena.semc.service.fineReport.FineReportManageService;
import com.digiwin.athena.semc.service.mobile.MobilePortalService;
import com.digiwin.athena.semc.service.portal.*;
import com.digiwin.athena.semc.service.sso.IErpSsoInfoService;
import com.digiwin.athena.semc.service.sso.IThirdSsoInfoService;
import com.digiwin.athena.semc.util.RsaEncryptUtil;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.mobile.FullBackResp;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.net.URLEncoder;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


@Slf4j
@Service
public class LabelSystemClickServiceImpl implements LabelSystemClickService {

    @Resource
    LabelSystemSourceService labelSystemSourceService;

    @Resource
    LabelSystemDataService labelSystemDataService;

    @Autowired
    IErpSsoInfoService erpSsoInfoService;

    @Autowired
    IThirdSsoInfoService thirdSsoInfoService;

    @Autowired
    private AppLinkService appLinkService;

    @Resource
    private IPreinstalledApplicationService preinstalledApplicationService;

    @Autowired
    private KmService kmService;

    @Resource
    private EnvProperties envProperties;

    @Autowired
    SyncJobInfoMapper syncJobInfoMapper;

    @Autowired
    MayCurService mayCurService;

    @Autowired
    EocService eocService;

    @Autowired
    private MobilePortalService mobilePortalService;

    @Resource
    LabelSystemCustomService labelSystemCustomService;

    @Resource
    private TripartiteApplicationService tripartiteApplicationService;

    @Resource
    private FineReportManageService fineReportManageService;

    @Resource
    private FineReportAuthService fineReportAuthService;

    @Resource
    private FineReportProxyService fineReportProxyService;

    /**
     * 查询自自定义组件 跳转链接
     *
     * @param systemId 自定义组件id
     * @return 返回对象
     */
    @Override
    public AppLinkDTO queryCustomJumpLink(Long systemId) {
        AppLinkDTO appLinkDTO = new AppLinkDTO();

        // 查询自定义组件信息，判断当前组件是否是内嵌网页类型的组件
        LabelSystemCustom labelSystemCustom = labelSystemCustomService.getById(systemId);
        if (ObjectUtils.isEmpty(labelSystemCustom)) {
            return appLinkDTO;
        }
        if (Constants.DataCategoryEnum.WEB_PAGE.getVal().equals(labelSystemCustom.getDataCategory())) {
            if (StringUtils.isNotBlank(labelSystemCustom.getLinkParam())) {
                StringBuilder stringBuilder = Utils.buildWebLinkUrl(labelSystemCustom.getLinkParam());
                String linkUrl = labelSystemCustom.getLinkUrl() + "?" + stringBuilder;
                appLinkDTO.setCloudwebsite(linkUrl);
            } else {
                appLinkDTO.setCloudwebsite(labelSystemCustom.getLinkUrl());
            }
            return appLinkDTO;
        }
        if (Objects.equals(11,labelSystemCustom.getDataCategory())){
            if (StringUtils.isNotBlank(labelSystemCustom.getLinkParam())) {
                StringBuilder stringBuilder = Utils.buildWebLinkUrl(labelSystemCustom.getLinkParam());
                String linkUrl = labelSystemCustom.getLinkUrl() + "?" + stringBuilder;
                appLinkDTO.setCloudwebsite(linkUrl);
            } else {
                appLinkDTO.setCloudwebsite(labelSystemCustom.getLinkUrl());
            }
            return appLinkDTO;
        }

        // 不是内嵌网页类型的组件，再查询组件配置的数据源
        List<Long> dataIdList = labelSystemSourceService.selectBySystem(systemId, Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal());
        if (CollectionUtils.isEmpty(dataIdList)) {
            return appLinkDTO;
        }
        List<LabelSystemData> systemDataList = labelSystemDataService.queryByIds(dataIdList);
        if (CollectionUtils.isEmpty(systemDataList)) {
            return appLinkDTO;
        }
        // 构建应用或作业sso链接
        return buildCustomApp(systemDataList.get(0));
    }

    /**
     * 构建应用或作业sso链接
     *
     * @param systemData 数据源
     * @return 返回对象
     */
    public AppLinkDTO buildCustomApp(LabelSystemData systemData) {
        AppLinkDTO appLinkDTO = new AppLinkDTO();
        // 源应用数据来源 1:b/s表 2:c/s表 3:预设表 4:IAM接口
        Integer dataType = systemData.getDataType();
        // 应用code
        String appCode = systemData.getAppCode();
        // 数据源分类（ 0-预设组件-三方待办、1-预设组件-三方报表、2-预设组件-新闻公告、3-自定义组件-作业集成、4-自定义组件-应用集成
        Integer dataCategory = systemData.getDataCategory();

        // BS应用
        if (ApplicationTypeEnum.BS_APPLICATION.getType().equals(dataType)) {
            List<ThirdSsoInfoDto> thirdSsoInfoList = thirdSsoInfoService.erpSsoInfoWithParams();
            if (CollectionUtils.isEmpty(thirdSsoInfoList)) {
                return appLinkDTO;
            }
            Map<Long, ThirdSsoInfoDto> idMap = thirdSsoInfoList.stream().collect(Collectors.toMap(ThirdSsoInfoDto::getId, Function.identity()));
            ThirdSsoInfoDto thirdSsoInfoDto = idMap.get(Long.parseLong(appCode));
            if (thirdSsoInfoDto == null) {
                return appLinkDTO;
            }
            AppLinkDTO appLink = buildBSAppLinkDTO(thirdSsoInfoDto);

            // 如果构建的是作业，则拼接回调地址
            if (Constants.DataCategoryEnum.CATEGORY_WORK.getVal().equals(dataCategory)) {
                String cloudwebsite = "";
                if (thirdSsoInfoDto.getProtocolType().equals(3) || thirdSsoInfoDto.getProtocolType().equals(2)) {
                    cloudwebsite = appLink.getCloudwebsite() + systemData.getCallBackUrl();
                } else {
                    cloudwebsite = appLink.getCloudwebsite();
                    String[] linkParamArray = cloudwebsite.split("\\?");
                    systemData.setAppId(thirdSsoInfoDto.getAppId());
                    String jobUrl = getSsoJobUrl(systemData);
                    cloudwebsite = linkParamArray[0] + packageJobUrl(jobUrl) + "&" + linkParamArray[1];
                }
                appLink.setCloudwebsite(cloudwebsite);
                appendAccountSet(appLink,systemData);
            }
            return appLink;
        }
        // CS应用
        else if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(dataType)) {
            List<ErpSsoInfo> erpSsoInfoList = erpSsoInfoService.erpSsoInfoWithParams();
            if (CollectionUtils.isEmpty(erpSsoInfoList)) {
                return appLinkDTO;
            }
            Map<Long, ErpSsoInfo> idMap = erpSsoInfoList.stream().collect(Collectors.toMap(ErpSsoInfo::getId, Function.identity()));
            ErpSsoInfo erpSsoInfo = idMap.get(Long.parseLong(appCode));
            if (erpSsoInfo == null) {
                return appLinkDTO;
            }
            AppLinkDTO appLink = buildCSAppLinkDTO(erpSsoInfo);

            // 如果构建的是作业，则拼接动态参数
            if (Constants.DataCategoryEnum.CATEGORY_WORK.getVal().equals(dataCategory)) {
                StringBuilder cloudwebsite = new StringBuilder(appLink.getCloudwebsite());
                systemData.setAppId(erpSsoInfo.getAppId());
                JSONObject jsonObject = JSONObject.parseObject(getSsoJobUrl(systemData));
                if (null != jsonObject) {
                    for (String key : jsonObject.keySet()) {
                        Object value = jsonObject.get(key);
                        cloudwebsite.append("&").append(key).append("=").append(value);
                    }
                }
                appLink.setCloudwebsite(cloudwebsite.toString());
                appendAccountSet(appLink,systemData);
            }
            return appLink;
        }
        // 预设应用
        else if (ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(dataType)) {
            List<AppLinkDTO> preApplicationList = appLinkService.queryPerInstallAppGroup(AppAuthContextHolder.getContext().getAuthoredUser());
            if (CollectionUtils.isEmpty(preApplicationList)) {
                return appLinkDTO;
            }
            Map<String, AppLinkDTO> idMap = preApplicationList.stream().collect(Collectors.toMap(AppLinkDTO::getPrimaryId, Function.identity()));
            AppLinkDTO preAppLink = idMap.get(appCode);
            if (preAppLink == null) {
                return appLinkDTO;
            }
            systemData.setAppId(preAppLink.getAppId());
            //如果是每刻云票和每刻报销
            if (MaycurCodeEnum.MAYCUR_CLOUD.getType().equals(preAppLink.getCode()) || MaycurCodeEnum.MAYCUR_APPROVALS.getType().equals(preAppLink.getCode())) {
                preAppLink.setIsNeedSsoUrl(0);
                getMaycurSsoUrl(preAppLink, dataCategory, systemData);
                return preAppLink;
            }
            // 如果构建的是作业
            if (Constants.DataCategoryEnum.CATEGORY_WORK.getVal().equals(dataCategory)) {
                if (PreinstalledApplicationTypeEnum.BS_APPLICATION.getValue().equals(preAppLink.getType())) {
                    String cloudwebsite = preAppLink.getCloudwebsite();
                    String[] linkParamArray = cloudwebsite.split("\\?");
                    cloudwebsite = linkParamArray[0] + "?" + getSsoJobUrl(systemData) + "&" + linkParamArray[1];
                    preAppLink.setCloudwebsite(cloudwebsite);
                } else if (PreinstalledApplicationTypeEnum.CS_APPLICATION.getValue().equals(preAppLink.getType())) {
                    StringBuilder cloudwebsite = new StringBuilder(preAppLink.getCloudwebsite());
                    JSONObject jsonObject = JSONObject.parseObject(getSsoJobUrl(systemData));
                    if (null != jsonObject) {
                        for (String key : jsonObject.keySet()) {
                            Object value = jsonObject.get(key);
                            cloudwebsite.append("&").append(key).append("=").append(value);
                        }
                    }
                    preAppLink.setCloudwebsite(cloudwebsite.toString());
                } else if (PreinstalledApplicationTypeEnum.SPECIAL_APPLICATION.getValue().equals(preAppLink.getType())) {
                    // 针对TT应用，支持配置作业参数，即把预设的作业参数替换掉
                    if (Constants.TIPTOP_PRODUCT_TYPE.equals(preAppLink.getProductCode())) {
                        String cloudwebsite = preAppLink.getCloudwebsite();
                        // 动态参数
                        JSONObject jsonObject = JSONObject.parseObject(getSsoJobUrl(systemData));
                        if (ObjectUtils.isNotEmpty(jsonObject)) {
                            List<PreinstalledApplication> preInstalledAppList = preinstalledApplicationService.queryPreinstalledAppList(AppAuthContextHolder.getContext().getAuthoredUser());
                            List<PreinstalledApplication> TTAppList = preInstalledAppList.stream().filter(x -> Constants.TIPTOP_PRODUCT_TYPE.equals(x.getProductCode())).collect(Collectors.toList());
                            StringBuilder arg = new StringBuilder();
                            for (String key : jsonObject.keySet()) {
                                Object value = jsonObject.get(key);
                                arg.append("&").append(key).append("=").append(value);
                            }
                            for (PreinstalledApplication x : TTAppList) {
                                if (preAppLink.getPrimaryId().equals(String.valueOf(x.getId()))) {
                                    ErpSsoSpecialDTO erpSsoSpecialDTO = Optional.ofNullable(JSONObject.parseObject(x.getApplicationConfig(), ErpSsoSpecialDTO.class)).orElse(new ErpSsoSpecialDTO());
                                    cloudwebsite = cloudwebsite.replaceAll("&Arg=" + erpSsoSpecialDTO.getJobCode(), arg.toString());
                                }
                            }
                        }
                        preAppLink.setCloudwebsite(cloudwebsite);
                    } else if (Constants.T100_PRODUCT_TYPE.equals(preAppLink.getProductCode())) {
                        String cloudwebsite = preAppLink.getCloudwebsite();
                        // 动态参数
                        JSONObject jsonObject = JSONObject.parseObject(getSsoJobUrl(systemData));
                        if (ObjectUtils.isNotEmpty(jsonObject) && jsonObject.containsKey("Arg")) {
                            String value = jsonObject.getString("Arg");
                            cloudwebsite = cloudwebsite.replaceAll("azzi000", value);
                        }
                        preAppLink.setCloudwebsite(cloudwebsite);
                    } else {
                        StringBuilder cloudwebsite = new StringBuilder(preAppLink.getCloudwebsite());
                        JSONObject jsonObject = JSONObject.parseObject(getSsoJobUrl(systemData));
                        if (ObjectUtils.isNotEmpty(jsonObject)) {
                            for (String key : jsonObject.keySet()) {
                                Object value = jsonObject.get(key);
                                cloudwebsite.append("&").append(key).append("=").append(value);
                            }
                        }
                        preAppLink.setCloudwebsite(cloudwebsite.toString());
                    }
                } else if (PreinstalledApplicationTypeEnum.IAM_APPLICATION.getValue().equals(preAppLink.getType())) {
                    String cloudwebsite = appendJobField(preAppLink, systemData);
                    preAppLink.setCloudwebsite(cloudwebsite);
                }
                appendAccountSet(preAppLink,systemData);
            }
            return preAppLink;
        }
        // 雅典娜应用
        else if (ApplicationTypeEnum.IAM_APPLICATION.getType().equals(dataType)) {
            List<AppLinkDTO> athenaAppList = appLinkService.queryDefaultGroup(AppAuthContextHolder.getContext().getAuthoredUser());
            if (CollectionUtils.isEmpty(athenaAppList)) {
                return appLinkDTO;
            }
            Map<String, AppLinkDTO> idMap = athenaAppList.stream().collect(Collectors.toMap(AppLinkDTO::getPrimaryId, Function.identity()));
            AppLinkDTO athenaAppLink = idMap.get(appCode);
            if (athenaAppLink == null) {
                return appLinkDTO;
            }
            // 如果构建的是作业，则拼接作业属性
            if (Constants.DataCategoryEnum.CATEGORY_WORK.getVal().equals(dataCategory)) {
                String cloudwebsite = appendJobField(athenaAppLink, systemData);
                athenaAppLink.setCloudwebsite(cloudwebsite);
            }
            return athenaAppLink;
        }
        //鼎捷雅典娜APP作业
        else if (dataType.equals(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType())
                && appCode.equals(VirtualApplicationEnum.ATHENA_APP.getPrimaryId())) {
            //移动app方式展示
            appLinkDTO.setShowType(1);
            //如果是自定义作业地址
            //是否需要自定义作业（0：不需要；1：需要）
            if (null != systemData.getIsJob() && systemData.getIsJob() == 1) {
                appLinkDTO.setNeedAuthCodeFlag(0);
                appLinkDTO.setIsHavePerm(Boolean.TRUE);
                appLinkDTO.setCloudwebsite(systemData.getCallBackUrl());
                return appLinkDTO;
            }
            MobileSSOReq mobileSSOReq = new MobileSSOReq();
            appLinkDTO.setIsHavePerm(Boolean.FALSE);
            if (StringUtils.isEmpty(systemData.getWorkCode())) {
                return appLinkDTO;
            }
            mobileSSOReq.setCustomApplicationId(systemData.getWorkCode());
            FullBackResp fullCallBackUrl = mobilePortalService.getFullCallBackUrl(mobileSSOReq);
            if (null == fullCallBackUrl) {
                return appLinkDTO;
            }
            if (!fullCallBackUrl.getIsHavePerm()) {
                return appLinkDTO;
            }
            appLinkDTO.setCloudwebsite(fullCallBackUrl.getMobileCloudWebsite());
            appLinkDTO.setIsHavePerm(fullCallBackUrl.getIsHavePerm());
            appLinkDTO.setNeedAuthCodeFlag(fullCallBackUrl.getIsNeedCode() ? 1 : 0);
        }
        // 帆软报表
        else if (dataType.equals(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType())
                && appCode.equals(VirtualApplicationEnum.FINE_REPORT_APP.getPrimaryId())) {
            appLinkDTO.setNeedAuthCodeFlag(Constants.NEED_AUTH_CODE_FLAG_NO);
            // 查询当前租户的帆软应用配置publicKey
            FineReportConfigDTO fineReportConfigDTO = tripartiteApplicationService.queryFineReportConfig();
            if (ObjectUtils.isEmpty(fineReportConfigDTO) || StringUtils.isBlank(fineReportConfigDTO.getPublicKey())) {
                return appLinkDTO;
            }
            // 获取当前用户映射的帆软账号
            FineReportUserMapping fineReportUserMapping = fineReportManageService.queryCurrentUserMapping();
            if (ObjectUtils.isEmpty(fineReportUserMapping)) {
                return appLinkDTO;
            }
            FineReportTreeVO fineReportTreeVO = JSON.parseObject(systemData.getFineReportParam(), FineReportTreeVO.class);
            if (ObjectUtils.isEmpty(fineReportTreeVO)) {
                return appLinkDTO;
            }
            String fineReportUrl = buildFineReportUrl(fineReportConfigDTO, fineReportUserMapping.getFrUserId(), fineReportTreeVO.getPath(), null);
            appLinkDTO.setCloudwebsite(fineReportUrl);
        }
        return appLinkDTO;
    }

    /**
     * 构建帆软报表跳转链接
     *
     * @param fineReportConfigDTO 帆软应用配置
     * @param frUserId            帆软用户账号
     * @param path                报表路径
     * @param deviceType          设备类型
     * @return 返回
     */
    private String buildFineReportUrl(FineReportConfigDTO fineReportConfigDTO, String frUserId, String path, Integer deviceType) {
        // 加密文本，如果开启了【ssoToken超时设置】功能，则传入时间戳和用户名
        String plainText = frUserId;
        if (ObjectUtils.isNotEmpty(fineReportConfigDTO.getTokenTimeoutFlag()) && Boolean.TRUE.equals(fineReportConfigDTO.getTokenTimeoutFlag())) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("username", frUserId);
            jsonObject.put("issueTime", System.currentTimeMillis()); // 当前时间的毫秒时间戳
            plainText = JSON.toJSONString(jsonObject);
        }
        // 公钥，帆软决策系统中【系统管理】-【集成后台单点登录】中生成的publicKey
        String publicKey = fineReportConfigDTO.getPublicKey();
        // 加密后的ssoToken,可在帆软决策系统中【系统管理】-【集成后台单点登录】页面进行解密测试
        String encryptToken = RsaEncryptUtil.encrypt(plainText, publicKey);
        String encodeToken;
        try {
            // encode后的ssoToken,可以直接放于url上进行单点
            encodeToken = URLEncoder.encode(encryptToken, "UTF-8");
        } catch (Exception e) {
            log.error("URLEncoder.encode(encryptToken) occur error.encryptToken:{}", encryptToken, e);
            throw new RuntimeException(e);
        }
        String fineReportUrl;
        // 组装帆软报表链接
        if (path.endsWith(Constants.CPT_FINE_REPORT_END)) {
            fineReportUrl = envProperties.getFineReportUrl() + Constants.CPT_FINE_REPORT_PATH + path;
        } else if (path.endsWith(Constants.FRM_FINE_REPORT_END)) {
            fineReportUrl = envProperties.getFineReportUrl() + Constants.FRM_FINE_REPORT_PATH + path;
        } else {
            fineReportUrl = envProperties.getFineReportUrl() + Constants.FVS_FINE_REPORT_PATH + path;
        }
        // 移动端报表固定拼接"op=h5"
        if (ObjectUtils.isNotEmpty(deviceType) && Constants.MOBILE_FINE_REPORT.equals(deviceType)) {
            fineReportUrl = fineReportUrl + "&op=h5&ssoToken=" + encodeToken;
        } else {
            fineReportUrl = fineReportUrl + "&ssoToken=" + encodeToken;
        }
        return fineReportUrl;
    }

    /**
     * 组装每刻跳转地址
     *
     * @param appLinkDTO
     * @return
     */
    public String getMaycurSsoUrl(AppLinkDTO appLinkDTO, Integer dataCategory, LabelSystemData systemData) {
        String ssoUrl = "";
        //获取工号
        String userId = eocService.getEmpJobNum();
        if (StringUtils.isEmpty(userId)) {
            return "";
        }
        PreinstalledApplicationInstance preinstalledIns = preinstalledApplicationService.getPreINstance(Long.parseLong(appLinkDTO.getPrimaryId()), "", "");
        if (null == preinstalledIns || null == preinstalledIns.getApplicationExtConfig()) {
            return "";
        }
        //取回调地址
        String callBackUrl = preinstalledIns.getApplicationExtConfig().getString("callBackUrl");
        String appId = preinstalledIns.getApplicationExtConfig().getString("appId");
        String appSecret = preinstalledIns.getApplicationExtConfig().getString("appSecret");
        long timestamp = System.currentTimeMillis();

        //获取ssoToken
        String ssoToken = mayCurService.getSsoToken(userId, appSecret, timestamp);
        //组装首页跳转链接地址
        ssoUrl = mayCurService.getHomeSsoUrl(callBackUrl, appId, userId, ssoToken, timestamp);
        //作业
        if (Constants.DataCategoryEnum.CATEGORY_WORK.getVal().equals(dataCategory)) {
            String jobUrl = getSsoJobUrl(systemData);
            //每刻云票的作业跳转地址
            if (StringUtils.isNotEmpty(jobUrl) && MaycurCodeEnum.MAYCUR_CLOUD.getType().equals(appLinkDTO.getCode())) {
                ssoUrl = mayCurService.getCloudSsoUrl(callBackUrl, appId, userId, ssoToken, jobUrl, timestamp);
            }
            //每刻报销的作业跳转地址
            if (StringUtils.isNotEmpty(jobUrl) && MaycurCodeEnum.MAYCUR_APPROVALS.getType().equals(appLinkDTO.getCode())) {
                ssoUrl = mayCurService.getJobSsoUrl(callBackUrl, appId, userId, ssoToken, jobUrl, timestamp);
            }
        }
        appLinkDTO.setCloudwebsite(ssoUrl);
        return ssoUrl;
    }

    /**
     * 拼接作业地址
     *
     * @param jobUrl
     * @return
     */
    public String packageJobUrl(String jobUrl) {
        if (StringUtils.isEmpty(jobUrl)) {
            return "";
        }
        if (jobUrl.contains("?")) {
            return jobUrl;
        } else {
            return "?" + jobUrl;
        }
    }

    /**
     * 获取作业同步中的作业地址
     *
     * @param systemData
     * @return
     */
    public String getSsoJobUrl(LabelSystemData systemData) {
        //是否需要自定义作业（0：不需要；1：需要）
        if (null != systemData.getIsJob() && systemData.getIsJob() == 1) {
            return systemData.getCallBackUrl();
        }
        List<SyncJobInfo> syncJobInfoList = syncJobInfoMapper.selectList(getJobCondition(systemData.getAppId(), systemData.getWorkCode()));
        if (CollectionUtils.isNotEmpty(syncJobInfoList)) {
            return syncJobInfoList.get(0).getJobUrl();
        }
        return "";
    }


    /**
     * 查询作业信息
     */
    public QueryWrapper getJobCondition(String appId, String jobCode) {
        QueryWrapper<SyncJobInfo> condition = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(jobCode)) {
            condition.eq("job_code", jobCode);
        }
        if (StringUtils.isNotEmpty(appId)) {
            condition.eq("app_id", appId);
        }
        return condition;
    }


    /**
     * 拼接作业属性
     *
     * @param athenaAppLink 应用
     * @param systemData    源数据
     * @return 返回对象
     */
    private String appendJobField(AppLinkDTO athenaAppLink, LabelSystemData systemData) {
        String cloudwebsite = athenaAppLink.getCloudwebsite();
        // 查询km应用作业池
        List<AppJobDTO> appJobDTOList = kmService.queryAppJobList();
        if (CollectionUtils.isEmpty(appJobDTOList)) {
            return cloudwebsite;
        }
        AppJobDTO appJobDTO = appJobDTOList.stream().filter(x -> athenaAppLink.getId().equals(x.getAppCode())).findFirst().orElse(null);
        if (appJobDTO == null) {
            return cloudwebsite;
        }
        AppJobDTO.Job job = appJobDTO.getData().stream().filter(x -> systemData.getWorkCode().equals(x.getCode())).findFirst().orElse(null);
        if (job == null) {
            return cloudwebsite;
        }
        //获取作业跳转路径映射类型
        cloudwebsite = cloudwebsite + "&code=" + job.getCode() + "&name=" + job.getName() + "&type=" + job.getType()
                + "&category=" + job.getCategory() + "&ifCustom=" + job.getIfCustom();

        // 如果配置了动态参数，则需要拼接
        if (StringUtils.isNotBlank(systemData.getJobLinkParam())) {
            StringBuilder stringBuilder = Utils.buildWebLinkUrl(systemData.getJobLinkParam());
            cloudwebsite = cloudwebsite + "&" + stringBuilder;
        }
        String jobType = getJobTypeMap(job.getType());
        // 将作业地址替换成前端跳转的路径
        if (StringUtils.isNotEmpty(jobType)) {
            cloudwebsite = cloudwebsite.replace("sso-login", jobType);
        }
        return cloudwebsite;
    }

    /**
     * 获取作业跳转路径映射map
     *
     * @return
     */
    public String getJobTypeMap(String type) {
        Map<String, String> jobTypeMap = new HashMap<>();
        //基础资料/公共作业
        jobTypeMap.put("baseDataEntry".toLowerCase(), "base-data-entry");
        jobTypeMap.put("statement".toLowerCase(), "report");
        jobTypeMap.put("manualStartProject".toLowerCase(), "add-task");
        return jobTypeMap.get(type.toLowerCase());
    }

    /**
     * 构建BS应用SSO信息
     *
     * @param thirdSsoInfo 入参
     * @return 返回
     */
    private AppLinkDTO buildBSAppLinkDTO(ThirdSsoInfoDto thirdSsoInfo) {
        AppLinkDTO appLink = new AppLinkDTO();
        appLink.setPrimaryId(String.valueOf(thirdSsoInfo.getId()));
        appLink.setId(thirdSsoInfo.getCode());
        appLink.setName(thirdSsoInfo.getName());
        appLink.setDesc(thirdSsoInfo.getAppDesc());
        appLink.setAppToken(thirdSsoInfo.getAppToken());
        appLink.setType(PreinstalledApplicationTypeEnum.BS_APPLICATION.getValue());
        appLink.setSystemType(ApplicationTypeEnum.BS_APPLICATION.getType());
        appLink.setDataSource(ApplicationTypeEnum.BS_APPLICATION.getType());
        appLink.setCloudwebsite(MapUtils.isNotEmpty(thirdSsoInfo.getExt()) ? thirdSsoInfo.getExt().get("_fullpath").toString() : "");
        appLink.setApplicationAppId(thirdSsoInfo.getAppId());
        appLink.setCallBackUrl(thirdSsoInfo.getCallBackUrl());
        appLink.setUserBindFlag(thirdSsoInfo.getUserBindFlag());
        if (Arrays.asList(Constants.BindFlagEnum.AUTO.getFlag(), Constants.BindFlagEnum.HAND.getFlag()).contains(thirdSsoInfo.getUserBindFlag())) {
            appLink.setNeedAuthCodeFlag(Constants.NEED_AUTH_CODE_FLAG_YES);
        }
        return appLink;
    }

    /**
     * 构建CS应用SSO信息
     *
     * @param erpSsoInfo CS应用
     * @return 返回
     */
    private AppLinkDTO buildCSAppLinkDTO(ErpSsoInfo erpSsoInfo) {
        AppLinkDTO appLink = new AppLinkDTO();
        appLink.setPrimaryId(String.valueOf(erpSsoInfo.getId()));
        appLink.setId(erpSsoInfo.getCode());
        appLink.setName(erpSsoInfo.getName());
        appLink.setDesc(erpSsoInfo.getAppDesc());
        appLink.setAppToken(erpSsoInfo.getAppToken());
        appLink.setType(PreinstalledApplicationTypeEnum.CS_APPLICATION.getValue());
        appLink.setSystemType(ApplicationTypeEnum.CS_APPLICATION.getType());
        appLink.setDataSource(ApplicationTypeEnum.CS_APPLICATION.getType());
        appLink.setCloudwebsite(MapUtils.isNotEmpty(erpSsoInfo.getExt()) ? erpSsoInfo.getExt().get("_fullpath").toString() : "");
        appLink.setApplicationAppId(erpSsoInfo.getAppId());
        appLink.setCallBackUrl(erpSsoInfo.getCallBackUrl());
        appLink.setUserBindFlag(erpSsoInfo.getUserBindFlag());
        if (Arrays.asList(Constants.BindFlagEnum.AUTO.getFlag(), Constants.BindFlagEnum.HAND.getFlag()).contains(erpSsoInfo.getUserBindFlag())) {
            appLink.setNeedAuthCodeFlag(Constants.NEED_AUTH_CODE_FLAG_YES);
        }
        return appLink;
    }

    /**
     * 获取统计类型跳转链接
     *
     * @param labelSystemCountDataDTO 请求入参
     * @return 返回
     */
    public AppLinkDTO queryCountLink(LabelSystemCountDataDTO labelSystemCountDataDTO) {
        LabelSystemCountDataDTO.JobInfo jobInfo = labelSystemCountDataDTO.getJobInfo();
        LabelSystemData systemData = new LabelSystemData();
        systemData.setDataCategory(Constants.DataCategoryEnum.CATEGORY_WORK.getVal());
        systemData.setAppCode(jobInfo.getAppPrimaryId());
        systemData.setDataType(jobInfo.getDataType());
        systemData.setIsJob(jobInfo.getIsJob());
        systemData.setWorkCode(jobInfo.getWorkCode());
        systemData.setCallBackUrl(jobInfo.getCallBackUrl());
        return buildCustomApp(systemData);
    }

    private void appendAccountSet(AppLinkDTO appLink, LabelSystemData systemData) {
        if(Objects.nonNull(appLink) && StringUtils.isNotBlank(appLink.getCloudwebsite()) && Objects.nonNull(systemData)){
            String url = appLink.getCloudwebsite();
            if (Constants.DataCategoryEnum.CATEGORY_WORK.getVal().equals(systemData.getDataCategory()) && StringUtils.isNotBlank(systemData.getAccountId())) {
                appLink.setCloudwebsite(url+"&accountId="+systemData.getAccountId());
            }
        }
    }

    /**
     * 获取帆软报表链接
     * 调用处：
     * 1、小AI全部报表页面点击，deviceType传1，表示pc端触发
     * 2、移动端后端，deviceType传2，表示移动端触发
     *
     * @param queryFineReportUrlReq 请求入参
     * @return 查询结果
     */
    public JSONObject queryFineReportUrl(QueryFineReportUrlReq queryFineReportUrlReq) {
        JSONObject resp = new JSONObject();
        // 查询当前用户(包括所属组织和角色)有权限的报表，校验是否可以查看
        List<FineReportAuth> fineReportAuthList = fineReportAuthService.queryFineReportAuthList();
        if (CollectionUtils.isEmpty(fineReportAuthList)) {
            resp.put("errorCode", "1001"); // 无权限
            resp.put("fineReportUrl", "");
            return resp;
        }

        // 是否有查看全部报表的权限，如果没有，则进一步判断是否有匹配的报表
        boolean allFlag = fineReportAuthList.stream().noneMatch(x -> Constants.ALL_AUTH_FLAG_YES.equals(x.getAllAuthFlag()));
        if (allFlag) {
            // 权限内的报表不包含当前报表
            boolean matchedFlag = fineReportAuthList.stream().noneMatch(x -> queryFineReportUrlReq.getReportId().equals(x.getFineReportId()));
            if (matchedFlag) {
                resp.put("errorCode", "1001"); // 无权限
                resp.put("fineReportUrl", "");
                return resp;
            }
        }

        // 查询当前用户映射的帆软用户
        FineReportUserMapping fineReportUserMapping = fineReportManageService.queryCurrentUserMapping();
        if (ObjectUtils.isEmpty(fineReportUserMapping)) {
            resp.put("errorCode", "1002"); // 当前用户映射的帆软账号不存在
            resp.put("fineReportUrl", "");
            return resp;
        }

        // 查询当前租户的帆软应用配置
        FineReportConfigDTO fineReportConfigDTO = tripartiteApplicationService.queryFineReportConfig();
        if (ObjectUtils.isEmpty(fineReportConfigDTO)) {
            resp.put("errorCode", "1003"); // 报表配置不存在
            resp.put("fineReportUrl", "");
            return resp;
        }

        // 移动端点击没有报表路径，则查询报表数据，pc端【全部】-【报表】页面点击报表，前端可以传path，不需要查询
        String path = queryFineReportUrlReq.getPath();
        if (StringUtils.isEmpty(path)) {
            List<FineReportTreeVO> totalFineReportList = Lists.newArrayList();
            // pc端
            if (Constants.PC_FINE_REPORT.equals(queryFineReportUrlReq.getDeviceType())) {
                queryFineReportListByDeviceType(fineReportConfigDTO, Constants.FineReportDeviceEnum.PC_DEVICVE.getFlag(), totalFineReportList);
            }
            // 移动端
            else if (Constants.MOBILE_FINE_REPORT.equals(queryFineReportUrlReq.getDeviceType())) {
                List<String> deviceTypeList = Arrays.asList(Constants.FineReportDeviceEnum.PAD_DEVICVE.getFlag(),
                        Constants.FineReportDeviceEnum.PFONE_DEVICE.getFlag());
                deviceTypeList.forEach(x -> queryFineReportListByDeviceType(fineReportConfigDTO, x, totalFineReportList));
            }

            // 过滤出当前报表
            FineReportTreeVO fineReportTreeVO = totalFineReportList.stream().filter(x -> queryFineReportUrlReq.getReportId().equals(x.getId())).findFirst().orElse(null);
            if (ObjectUtils.isEmpty(fineReportTreeVO)) {
                resp.put("errorCode", "1004"); // 报表不存在
                resp.put("fineReportUrl", "");
                return resp;
            }
            path = fineReportTreeVO.getPath();
        }

        // 构建报表链接
        String fineReportUrl = buildFineReportUrl(fineReportConfigDTO, fineReportUserMapping.getFrUserId(), path, queryFineReportUrlReq.getDeviceType());
        resp.put("errorCode", "1000");
        resp.put("fineReportUrl", fineReportUrl);
        return resp;
    }

    /**
     * 查询帆软报表列表
     *
     * @param fineReportConfigDTO 帆软应用配置
     * @param deviceType          设备类型
     * @param totalFineReportList 返回列表
     */
    private void queryFineReportListByDeviceType(FineReportConfigDTO fineReportConfigDTO, String deviceType, List<FineReportTreeVO> totalFineReportList) {
        List<FineReportTreeVO> fineReportTreeList = fineReportProxyService.queryFineReportEntryTree(fineReportConfigDTO.getClientId(), fineReportConfigDTO.getSecret(), deviceType);
        fineReportTreeList = fineReportTreeList.stream().filter(y -> Constants.FINE_REPORT_TYPE.equals(y.getEntryType())).sorted(Comparator.comparing(FineReportTreeVO::getSortIndex)).collect(Collectors.toList());
        totalFineReportList.addAll(fineReportTreeList);
    }
}