package com.digiwin.athena.semc.service.portal.impl;


import com.alibaba.fastjson.JSON;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.enums.EAIServiceNameEnum;
import com.digiwin.athena.semc.dto.portal.LabelSystemCountDataDTO;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.mapper.portal.LabelSystemDataMapper;
import com.digiwin.athena.semc.proxy.esp.service.ESPService;
import com.digiwin.athena.semc.proxy.tripartite.service.TripartiteService;
import com.digiwin.athena.semc.service.portal.LabelSystemCountService;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Slf4j
@Service
public class LabelSystemCountServiceImpl implements LabelSystemCountService {

    @Resource
    private ESPService espService;

    @Resource
    private TripartiteService tripartiteService;

    @Resource
    LabelSystemDataMapper labelSystemDataMapper;


    /**
     * 统计分类是否选中标识 0：否 1：是
     */
    private static final Integer CONTENT_SELECTED_FlAG = 1;


    /**
     * 获取统计组件第三方的统计类型配置
     *
     * @param labelSystemData 请求参数
     * @return 统计类型及内容的集合
     */
    @Override
    public JSONArray queryCountConfigData(LabelSystemData labelSystemData) {
        Map<String, Object> result;
        // 获取语系
        String locale = LocaleContextHolder.getLocale().toString();

        // 混合云方式，通过esp的方式调用
        if (Constants.DataModelEnum.MODEL_HYBRID_CLOUD.getVal().equals(labelSystemData.getDataModel())) {
            // 封装查询条件
            Map<String, Object> params = new HashMap<>();
            params.put("locale", locale);
            result = espService.queryByEsp(labelSystemData.getMiddleSystemName(), labelSystemData.getMiddleSystemUid(),
                    EAIServiceNameEnum.COUNT_COMPONENT_LIST.getServiceName(), null, params, "", null);
        } else {   // 非混合云，直接https的方式调用
            result = tripartiteService.selectDataCountListPost(null, null, labelSystemData.getRestUrl() + "/third/count/queryConfigList", locale);
        }
        if (MapUtils.isEmpty(result)
                || (ObjectUtils.isEmpty(result.get("countConfigList"))) && ObjectUtils.isEmpty(result.get("count_config_list"))) {
            return new JSONArray();
        }

        return ObjectUtils.isNotEmpty(result.get("countConfigList")) ? JSONArray.fromObject(result.get("countConfigList"))
                : JSONArray.fromObject(result.get("count_config_list"));
    }

    /**
     * 获取三方应用统计类型指标数据--前端可视化查询接口
     *
     * @param labelSystemData 数据源信息
     * @return jsonArray
     */
    @Override
    public Map<String, Object> queryCountContentDataByConfig(LabelSystemData labelSystemData) {
        Map<String, Object> result = Maps.newHashMap();
        //获取对应的语系
        String locale = LocaleContextHolder.getLocale().toString();

        // 获取选中的统计类型指标数据
        String countContentInfo = labelSystemData.getCountContentCode();
        if (StringUtils.isBlank(labelSystemData.getCountCode()) || StringUtils.isBlank(countContentInfo)) {
            return result;
        }
        List<LabelSystemCountDataDTO> countDataDTOList = JSON.parseArray(countContentInfo, LabelSystemCountDataDTO.class);
        List<String> contentCodeList = countDataDTOList.stream().filter(x -> CONTENT_SELECTED_FlAG.equals(x.getSelectedFlag())).map(LabelSystemCountDataDTO::getContentCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(contentCodeList)) {
            return result;
        }

        // 混合云
        if (Constants.DataModelEnum.MODEL_HYBRID_CLOUD.getVal().equals(labelSystemData.getDataModel())) {
            Map<String, Object> params = new HashMap<>();
            params.put("countType", labelSystemData.getCountCode());
            params.put("countContent", contentCodeList);
            params.put("locale", locale);
            result = espService.queryByEsp(labelSystemData.getMiddleSystemName(), labelSystemData.getMiddleSystemUid(),
                    EAIServiceNameEnum.COUNT_FRONT_COMPONENT_LIST.getServiceName(), null, params, "", null);
        } else { //非混合云，直接https的方式调用
            result = tripartiteService.selectDataCountListPost(labelSystemData.getCountCode(), contentCodeList, labelSystemData.getRestUrl() + "/third/count/queryContentListByConfig", locale);
        }
        if (MapUtils.isEmpty(result)
                || (ObjectUtils.isEmpty(result.get("countContentList"))) && ObjectUtils.isEmpty(result.get("count_content_list"))) {
            return new HashMap<>();
        }

        // 判断指标是否可以点击跳转
        JSONArray jsonArray = ObjectUtils.isNotEmpty(result.get("countContentList")) ? JSONArray.fromObject(result.get("countContentList"))
                : JSONArray.fromObject(result.get("count_content_list"));
        Map<String, LabelSystemCountDataDTO> contentCodeMap = countDataDTOList.stream().collect(Collectors.toMap(LabelSystemCountDataDTO::getContentCode, Function.identity(), (a, b) -> a));
        for (Object item : jsonArray) {
            JSONObject jsonObject = (JSONObject) item;
            String linkStr = jsonObject.getString("count_link");
            String countCode = jsonObject.getString("count_code");
            if (StringUtils.isEmpty(linkStr)) {
                // 判断是否配置了作业
                LabelSystemCountDataDTO labelSystemCountDataDTO = contentCodeMap.get(countCode);
                if (ObjectUtils.isNotEmpty(labelSystemCountDataDTO)
                        && ObjectUtils.isNotEmpty(labelSystemCountDataDTO.getJobInfo())
                        && ObjectUtils.isNotEmpty(labelSystemCountDataDTO.getJobInfo().getAppPrimaryId())
                        && ObjectUtils.isNotEmpty(labelSystemCountDataDTO.getJobInfo().getDataType())
                        && ((Constants.IsNeedJobEnum.NEED_CUSTOM_JOB.getValue().equals(labelSystemCountDataDTO.getJobInfo().getIsJob())
                        && StringUtils.isNotBlank(labelSystemCountDataDTO.getJobInfo().getCallBackUrl())) || (Constants.IsNeedJobEnum.NOT_NEED_JOB.getValue().equals(labelSystemCountDataDTO.getJobInfo().getIsJob())
                        && StringUtils.isNotBlank(labelSystemCountDataDTO.getJobInfo().getWorkCode())))) {
                    jsonObject.put("ifLink", true);
                } else {
                    jsonObject.put("ifLink", false);
                }
            } else {
                jsonObject.put("ifLink", true);
                jsonObject.put("count_link", null);
                LabelSystemCountDataDTO labelSystemCountDataDTO = contentCodeMap.get(countCode);
                // 保存统计类型跳转链接
                if (ObjectUtils.isNotEmpty(labelSystemCountDataDTO)) {
                    labelSystemCountDataDTO.setContentLink(linkStr);
                    String contentInfoStr = new Gson().toJson(countDataDTOList);
                    labelSystemData.setCountContentCode(contentInfoStr);
                    labelSystemDataMapper.updateById(labelSystemData);
                }
            }
        }
        result.put("countContentList", jsonArray);
        return result;
    }
}
