package com.digiwin.athena.semc.service.portal.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.event.SyncReadListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.*;
import com.digiwin.athena.semc.common.enums.VirtualApplicationEnum;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.LabelSystemCustomQueryReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemCustomSaveReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemLinkParamDTO;
import com.digiwin.athena.semc.dto.portal.QueryImportRecordReq;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.menu.CustomizedMenuTemplate;
import com.digiwin.athena.semc.entity.portal.*;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.menu.CustomizedMenuTemplateMapper;
import com.digiwin.athena.semc.mapper.portal.*;
import com.digiwin.athena.semc.proxy.km.service.KmService;
import com.digiwin.athena.semc.proxy.mdc.MdcService;
import com.digiwin.athena.semc.proxy.trans.service.TranslateService;
import com.digiwin.athena.semc.service.applink.AppLinkService;
import com.digiwin.athena.semc.service.portal.IImportRecordService;
import com.digiwin.athena.semc.service.portal.LabelSystemCustomService;
import com.digiwin.athena.semc.service.portal.LabelSystemPreService;
import com.digiwin.athena.semc.service.portal.RelatedAppServiceWrapper;
import com.digiwin.athena.semc.service.workbench.constant.WorkBenchConstant;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.InterceptorIgnoreUtil;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.common.AuthSystemLabelReq;
import com.digiwin.athena.semc.vo.common.BizObjAuthRelBatchSystemVo;
import com.digiwin.athena.semc.vo.portal.*;
import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import io.github.linpeilie.Converter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


@Slf4j
@Service
public class LabelSystemCustomServiceImpl extends ServiceImpl<LabelSystemCustomMapper, LabelSystemCustom> implements LabelSystemCustomService {

    @Resource
    MessageUtils messageUtils;

    @Resource
    LabelSystemCustomMapper labelSystemCustomMapper;

    @Resource
    LabelSystemSourceMapper labelSystemSourceMapper;

    @Resource
    PortalLayoutCustomMapper portalLayoutCustomMapper;

    @Resource
    LabelSystemDataMapper labelSystemDataMapper;

    @Autowired
    PortalInfoContentMapper portalInfoContentMapper;

    @Autowired
    CustomizedMenuTemplateMapper customizedMenuTemplateMapper;

    @Autowired
    MdcService mdcService;

    @Resource
    private IImportRecordService importRecordService;

    @Resource
    private EnvProperties envProperties;

    @Resource
    private LabelSystemCustomImportMapper labelSystemCustomImportMapper;

    @Resource
    private Converter converter;

    @Autowired
    private AppLinkService appLinkService;

    @Autowired
    private LabelSystemPreService labelSystemPreService;

    @Resource
    private LabelSystemPreMapper labelSystemPreMapper;

    @Resource
    private TranslateService translateService;

    @Autowired
    private RelatedAppServiceWrapper relatedAppServiceWrapper;

    @Autowired
    private KmService kmService;

    @Resource
    private PortalInfoMapper portalInfoMapper;

    /**
     * 经典门户图标数量
     */
    public static final int CLASSIC_ICON_COUNT = 20;

    @Override
    public ResultPageBean pageQuery(LabelSystemCustomQueryReq labelSystemCustomQueryReq) {
        String tenantVersion = kmService.queryTenantVersion();
        ResultPageBean resultPageBean;
        List<LabelSystemCustom> labelSystemCustomList = new ArrayList<>();
        if (!Objects.equals(1,labelSystemCustomQueryReq.getQueryCondition().getSource())) {
            if (CollectionUtils.isNotEmpty(labelSystemCustomQueryReq.getQueryCondition().getAppCodeList())
                    || CollectionUtils.isNotEmpty(labelSystemCustomQueryReq.getQueryCondition().getAccountIds())) {
                LabelSystemCustomQueryReq.QueryCondition queryCondition = labelSystemCustomQueryReq.getQueryCondition();
                Map<String, Object> req = new HashMap<>();
                req.put("appCodeList", queryCondition.getAppCodeList());
                req.put("accountIds", queryCondition.getAccountIds());
                List<Long> longs = labelSystemCustomMapper.queryCustomLabelIdByApp(queryCondition.getNameZh(), queryCondition.getDataCategory(), queryCondition.getValidStatus(), req, labelSystemCustomQueryReq.getClientType(), labelSystemCustomQueryReq.getQueryCondition().getSource(),AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                if (CollectionUtils.isNotEmpty(longs)) {
                    LambdaQueryWrapper<LabelSystemCustom> queryPreWrapper = new LambdaQueryWrapper<>();
                    queryPreWrapper.in(LabelSystemCustom::getId, longs);
                    labelSystemCustomList = labelSystemCustomMapper.selectList(queryPreWrapper);
                }
            } else {
                LambdaQueryWrapper<LabelSystemCustom> queryPreWrapper = new LambdaQueryWrapper<>();
                queryPreWrapper.eq(LabelSystemCustom::getTenantId, AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                queryPreWrapper.like(!StringUtils.isEmpty(labelSystemCustomQueryReq.getQueryCondition().getNameZh()), LabelSystemCustom::getNameZh,
                        labelSystemCustomQueryReq.getQueryCondition().getNameZh());
                queryPreWrapper.eq(!Objects.isNull(labelSystemCustomQueryReq.getQueryCondition().getValidStatus()), LabelSystemCustom::getValidStatus,
                        labelSystemCustomQueryReq.getQueryCondition().getValidStatus());
                queryPreWrapper.in(!CollectionUtils.isEmpty(labelSystemCustomQueryReq.getQueryCondition().getDataCategory()), LabelSystemCustom::getDataCategory,
                        labelSystemCustomQueryReq.getQueryCondition().getDataCategory());
                queryPreWrapper.eq(LabelSystemCustom::getClientType, labelSystemCustomQueryReq.getClientType());
                queryPreWrapper.eq(Objects.nonNull(labelSystemCustomQueryReq.getQueryCondition().getSource()), LabelSystemCustom::getSource,
                        labelSystemCustomQueryReq.getQueryCondition().getSource());
                labelSystemCustomList = labelSystemCustomMapper.selectList(queryPreWrapper);
            }
        }
        // 查询出isv自定义组件有权限的部件id
        //查询所有有权限的isv部件id的集合
        if (!Objects.equals(0,labelSystemCustomQueryReq.getQueryCondition().getSource())) {
            List<Long> ids = getLableSysTemCustomIds(tenantVersion, labelSystemCustomQueryReq.getClientType());
            if (CollectionUtils.isNotEmpty(ids)) {
                List<LabelSystemCustom> labelSystemCustoms = new ArrayList<>();
                if (CollectionUtils.isNotEmpty(labelSystemCustomQueryReq.getQueryCondition().getAppCodeList())
                        || CollectionUtils.isNotEmpty(labelSystemCustomQueryReq.getQueryCondition().getAccountIds())) {
                    LabelSystemCustomQueryReq.QueryCondition queryCondition = labelSystemCustomQueryReq.getQueryCondition();
                    Map<String, Object> req = new HashMap<>();
                    req.put("appCodeList", queryCondition.getAppCodeList());
                    req.put("accountIds", queryCondition.getAccountIds());
                    List<Long> longs = labelSystemCustomMapper.queryCustomLabelIdByApp(queryCondition.getNameZh(), queryCondition.getDataCategory(), queryCondition.getValidStatus(), req, labelSystemCustomQueryReq.getClientType(), labelSystemCustomQueryReq.getQueryCondition().getSource(),WorkBenchConstant.SYSTEM_TENANT);
                    List<Long> intersection = (List<Long>) CollectionUtils.intersection(ids, longs);
                    if (CollectionUtils.isNotEmpty(intersection)) {
                        labelSystemCustoms = labelSystemCustomMapper.selectBatchIds(intersection);
                    }
                }else {
                    LambdaQueryWrapper<LabelSystemCustom> queryPreWrapper = new LambdaQueryWrapper<>();
                    queryPreWrapper.eq(LabelSystemCustom::getTenantId, WorkBenchConstant.SYSTEM_TENANT);
                    queryPreWrapper.like(!StringUtils.isEmpty(labelSystemCustomQueryReq.getQueryCondition().getNameZh()), LabelSystemCustom::getNameZh,
                            labelSystemCustomQueryReq.getQueryCondition().getNameZh());
                    queryPreWrapper.eq(!Objects.isNull(labelSystemCustomQueryReq.getQueryCondition().getValidStatus()), LabelSystemCustom::getValidStatus,
                            labelSystemCustomQueryReq.getQueryCondition().getValidStatus());
                    queryPreWrapper.in(!CollectionUtils.isEmpty(labelSystemCustomQueryReq.getQueryCondition().getDataCategory()), LabelSystemCustom::getDataCategory,
                            labelSystemCustomQueryReq.getQueryCondition().getDataCategory());
                    queryPreWrapper.eq(LabelSystemCustom::getClientType, labelSystemCustomQueryReq.getClientType());
                    queryPreWrapper.eq(Objects.nonNull(labelSystemCustomQueryReq.getQueryCondition().getSource()), LabelSystemCustom::getSource,
                            labelSystemCustomQueryReq.getQueryCondition().getSource());
                    queryPreWrapper.in(LabelSystemCustom::getId,ids);
                    labelSystemCustoms = labelSystemCustomMapper.selectList(queryPreWrapper);
                }
                if (CollectionUtils.isNotEmpty(labelSystemCustoms)) {
                    labelSystemCustomList.addAll(labelSystemCustoms);
                }
            }
        }
        // 查找自定义组件信息
            if (!CollectionUtils.isEmpty(labelSystemCustomList)) {
                Gson gson = new Gson();
                // 查询数据源信息
                List<JSONObject> labelSystemSourceList = labelSystemSourceMapper.listByCondition(
                        null,0,
                        labelSystemCustomList.stream().map(LabelSystemCustom::getId).collect(Collectors.toList()));

                List<LabelSystemCustomQueryVO.DataSourceInfo> dataSourceInfoList = new LinkedList<>();
                labelSystemSourceList.forEach(item->{
                    LabelSystemCustomQueryVO.DataSourceInfo dataSourceInfo = gson.fromJson(JSON.toJSONString(item),LabelSystemCustomQueryVO.DataSourceInfo.class);
                    dataSourceInfoList.add(dataSourceInfo);
                });

                Map<Long,List<LabelSystemCustomQueryVO.DataSourceInfo>> map
                        = dataSourceInfoList.stream().collect(Collectors.groupingBy(LabelSystemCustomQueryVO.DataSourceInfo::getSystemId));

                List<LabelSystemCustomQueryVO> labelSystemCustomQueryVOList = labelSystemCustomList.stream()
                        .map(item->{
                            List<LabelSystemCustomQueryVO.DataSourceInfo> dataList = map.get(item.getId());
                            LabelSystemCustomQueryVO labelSystemCustomQueryVO = converter.convert(item, LabelSystemCustomQueryVO.class);
                            labelSystemCustomQueryVO.setComponentSource(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal());
                            labelSystemCustomQueryVO.setDataSourceInfo(dataList);

                            // 内嵌网页类型的组件，链接参数
                            if (Constants.DataCategoryEnum.WEB_PAGE.getVal().equals(item.getDataCategory())) {
                                labelSystemCustomQueryVO.setLinkUrlFull(item.getLinkUrl());
                                if (StringUtils.isNotBlank(item.getLinkParam())) {
                                    List<LabelSystemLinkParamDTO> linkParamList = com.alibaba.fastjson.JSONArray.parseArray(item.getLinkParam(), LabelSystemLinkParamDTO.class);
                                    labelSystemCustomQueryVO.setLinkParamList(linkParamList);

                                    // 数据源名称展示为链接
                                    StringBuilder stringBuilder = Utils.buildWebLinkDisplayUrl(item.getLinkParam());
                                    labelSystemCustomQueryVO.setLinkUrlFull(item.getLinkUrl() + "?" + stringBuilder);
                                }
                            }
                            //此处移动端自定义组件和预设组件的三方报表公用了
                            if (Objects.equals(11,item.getDataCategory())){
                                labelSystemCustomQueryVO.setLinkUrlFull(item.getLinkUrl());
                                if (StringUtils.isNotBlank(item.getLinkParam())) {
                                    List<LabelSystemLinkParamDTO> linkParamList = com.alibaba.fastjson.JSONArray.parseArray(item.getLinkParam(), LabelSystemLinkParamDTO.class);
                                    labelSystemCustomQueryVO.setLinkParamList(linkParamList);

                                    // 数据源名称展示为链接
                                    StringBuilder stringBuilder = Utils.buildWebLinkDisplayUrl(item.getLinkParam());
                                    labelSystemCustomQueryVO.setLinkUrlFull(item.getLinkUrl() + "?" + stringBuilder);
                                }
                            }
                            return labelSystemCustomQueryVO;
                        }).collect(Collectors.toList());

                if (Constants.IS_LAYOUT.equals(labelSystemCustomQueryReq.getIsLayout())) {
                    this.filterPortalLayout(labelSystemCustomQueryVOList);
                }

                List<LabelSystemCustomQueryVO> LabelSystemCustomQuerySortVO = labelSystemCustomQueryVOList.stream()
                        .sorted(Comparator.comparing(LabelSystemCustomQueryVO::getModifyTime).reversed()).collect(Collectors.toList());
                List<LabelSystemCustomQueryVO> pageData = LabelSystemCustomQuerySortVO.stream()
                        .skip((labelSystemCustomQueryReq.getPageNum() - 1) * labelSystemCustomQueryReq.getPageSize().longValue())
                        .limit(labelSystemCustomQueryReq.getPageSize()).collect(Collectors.toList());
                for (LabelSystemCustomQueryVO labelSystemCustomQueryVO : pageData){
                    if (WorkBenchConstant.SYSTEM_TENANT.equals(labelSystemCustomQueryVO.getTenantId())){
                        labelSystemCustomQueryVO.setStatus(1);
                    }
                }
                buildAppInfo(pageData);
                resultPageBean = ResultPageBean.success(ResponseBody.getInstance(pageData, PageInfo.getPageInfo(
                        labelSystemCustomQueryReq.getPageNum(), labelSystemCustomQueryReq.getPageSize(), LabelSystemCustomQuerySortVO.size())));

            } else {

                resultPageBean = ResultPageBean.success(ResponseBody.getInstance(labelSystemCustomList, PageInfo.getPageInfo(
                        labelSystemCustomQueryReq.getPageNum(), labelSystemCustomQueryReq.getPageSize(), labelSystemCustomList.size())));
            }
        return resultPageBean;
    }

    private List<Long> getLableSysTemCustomIds(String tenantVersion,Integer clientType) {
        List<Long> isddds = relatedAppServiceWrapper.queryCurrTenantPortalList(tenantVersion);
        if (CollectionUtils.isEmpty(isddds)){
            return Collections.emptyList();
        }
        LambdaQueryWrapper<PortalInfo> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(PortalInfo::getVersion,tenantVersion).in(CollectionUtils.isNotEmpty(isddds),PortalInfo::getPortalDesignerId,isddds);
        queryWrapper.eq(PortalInfo::getClientType,clientType);
        List<PortalInfo> portalInfoList = InterceptorIgnoreUtil.handler(() -> portalInfoMapper.selectList(queryWrapper));
        List<Long> portalIds = new ArrayList<>();
        for (PortalInfo portalInfo : portalInfoList){
            Long id = portalInfo.getId();
            portalIds.add(id);
        }
        if (CollectionUtils.isEmpty(portalIds)){
            return Collections.emptyList();
        }
        LambdaQueryWrapper<PortalInfoContent> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        if (Objects.equals(0,clientType)){
            lambdaQueryWrapper.in(PortalInfoContent::getContentType,0);
        }else{
            lambdaQueryWrapper.in(PortalInfoContent::getContentType,11);
        }
        lambdaQueryWrapper.in(PortalInfoContent::getLabelTypeSource,1).in(CollectionUtils.isNotEmpty(portalIds),PortalInfoContent::getPortalId,portalIds);
        List<PortalInfoContent> portalInfoContents = InterceptorIgnoreUtil.handler(() -> portalInfoContentMapper.selectList(lambdaQueryWrapper));
        List<Long> contentIds = new ArrayList<>();
        for (PortalInfoContent portalInfoContent : portalInfoContents){
            Long contentId = portalInfoContent.getContentId();
            contentIds.add(contentId);
        }
        if (CollectionUtils.isEmpty(contentIds)){
            return Collections.emptyList();
        }
        LambdaQueryWrapper<LabelSystemCustom> labelSystemCustomLambdaQueryWrapper = new LambdaQueryWrapper<>();
        labelSystemCustomLambdaQueryWrapper.in(CollectionUtils.isNotEmpty(contentIds),LabelSystemCustom::getComponentDesignerId,contentIds).eq(LabelSystemCustom::getVersion,tenantVersion);
        List<LabelSystemCustom> labelSystemCustoms = labelSystemCustomMapper.selectList(labelSystemCustomLambdaQueryWrapper);
        List<Long> collect = labelSystemCustoms.stream().map(e -> e.getId()).collect(Collectors.toList());
        return collect;
    }

    /**
     * 补充数据源的关联应用名称和账套信息
     * @param pageData 自定义组件
     */
    private void buildAppInfo(List<LabelSystemCustomQueryVO> pageData){
        try{
            Set<Long> dataIds = new HashSet<>();
            pageData.forEach(item->{
                if(CollectionUtils.isNotEmpty(item.getDataSourceInfo())){
                    dataIds.add(item.getDataSourceInfo().get(0).getDataId());
                }}
            );
            if(CollectionUtils.isNotEmpty(dataIds)){
                List<LabelSystemData> labelSystemDataList= labelSystemDataMapper.selByIds(new ArrayList<>(dataIds));
                if(CollectionUtils.isNotEmpty(labelSystemDataList)){
                    Map<Long, LabelSystemData> labelSystemDataMap = labelSystemDataList.stream().collect(Collectors.toMap(LabelSystemData::getId, a -> a, (k1, k2) -> k1));
                    List<AppLinkDTO> appLinkList = appLinkService.queryManageList(AppAuthContextHolder.getContext().getAuthoredUser());
                    Map<String, AppLinkDTO> appLinkMap = appLinkList.stream().collect(Collectors.toMap(AppLinkDTO::getPrimaryId, value -> value, (key1, key2) -> key1));
                    pageData.forEach(item->{
                        if(CollectionUtils.isNotEmpty(item.getDataSourceInfo())){
                            Long dataId = item.getDataSourceInfo().get(0).getDataId();
                            LabelSystemData labelSystemData = labelSystemDataMap.get(dataId);
                            if(Objects.nonNull(labelSystemData)){
                                item.setAccountId(labelSystemData.getAccountId());
                                item.setAppSystemId(labelSystemData.getAppCode());
                                item.setDataSource(labelSystemData.getDataType());
                                AppLinkDTO appLinkDTO = appLinkMap.get(labelSystemData.getAppCode());
                                if(Objects.nonNull(appLinkDTO)){
                                    item.setAppCode(appLinkDTO.getCode());
                                    item.setAppName(appLinkDTO.getName());
                                }else if(VirtualApplicationEnum.ATHENA_APP.getPrimaryId().equals(labelSystemData.getAppCode())){
                                    item.setAppCode(VirtualApplicationEnum.ATHENA_APP.getCode());
                                    item.setAppName(VirtualApplicationEnum.ATHENA_APP.getName());
                                }else if(VirtualApplicationEnum.ATHENA_AGILE_INTERACTION.getPrimaryId().equals(labelSystemData.getAppCode())){
                                    item.setAppCode(VirtualApplicationEnum.ATHENA_AGILE_INTERACTION.getCode());
                                    item.setAppName(VirtualApplicationEnum.ATHENA_AGILE_INTERACTION.getName());
                                }else if(VirtualApplicationEnum.FINE_REPORT_APP.getPrimaryId().equals(labelSystemData.getAppCode())){
                                    item.setAppCode(VirtualApplicationEnum.FINE_REPORT_APP.getCode());
                                    item.setAppName(VirtualApplicationEnum.FINE_REPORT_APP.getName());
                                }
                            }
                        }
                    });
                }
            }
        } catch (Exception e) {
            log.error("LabelSystemCustomQueryVO.buildAppInfo is error",e);
        }
    }


    private List<LabelSystemCustomQueryVO> filterPortalLayout(List<LabelSystemCustomQueryVO> labelSystemCustomQueryVOList){
        LambdaQueryWrapper<PortalLayoutCustom> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(PortalLayoutCustom::getLabelType,0);
        queryWrapper.eq(PortalLayoutCustom::getTenantId,Utils.getTenantId());
        queryWrapper.eq(PortalLayoutCustom::getDelFlag, Constants.DEFAULT_CONFIGURED_FLAG_NO);
        List<PortalLayoutCustom> portalLayoutCustomList = portalLayoutCustomMapper.selectList(queryWrapper);

        portalLayoutCustomList.forEach(data->{
            labelSystemCustomQueryVOList.removeIf(e->e.getId().equals(data.getLabelId()));
        });

        return labelSystemCustomQueryVOList;
    }

    /**
     * 过滤门户中已经添加的预设组件和三方待办 和轮播图组件
     * @param labelSystemPreQueryVOList
     * @return
     */
    private List<LabelSystemPreQueryVO> filterPortalLayoutPre(List<LabelSystemPreQueryVO> labelSystemPreQueryVOList) {
        LambdaQueryWrapper<PortalLayoutCustom> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(PortalLayoutCustom::getLabelType, 1);
        queryWrapper.eq(PortalLayoutCustom::getTenantId, AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        queryWrapper.eq(PortalLayoutCustom::getDelFlag, Constants.DEFAULT_CONFIGURED_FLAG_NO);
        List<PortalLayoutCustom> portalLayoutCustomList = portalLayoutCustomMapper.selectList(queryWrapper);

        portalLayoutCustomList.forEach(data -> {
            labelSystemPreQueryVOList.removeIf(e -> e.getId().equals(data.getLabelId()));
        });
        //过滤三方待办和轮播图组件
        List<LabelSystemPreQueryVO> labelSystemPreVOList = labelSystemPreQueryVOList.stream()
                .filter(e -> !e.getDataType().equals(Constants.DataTypeEnum.TYPE_THIRD_TODO.getVal()) && !e.getDataType().equals(Constants.DataTypeEnum.TYPE_CAROUSEL.getVal())).collect(Collectors.toList());
        return labelSystemPreVOList;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity<?> save(LabelSystemCustomSaveReq labelSystemCustomSaveReq) {
        ResponseEntity<?> responseEntity = this.validData(labelSystemCustomSaveReq);
        if(null != responseEntity) {
            return responseEntity;
        }
        LabelSystemCustom labelSystemCustom = converter.convert(labelSystemCustomSaveReq, LabelSystemCustom.class);
        // 内嵌网页类型组件的链接配置，转为jsonString存入数据库
        if (CollectionUtils.isNotEmpty(labelSystemCustomSaveReq.getLinkParamList())) {
            String linkParam = JSON.toJSONString(labelSystemCustomSaveReq.getLinkParamList());
            labelSystemCustom.setLinkParam(linkParam);
        }

        if (Objects.isNull(labelSystemCustomSaveReq.getId())) {
            labelSystemCustom.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            labelSystemCustom.setValidStatus(0);
            labelSystemCustom.setModifyUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
            labelSystemCustom.setCreateUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
            labelSystemCustomMapper.insert(labelSystemCustom);

            if (!CollectionUtils.isEmpty(labelSystemCustomSaveReq.getDataSourceInfo())) {
                List<LabelSystemSource> labelSystemSourceList = labelSystemCustomSaveReq.getDataSourceInfo().stream()
                        .map(item->{
                            LabelSystemSource labelSystemSource = converter.convert(item, LabelSystemSource.class);
                            labelSystemSource.setSystemId(labelSystemCustom.getId());
                            labelSystemSource.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                            return labelSystemSource;
                        }).collect(Collectors.toList());

                labelSystemSourceMapper.insertBatch(labelSystemSourceList);
            }
            return ResponseEntityWrapper.wrapperOk(labelSystemCustom.getId());
        } else {
            labelSystemCustom.setModifyUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
            if (Objects.equals(WorkBenchConstant.SYSTEM_TENANT,labelSystemCustom.getTenantId())){
                String error = messageUtils.getMessage("error.message.system.lable.custom.not.modify");
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, error);
            }
            labelSystemCustomMapper.updateById(labelSystemCustom);

            if (!CollectionUtils.isEmpty(labelSystemCustomSaveReq.getDataSourceInfo())) {
                LambdaUpdateWrapper<LabelSystemSource> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(LabelSystemSource::getTenantId,AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                updateWrapper.in(LabelSystemSource::getSystemId,
                        labelSystemCustomSaveReq.getDataSourceInfo().stream().map(LabelSystemCustomSaveReq.DataSourceInfo::getSystemId)
                                .collect(Collectors.toList()));
                labelSystemSourceMapper.delete(updateWrapper);

                List<LabelSystemSource> labelSystemSourceList = labelSystemCustomSaveReq.getDataSourceInfo().stream()
                        .map(item->{
                            LabelSystemSource labelSystemSource = converter.convert(item, LabelSystemSource.class);
                            labelSystemSource.setSystemId(labelSystemCustomSaveReq.getId());
                            labelSystemSource.setComponentSource(0);
                            labelSystemSource.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                            return labelSystemSource;
                        }).collect(Collectors.toList());
                labelSystemSourceMapper.insertItemBatch(labelSystemSourceList);
            }
            return ResponseEntityWrapper.wrapperOk(labelSystemCustomSaveReq.getId());
        }
    }


    /**
     *  校验自定义组件名称重复 以及 数据源类型是否相同
     * @param labelSystemCustomSaveReq
     * @return
     */
    private ResponseEntity<?> validData (LabelSystemCustomSaveReq labelSystemCustomSaveReq) {
        // 内嵌网页类型的组件，链接地址不能为空
        if(Constants.DataCategoryEnum.WEB_PAGE.getVal().equals(labelSystemCustomSaveReq.getDataCategory())
                && StringUtils.isBlank(labelSystemCustomSaveReq.getLinkUrl())){
            String error = String.format(messageUtils.getMessage("error.message.system.link.not.null"));
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, error);
        }
        // 编辑
        if (Objects.nonNull(labelSystemCustomSaveReq.getId())) {
            LambdaQueryWrapper<LabelSystemCustom> queryWrapperById = new LambdaQueryWrapper<>();
            queryWrapperById.eq(LabelSystemCustom::getTenantId,AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            queryWrapperById.eq(LabelSystemCustom::getId,labelSystemCustomSaveReq.getId());
            LabelSystemCustom labelSystemCustom = labelSystemCustomMapper.selectOne(queryWrapperById);
            if (ObjectUtils.isEmpty(labelSystemCustom)) {
                String error = String.format(messageUtils.getMessage("error.message.system.custom.not.exist"));
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, error);
            }
            if (!labelSystemCustom.getDataCategory().equals(labelSystemCustomSaveReq.getDataCategory())) {
                String error = String.format(messageUtils.getMessage("error.message.system.custom.not.modify"));
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, error);
            }
            if (Objects.equals(WorkBenchConstant.SYSTEM_TENANT,labelSystemCustom.getTenantId())){
                String error = String.format(messageUtils.getMessage("error.message.system.lable.custom.not.modify"));
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, error);
            }

            LambdaQueryWrapper<LabelSystemCustom> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(LabelSystemCustom::getTenantId,AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            List<LabelSystemCustom> labelSystemCustomList = labelSystemCustomMapper.selectList(queryWrapper);

            if(!labelSystemCustomSaveReq.getNameZh().trim().equals(labelSystemCustom.getNameZh())) {
                // 再去判断和其他数据是否重复
                for (LabelSystemCustom data : labelSystemCustomList) {
                    if(labelSystemCustomSaveReq.getNameZh().trim().equals(data.getNameZh())) {
                        String error = String.format(messageUtils.getMessage("error.message.system.custom.name.zh.exist"), labelSystemCustomSaveReq.getNameZh());
                        return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, error);
                    }
                }
            }
        } else {
            LambdaQueryWrapper<LabelSystemCustom> queryZhWrapper = new LambdaQueryWrapper<>();
            queryZhWrapper.eq(LabelSystemCustom::getTenantId,AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            queryZhWrapper.eq(LabelSystemCustom::getNameZh,labelSystemCustomSaveReq.getNameZh());
            List<LabelSystemCustom> labelSystemCustomZh = labelSystemCustomMapper.selectList(queryZhWrapper);
            // 新增
            if (labelSystemCustomZh.size() >= 1){
                String error = String.format(messageUtils.getMessage("error.message.system.custom.name.zh.exist"), labelSystemCustomSaveReq.getNameZh());
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, error);
            }

            LambdaQueryWrapper<LabelSystemCustom> queryUsWrapper = new LambdaQueryWrapper<>();
            queryUsWrapper.eq(LabelSystemCustom::getTenantId,AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            queryUsWrapper.eq(LabelSystemCustom::getNameUs,labelSystemCustomSaveReq.getNameUs());
            List<LabelSystemCustom> labelSystemCustomUs = labelSystemCustomMapper.selectList(queryUsWrapper);
            if (labelSystemCustomUs.size() >= 1){
                String error = String.format(messageUtils.getMessage("error.message.system.custom.name.us.exist"), labelSystemCustomSaveReq.getNameUs());
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, error);
            }
        }

        // 判断组件的组件分类值与数据源分类值是否相同
        if (CollectionUtils.isNotEmpty(labelSystemCustomSaveReq.getDataSourceInfo())) {
            for (LabelSystemCustomSaveReq.DataSourceInfo item : labelSystemCustomSaveReq.getDataSourceInfo()) {
                LambdaQueryWrapper<LabelSystemData> queryWrapperData = new LambdaQueryWrapper<>();
                queryWrapperData.eq(LabelSystemData::getTenantId, AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                queryWrapperData.eq(LabelSystemData::getId, item.getDataId());
                LabelSystemData labelSystemData = labelSystemDataMapper.selectOne(queryWrapperData);

                if (!labelSystemData.getDataCategory().equals(labelSystemCustomSaveReq.getDataCategory())) {
                    String error = messageUtils.getMessage("error.message.system.pre.dara.fail");
                    return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.UPDATE_SYSTEM_DATA_SOURCE, error);
                }
            }
        }
        return null;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity<?> delete(List<Long> idList,Integer clentType) {
        LambdaQueryWrapper<LabelSystemCustom> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(LabelSystemCustom::getTenantId,AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        if (idList.size() == 1) {
            queryWrapper.eq(LabelSystemCustom::getId,idList.get(0));
            queryWrapper.eq(LabelSystemCustom::getValidStatus,0);
            LabelSystemCustom labelSystemCustom = labelSystemCustomMapper.selectOne(queryWrapper);
            if (ObjectUtils.isEmpty(labelSystemCustom)) {
                String error = messageUtils.getMessage("error.message.system.custom.del.fail");
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, error);
            }

        } else {
            queryWrapper.in(LabelSystemCustom::getId,idList);
            List<LabelSystemCustom> labelSystemCustom = labelSystemCustomMapper.selectList(queryWrapper);
            boolean flag = labelSystemCustom.stream().anyMatch(item->Constants.LABEL_SYSTEM_PRE_VALID_STATUS.equals(item.getValidStatus()));
            if (flag) {
                String error = messageUtils.getMessage("error.message.system.custom.batdel.fail");
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, error);
            }
        }

        //校验极简门户
        LambdaQueryWrapper<PortalLayoutCustom> cusQueryWrapper = new LambdaQueryWrapper<>();
        cusQueryWrapper.in(PortalLayoutCustom::getLabelId, idList);
        cusQueryWrapper.eq(PortalLayoutCustom::getLabelType, Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal());
        cusQueryWrapper.eq(PortalLayoutCustom::getTenantId, Utils.getTenantId());
        cusQueryWrapper.eq(PortalLayoutCustom::getDelFlag, Constants.DEFAULT_CONFIGURED_FLAG_NO);
        PortalLayoutCustom portalLayoutCustom = portalLayoutCustomMapper.selectOne(cusQueryWrapper);
        if (!ObjectUtils.isEmpty(portalLayoutCustom)) {
            String error = messageUtils.getMessage("error.message.system.portal.layout.del");
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, error);
        }
        //校验是否有经典门户关联
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        List<PortalInfoContent> contentList=portalInfoContentMapper.selPortalConent(tenantId,idList,Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal(),null);
        if (CollectionUtils.isNotEmpty(contentList)) {
            String error = messageUtils.getMessage("error.message.jd.portal.layout.del.error");
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, error);
        }
        // 校验是否关联自定义菜单
        List<CustomizedMenuTemplate> templateList = customizedMenuTemplateMapper.queryTempListByLabelId(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal(), idList, tenantId);
        if (CollectionUtils.isNotEmpty(templateList)) {
            String error = messageUtils.getMessage("error.message.jd.menu.del.error");
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, error);
        }

        try {
            List<LabelSystemCustom> labelSystemCustoms = labelSystemCustomMapper.selectBatchIds(idList);
            for (LabelSystemCustom labelSystemCustom : labelSystemCustoms){
                if (labelSystemCustom.getTenantId().equals(WorkBenchConstant.SYSTEM_TENANT)){
                    idList.remove(labelSystemCustom.getId());
                }
            }
            labelSystemCustomMapper.deleteBatchIds(idList);
            //删除自定义组件和数据源关系
            LambdaUpdateWrapper<LabelSystemSource> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(LabelSystemSource::getSystemId,idList);
            updateWrapper.eq(LabelSystemSource::getComponentSource,Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal());
            labelSystemSourceMapper.delete(updateWrapper);

        } catch (Exception e) {
            log.error("delete system.custom error", e);
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, messageUtils.getMessage(I18NKey.DELETE_SYSTEM_CUSTOM));
        }

        return ResponseEntityWrapper.wrapperOk();
    }

    @Override
    public List<LabelSystemCustom> queryCustomSystem(LabelSystemAllVo req) {
        QueryWrapper<LabelSystemCustom> condition = new QueryWrapper<>();
        if(CollectionUtils.isNotEmpty(req.getDataCategoryList())){
            condition.in("data_category",req.getDataCategoryList());
        }
        if(StringUtils.isNotEmpty(req.getName())){
            condition.like("name_zh", req.getName());
        }
        condition.eq("valid_status",1);
        condition.orderByDesc("modify_time");
        return labelSystemCustomMapper.selectList(condition);
    }

    @Override
    public List<SystemCustomImportVo> readExcel(String fileId) {
        DMC dmcInstance = mdcService.buildDmc();
        List<SystemCustomImportVo> excelVoList;
        try {
            byte[] byteArray = dmcInstance.download(fileId);
            ByteArrayInputStream input = new ByteArrayInputStream(byteArray);
            SyncReadListener excelListener = new SyncReadListener();
            // 读取sheet
            ExcelReader excelReader = EasyExcelFactory.read(input).build();
            excelReader.read(EasyExcelFactory.readSheet(0).head(SystemCustomImportVo.class).headRowNumber(2).registerReadListener(excelListener).build());
            // 这里千万别忘记关闭，读的
            excelReader.finish();
            excelVoList = mdcService.doReadSync(excelListener);
        } catch (Exception e) {
            log.error("SystemDataImport read excel occur error", e);
            throw new RuntimeException(e);
        }
        return excelVoList;
    }

    @Override
    @Transactional
    public ImportExcelResp importReport(List<SystemCustomImportVo> customImportVoList) {
        ImportExcelResp excelResp=new ImportExcelResp();
        //数据库中自定义组件名称
        List<String> customNameList = new ArrayList<>();
        Map<String,LabelSystemData> systemDataMap=new HashMap<>();
        //查询数据源信息
        List<LabelSystemData> systemDataList = labelSystemDataMapper.selectList(new QueryWrapper<LabelSystemData>());
        if (CollectionUtils.isNotEmpty(systemDataList)) {
            systemDataMap =systemDataList.stream().collect(Collectors.toMap(LabelSystemData::getName, Function.identity(), (a, b) -> a));
        }
        //查询自定义组件
        //List<LabelSystemCustom> systemCustomList = InterceptorIgnoreUtil.handler(() -> labelSystemCustomMapper.selectList(new QueryWrapper<LabelSystemCustom>()));
        LambdaQueryWrapper<LabelSystemCustom> labelSystemCustomLambdaQueryWrapper = new LambdaQueryWrapper<>();
        labelSystemCustomLambdaQueryWrapper.ne(LabelSystemCustom::getTenantId,WorkBenchConstant.SYSTEM_TENANT);
        List<LabelSystemCustom> systemCustomList=labelSystemCustomMapper.selectList(labelSystemCustomLambdaQueryWrapper);
        if (CollectionUtils.isNotEmpty(systemCustomList)) {
            customNameList = systemCustomList.stream().map(LabelSystemCustom::getNameZh).collect(Collectors.toList());
        }

        //初始化分类map
        Map<String,Integer> categoryMap=initCategoryMap();
        //初始化状态
        Map<String,Integer> statusMap=initStatusMap();
        int successNum = 0;
        int failNum = 0;
        int iconIndex=0;
        int classIconAppIndex=1;
        int classIconJobIndex=1;
        for (SystemCustomImportVo customImportVo : customImportVoList) {
            // 基础校验
            StringBuilder errorSb = validateData(customImportVo,customNameList,systemDataMap,categoryMap);
            if (StringUtils.isNotBlank(errorSb.toString())) {
                failNum++;
                customImportVo.setFailDesc(errorSb.substring(0, errorSb.length() - 1));
                continue;
            }
            customImportVo.setFailDesc(errorSb.toString());
            //插入自定义组件
            LabelSystemCustom systemCustom=initLabelCustom(customImportVo,systemDataMap,categoryMap,statusMap,iconIndex,classIconAppIndex,classIconJobIndex);
            successNum++;
            iconIndex++;
            //作业-经典门户图标
            if (systemCustom.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_WORK.getVal())) {
                classIconJobIndex++;
            }
            //应用-经典门户图标
            if (systemCustom.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_APP.getVal())) {
                classIconAppIndex++;
            }
            //极简门户图标，如果大于7，则取第一个
            if (iconIndex >= 7) {
                iconIndex = 0;
            }
            //经典门户应用图标下标索引，如果大于20，则取第一个
            if (classIconAppIndex > CLASSIC_ICON_COUNT) {
                classIconAppIndex = 1;
            }
            //经典门户作业图标下标索引，如果大于20，则取第一个
            if (classIconJobIndex > CLASSIC_ICON_COUNT) {
                classIconJobIndex = 1;
            }
        }
        String nowTime= DateUtils.getNowTime(DateUtils.DATE_TIME_FORMATTER);
        //生成失败的excel文件
        ShareInfo shareInfo = importRecordService.uploadExcel(write(customImportVoList,nowTime));
        //初始化导入记录
        initDataImport(shareInfo.getFileId(),successNum,failNum,nowTime);
        excelResp.setFailFileId(shareInfo.getFileId());
        excelResp.setFailFileName(shareInfo.getFileName());
        excelResp.setFailFileUrl(shareInfo.getUrl());
        // 构建返回信息
        String resultCode;
        if (successNum > 0 && failNum == 0) {
            resultCode = "2001";
        } else if (successNum > 0 && failNum > 0) {
            resultCode = "2002";
        } else if (successNum == 0 && failNum > 0) {
            resultCode = "2003";
        } else {
            resultCode = "2003";
        }
        excelResp.setResultCode(resultCode);
        excelResp.setFailCount(failNum);
        excelResp.setSuccessCount(successNum);
        return excelResp;
    }

    /**
     * 初始化数据源导入记录
     * @param fileId
     * @param successCount
     * @param failCount
     * @return
     */
    public LabelSystemCustomImport initDataImport(String fileId,Integer successCount,Integer failCount,String nowTime){
        LabelSystemCustomImport importRecord=new LabelSystemCustomImport();
        importRecord.setFileId(fileId);
        importRecord.setSuccessCount(successCount);
        importRecord.setFailCount(failCount);
        importRecord.setCreateUserName(Utils.getUserName());
        importRecord.setCreateUserId(Utils.getUserId());
        importRecord.setCreateTime(DateUtils.getDateFormat(nowTime,DateUtils.DATE_TIME_FORMATTER,DateUtils.DATE_TIME_NORMAL_FORMATTER));
        importRecord.setModifyTime(DateUtils.getDateFormat(nowTime,DateUtils.DATE_TIME_FORMATTER,DateUtils.DATE_TIME_NORMAL_FORMATTER));
        importRecord.setModifyUserId(Utils.getUserId());
        importRecord.setTenantId(Utils.getTenantId());
        labelSystemCustomImportMapper.insert(importRecord);
        return importRecord;
    }

    /**
     * 写入excel文件
     *
     * @param list 报表数据
     * @return
     */
    public File write(List<SystemCustomImportVo> list,String nowTime) {
        File file = new File("自定义组件导入记录_"+nowTime+".xlsx");
        EasyExcel.write(file, SystemCustomImportVo.class).relativeHeadRowIndex(1)
                .registerWriteHandler(new SystemCustomWriteHandler())
                .registerWriteHandler(Utils.initHorizontalCell())
                .sheet("自定义组件").doWrite(list);
        return file;
    }
    /**
     * 组装待插入的数据源数据数据
     * @param customImportVo excel中的数据
     * @param systemDataMap 数据源信息map
     * @param categoryMap 分类信息map
     * @param statusMap 状态map
     * @param iconIndex 极简门户图标的下标，7个图标里顺序取
     * @param classIconAppIndex 经典门户应用图标的下标，5个，1-5
     * @return classIconJobIndex 经典门户作业图标的下标，5个，1-5
     */
    public LabelSystemCustom initLabelCustom(SystemCustomImportVo customImportVo ,
                                             Map<String,LabelSystemData> systemDataMap,
                                             Map<String,Integer> categoryMap,
                                             Map<String,Integer> statusMap,
                                             int iconIndex,int classIconAppIndex,
                                             int classIconJobIndex
                                             ) {
        //组装自定义组件的数据
        LabelSystemCustom systemCustom = new LabelSystemCustom();
        systemCustom.setNameZh(customImportVo.getNameZh());
        systemCustom.setRemark(customImportVo.getRemark());
        systemCustom.setDataCategory(categoryMap.get(customImportVo.getDataCategory()));
        systemCustom.setValidStatus(statusMap.get(customImportVo.getValidStatus()));
        systemCustom.setCreateUserName(Utils.getUserName());
        systemCustom.setModifyUserName(Utils.getUserName());
        systemCustom.setCreateUserId(Utils.getUserId());
        systemCustom.setCreateTime(DateUtils.getNowTime(""));
        systemCustom.setModifyTime(DateUtils.getNowTime(""));
        systemCustom.setModifyUserId(Utils.getUserId());
        systemCustom.setTenantId(Utils.getTenantId());
        systemCustom.setIcon(Utils.getPortCard(iconIndex));
        // 内嵌网页类型的自定义组件，excel中数据源名称填的是跳转链接
        if (Constants.DataCategoryNameEnum.CATEGORY_WEB_NAME.getVal().equals(customImportVo.getDataCategory())) {
            systemCustom.setLinkUrl(customImportVo.getDataName());
        }
        //作业-经典门户图标
        if (systemCustom.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_WORK.getVal())) {
            systemCustom.setClassicsIcon(Constants.ICON_TZZY_JOB + classIconJobIndex);
        }
        //应用-经典门户图标
        if (systemCustom.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_APP.getVal())) {
            systemCustom.setClassicsIcon(Constants.ICON_TZYY_APP + classIconAppIndex);
        }
        systemCustom.setClientType(0);
        labelSystemCustomMapper.insert(systemCustom);
        LabelSystemData systemData = systemDataMap.get(customImportVo.getDataName());
        if (null != systemData) {
            //插入组件和数据源的关系
            LabelSystemSource systemSource = new LabelSystemSource();
            systemSource.setSystemId(systemCustom.getId());
            systemSource.setDataId(systemData.getId());
            systemSource.setComponentSource(0);
            systemSource.setCreateTime(DateUtils.getNowTime(""));
            systemSource.setTenantId(Utils.getTenantId());
            labelSystemSourceMapper.insert(systemSource);
        }
        return systemCustom;
    }


    /**
     * 校验excel数据
     * @param customImportVo excel中的数据
     * @param customNameList 数据库和excel中的自定义组件名称
     * @param systemDataMap 数据源信息map
     * @param categoryMap 初始化分类map
     * @return
     */
    private StringBuilder validateData(SystemCustomImportVo customImportVo , List<String> customNameList,Map<String,LabelSystemData> systemDataMap,Map<String,Integer> categoryMap) {
        StringBuilder errorSb = new StringBuilder();
        //自定义组件名称校验
        if (StringUtils.isEmpty(customImportVo.getNameZh())) {
            errorSb.append("“自定义组件名称”未填写").append(",");
        }
        if (StringUtils.isNotEmpty(customImportVo.getNameZh()) && customImportVo.getNameZh().length() > 40) {
            errorSb.append("“自定义组件名称”内容超过最大长度限制").append(",");
        }
        if (customNameList.contains(customImportVo.getNameZh())) {
            errorSb.append("“自定义组件名称”重复").append(",");
        }
        if (StringUtils.isNotEmpty(customImportVo.getNameZh())){
            customNameList.add(customImportVo.getNameZh());
        }
        //组件分类
        if (StringUtils.isEmpty(customImportVo.getDataCategory())) {
            errorSb.append("“组件分类”未填写").append(",");
        }
        List<String> categoryNameList =initCategoryNameList();
        if (StringUtils.isNotEmpty(customImportVo.getDataCategory()) && !categoryNameList.contains(customImportVo.getDataCategory())) {
            errorSb.append("“组件分类”值错误").append(",");
        }
        //状态校验
        if (StringUtils.isEmpty(customImportVo.getValidStatus())) {
            errorSb.append("“状态”未填写").append(",");
        }
        List<String> validStatusList =initValidStatusList();
        if (StringUtils.isNotEmpty(customImportVo.getValidStatus()) && !validStatusList.contains(customImportVo.getValidStatus())) {
            errorSb.append("“状态”值错误").append(",");
        }
        //备注校验
        if (StringUtils.isNotBlank(customImportVo.getRemark()) && customImportVo.getRemark().length() > 100) {
            errorSb.append("“自定义组件备注”内容超过最大长度限制").append(",");
        }
        //数据源校验
        if (StringUtils.isEmpty(customImportVo.getDataName())) {
            errorSb.append("“数据源名称”未填写").append(",");
        }
        // 数据源名称长度校验
        if (customImportVo.getDataName().length() > 500) {
            errorSb.append("“数据源名称”内容超过最大长度限制").append(",");
        }

        // 不是内嵌网页类型的组件，需要校验数据源信息
        if (!Constants.DataCategoryNameEnum.CATEGORY_WEB_NAME.getVal().equals(customImportVo.getDataCategory())) {
            if (StringUtils.isNotEmpty(customImportVo.getDataName()) &&
                    null == systemDataMap.get(customImportVo.getDataName())) {
                errorSb.append("“数据源名称”值错误").append(",");
            }
            if (StringUtils.isNotEmpty(customImportVo.getDataName()) &&
                    StringUtils.isNotEmpty(customImportVo.getDataCategory()) &&
                    null != systemDataMap.get(customImportVo.getDataName())) {
                LabelSystemData systemData=systemDataMap.get(customImportVo.getDataName());
                if(!systemData.getDataCategory().equals(categoryMap.get(customImportVo.getDataCategory()))){
                    errorSb.append("自定义组件类型与关联数据源类型不一致").append(",");
                }
            }
            if (StringUtils.isNotEmpty(customImportVo.getDataName()) &&
                    null != systemDataMap.get(customImportVo.getDataName())) {
                LabelSystemData systemData=systemDataMap.get(customImportVo.getDataName());
                //数据源没有开启
                if(systemData.getValidStatus().equals(Constants.VALID_STATUS_UNUSABLE)){
                    errorSb.append("关联数据源未启用").append(",");
                }
            }
        }
        return errorSb;
    }

    /**
     * 初始化分类Map,key:名称，val:枚举值
     * @return
     */
    public Map<String,Integer> initCategoryMap() {
        Map<String,Integer> categoryMap = new HashMap<>();
        categoryMap.put(Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal(),Constants.DataCategoryEnum.CATEGORY_WORK.getVal());
        categoryMap.put(Constants.DataCategoryNameEnum.CATEGORY_APP_NAME.getVal(),Constants.DataCategoryEnum.CATEGORY_APP.getVal());
        categoryMap.put(Constants.DataCategoryNameEnum.CATEGORY_WEB_NAME.getVal(),Constants.DataCategoryEnum.WEB_PAGE.getVal());
        return categoryMap;
    }

    /**
     * 初始化状态Map,key:名称，val:枚举值
     * @return
     */
    public Map<String,Integer> initStatusMap() {
        Map<String,Integer> statusMap = new HashMap<>();
        statusMap.put(Constants.ValidStatusNameEnum.VALID_STATUS_ON.getVal(),Constants.VALID_STATUS_ENABLE);
        statusMap.put(Constants.ValidStatusNameEnum.VALID_STATUS_OFF.getVal(),Constants.VALID_STATUS_UNUSABLE);
        return statusMap;
    }

    /**
     * 初始化分类Map,key:枚举值，val:名称
     * @return
     */
    public Map<Integer,String> initCategoryValMap() {
        Map<Integer,String> categoryMap = new HashMap<>();
        categoryMap.put(Constants.DataCategoryEnum.CATEGORY_WORK.getVal(),Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal());
        categoryMap.put(Constants.DataCategoryEnum.CATEGORY_APP.getVal(),Constants.DataCategoryNameEnum.CATEGORY_APP_NAME.getVal());
        categoryMap.put(Constants.DataCategoryEnum.WEB_PAGE.getVal(),Constants.DataCategoryNameEnum.CATEGORY_WEB_NAME.getVal());
        return categoryMap;
    }

    /**
     * 初始化状态Map,key:枚举值，val:名称
     * @return
     */
    public Map<Integer,String> initStatusValMap() {
        Map<Integer,String> statusMap = new HashMap<>();
        statusMap.put(Constants.DataCategoryEnum.CATEGORY_TODO.getVal(),Constants.ValidStatusNameEnum.VALID_STATUS_OFF.getVal());
        statusMap.put(Constants.DataCategoryEnum.CATEGORY_REPORT.getVal(),Constants.ValidStatusNameEnum.VALID_STATUS_ON.getVal());
        return statusMap;
    }

    /**
     * 初始化分类集合
     * @return
     */
    public List<String> initCategoryNameList() {
        List<String> categoryNameList = new ArrayList<>();
        categoryNameList.add(Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal());
        categoryNameList.add(Constants.DataCategoryNameEnum.CATEGORY_APP_NAME.getVal());
        categoryNameList.add(Constants.DataCategoryNameEnum.CATEGORY_WEB_NAME.getVal());
        return categoryNameList;
    }

    /**
     * 初始化状态集合
     * @return
     */
    public List<String> initValidStatusList() {
        List<String> validStatusList = new ArrayList<>();
        validStatusList.add(Constants.ValidStatusNameEnum.VALID_STATUS_ON.getVal());
        validStatusList.add(Constants.ValidStatusNameEnum.VALID_STATUS_OFF.getVal());
        return validStatusList;
    }

    @Override
    public PageInfoResp<LabelSystemCustomImport> queryImportRecord(QueryImportRecordReq queryImportRecordReq) {
        QueryWrapper<LabelSystemCustomImport> condition = new QueryWrapper<>();
        if (StringUtils.isBlank(queryImportRecordReq.getStartTime()) || StringUtils.isBlank(queryImportRecordReq.getEndTime())) {
            String currentDate = DateUtils.getNowTime(DateUtils.DATE_TIME_NORMAL_FORMATTER);
            condition.ge("create_time", DateUtils.addDate(currentDate, DateUtils.DATE_TIME_NORMAL_FORMATTER, -1, DateUtils.YEAR));
            condition.le("create_time", currentDate);
        } else {
            condition.ge("create_time", queryImportRecordReq.getStartTime());
            condition.le("create_time", queryImportRecordReq.getEndTime());
        }
        if (StringUtils.isNotEmpty(queryImportRecordReq.getUserIdName())) {
            condition.and(i -> i.like("create_user_name", queryImportRecordReq.getUserIdName()).or().like("create_user_id", queryImportRecordReq.getUserIdName()));
        }
        condition.orderByDesc("create_time");
        PageInfoResp<LabelSystemCustomImport> pageInfoResp = new PageInfoResp<>();
        pageInfoResp.setPageNo(queryImportRecordReq.getPageNum());
        pageInfoResp.setPageSize(queryImportRecordReq.getPageSize());
        pageInfoResp.setTotalPages(0);
        pageInfoResp.setTotalRecords(0);
        Page<LabelSystemCustomImport> pageResult = labelSystemCustomImportMapper.selectPage(new Page<>(queryImportRecordReq.getPageNum(), queryImportRecordReq.getPageSize()), condition);
        if (pageResult!=null && CollectionUtils.isNotEmpty(pageResult.getRecords())) {
            // 拼接文件预览链接
            pageResult.getRecords().forEach(x-> x.setFileUrl(envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + x.getFileId().trim()));
            pageInfoResp.setTotalPages(Integer.parseInt(String.valueOf(pageResult.getPages())));
            pageInfoResp.setTotalRecords(Integer.parseInt(String.valueOf(pageResult.getTotal())));
            pageInfoResp.setList(pageResult.getRecords());
        }
        else {
            pageInfoResp.setList(Lists.newArrayList());
        }
        return pageInfoResp;
    }

    @Override
    public List<SystemCustomExportVo> exportReport() {
        List<SystemCustomExportVo> customExportVoList = new ArrayList<>();
        //查询自定义组件-作业 和自定义组件-应用 分类的自定义组件
        LabelSystemAllVo req = new LabelSystemAllVo();
        List<Integer> dataCategoryList = new ArrayList<>();
        dataCategoryList.add(Constants.DataCategoryEnum.CATEGORY_APP.getVal());
        dataCategoryList.add(Constants.DataCategoryEnum.CATEGORY_WORK.getVal());
        req.setDataCategoryList(dataCategoryList);
        List<LabelSystemCustom> systemCustomList = queryCustomList(req);
        if (CollectionUtils.isEmpty(systemCustomList)) {
            return customExportVoList;
        }
        List<Long> customIdList = systemCustomList.stream().map(LabelSystemCustom::getId).collect(Collectors.toList());
        //查询预设组件和自定义组件关联的数据源
        List<LabelSystemSource> systemSourcCusList = labelSystemSourceMapper.selBySystemIds(customIdList, Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal());
        if (CollectionUtils.isEmpty(systemSourcCusList)) {
            return customExportVoList;
        }
        Map<Long, Long> systemSourcMap = systemSourcCusList.stream().collect(Collectors.toMap(LabelSystemSource::getSystemId, LabelSystemSource::getDataId, (a, b) -> a));
        //查询数据源
        List<Long> dataIdList = systemSourcCusList.stream().map(LabelSystemSource::getDataId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dataIdList)) {
            return customExportVoList;
        }
        List<LabelSystemData> systemDataList = labelSystemDataMapper.selByIds(dataIdList);
        Map<Long, LabelSystemData> systemDataMap = systemDataList.stream().collect(Collectors.toMap(LabelSystemData::getId, Function.identity()));

        //初始化分类map
        Map<Integer, String> categoryMap = initCategoryValMap();
        //初始化状态map
        Map<Integer, String> statusMap = initStatusValMap();
        for (LabelSystemCustom systemCustom : systemCustomList) {
            SystemCustomExportVo customExport = new SystemCustomExportVo();
            customExport.setNameZh(systemCustom.getNameZh());
            customExport.setDataCategory(categoryMap.get(systemCustom.getDataCategory()));
            customExport.setValidStatus(statusMap.get(systemCustom.getValidStatus()));
            customExport.setRemark(systemCustom.getRemark());
            //获取组件对应的数据源ID
            Long dataId = systemSourcMap.get(systemCustom.getId());
            if (null  != dataId) {
                //获取数据源信息
                LabelSystemData systemData = systemDataMap.get(dataId);
                if (null != systemData) {
                    customExport.setDataName(systemData.getName());
                }
            }
            customExportVoList.add(customExport);
        }
        return customExportVoList;
    }

    /**
     * 查询自定义组件
     * @param req
     * @return
     */
    @Override
    public List<LabelSystemCustom> queryCustomList(LabelSystemAllVo req) {
        QueryWrapper<LabelSystemCustom> condition = new QueryWrapper<>();
        condition.eq("client_type",0);
        if (CollectionUtils.isNotEmpty(req.getDataCategoryList())) {
            condition.in("data_category", req.getDataCategoryList());
        }
        if (CollectionUtils.isNotEmpty(req.getIdList())) {
            condition.in("id", req.getIdList());
        }
        if (!ObjectUtils.isEmpty(req.getValidStatus())) {
            condition.eq("valid_status", req.getValidStatus());
        }
        condition.eq("tenant_id",AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        condition.orderByDesc("modify_time");
        return labelSystemCustomMapper.selectList(condition);
    }

    @Override
    public Page<BizObjAuthRelBatchSystemVo> pageListCustom(List<Long> idList, AuthSystemLabelReq req,List<Long> permSystemIdList) {
        LambdaQueryWrapper<LabelSystemCustom> queryPreWrapper = new LambdaQueryWrapper<>();
        queryPreWrapper.like(StringUtils.isNotEmpty(req.getName()), LabelSystemCustom::getNameZh,req.getName());
        queryPreWrapper.in(CollectionUtils.isNotEmpty(idList), LabelSystemCustom::getId,idList);
        //排除【鼎捷雅典娜APP】的组件
        queryPreWrapper.notIn(CollectionUtils.isNotEmpty(permSystemIdList), LabelSystemCustom::getId,permSystemIdList);
        //根据名称正序排序
        queryPreWrapper.last("ORDER BY cast(name_zh as char character set gbk ) ASC,id desc");
        Page<LabelSystemCustom>  systemCustomPage= labelSystemCustomMapper.selectPage(new Page<>(req.getPageNum(), req.getPageSize()),queryPreWrapper);
        List<BizObjAuthRelBatchSystemVo> relBatchSystemVoList=new ArrayList<>();
        Page<BizObjAuthRelBatchSystemVo> relBatchSystemVoPage=new Page<>();
        for(LabelSystemCustom systemCustom:systemCustomPage.getRecords()){
            BizObjAuthRelBatchSystemVo systemVo=new BizObjAuthRelBatchSystemVo();
            systemVo.setLabelId(systemCustom.getId());
            systemVo.setLabelName(systemCustom.getNameZh());
            systemVo.setLabelType(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal());
            relBatchSystemVoList.add(systemVo);
        }
        relBatchSystemVoPage.setRecords(relBatchSystemVoList);
        relBatchSystemVoPage.setTotal(systemCustomPage.getTotal());
        return relBatchSystemVoPage;
    }

    @Override
    public List<LabelSystemData> queryAthenaAppList(List<Long> systemIds, String appCode) {
        return labelSystemDataMapper.queryAthenaAppList(systemIds,appCode);
    }

    @Override
    public ResponseEntity<?> updateState(LabelSystemCustomSaveReq labelSystemCustomSaveReq){
        //部件id
        Long id = labelSystemCustomSaveReq.getId();
        //部件状态
        Integer validStatus = labelSystemCustomSaveReq.getValidStatus();
        LabelSystemCustom labelSystemCustom = labelSystemCustomMapper.selectById(id);
        if (Objects.equals(labelSystemCustom.getTenantId(),WorkBenchConstant.SYSTEM_TENANT)){
            String error = messageUtils.getMessage("error.message.system.lable.custom.not.modify");
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, error);
        }
        labelSystemCustom.setValidStatus(validStatus);
        labelSystemCustomMapper.updateById(labelSystemCustom);
        return ResponseEntityWrapper.wrapperOk();
    }

    @Override
    public ResponseEntity<?> query(Integer clientType,Integer isLayout){
        List<LabelSystemCustomQueryVO> LabelSystemCustomQuerySortVO = new ArrayList<>();
        List<LabelSystemPreQueryVO> LabelSystemPreQueryVOList = new ArrayList<>();
        LambdaQueryWrapper<LabelSystemCustom> queryPreWrapper = new LambdaQueryWrapper<>();
        queryPreWrapper.eq(LabelSystemCustom::getClientType,clientType);
        List<LabelSystemCustom> labelSystemCustomList = labelSystemCustomMapper.selectList(queryPreWrapper);
        String tenantVersion = kmService.queryTenantVersion();
        List<Long> lableSysTemCustomIds = getLableSysTemCustomIds(tenantVersion,clientType);
        labelSystemCustomList.removeIf(e->e.getTenantId().equals(WorkBenchConstant.SYSTEM_TENANT) && !lableSysTemCustomIds.contains(e.getId()));
        // 查找自定义组件信息
        if (!CollectionUtils.isEmpty(labelSystemCustomList)) {
            Gson gson = new Gson();
            // 查询数据源信息
            List<JSONObject> labelSystemSourceList = labelSystemSourceMapper.listByCondition(null,0,
                    labelSystemCustomList.stream().map(LabelSystemCustom::getId).collect(Collectors.toList()));

            List<LabelSystemCustomQueryVO.DataSourceInfo> dataSourceInfoList = new LinkedList<>();
            labelSystemSourceList.forEach(item->{
                LabelSystemCustomQueryVO.DataSourceInfo dataSourceInfo = gson.fromJson(JSON.toJSONString(item),LabelSystemCustomQueryVO.DataSourceInfo.class);
                dataSourceInfoList.add(dataSourceInfo);
            });

            Map<Long,List<LabelSystemCustomQueryVO.DataSourceInfo>> map
                    = dataSourceInfoList.stream().collect(Collectors.groupingBy(LabelSystemCustomQueryVO.DataSourceInfo::getSystemId));

            List<LabelSystemCustomQueryVO> labelSystemCustomQueryVOList = labelSystemCustomList.stream()
                    .map(item->{
                        List<LabelSystemCustomQueryVO.DataSourceInfo> dataList = map.get(item.getId());
                        LabelSystemCustomQueryVO labelSystemCustomQueryVO = converter.convert(item, LabelSystemCustomQueryVO.class);
                        labelSystemCustomQueryVO.setComponentSource(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal());
                        labelSystemCustomQueryVO.setDataSourceInfo(dataList);

                        // 内嵌网页类型的组件，链接参数
                        if (Constants.DataCategoryEnum.WEB_PAGE.getVal().equals(item.getDataCategory())) {
                            labelSystemCustomQueryVO.setLinkUrlFull(item.getLinkUrl());
                            if (StringUtils.isNotBlank(item.getLinkParam())) {
                                List<LabelSystemLinkParamDTO> linkParamList = com.alibaba.fastjson.JSONArray.parseArray(item.getLinkParam(), LabelSystemLinkParamDTO.class);
                                labelSystemCustomQueryVO.setLinkParamList(linkParamList);

                                // 数据源名称展示为链接
                                StringBuilder stringBuilder = Utils.buildWebLinkDisplayUrl(item.getLinkParam());
                                labelSystemCustomQueryVO.setLinkUrlFull(item.getLinkUrl() + "?" + stringBuilder);
                            }
                        }
                        return labelSystemCustomQueryVO;
                    }).collect(Collectors.toList());

//            if (Constants.IS_LAYOUT.equals(labelSystemCustomQueryReq.getIsLayout())) {
//////                this.filterPortalLayout(labelSystemCustomQueryVOList);
//////            }

            LabelSystemCustomQuerySortVO = labelSystemCustomQueryVOList.stream()
                    .sorted(Comparator.comparing(LabelSystemCustomQueryVO::getModifyTime).reversed()).collect(Collectors.toList());
            buildAppInfo(LabelSystemCustomQuerySortVO);
        }
        //ISV自定义部件
        List<LabelSystemCustomQueryVO> isvLabelSystemCustomQueryVOList = LabelSystemCustomQuerySortVO.stream().filter(e -> e.getTenantId().equals(WorkBenchConstant.SYSTEM_TENANT)).collect(Collectors.toList());
        List<LabelSystemCustomQueryVO> tenantLabelSystemCustomQueryVOList =  LabelSystemCustomQuerySortVO.stream().filter(e -> !e.getTenantId().equals(WorkBenchConstant.SYSTEM_TENANT)).collect(Collectors.toList());
        //查询出预设部件
        if (0 == clientType) {
                labelSystemPreService.initPreData(0);
                LambdaQueryWrapper<LabelSystemPre> queryPreWrapper1 = new LambdaQueryWrapper<>();
                queryPreWrapper1.eq(LabelSystemPre::getTenantId, AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                // 预设组件名支持多语言
                String locale = LocaleContextHolder.getLocale().toString();
                queryPreWrapper1.eq(LabelSystemPre::getClientType,clientType);
                // 查找预设组件信息
                List<LabelSystemPre> labelSystemPreList = InterceptorIgnoreUtil.handler(() -> labelSystemPreMapper.selectList(queryPreWrapper1));
                if (CollectionUtils.isNotEmpty(labelSystemPreList)) {
                    Gson gson = new Gson();
                    // 查询数据源信息
                    List<JSONObject> labelSystemSourceList = labelSystemSourceMapper.listByCondition(
                            AppAuthContextHolder.getContext().getAuthoredUser().getTenantId(), 1,
                            labelSystemPreList.stream().map(LabelSystemPre::getId).collect(Collectors.toList()));

                    List<LabelSystemPreQueryVO.DataSourceInfo> dataSourceInfoList = new LinkedList<>();
                    labelSystemSourceList.forEach(item -> {
                        LabelSystemPreQueryVO.DataSourceInfo dataSourceInfo = gson.fromJson(JSON.toJSONString(item), LabelSystemPreQueryVO.DataSourceInfo.class);
                        dataSourceInfoList.add(dataSourceInfo);
                    });

                    Map<Long, List<LabelSystemPreQueryVO.DataSourceInfo>> map
                            = dataSourceInfoList.stream().collect(Collectors.groupingBy(LabelSystemPreQueryVO.DataSourceInfo::getSystemId));

                    LabelSystemPreQueryVOList = labelSystemPreList.stream()
                            .map(item -> {
                                LabelSystemPreQueryVO labelSystemPreQueryVO = converter.convert(item, LabelSystemPreQueryVO.class);
                                List<LabelSystemPreQueryVO.DataSourceInfo> dataList = map.get(item.getId());
                                // 预设组件名支持多语言
                                if (Constants.ZH_TW_LOCALE.equals(locale) && StringUtils.isNotEmpty(item.getNameTw())) {
                                    labelSystemPreQueryVO.setName(item.getNameTw());
                                }
                                //固定组件的修改人 返回空
                                if (Constants.DataCategoryEnum.CATEGORY_CURRENCY.getVal().equals(item.getDataCategory())) {
                                    labelSystemPreQueryVO.setModifyUserId("");
                                    labelSystemPreQueryVO.setModifyTime("");
                                }
                                labelSystemPreQueryVO.setComponentSource(1);
                                labelSystemPreQueryVO.setDataSourceInfo(dataList);
                                return labelSystemPreQueryVO;
                            }).collect(Collectors.toList());

                    //如果是极简门户，需要过滤三方待办和轮播图组件
                    if (Constants.IS_LAYOUT.equals(isLayout)) {
                        LabelSystemPreQueryVOList = filterPortalLayoutPre(LabelSystemPreQueryVOList);
                    }
                }
        }else{
            List<LabelSystemPre> labelSystemPreList = labelSystemPreService.initMobileLabelSystemPre();
            for(LabelSystemPre labelSystemPre:labelSystemPreList) {
                String name = translateService.translateTextCache(labelSystemPre.getName(), StringUtils.EMPTY);
                labelSystemPre.setName(name);
                labelSystemPre.setModifyUserId("");
                labelSystemPre.setModifyUserName("");
            }
            LabelSystemPreQueryVOList = labelSystemPreList.stream().map(item -> {
                LabelSystemPreQueryVO labelSystemPreQueryVO = converter.convert(item, LabelSystemPreQueryVO.class);
                return labelSystemPreQueryVO;
            }).collect(Collectors.toList());
        }
        Map data = new HashMap();
        data.put("isvLabelSystemCustomQueryVOList",isvLabelSystemCustomQueryVOList);
        data.put("tenantLabelSystemCustomQueryVOList",tenantLabelSystemCustomQueryVOList);
        data.put("labelSystemPreQueryVOList",LabelSystemPreQueryVOList);
        return ResponseEntityWrapper.wrapperOk(data);
    }
}