package com.digiwin.athena.semc.service.portal.impl;

import com.digiwin.athena.semc.proxy.fineReport.model.resp.FineReportTreeVO;
import com.google.common.collect.Lists;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.event.SyncReadListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.MaycurCodeEnum;
import com.digiwin.athena.semc.common.enums.PreinstalledApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.VirtualApplicationEnum;
import com.digiwin.athena.semc.dto.erpsso.ErpSsoSpecialDTO;
import com.digiwin.athena.semc.dto.erpsso.QuerySsoListReq;
import com.digiwin.athena.semc.dto.mobile.CustomApplicationsListPageReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemCountDataDTO;
import com.digiwin.athena.semc.dto.portal.LabelSystemDataDto;
import com.digiwin.athena.semc.dto.portal.QueryImportRecordReq;
import com.digiwin.athena.semc.dto.portal.QueryLabelSystemReq;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.applink.TenantAppDTO;
import com.digiwin.athena.semc.entity.bench.SyncJobInfo;
import com.digiwin.athena.semc.entity.mobile.MobileDatasourceInfo;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.entity.portal.LabelSystemDataImport;
import com.digiwin.athena.semc.entity.portal.LabelSystemSource;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplication;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplicationInstance;
import com.digiwin.athena.semc.entity.portal.TodoList;
import com.digiwin.athena.semc.entity.sso.ErpSsoInfo;
import com.digiwin.athena.semc.entity.sso.ThirdSsoInfo;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.bench.SyncJobInfoMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemDataImportMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemDataMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemSourceMapper;
import com.digiwin.athena.semc.mapper.portal.PreinstalledApplicationInstanceMapper;
import com.digiwin.athena.semc.mapper.portal.PreinstalledApplicationMapper;
import com.digiwin.athena.semc.mapper.portal.TodoListMapper;
import com.digiwin.athena.semc.mapper.sso.ErpSsoInfoMapper;
import com.digiwin.athena.semc.mapper.sso.ThirdSsoInfoMapper;
import com.digiwin.athena.semc.proxy.eoc.service.EocService;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.km.service.KmService;
import com.digiwin.athena.semc.proxy.km.service.model.AppJobDTO;
import com.digiwin.athena.semc.proxy.mdc.MdcService;
import com.digiwin.athena.semc.service.applink.AppLinkService;
import com.digiwin.athena.semc.service.bench.SyncJobInfoService;
import com.digiwin.athena.semc.service.bench.ThirdJobConfigService;
import com.digiwin.athena.semc.service.mobile.MobileDatasourceInfoService;
import com.digiwin.athena.semc.service.portal.IImportRecordService;
import com.digiwin.athena.semc.service.portal.IPreinstalledApplicationService;
import com.digiwin.athena.semc.service.portal.LabelSystemDataService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.FormatUtil;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.portal.ImportExcelResp;
import com.digiwin.athena.semc.vo.portal.LabelSystemDataAppVo;
import com.digiwin.athena.semc.vo.portal.SystemDataExportVo;
import com.digiwin.athena.semc.vo.portal.SystemDataImportVo;
import com.digiwin.athena.semc.vo.portal.SystemDataJobExportVo;
import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.digiwin.athena.semc.dto.portal.LabelSystemLinkParamDTO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.text.Collator;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import io.github.linpeilie.Converter;
import lombok.extern.slf4j.Slf4j;


@Slf4j
@Service
public class LabelSystemDataServiceImpl extends ServiceImpl<LabelSystemDataMapper, LabelSystemData> implements LabelSystemDataService {

    @Autowired
    LabelSystemDataMapper labelSystemDataMapper;

    @Autowired
    LabelSystemSourceMapper labelSystemSourceMapper;

    @Autowired
    ThirdSsoInfoMapper thirdSsoInfoMapper;

    @Autowired
    ErpSsoInfoMapper erpSsoInfoMapper;

    @Autowired
    PreinstalledApplicationMapper preinstalledApplicationMapper;

    @Autowired
    PreinstalledApplicationInstanceMapper preinstalledApplicationInstanceMapper;

    @Resource
    private IamService iamService;

    @Resource
    private MessageUtils messageUtils;

    @Resource
    private KmService kmService;

    @Resource
    private SyncJobInfoService syncJobInfoService;

    @Autowired
    SyncJobInfoMapper syncJobInfoMapper;

    @Resource
    private IPreinstalledApplicationService preinstalledApplicationService;

    @Autowired
    ThirdJobConfigService thirdJobConfigService;

    @Autowired
    MdcService mdcService;

    @Autowired
    private AppLinkService appLinkService;

    @Resource
    private IImportRecordService importRecordService;

    @Autowired
    LabelSystemDataImportMapper labelSystemDataImportMapper;

    @Resource
    private EnvProperties envProperties;

    @Autowired
    TodoListMapper todoListMapper;

    @Resource
    EocService eocService;

    @Resource
    private MobileDatasourceInfoService mobileDatasourceInfoService;

    @Resource
    private Converter converter;

    @Override
    public PageInfoResp<LabelSystemData> queryDataList(QueryLabelSystemReq req) {
        PageInfoResp<LabelSystemData> pageInfoResp = new PageInfoResp<>();
        //  Page<LabelSystemData> systemDataListPage = selectByParam(req);
        Integer startNum = (req.getPageNum() - 1) * req.getPageSize();
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        List<LabelSystemData> systemDataList = labelSystemDataMapper.selectByPage(req.getAppCodeList(), req, startNum, req.getPageSize(), tenantId);
        if (CollectionUtils.isEmpty(systemDataList)) {
            return pageInfoResp;
        }

        //根据源应用来源（ 0：CS、1：BS、2：平台预设、3：雅典娜应用）拆分数据
        LabelSystemDataAppVo systemDataAppVo = getSsoAppMap(systemDataList);
        //CS应用
        Map<Long, ErpSsoInfo> erpInfoMap = systemDataAppVo.getErpInfoMap();
        //BS应用
        Map<Long, ThirdSsoInfo> thirdSsoInfoMap = systemDataAppVo.getThirdSsoInfoMap();
        //雅典娜应用
        Map<String, TenantAppDTO> athenaInfoMap = systemDataAppVo.getAthenaInfoMap();


        // 查询km应用作业池
        List<AppJobDTO> appJobDTOList = new ArrayList<>();
        //判断是否有KM作业的集成
        List<LabelSystemData> systemDataKMList = systemDataList.stream()
                .filter(x -> Constants.DataCategoryEnum.CATEGORY_WORK.getVal().equals(x.getDataCategory()))
                .filter(x -> x.getDataType().equals(ApplicationTypeEnum.IAM_APPLICATION.getType()))
                .collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(systemDataKMList)) {
            appJobDTOList = kmService.queryAppJobList();
        }
        //判断是否有鼎捷雅典娜APP作业
        List<LabelSystemData> systemDataAppList = systemDataList.stream()
                .filter(x -> VirtualApplicationEnum.ATHENA_APP.getPrimaryId().equals(x.getAppCode()))
                .filter(x -> x.getDataType().equals(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType()))
                .collect(Collectors.toList());
        Map<Long, MobileDatasourceInfo> datasourceMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(systemDataAppList)) {
            //查询移动应用作业
            CustomApplicationsListPageReq customApplicationReq = new CustomApplicationsListPageReq();
            customApplicationReq.setStatus(Constants.VALID_STATUS_ENABLE);
            List<MobileDatasourceInfo> datasourceInfoList = mobileDatasourceInfoService.queryDatasourceInfo(customApplicationReq);
            datasourceMap = datasourceInfoList.stream().collect(Collectors.toMap(MobileDatasourceInfo::getId, y -> y, (a, b) -> a));

        }
        //查询租户下预设应用信息
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        List<PreinstalledApplication> preInstalledAppList = preinstalledApplicationService.queryPreinstalledAppList(user);
        Map<Long, PreinstalledApplication> preinstalledApplicationMap = preInstalledAppList.stream().collect(Collectors.toMap(PreinstalledApplication::getId, Function.identity(), (a, b) -> a));
        //查询源应用信息
        for (LabelSystemData systemData : systemDataList) {
            // 虚拟应用，业务待办类型的数据源可选择"雅典娜智驱平台"
            if (ApplicationTypeEnum.VIRTUAL_APPLICATION.getType().equals(systemData.getDataType())) {
                String name = VirtualApplicationEnum.parseNameById(systemData.getAppCode());
                systemData.setAppName(name);
            } else {
                String appName = addAppIDName(erpInfoMap, thirdSsoInfoMap, athenaInfoMap, systemData, false, preinstalledApplicationMap);
                systemData.setAppName(appName);
            }
            //如果是作业，查询作业名称
            if (StringUtils.isNotEmpty(systemData.getWorkCode())) {
                systemData.setWorkName(getWorkName(systemData, appJobDTOList, datasourceMap));
            }
            // 统计组件中统计类型配置信息
            if (Constants.DataCategoryEnum.CATEGORY_COUNT.getVal().equals(systemData.getDataCategory())
                    && StringUtils.isNotBlank(systemData.getCountContentCode())) {
                List<LabelSystemCountDataDTO> countDataDTOList = JSONArray.parseArray(systemData.getCountContentCode(), LabelSystemCountDataDTO.class);
                systemData.setCountContentCode(null);
                systemData.setCountContentList(countDataDTOList);
            }
            // 雅典娜应用作业动态参数
            if (StringUtils.isNotBlank(systemData.getJobLinkParam())) {
                List<LabelSystemLinkParamDTO> linkParamList = JSONArray.parseArray(systemData.getJobLinkParam(), LabelSystemLinkParamDTO.class);
                systemData.setLinkParamList(linkParamList);
            }
            // 帆软报表信息
            if (StringUtils.isNotBlank(systemData.getFineReportParam())) {
                FineReportTreeVO fineReportTreeVO = JSON.parseObject(systemData.getFineReportParam(), FineReportTreeVO.class);
                systemData.setFineReportInfo(fineReportTreeVO);
            }
        }
        int totalCount = labelSystemDataMapper.selectCountBy(req.getAppCodeList(), req, tenantId);
        int totalPages = totalCount % req.getPageSize() == 0 ? totalCount / req.getPageSize()
                : totalCount / req.getPageSize() + 1;
        pageInfoResp.setTotalPages(totalPages);
        pageInfoResp.setPageNo(req.getPageNum());
        pageInfoResp.setPageSize(req.getPageSize());
        pageInfoResp.setTotalRecords(totalCount);
        pageInfoResp.setList(systemDataList);
        return pageInfoResp;
    }

    /**
     * 从km获取作业名称
     *
     * @param appCode
     * @param workCode
     * @return
     */
    public String getKmJobName(String appCode, String workCode, List<AppJobDTO> appJobDTOList) {
        if (CollectionUtils.isEmpty(appJobDTOList)) {
            return "";
        }
        AppJobDTO appJobDTO = appJobDTOList.stream().filter(x -> appCode.equals(x.getAppCode())).findFirst().orElse(null);
        if (appJobDTO == null) {
            return "";
        }
        AppJobDTO.Job job = appJobDTO.getData().stream().filter(x -> workCode.equals(x.getCode())).findFirst().orElse(null);
        if (job == null) {
            return "";
        }
        return job.getName();
    }

    /**
     * 获取作业名称
     *
     * @param systemData
     * @return
     */
    public String getWorkName(LabelSystemData systemData, List<AppJobDTO> appJobDTOList, Map<Long, MobileDatasourceInfo> datasourceMap) {

        //雅典娜应用作业，从km 获取作业名称
        if (ApplicationTypeEnum.IAM_APPLICATION.getType().equals(systemData.getDataType())) {
            return getKmJobName(systemData.getAppCode(), systemData.getWorkCode(), appJobDTOList);
        }
        //鼎捷移动app作业
        if (ApplicationTypeEnum.VIRTUAL_APPLICATION.getType().equals(systemData.getDataType())
                && VirtualApplicationEnum.ATHENA_APP.getPrimaryId().equals(systemData.getAppCode())) {
            MobileDatasourceInfo datasourceInfo = datasourceMap.get(Long.parseLong(systemData.getWorkCode()));
            String jobName = datasourceInfo == null ? "" : datasourceInfo.getName();
            return jobName;
        }
        //从作业同步数据获取作业名称
        List<SyncJobInfo> syncJobInfoList = syncJobInfoMapper.selectList(getJobCondition(systemData.getAppId(), systemData.getWorkCode()));
        if (CollectionUtils.isNotEmpty(syncJobInfoList)) {
            return syncJobInfoList.get(0).getJobName();
        }
        return "";
    }

    /**
     * 查询作业信息
     */
    public QueryWrapper getJobCondition(String appId, String jobCode) {
        QueryWrapper<SyncJobInfo> condition = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(jobCode)) {
            condition.eq("job_code", jobCode);
        }
        if (StringUtils.isNotEmpty(appId)) {
            condition.eq("app_id", appId);
        }
        return condition;
    }

    /**
     * @param erpInfoMap
     * @param thirdSsoInfoMap
     * @param athenaInfoMap
     * @param systemData
     * @return
     */
    public String addAppIDName(Map<Long, ErpSsoInfo> erpInfoMap, Map<Long, ThirdSsoInfo> thirdSsoInfoMap,
                               Map<String, TenantAppDTO> athenaInfoMap,
                               LabelSystemData systemData, Boolean type,
                               Map<Long, PreinstalledApplication> preinstalledApplicationMap) {
        String appName = "";
        String appCode = "";
        String appId = "";
        String systemType = "";
        String appToken = "";
        String callBackUrl = "";
        int isNeedSsoUrl = 0;
        int isFixedRefresh = 0;
        if (StringUtils.isEmpty(systemData.getAppCode())) {
            return appName;
        }
        if (null == systemData.getDataType()) {
            return appName;
        }
        //cs
        if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(systemData.getDataType())) {
            ErpSsoInfo erpSsoInfo = erpInfoMap.get(Long.parseLong(systemData.getAppCode()));
            if (null != erpSsoInfo) {
                appName = erpSsoInfo == null ? "" : erpSsoInfo.getName();
                appCode = erpSsoInfo == null ? "" : erpSsoInfo.getCode();
                appId = erpSsoInfo == null ? "" : erpSsoInfo.getAppId();
                systemType = Constants.SYSTEM_TYPE_WT;
                appToken = erpSsoInfo.getAppToken();
                systemData.setProtocolType(erpSsoInfo.getProtocolType());
                callBackUrl = erpSsoInfo.getCallBackUrl();
            }
        }
        //bs
        if (ApplicationTypeEnum.BS_APPLICATION.getType().equals(systemData.getDataType())) {
            ThirdSsoInfo thirdSsoInfo = thirdSsoInfoMap.get(Long.parseLong(systemData.getAppCode()));
            if (thirdSsoInfo != null) {
                appName = thirdSsoInfo.getAppName();
                appCode = thirdSsoInfo.getAppCode();
                appId = thirdSsoInfo.getAppId();
                systemType = Constants.SYSTEM_TYPE_MT;
                appToken = thirdSsoInfo.getAppToken();
                systemData.setProtocolType(thirdSsoInfo.getProtocolType());
                callBackUrl = thirdSsoInfo.getCallBackUrl();
            }
        }
        //预设
        if (ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(systemData.getDataType())) {
            PreinstalledApplication preinstalledApplication = preinstalledApplicationMap.get(Long.parseLong(systemData.getAppCode()));
            if (null != preinstalledApplication) {
                appName = preinstalledApplication.getApplicationName();
                appCode = preinstalledApplication.getApplicationCode();
                //PreinstalledApplicationInstance applicationInstance=preinstalledApplicationService.getPreINstance(preinstalledApplication.getId(),"","");
                appId = preinstalledApplication.getAppId();
                systemType = getPreSystem(preinstalledApplication);
                appToken = preinstalledApplication.getAppToken();
                systemData.setProtocolType(preinstalledApplication.getProtocolType());
                JSONObject jsonObject = Optional.ofNullable(JSONObject.parseObject(preinstalledApplication.getApplicationConfig())).orElse(new JSONObject());
                callBackUrl = String.format(Constants.CS_APP_CALLBACK_URL, jsonObject.getString("applicationCode"));
                //每刻报销和每刻云票需要重新获取sso地址
                if (MaycurCodeEnum.MAYCUR_APPROVALS.getType().equals(preinstalledApplication.getApplicationCode())) {
                    isNeedSsoUrl = 1;
                    isFixedRefresh = 1;
                    PreinstalledApplicationInstance applicationInstance = preinstalledApplicationService.getPreINstance(preinstalledApplication.getId(), "", "");
                    //取回调地址
                    if (null != applicationInstance && null != applicationInstance.getApplicationExtConfig()) {
                        net.sf.json.JSONObject instanceObject = applicationInstance.getApplicationExtConfig();
                        callBackUrl = instanceObject.getString("callBackUrl");
                        appId = instanceObject.getString("appId");
                    }
                }
                //t100和TIPTOP也需要获取跳转url
                if (Constants.TIPTOP_PRODUCT_TYPE.equals(preinstalledApplication.getProductCode()) || Constants.T100_PRODUCT_TYPE.equals(preinstalledApplication.getProductCode())) {
                    isNeedSsoUrl = 1;
                }

            }

        }
        //雅典娜应用
        if (ApplicationTypeEnum.IAM_APPLICATION.getType().equals(systemData.getDataType())) {
            TenantAppDTO appDTO = athenaInfoMap.get(systemData.getAppCode());
            appName = appDTO == null ? "" : appDTO.getName();
            appCode = systemData.getAppCode();
        }
        //虚拟应用
        if (ApplicationTypeEnum.VIRTUAL_APPLICATION.getType().equals(systemData.getDataType())) {
            appCode = VirtualApplicationEnum.parseCodeById(systemData.getAppCode());
            appName = VirtualApplicationEnum.parseNameById(systemData.getAppCode());
        }
        systemData.setAppId(appId);
        if (type) {
            systemData.setAppCode(appCode);
            systemData.setSystemType(systemType);
            systemData.setAppToken(appToken);
            systemData.setCallBackUrl(callBackUrl);
            systemData.setIsNeedSsoUrl(isNeedSsoUrl);
            systemData.setIsFixedRefresh(isFixedRefresh);
        }
        systemData.setAppName(appName);
        return appName;
    }

    public static boolean canConvertToLong(String str) {
        try {
            Long.parseLong(str);
            return true;
        } catch (NumberFormatException e) {
            return false;
        }
    }

    /**
     * 获取预设表里的应用属于稳态还是敏态
     *
     * @param preinstalledApplication
     * @return
     */
    public String getPreSystem(PreinstalledApplication preinstalledApplication) {
        String systemType = "";
        if (null == preinstalledApplication.getSystemType()) {
            return systemType;
        }
        //bs = mt
        if (preinstalledApplication.getSystemType().equals(Integer.parseInt(PreinstalledApplicationTypeEnum.BS_APPLICATION.getValue()))) {
            systemType = Constants.SYSTEM_TYPE_MT;
        }
        //cs = wt
        if (preinstalledApplication.getSystemType().equals(Integer.parseInt(PreinstalledApplicationTypeEnum.CS_APPLICATION.getValue()))) {
            systemType = Constants.SYSTEM_TYPE_WT;
        }
        return systemType;
    }

    /**
     * 查询雅典娜应用
     *
     * @param
     * @return
     */
    public Map<String, TenantAppDTO> getAthenaInfoMap(List<LabelSystemData> athenaList) {
        Map<String, TenantAppDTO> athenaInfoMap = new HashMap<>();
        if (CollectionUtils.isEmpty(athenaList)) {
            return athenaInfoMap;
        }
        List<TenantAppDTO> allTenantApps = iamService.queryTenantApps();
        athenaInfoMap = allTenantApps.stream()
                .collect(Collectors.toMap(value -> value.getId(), value -> value, (key1, key2) -> key1));
        return athenaInfoMap;
    }

    /**
     * 查询平台预设应用
     *
     * @param
     * @return
     */
    public Map<Long, PreinstalledApplication> getPreInfoMap() {
        List<PreinstalledApplication> preinstalledAppList = preinstalledApplicationMapper.selectList(new QueryWrapper<PreinstalledApplication>());
        Map<Long, PreinstalledApplication> preInfoMap = preinstalledAppList.stream().collect(Collectors.toMap(PreinstalledApplication::getId, Function.identity(), (a, b) -> a));

        return preInfoMap;
    }

    /**
     * 查询CS应用
     *
     * @param csList
     * @return
     */
    public Map<Long, ErpSsoInfo> getErpInfoMap(List<LabelSystemData> csList, LabelSystemDataAppVo systemDataAppVo) {
        Map<Long, ErpSsoInfo> erpInfoMap = new HashMap<>();
        if (CollectionUtils.isEmpty(csList)) {
            return erpInfoMap;
        }
        List<String> thirdFolderIdList = csList.stream().map(LabelSystemData::getAppCode).collect(Collectors.toList());
        QuerySsoListReq querySsoListReq = new QuerySsoListReq();
        List<Long> idList = thirdFolderIdList.stream().map(Long::parseLong).collect(Collectors.toList());
        querySsoListReq.setIdList(idList);
        systemDataAppVo.setErpSystemId(idList);
        List<ErpSsoInfo> erpInfoList = erpSsoInfoMapper.querySsoListByScope(querySsoListReq);
        erpInfoMap = erpInfoList.stream().collect(Collectors.toMap(ErpSsoInfo::getId, Function.identity(), (a, b) -> a));
        return erpInfoMap;
    }

    /**
     * 查询BS应用
     *
     * @param bsList
     * @return
     */
    public Map<Long, ThirdSsoInfo> getSsoInfoMap(List<LabelSystemData> bsList, LabelSystemDataAppVo systemDataAppVo) {
        Map<Long, ThirdSsoInfo> thirdSsoInfoMap = new HashMap<>();
        if (CollectionUtils.isEmpty(bsList)) {
            return thirdSsoInfoMap;
        }
        List<String> thirdFolderIdList = bsList.stream().map(LabelSystemData::getAppCode).collect(Collectors.toList());
        QuerySsoListReq querySsoListReq = new QuerySsoListReq();
        List<Long> idList = thirdFolderIdList.stream().map(Long::parseLong).collect(Collectors.toList());
        querySsoListReq.setIdList(idList);
        systemDataAppVo.setBsSystemId(idList);
        List<ThirdSsoInfo> thirdSsoInfoList = thirdSsoInfoMapper.queryThirdListByScope(querySsoListReq);
        thirdSsoInfoMap = thirdSsoInfoList.stream().collect(Collectors.toMap(ThirdSsoInfo::getId, Function.identity(), (a, b) -> a));
        return thirdSsoInfoMap;
    }


    @Override
    @Transactional
    public ResponseEntity<?> updateValidStatus(QueryLabelSystemReq req) {
        LabelSystemData systemData = labelSystemDataMapper.selectById(req.getId());
        if (null == systemData) {
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.UPDATE_FAILED, "the data source does not exist");
        }

        systemData.setId(req.getId());
        systemData.setValidStatus(req.getValidStatus());
        systemData.setModifyUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
        //如果是启用，校验参数
        if (Constants.VALID_STATUS_ENABLE.equals(req.getValidStatus())) {
            ResponseEntity<?> checkResp = checkSystemData(systemData);
            if (null != checkResp) {
                return checkResp;
            }
        }
        //如果是停用，校验是否有组件关联
        if (Constants.VALID_STATUS_UNUSABLE.equals(req.getValidStatus())) {
            List<Long> dataIds = new ArrayList<>();
            dataIds.add(req.getId());
            List<LabelSystemSource> systemSourceList = labelSystemSourceMapper.selByDataIds(dataIds, null);
            if (CollectionUtils.isNotEmpty(systemSourceList)) {
                String error = messageUtils.getMessage("error.message.system.data.stop");
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
            }
        }
        labelSystemDataMapper.updateById(systemData);
        return ResponseEntityWrapper.wrapperOk();
    }

    @Override
    @Transactional
    public ResponseEntity<?> delData(QueryLabelSystemReq req) {
        //校验是否有已启用的数据源
        List<LabelSystemData> valIdDataList = new ArrayList<>();
        req.setValidStatus(Constants.VALID_STATUS_ENABLE);
        req.setPageNum(Constants.pageNum);
        req.setPageSize(Constants.pageSize);
        Page<LabelSystemData> systemDataListPage = selectByParam(req);
        if (null != systemDataListPage) {
            valIdDataList = systemDataListPage.getRecords();
        }
        //删除一条数据源，且数据源状态已启用
        if (CollectionUtils.isNotEmpty(valIdDataList) && req.getIds().size() == 1) {
            String error = messageUtils.getMessage("error.message.system.data.delete");
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
        //删除多条数据源，且数据源状态存在已启用的
        if (CollectionUtils.isNotEmpty(valIdDataList)) {
            String error = messageUtils.getMessage("error.message.system.data.delete.fail");
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
        //删除数据源
        labelSystemDataMapper.deleteBatchIds(req.getIds());
        //删除数据源和组件关系
        labelSystemSourceMapper.delByDataIds(req.getIds());
        return ResponseEntityWrapper.wrapperOk();
    }

    @Override
    @Transactional
    public ResponseEntity<?> saveData(LabelSystemData req) {
        //校验参数合法性
        ResponseEntity<?> checkResp = checkSystemData(req);
        if (null != checkResp) {
            return checkResp;
        }
        req.setName(req.getName().trim());

        // 雅典娜作业参数配置，转为json存入数据库
        if (CollectionUtils.isNotEmpty(req.getLinkParamList())) {
            String linkParam = JSON.toJSONString(req.getLinkParamList());
            req.setJobLinkParam(linkParam);
        } else {
            req.setJobLinkParam("");
        }
        // 帆软报表信息，转为json存入数据库
        if (ObjectUtils.isNotEmpty(req.getFineReportInfo())) {
            String fineReportParam = JSON.toJSONString(req.getFineReportInfo());
            req.setFineReportParam(fineReportParam);
        } else {
            req.setFineReportParam("");
        }

        //校验名称是否重复
        int isExistData = labelSystemDataMapper.countByParam(req.getName(), req.getId(), AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        if (isExistData > 0) {
            String error = messageUtils.getMessage("error.message.system.data.name.exist");
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, error);
        }
        //如果是停用，校验是否有组件关联
        if (null != req.getId() && null != req.getValidStatus() && Constants.VALID_STATUS_UNUSABLE.equals(req.getValidStatus())) {
            List<Long> dataIds = new ArrayList<>();
            dataIds.add(req.getId());
            List<LabelSystemSource> systemSourceList = labelSystemSourceMapper.selByDataIds(dataIds, null);
            if (CollectionUtils.isNotEmpty(systemSourceList)) {
                String error = messageUtils.getMessage("error.message.system.data.stop");
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
            }
        }
        req.setModifyUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
        // 统计分类下类型集合参数转成string保存
        if (CollectionUtils.isNotEmpty(req.getCountContentList())) {
            String contentInfo = JSON.toJSONString(req.getCountContentList());
            req.setCountContentCode(contentInfo);
        }
        if (req.getId() == null) {
            req.setCreateUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
            labelSystemDataMapper.insert(req);
        } else {
            // 源应用和数据源分类不允许修改
            LabelSystemData systemData = labelSystemDataMapper.selectById(req.getId());
            if (ObjectUtils.isEmpty(systemData)) {
                String error = messageUtils.getMessage("error.message.system.data.not.exist");
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
            }
            if (!systemData.getAppCode().equals(req.getAppCode()) || !systemData.getDataCategory().equals(req.getDataCategory())) {
                String error = messageUtils.getMessage("error.message.system.data.not.modify");
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
            }
            labelSystemDataMapper.updateById(req);
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    @Override
    public List<LabelSystemData> queryByIds(List<Long> ids) {
        return labelSystemDataMapper.selectBatchIds(ids);
    }

    @Override
    public List<String> getDataNameList(Integer dataType, String appCode) {
        return labelSystemDataMapper.getDataNameList(dataType, appCode);
    }

    @Override
    public List<LabelSystemData> queryDataInfoBy(List<Long> ids, Boolean isCount) {
        List<LabelSystemData> systemDataList = new ArrayList<>();
        if (CollectionUtils.isEmpty(ids)) {
            return systemDataList;
        }
        systemDataList = labelSystemDataMapper.selectBatchIds(ids);

        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        //查询租户下预设应用信息
        List<PreinstalledApplication> preInstalledAppList = preinstalledApplicationService.queryPreinstalledAppList(user);
        Map<Long, PreinstalledApplication> preinstalledApplicationMap = preInstalledAppList.stream().collect(Collectors.toMap(PreinstalledApplication::getId, Function.identity(), (a, b) -> a));

        //应用权限查询,筛选过滤出用户所有有权限的应用
        List<AppLinkDTO> appLinkListDTO = appLinkService.queryAllAuthorizedList(String.valueOf(user.getSid()));
        //预设应用重新赋值数据源类型
        for (AppLinkDTO dto : appLinkListDTO) {
            if (canConvertToLong(dto.getPrimaryId()) && preinstalledApplicationMap.get(Long.parseLong(dto.getPrimaryId())) != null) {
                dto.setType("3");
            }
        }
        systemDataList = systemDataList.stream().filter(x -> appLinkListDTO.stream().map(y -> y.getPrimaryId() + "-" + y.getType()).collect(Collectors.toList()).contains(x.getAppCode() + "-" + x.getDataType())).collect(Collectors.toList());
        LabelSystemDataAppVo systemDataAppVo = new LabelSystemDataAppVo();
        //CS应用
        List<LabelSystemData> csList = systemDataList.stream().filter(item -> ApplicationTypeEnum.CS_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map<Long, ErpSsoInfo> erpInfoMap = getErpInfoMap(csList, systemDataAppVo);
        //BS应用
        List<LabelSystemData> bsList = systemDataList.stream().filter(item -> ApplicationTypeEnum.BS_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map<Long, ThirdSsoInfo> thirdSsoInfoMap = getSsoInfoMap(bsList, systemDataAppVo);

        //应用的AppId集合
        List<String> appIdList = new ArrayList<>();
        //工号或者地端账号
        List<String> userIdList = new ArrayList<>();
        for (LabelSystemData systemData : systemDataList) {
            Map<String, TenantAppDTO> athenaInfoMap = new HashMap<>();
            String appName = addAppIDName(erpInfoMap, thirdSsoInfoMap, athenaInfoMap, systemData, true, preinstalledApplicationMap);
            systemData.setAppName(appName);

            String verifyUserId = "";
            //需要统计待办数量
            if (isCount) {
                //每刻报销获取工号
                if (MaycurCodeEnum.MAYCUR_APPROVALS.getType().equals(systemData.getAppCode())) {
                    // 获取员工工号
                    verifyUserId = this.eocService.getEmpJobNum();
                } else {
                    //查询当前鼎捷云用户对应地端用户
                    verifyUserId = iamService.queryMappingEmpId(systemData.getAppCode());
                }
                if (StringUtils.isNotEmpty(verifyUserId) && !userIdList.contains(verifyUserId)) {
                    userIdList.add(verifyUserId);
                }
            }

            if (StringUtils.isNotEmpty(verifyUserId) && StringUtils.isNotEmpty(systemData.getAppId()) && !appIdList.contains(systemData.getAppId())) {
                appIdList.add(systemData.getAppId());
            }
        }

        if (isCount) {
            Map<String, Integer> todoNumMap = new HashMap<>();
            //统计每个应用的待办数量，且 需要统计待办数量
            if (CollectionUtils.isNotEmpty(userIdList) && CollectionUtils.isNotEmpty(appIdList)) {
                List<TodoList> todoNumListList = todoListMapper.queryToDoNum(appIdList, userIdList);
                todoNumMap = todoNumListList.stream().collect(Collectors.toMap(TodoList::getAppId, TodoList::getToDoNum, (a, b) -> a));
            }

            for (LabelSystemData systemData : systemDataList) {
                if (StringUtils.isNotEmpty(systemData.getAppId())) {
                    Integer todoNum = todoNumMap.get(systemData.getAppId());
                    systemData.setToDoNum(todoNum == null ? 0 : todoNum);
                }
            }
        }
        return systemDataList;
    }

    @Override
    public LabelSystemDataDto getSystemDataSso(Long id) {
        LabelSystemDataDto labelSystemDataDto = new LabelSystemDataDto();
        //查询数据源信息
        LabelSystemData labelSystemData = labelSystemDataMapper.selectById(id);
        if (null == labelSystemData) {
            return null;
        }
        converter.convert(labelSystemData, labelSystemDataDto);
        //CS应用
        if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(labelSystemData.getDataType())) {
            ErpSsoInfo erpSsoInfo = erpSsoInfoMapper.selectById(labelSystemData.getAppCode());
            if (null != erpSsoInfo) {
                labelSystemDataDto.setAppId(erpSsoInfo.getAppId());
                labelSystemDataDto.setAppCode(erpSsoInfo.getCode());
                labelSystemDataDto.setAppName(erpSsoInfo.getName());
                labelSystemDataDto.setAppToken(erpSsoInfo.getAppToken());
                labelSystemDataDto.setUserBindFlag(erpSsoInfo.getUserBindFlag());
                labelSystemDataDto.setProtocolType(erpSsoInfo.getProtocolType());
                labelSystemDataDto.setCasServerUrl(erpSsoInfo.getCasServerUrl());
            }
        }
        //BS应用
        if (ApplicationTypeEnum.BS_APPLICATION.getType().equals(labelSystemData.getDataType())) {
            ThirdSsoInfo thirdSsoInfo = thirdSsoInfoMapper.selectById(labelSystemData.getAppCode());
            if (null != thirdSsoInfo) {
                labelSystemDataDto.setAppId(thirdSsoInfo.getAppId());
                labelSystemDataDto.setAppCode(thirdSsoInfo.getAppCode());
                labelSystemDataDto.setAppName(thirdSsoInfo.getAppName());
                labelSystemDataDto.setAppToken(thirdSsoInfo.getAppToken());
                labelSystemDataDto.setUserBindFlag(thirdSsoInfo.getUserBindFlag());
                labelSystemDataDto.setProtocolType(thirdSsoInfo.getProtocolType());
                labelSystemDataDto.setCasServerUrl(thirdSsoInfo.getCasServerUrl());
            }
        }
        //预设应用
        if (ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(labelSystemData.getDataType())) {
            AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
            List<PreinstalledApplication> preInstalledAppList = preinstalledApplicationService.queryPreinstalledAppList(user);
            Map<Long, PreinstalledApplication> preinstalledApplicationMap = preInstalledAppList.stream().collect(Collectors.toMap(PreinstalledApplication::getId, Function.identity(), (a, b) -> a));
            PreinstalledApplication preinstalled = preinstalledApplicationMap.get(Long.parseLong(labelSystemData.getAppCode()));
            if (null != preinstalled) {
                labelSystemDataDto.setAppId(preinstalled.getAppId());
                labelSystemDataDto.setAppCode(preinstalled.getApplicationCode());
                labelSystemDataDto.setAppName(preinstalled.getApplicationName());
                labelSystemDataDto.setAppSecret(preinstalled.getAppSecret());
                labelSystemDataDto.setAppToken(preinstalled.getAppToken());
                labelSystemDataDto.setUserBindFlag(preinstalled.getUserBindFlag());
                if (StringUtils.isNotEmpty(preinstalled.getApplicationConfig())) {
                    ErpSsoSpecialDTO erpSsoSpecialDTO = Optional.ofNullable(JSONObject.parseObject(preinstalled.getApplicationConfig(), ErpSsoSpecialDTO.class)).orElse(new ErpSsoSpecialDTO());
                    labelSystemDataDto.setCallBackUrl(erpSsoSpecialDTO == null ? "" : erpSsoSpecialDTO.getCallBackUrl());
                }
                //每刻报销和每刻云票
                if (MaycurCodeEnum.MAYCUR_CLOUD.getType().equals(preinstalled.getApplicationCode()) ||
                        MaycurCodeEnum.MAYCUR_APPROVALS.getType().equals(preinstalled.getApplicationCode())) {
                    //取回调地址
                    PreinstalledApplicationInstance applicationInstance = preinstalledApplicationService.getPreINstance(preinstalled.getId(), "", "");
                    net.sf.json.JSONObject jsonObject = applicationInstance.getApplicationExtConfig();
                    String callBackUrl = jsonObject.getString("callBackUrl");
                    String appId = jsonObject.getString("appId");
                    String appSecret = jsonObject.getString("appSecret");
                    labelSystemDataDto.setAppId(appId);
                    labelSystemDataDto.setAppSecret(appSecret);
                    labelSystemDataDto.setCallBackUrl(callBackUrl);
                }
                labelSystemDataDto.setProtocolType(preinstalled.getProtocolType());
                labelSystemDataDto.setCasServerUrl(preinstalled.getCasServerUrl());
            }
        }
        return labelSystemDataDto;
    }

    @Override
    public List<AppJobDTO.Job> getAppJobList(String appCode, Integer dataSource, Boolean isToGet, Integer type) {
        List<AppJobDTO.Job> jobListDTOList = new ArrayList<>();
        //雅典娜应用查询KM作业
        if (dataSource.equals((ApplicationTypeEnum.IAM_APPLICATION.getType()))) {
            //从km查询租户下所有应用作业信息
            List<AppJobDTO> appJobListDTOList = kmService.queryAppJobList();
            if (CollectionUtils.isEmpty(appJobListDTOList)) {
                return jobListDTOList;
            }
            Map<String, AppJobDTO> appJobListMap = appJobListDTOList.stream().collect(Collectors.toMap(AppJobDTO::getAppCode, Function.identity(), (a, b) -> a));
            //取出当前应用的作业
            if (null != appJobListMap && null != appJobListMap.get(appCode)) {
                jobListDTOList = appJobListMap.get(appCode).getData();
            }
        }
        //鼎捷雅典娜APP作业
        else if (dataSource.equals(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType())
                && appCode.equals(VirtualApplicationEnum.ATHENA_APP.getPrimaryId())
        ) {
            CustomApplicationsListPageReq customApplicationReq = new CustomApplicationsListPageReq();
            customApplicationReq.setStatus(Constants.VALID_STATUS_ENABLE);
            List<MobileDatasourceInfo> datasourceInfoList = mobileDatasourceInfoService.queryDatasourceInfo(customApplicationReq);
            jobListDTOList = packageAppJob(datasourceInfoList);
        }
        //从作业同步数据中查询
        else {
            //查看该应用作业同步模式，如果是拉取模式，需要请求接口拉取作业
            Map<String, String> ssoInfoMap = getSSoInfo(Long.parseLong(appCode), dataSource);
            if (null != ssoInfoMap && StringUtils.isNotEmpty(ssoInfoMap.get("appId"))) {
                List<SyncJobInfo> jobInfoList = new ArrayList<>();

                // 查询当前租户的账套信息
                String appIdCode = ssoInfoMap.get("appIdCode");
               /* List<AccountDTO> accountList = iamService.queryTenantAccountMappingList(appIdCode, null, null);
                List<String> accountIdList = accountList.stream().map(AccountDTO::getAccount).collect(Collectors.toList());*/
                List<String> accountIdList = Lists.newArrayList();

                //需要请求三方系统查询
                if (isToGet) {
                    jobInfoList = thirdJobConfigService.getThirdJobList(appCode, dataSource, ssoInfoMap.get("appToken"), ssoInfoMap.get("appId"), appIdCode);
                    if (CollectionUtils.isNotEmpty(accountIdList)) {
                        jobInfoList = jobInfoList.stream().filter(x -> accountIdList.contains(x.getAccountId())).collect(Collectors.toList());
                    }
                }
                if (CollectionUtils.isEmpty(jobInfoList)) {
                    jobInfoList = syncJobInfoService.selectJobList(ssoInfoMap.get("appId"), accountIdList);
                }

                //如果是移动端作业，移动端作业地址不可为空
                if (null != type && Constants.JobWorkTypeEnum.MOBILE_JOB.getValue().equals(type)) {
                    jobInfoList = jobInfoList.stream().filter(item -> ObjectUtils.isNotEmpty(item.getMobileJobUrl())).collect(Collectors.toList());
                }
                jobListDTOList = praseAppJob(jobInfoList, isToGet);
            }
        }

        return jobListDTOList;
    }


    /**
     * 鼎捷雅典娜APP作业转换
     *
     * @param datasourceInfoList
     * @return
     */
    public List<AppJobDTO.Job> packageAppJob(List<MobileDatasourceInfo> datasourceInfoList) {
        List<AppJobDTO.Job> appjobList = new ArrayList<>();
        if (CollectionUtils.isEmpty(datasourceInfoList)) {
            return appjobList;
        }
        for (MobileDatasourceInfo jobInfo : datasourceInfoList) {
            AppJobDTO.Job job = new AppJobDTO.Job();
            job.setName(jobInfo.getName());
            job.setCode(jobInfo.getId() + "");
            appjobList.add(job);
        }
        return appjobList;
    }


    @Override
    public Map<String, String> getSSoInfo(Long id, Integer dataSource) {
        Map<String, String> ssoInfoMap = new HashMap<>();

        //CS应用
        if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(dataSource)) {
            ErpSsoInfo erpSsoInfo = erpSsoInfoMapper.selectById(id);
            if (null != erpSsoInfo) {
                ssoInfoMap.put("appId", erpSsoInfo.getAppId());
                ssoInfoMap.put("appIdCode", erpSsoInfo.getCode());
                ssoInfoMap.put("appToken", erpSsoInfo.getAppToken());
            }
        }
        //BS应用
        if (ApplicationTypeEnum.BS_APPLICATION.getType().equals(dataSource)) {
            ThirdSsoInfo thirdSsoInfo = thirdSsoInfoMapper.selectById(id);
            if (null != thirdSsoInfo) {
                ssoInfoMap.put("appId", thirdSsoInfo.getAppId());
                ssoInfoMap.put("appIdCode", thirdSsoInfo.getAppCode());
                ssoInfoMap.put("appToken", thirdSsoInfo.getAppToken());
            }
        }
        //预设应用
        if (ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(dataSource)) {
            AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
            List<PreinstalledApplication> preInstalledAppList = preinstalledApplicationService.queryPreinstalledAppList(user);
            Map<Long, PreinstalledApplication> preinstalledApplicationMap = preInstalledAppList.stream().collect(Collectors.toMap(PreinstalledApplication::getId, Function.identity(), (a, b) -> a));
            PreinstalledApplication preinstalled = preinstalledApplicationMap.get(id);
            if (null != preinstalled) {
                ssoInfoMap.put("appId", preinstalled.getAppId());
                ssoInfoMap.put("appIdCode", preinstalled.getApplicationCode());
                ssoInfoMap.put("appToken", preinstalled.getAppToken());
            }
        }
        return ssoInfoMap;
    }

    @Override
    public LabelSystemDataAppVo getSsoAppMap(List<LabelSystemData> systemDataList) {
        LabelSystemDataAppVo systemDataAppVo = new LabelSystemDataAppVo();
        //CS应用
        List<LabelSystemData> csList = systemDataList.stream().filter(item -> ApplicationTypeEnum.CS_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map<Long, ErpSsoInfo> erpInfoMap = getErpInfoMap(csList, systemDataAppVo);
        systemDataAppVo.setErpInfoMap(erpInfoMap);
        //BS应用
        List<LabelSystemData> bsList = systemDataList.stream().filter(item -> ApplicationTypeEnum.BS_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map<Long, ThirdSsoInfo> thirdSsoInfoMap = getSsoInfoMap(bsList, systemDataAppVo);
        systemDataAppVo.setThirdSsoInfoMap(thirdSsoInfoMap);
        //预设应用
        Map<Long, PreinstalledApplication> preInfoMap = getPreInfoMap();
        systemDataAppVo.setPreInfoMap(preInfoMap);
        //雅典娜应用
        List<LabelSystemData> athenaList = systemDataList.stream().filter(item -> ApplicationTypeEnum.IAM_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map<String, TenantAppDTO> athenaInfoMap = getAthenaInfoMap(athenaList);
        systemDataAppVo.setAthenaInfoMap(athenaInfoMap);
        return systemDataAppVo;
    }

    @Override
    public LabelSystemDataAppVo getSsoAppMapTemp(List<LabelSystemData> systemDataList) {
        LabelSystemDataAppVo systemDataAppVo = new LabelSystemDataAppVo();
        //CS应用
        List<LabelSystemData> csList = systemDataList.stream().filter(item -> ApplicationTypeEnum.CS_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map<Long, ErpSsoInfo> erpInfoMap = getErpInfoMap(csList, systemDataAppVo);
        systemDataAppVo.setErpInfoMap(erpInfoMap);
        //BS应用
        List<LabelSystemData> bsList = systemDataList.stream().filter(item -> ApplicationTypeEnum.BS_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map<Long, ThirdSsoInfo> thirdSsoInfoMap = getSsoInfoMap(bsList, systemDataAppVo);
        systemDataAppVo.setThirdSsoInfoMap(thirdSsoInfoMap);
        //租户的预设应用
        List<LabelSystemData> preList = systemDataList.stream().filter(item -> ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map<Long, PreinstalledApplicationInstance> preInstanceListMap = new HashMap<>();
        Map<Long, PreinstalledApplication> preAppMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(preList)) {
            List<String> applicationIdList = preList.stream().map(LabelSystemData::getAppCode).collect(Collectors.toList());
            List<PreinstalledApplicationInstance> preInstanceList = preinstalledApplicationInstanceMapper.getPreInsBy(systemDataList.get(0).getTenantId(), applicationIdList,null);
            if (CollectionUtils.isNotEmpty(preInstanceList)) {
                preInstanceListMap = preInstanceList.stream().collect(Collectors.toMap(PreinstalledApplicationInstance::getPreinstalledApplicationId, Function.identity(), (a, b) -> a));
            }
            List<PreinstalledApplication> preAppList = preinstalledApplicationMapper.selectBatchIds(applicationIdList);
            preAppMap = preAppList.stream().collect(Collectors.toMap(PreinstalledApplication::getId, Function.identity(), (a, b) -> a));

        }
        //雅典娜应用
        List<LabelSystemData> athenaList = systemDataList.stream().filter(item -> ApplicationTypeEnum.IAM_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map<String, TenantAppDTO> athenaInfoMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(athenaList)) {
            athenaInfoMap = getAthenaInfoMap(athenaList);
        }
        //数据源中源应用名称，key：数据源ID，val:源应用名称
        Map<Long, LabelSystemDataDto> systemAppNameMap = new HashMap<>();
        for (LabelSystemData systemData : systemDataList) {
            LabelSystemDataDto labelSystemDataDto = new LabelSystemDataDto();
            //CS应用
            if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(systemData.getDataType())) {
                ErpSsoInfo erpSsoInfo = erpInfoMap.get(Long.parseLong(systemData.getAppCode()));
                if (null != erpSsoInfo) {
                    labelSystemDataDto.setAppId(erpSsoInfo.getAppId());
                    labelSystemDataDto.setAppCode(erpSsoInfo.getCode());
                    labelSystemDataDto.setAppName(erpSsoInfo.getName());
                    labelSystemDataDto.setAppToken(erpSsoInfo.getAppToken());
                    labelSystemDataDto.setUserBindFlag(erpSsoInfo.getUserBindFlag());
                    labelSystemDataDto.setProtocolType(erpSsoInfo.getProtocolType());
                    labelSystemDataDto.setCasServerUrl(erpSsoInfo.getCasServerUrl());
                }
            }
            //BS应用
            if (ApplicationTypeEnum.BS_APPLICATION.getType().equals(systemData.getDataType())) {
                ThirdSsoInfo thirdSsoInfo = thirdSsoInfoMap.get(Long.parseLong(systemData.getAppCode()));
                if (null != thirdSsoInfo) {
                    labelSystemDataDto.setAppId(thirdSsoInfo.getAppId());
                    labelSystemDataDto.setAppCode(thirdSsoInfo.getAppCode());
                    labelSystemDataDto.setAppName(thirdSsoInfo.getAppName());
                    labelSystemDataDto.setAppToken(thirdSsoInfo.getAppToken());
                    labelSystemDataDto.setUserBindFlag(thirdSsoInfo.getUserBindFlag());
                    labelSystemDataDto.setProtocolType(thirdSsoInfo.getProtocolType());
                    labelSystemDataDto.setCasServerUrl(thirdSsoInfo.getCasServerUrl());
                }
            }
            //预设应用
            if (ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(systemData.getDataType())) {
                PreinstalledApplicationInstance preInstance = preInstanceListMap.get(Long.parseLong(systemData.getAppCode()));
                if (null != preInstance) {
                    labelSystemDataDto.setAppId(preInstance.getAppId());
                    labelSystemDataDto.setAppSecret(preInstance.getAppSecret());
                }
                PreinstalledApplication preinstalledApplication = preAppMap.get(Long.parseLong(systemData.getAppCode()));
                if (null != preinstalledApplication) {
                    labelSystemDataDto.setAppCode(preinstalledApplication.getApplicationCode());
                    labelSystemDataDto.setAppName(preinstalledApplication.getApplicationName());
                }
            }
            //IAM 应用
            if (ApplicationTypeEnum.IAM_APPLICATION.getType().equals(systemData.getDataType())) {
                TenantAppDTO appDTO = athenaInfoMap.get(systemData.getAppCode());
                if (null != appDTO) {
                    labelSystemDataDto.setAppCode(appDTO.getId());
                    labelSystemDataDto.setAppName(appDTO.getName());
                }
            }
            //虚拟应用
            if (ApplicationTypeEnum.VIRTUAL_APPLICATION.getType().equals(systemData.getDataType())) {
                String code = VirtualApplicationEnum.parseCodeById(systemData.getAppCode());
                labelSystemDataDto.setAppCode(code);
                String name = VirtualApplicationEnum.parseNameById(systemData.getAppCode());
                labelSystemDataDto.setAppName(name);
            }
            systemAppNameMap.put(systemData.getId(), labelSystemDataDto);
        }
        systemDataAppVo.setSystemAppNameMap(systemAppNameMap);
        return systemDataAppVo;
    }

    /**
     * 三方系统作业转换
     *
     * @param jobInfoList
     * @return
     */
    public List<AppJobDTO.Job> praseAppJob(List<SyncJobInfo> jobInfoList, Boolean isToGet) {
        List<AppJobDTO.Job> jobListDTOList = new ArrayList<>();
        if (isToGet) {
            // 如果作业名称相同，则拼接账套id以示区分
            Map<String, List<SyncJobInfo>> nameMap = jobInfoList.stream().collect(Collectors.groupingBy(SyncJobInfo::getJobName));
            nameMap.forEach((k, v) -> {
                if (v.size() > 1) {
                    v.forEach(x -> {
                        if (StringUtils.isNotBlank(x.getAccountId())) {
                            x.setJobName(FormatUtil.format("{}({})", x.getJobName(), x.getAccountId()));
                        }
                    });
                }
            });
        }
        for (SyncJobInfo jobInfo : jobInfoList) {
            AppJobDTO.Job job = new AppJobDTO.Job();
            String name = jobInfo.getJobName();
            if (isToGet) {
               /* if (StringUtils.isNotEmpty(jobInfo.getJobName())) {
                    name = name;
                }*/
               /* if (StringUtils.isEmpty(jobInfo.getJobName()) &&
                        StringUtils.isNotEmpty(jobInfo.getJobCode())) {
                    name =jobInfo.getJobCode();
                }*/
                if (StringUtils.isNotEmpty(jobInfo.getVersion())) {
                    name = name + "-" + jobInfo.getVersion();
                }
            }
            job.setName(name);
            job.setCode(jobInfo.getJobCode());
            job.setAccountId(jobInfo.getAccountId());
            job.setAccountName(jobInfo.getAccountName());
            jobListDTOList.add(job);
        }
        return jobListDTOList;
    }


    /**
     * 校验数据源参数完整性
     *
     * @param labelSystemData
     * @return
     */
    public ResponseEntity<?> checkSystemData(LabelSystemData labelSystemData) {
        String error = "";
        //校验数据源名称
        if (StringUtils.isEmpty(labelSystemData.getName())) {
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, "the data source name cannot be empty");
        }
        if (StringUtils.isEmpty(labelSystemData.getName().trim())) {
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, "the data source name cannot be empty");
        }
        //校验源应用
        if (StringUtils.isEmpty(labelSystemData.getAppCode())) {
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, "the source application cannot be empty");
        }
        //校验分类
        if (null == labelSystemData.getDataCategory()) {
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, "the data source classification cannot be empty");
        }
        //校验源应用来源
        if (null == labelSystemData.getDataType()) {
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, "The source application source cannot be empty");
        }
        //数据源分类 选择自定义组件-作业集成 时 校验作业是否选择
        if (StringUtils.isEmpty(labelSystemData.getWorkCode())
                && Constants.DataCategoryEnum.CATEGORY_WORK.getVal().equals(labelSystemData.getDataCategory())
                && ApplicationTypeEnum.IAM_APPLICATION.getType().equals(labelSystemData.getDataType())) {
            error = messageUtils.getMessage("error.message.system.data.job.empty");
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, error);
        }
        //当源应用选择的是非雅典娜应用-BS 校验 接入模式必填
        /*if (null == labelSystemData.getDataModel() &&
                ApplicationTypeEnum.BS_APPLICATION.getType().equals(labelSystemData.getDataType())
        ) {
            error = messageUtils.getMessage("error.message.system.data.model.empty");
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, error);
        }*/
        //当源应用选择的是非雅典娜应用 校验 接入模式 选择混合云时，需要填写的参数： 地中台产品名称、系统UID
        if (!ApplicationTypeEnum.IAM_APPLICATION.getType().equals(labelSystemData.getDataType())
                && null != labelSystemData.getDataModel()
                && Constants.DataModelEnum.MODEL_HYBRID_CLOUD.getVal().equals(labelSystemData.getDataModel())) {
            if (StringUtils.isEmpty(labelSystemData.getMiddleSystemName())) {
                error = messageUtils.getMessage("error.message.system.data.middleSystemName.empty");
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, error);
            }
            if (StringUtils.isEmpty(labelSystemData.getMiddleSystemUid())) {
                error = messageUtils.getMessage("error.message.system.data.middleSystemUid.empty");
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, error);
            }
        }

        //当源应用选择的是非雅典娜应用、接入模式 选择云端客户时，需要填写的参数： RESTful URL
        if (!ApplicationTypeEnum.IAM_APPLICATION.getType().equals(labelSystemData.getDataType())
                && null != labelSystemData.getDataModel()
                && Constants.DataModelEnum.MODEL_CLOUD.getVal().equals(labelSystemData.getDataModel())) {
            if (StringUtils.isEmpty(labelSystemData.getRestUrl())) {
                error = messageUtils.getMessage("error.message.system.data.restUrl.empty");
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, error);
            }
        }

        //当源应用选择的是雅典娜应用、分类只能选择自定义组件-作业集成、自定义组件-应用集成
        if (ApplicationTypeEnum.IAM_APPLICATION.getType().equals(labelSystemData.getDataType())
                && !Constants.DataCategoryEnum.CATEGORY_WORK.getVal().equals(labelSystemData.getDataCategory())
                && !Constants.DataCategoryEnum.CATEGORY_APP.getVal().equals(labelSystemData.getDataCategory())
        ) {
            error = messageUtils.getMessage("error.message.system.data.dataType.fail");
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, error);
        }

        //校验cs、作业回调地址不为空的情况下校验是否是json格式
        if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(labelSystemData.getDataType())
                && StringUtils.isNotEmpty(labelSystemData.getCallBackUrl())
                && Utils.jsonParamValid(labelSystemData.getCallBackUrl())
        ) {
            error = messageUtils.getMessage("error.message.system.data.callBackUrl.fail");
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, error);
        }
        // 预设组件中，C/S应用需要校验是否是json格式
        if (ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(labelSystemData.getDataType())) {
            PreinstalledApplication preinstalledApplication = preinstalledApplicationMapper.selectById(labelSystemData.getAppCode());
            if (ObjectUtils.isNotEmpty(preinstalledApplication)
                    && Constants.APP_TYPE_CS.equals(preinstalledApplication.getSystemType())
                    && Utils.jsonParamValid(labelSystemData.getCallBackUrl())) {
                error = messageUtils.getMessage("error.message.system.data.callBackUrl.fail");
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, error);
            }
        }
        // 统计组件，校验cs应用的作业地址是否为json格式
        if (Constants.DataCategoryEnum.CATEGORY_COUNT.getVal().equals(labelSystemData.getDataCategory())
                && CollectionUtils.isNotEmpty(labelSystemData.getCountContentList())) {
            for (LabelSystemCountDataDTO labelSystemCountDataDTO : labelSystemData.getCountContentList()) {
                LabelSystemCountDataDTO.JobInfo jobInfo = labelSystemCountDataDTO.getJobInfo();
                if (ObjectUtils.isEmpty(jobInfo)) {
                    continue;
                }
                if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(jobInfo.getDataType())
                        && StringUtils.isNotEmpty(jobInfo.getCallBackUrl())
                        && Utils.jsonParamValid(jobInfo.getCallBackUrl())) {
                    error = messageUtils.getMessage("error.message.system.data.callBackUrl.fail");
                    return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, error);
                }
            }
        }
        return null;
    }

    /**
     * 条件查询数据源
     *
     * @return
     */
    public Page<LabelSystemData> selectByParam(QueryLabelSystemReq req) {
        QueryWrapper queryWrapper = new QueryWrapper<LabelSystemData>();
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        queryWrapper.orderByDesc("modify_time");
        queryWrapper.eq("tenant_id", tenantId);
        //分类查询
        if (CollectionUtils.isNotEmpty(req.getDataCategoryList())) {
            queryWrapper.in("data_category", req.getDataCategoryList());
        }
        if (CollectionUtils.isNotEmpty(req.getAppCodeList())) {
            queryWrapper.in("app_code", req.getAppCodeList());
        }
        if (null != req.getValidStatus()) {
            queryWrapper.eq("valid_status", req.getValidStatus());
        }
        if (StringUtils.isNotEmpty(req.getName())) {
            queryWrapper.like("name", req.getName());
        }
        if (CollectionUtils.isNotEmpty(req.getIds())) {
            queryWrapper.in("id", req.getIds());
        }
        Page<LabelSystemData> systemDataPage = labelSystemDataMapper.selectPage(new Page<>(req.getPageNum(), req.getPageSize()), queryWrapper);
        return systemDataPage;
    }


    @Override
    public List<SystemDataImportVo> readExcel(String fileId) {
        DMC dmcInstance = mdcService.buildDmc();
        List<SystemDataImportVo> excelVoList;
        try {
            byte[] byteArray = dmcInstance.download(fileId);
            ByteArrayInputStream input = new ByteArrayInputStream(byteArray);
            SyncReadListener excelListener = new SyncReadListener();
            // 读取sheet
            ExcelReader excelReader = EasyExcelFactory.read(input).build();
            excelReader.read(EasyExcelFactory.readSheet(0).head(SystemDataImportVo.class).headRowNumber(2).registerReadListener(excelListener).build());
            // 这里千万别忘记关闭，读的
            excelReader.finish();
            excelVoList = mdcService.doReadSync(excelListener);
        } catch (Exception e) {
            log.error("SystemDataImport read excel occur error", e);
            throw new RuntimeException(e);
        }
        return excelVoList;
    }

    @Override
    @Transactional
    public ImportExcelResp importReport(List<SystemDataImportVo> dataImportVoList) {
        ImportExcelResp excelResp = new ImportExcelResp();
        List<String> nameList = new ArrayList<>();
        //查询数据源信息
        List<LabelSystemData> systemDataList = labelSystemDataMapper.selectList(new QueryWrapper<LabelSystemData>());
        if (CollectionUtils.isNotEmpty(systemDataList)) {
            nameList = systemDataList.stream().map(LabelSystemData::getName).collect(Collectors.toList());
        }
        //IAM应用名称
        List<String> nameIamList = new ArrayList<>();
        //查询所有源应用,以name为key转map
        Map<String, List<AppLinkDTO>> nameAppMap = queryAppList(nameIamList);
        //从km查询租户下所有应用作业信息
        List<AppJobDTO> appJobListDTOList = kmService.queryAppJobList();
        //待插入的数据源
        List<LabelSystemData> systemDataListAdd = new ArrayList<>();
        //初始化数据源分类map
        Map<String, Integer> categoryMap = initCategoryMap();
        //初始化数据源状态
        Map<String, Integer> statusMap = initStatusMap();

        //移动应用作业
        CustomApplicationsListPageReq customApplicationReq = new CustomApplicationsListPageReq();
        customApplicationReq.setStatus(Constants.VALID_STATUS_ENABLE);
        List<MobileDatasourceInfo> datasourceInfoList = mobileDatasourceInfoService.queryDatasourceInfo(customApplicationReq);
        Map<String, MobileDatasourceInfo> datasourceMap = datasourceInfoList.stream().collect(Collectors.toMap(MobileDatasourceInfo::getName, y -> y, (a, b) -> a));
        int successNum = 0;
        int failNum = 0;
        for (SystemDataImportVo dataImportVo : dataImportVoList) {
            // 基础校验
            StringBuilder errorSb = validateData(dataImportVo, nameList, nameAppMap, appJobListDTOList, nameIamList, datasourceMap);
            if (StringUtils.isNotBlank(errorSb.toString())) {
                failNum++;
                dataImportVo.setFailDesc(errorSb.substring(0, errorSb.length() - 1));
                continue;
            }
            dataImportVo.setFailDesc(errorSb.toString());
            nameList.add(dataImportVo.getName());
            //组装待插入数据源
            LabelSystemData labelSystemData = initLabelSystemData(dataImportVo, categoryMap, statusMap, nameAppMap, appJobListDTOList, datasourceMap);
            systemDataListAdd.add(labelSystemData);
            successNum++;
        }
        //保存数据源数据
        if (CollectionUtils.isNotEmpty(systemDataListAdd)) {
            saveBatch(systemDataListAdd);
        }
        String nowTime = DateUtils.getNowTime(DateUtils.DATE_TIME_FORMATTER);
        // 生成失败的excel文件
        ShareInfo shareInfo = importRecordService.uploadExcel(write(dataImportVoList, nowTime));
        //初始化数据源导入记录
        initDataImport(shareInfo.getFileId(), successNum, failNum, nowTime);
        excelResp.setFailFileId(shareInfo.getFileId());
        excelResp.setFailFileName(shareInfo.getFileName());
        excelResp.setFailFileUrl(shareInfo.getUrl());
        // 构建返回信息
        String resultCode;
        if (successNum > 0 && failNum == 0) {
            resultCode = "2001";
        } else if (successNum > 0 && failNum > 0) {
            resultCode = "2002";
        } else if (successNum == 0 && failNum > 0) {
            resultCode = "2003";
        } else {
            resultCode = "2003";
        }
        excelResp.setResultCode(resultCode);
        excelResp.setFailCount(failNum);
        excelResp.setSuccessCount(successNum);
        return excelResp;
    }

    /**
     * 初始化数据源导入记录
     *
     * @param fileId
     * @param successCount
     * @param failCount
     * @return
     */
    public LabelSystemDataImport initDataImport(String fileId, Integer successCount, Integer failCount, String nowTime) {
        LabelSystemDataImport dataImport = new LabelSystemDataImport();
        dataImport.setFileId(fileId);
        dataImport.setSuccessCount(successCount);
        dataImport.setFailCount(failCount);
        dataImport.setCreateUserName(Utils.getUserName());
        dataImport.setCreateUserId(Utils.getUserId());
        dataImport.setCreateTime(DateUtils.getDateFormat(nowTime, DateUtils.DATE_TIME_FORMATTER, DateUtils.DATE_TIME_NORMAL_FORMATTER));
        dataImport.setModifyTime(DateUtils.getDateFormat(nowTime, DateUtils.DATE_TIME_FORMATTER, DateUtils.DATE_TIME_NORMAL_FORMATTER));
        dataImport.setModifyUserId(Utils.getUserId());
        dataImport.setTenantId(Utils.getTenantId());
        labelSystemDataImportMapper.insert(dataImport);
        return dataImport;
    }

    /**
     * 写入excel文件
     *
     * @param list 报表数据
     * @return
     */
    public File write(List<SystemDataImportVo> list, String nowTime) {
        File file = new File("数据源导入记录_" + nowTime + ".xlsx");
        EasyExcel.write(file, SystemDataImportVo.class)
                .relativeHeadRowIndex(1).
                registerWriteHandler(Utils.initHorizontalCell()).
                registerWriteHandler(new SystemDataWriteHandler()).
                sheet("数据源配置").doWrite(list);
        return file;
    }

    /**
     * 组装待插入的数据源数据数据
     *
     * @param dataImportVo      excel 中的数据
     * @param categoryMap       分类信息map
     * @param statusMap         状态map
     * @param nameAppMap        应用名称map
     * @param appJobListDTOList 作业信息
     * @return
     */
    public LabelSystemData initLabelSystemData(SystemDataImportVo dataImportVo, Map<String, Integer> categoryMap,
                                               Map<String, Integer> statusMap,
                                               Map<String, List<AppLinkDTO>> nameAppMap,
                                               List<AppJobDTO> appJobListDTOList,
                                               Map<String, MobileDatasourceInfo> datasourceMap) {
        LabelSystemData labelSystemData = new LabelSystemData();
        labelSystemData.setName(dataImportVo.getName());
        labelSystemData.setRemark(dataImportVo.getRemark());
        labelSystemData.setDataCategory(categoryMap.get(dataImportVo.getCategory()));
        labelSystemData.setValidStatus(statusMap.get(dataImportVo.getValidStatus()));
        //获取源应用信息
        List<AppLinkDTO> appLinkList = nameAppMap.get(dataImportVo.getAppName());
        AppLinkDTO appLinkDTO = null;
        if (CollectionUtils.isNotEmpty(appLinkList)) {
            appLinkDTO = appLinkList.get(0);
            labelSystemData.setDataType(appLinkDTO.getDataSource());
            labelSystemData.setAppCode(appLinkDTO.getPrimaryId());
        }
        //作业集成
        if (dataImportVo.getCategory().equals(Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal())) {
            //作业名称
            if (dataImportVo.getJobType().equals(Constants.JobTypeEnum.JOB_TYPE_NAME.getVal())) {
                //如果是IAM应用，需要校验作业是否存在
                if (null != appLinkDTO && appLinkDTO.getDataSource().equals(ApplicationTypeEnum.IAM_APPLICATION.getType())) {
                    //根据应用名称将应用作业转Map
                    Map<String, AppJobDTO> appJobListMap = appJobListDTOList.stream().collect(Collectors.toMap(AppJobDTO::getAppCode, Function.identity(), (a, b) -> a));
                    AppJobDTO appJobDTO = appJobListMap.get(appLinkDTO.getPrimaryId());
                    List<AppJobDTO.Job> jobList = appJobDTO.getData();
                    //将作业按code转换Map
                    Map<String, AppJobDTO.Job> appCodeJobMap = jobList.stream().collect(Collectors.toMap(AppJobDTO.Job::getCode, Function.identity(), (a, b) -> a));
                    AppJobDTO.Job job = appCodeJobMap.get(dataImportVo.getJobVal());
                    if (null == job) {
                        //将作业按名称转换Map
                        Map<String, AppJobDTO.Job> appNameJobMap = jobList.stream().collect(Collectors.toMap(AppJobDTO.Job::getName, Function.identity(), (a, b) -> a));
                        job = appNameJobMap.get(dataImportVo.getJobVal());
                    }
                    String jobCode = job == null ? "" : job.getCode();
                    labelSystemData.setWorkCode(jobCode);
                    labelSystemData.setIsJob(0);
                }
                //如果是非IAM应用，根据作业名称或者作业编码 校验作业是否存在
                if (null != appLinkDTO
                        && !appLinkDTO.getDataSource().equals(ApplicationTypeEnum.IAM_APPLICATION.getType())
                        && !appLinkDTO.getDataSource().equals(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType())
                ) {
                    List<SyncJobInfo> jobInfoList = syncJobInfoMapper.selByNameCode(appLinkDTO.getAppId(), dataImportVo.getJobVal());
                    if (CollectionUtils.isNotEmpty(jobInfoList)) {
                        labelSystemData.setWorkCode(jobInfoList.get(0).getJobCode());
                        labelSystemData.setAccountId(jobInfoList.get(0).getAccountId());
                        labelSystemData.setIsJob(0);
                    }
                }
                //如果是虚拟应用-鼎捷雅典娜APP，根据作业名称获取作业
                if (null != appLinkDTO
                        && appLinkDTO.getDataSource().equals(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType())
                        && appLinkDTO.getPrimaryId().equals(VirtualApplicationEnum.ATHENA_APP.getPrimaryId())) {
                    MobileDatasourceInfo datasourceInfo = datasourceMap.get(dataImportVo.getJobVal());
                    if (null != datasourceInfo) {
                        labelSystemData.setWorkCode(datasourceInfo.getId() + "");
                        labelSystemData.setIsJob(0);
                    }
                }
            }
            //作业回调地址
            if (dataImportVo.getJobType().equals(Constants.JobTypeEnum.JOB_TYPE_CALLBACK.getVal())) {
                labelSystemData.setIsJob(1);
                labelSystemData.setCallBackUrl(dataImportVo.getJobVal());
            }
        }
        labelSystemData.setCreateUserName(Utils.getUserName());
        labelSystemData.setModifyUserName(Utils.getUserName());
        labelSystemData.setCreateUserId(Utils.getUserId());
        labelSystemData.setCreateTime(DateUtils.getNowTime(""));
        labelSystemData.setModifyTime(DateUtils.getNowTime(""));
        labelSystemData.setModifyUserId(Utils.getUserId());
        labelSystemData.setTenantId(Utils.getTenantId());
        return labelSystemData;
    }


    /**
     * 获取租户下查询所有b/s应用、c/s应用、预设应用
     *
     * @return
     */
    public Map<String, List<AppLinkDTO>> queryAppList(List<String> nameIamList) {
        Map<String, List<AppLinkDTO>> nameAppMap = new HashMap<>();
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        //以预设表里的为准，删除重复的
        List<AppLinkDTO> appLinkList = appLinkService.queryManageList(user);
        appLinkList = filterRepeatApp(appLinkList, nameIamList);
        for (AppLinkDTO appLink : appLinkList) {
            String key = appLink.getName();
            List<AppLinkDTO> appList = new ArrayList<>();
            appList.add(appLink);
            if (!nameAppMap.containsKey(key)) {
                nameAppMap.put(key, new ArrayList<AppLinkDTO>(appList));
            } else {
                nameAppMap.get(key).addAll(appList);
            }
        }
        // 构建"鼎捷雅典娜APP"，作为数据源的源应用
        List<AppLinkDTO> appLinkDTOList = new ArrayList<>();
        AppLinkDTO athenaAppLinkDTO = Utils.initAthenaApp();
        appLinkDTOList.add(athenaAppLinkDTO);
        nameAppMap.put(athenaAppLinkDTO.getName(), appLinkDTOList);
        return nameAppMap;
    }

    /**
     * 如果预设里有的 以预设表里的为准，删除重复的
     *
     * @param appLinkListDT
     * @return
     */
    public List<AppLinkDTO> filterRepeatApp(List<AppLinkDTO> appLinkListDT, List<String> nameIamList) {
        List<AppLinkDTO> appLinkDTOList = new ArrayList<>();
        //预设表里的数据
        List<AppLinkDTO> matchedLinkList = appLinkListDT.stream().filter(x -> x.getDataSource().equals(ApplicationTypeEnum.PRESET_APPLICATION.getType())).collect(Collectors.toList());
        Map<String, AppLinkDTO> preListMap = matchedLinkList.stream().collect(Collectors.toMap(AppLinkDTO::getAppId, Function.identity(), (a, b) -> a));
        //IAM 数据
        List<AppLinkDTO> iamLinkList = appLinkListDT.stream().filter(x -> x.getDataSource().equals(ApplicationTypeEnum.IAM_APPLICATION.getType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(iamLinkList)) {
            List<String> namesIamList = iamLinkList.stream().map(AppLinkDTO::getName).collect(Collectors.toList());
            namesIamList = nameIamList;
        }
        Map<String, AppLinkDTO> iamListMap = iamLinkList.stream().collect(Collectors.toMap(AppLinkDTO::getPrimaryId, Function.identity(), (a, b) -> a));
        for (AppLinkDTO appLink : appLinkListDT) {
            //预设表数据，且预设表的appid 和 cs、bs、iam返回的应用code 一致，则需要过滤改应用
            AppLinkDTO iamData = iamListMap.get(appLink.getApplicationAppId());
            if (appLink.getDataSource().equals(ApplicationTypeEnum.PRESET_APPLICATION.getType()) && null != iamData) {
                continue;
            }
            AppLinkDTO preData = preListMap.get(appLink.getPrimaryId());
            //非预设表数据，且预设表的appid 和 cs、bs、iam返回的应用code 一致，则应用名称取预设表的名称
            if (!appLink.getDataSource().equals(ApplicationTypeEnum.PRESET_APPLICATION.getType()) && null != preData) {
                appLink.setName(preData.getName());
            }
            appLinkDTOList.add(appLink);
        }
        return appLinkDTOList;
    }

    /**
     * 校验excel数据
     *
     * @param dataImportVo      excel中的数据
     * @param nameList          数据库和excel中的数据源名称
     * @param nameAppMap        按应用名称分组的应用map
     * @param appJobListDTOList km作业
     * @param nameIamList       租户权限下IAM应用名称
     * @return
     */
    private StringBuilder validateData(SystemDataImportVo dataImportVo, List<String> nameList,
                                       Map<String, List<AppLinkDTO>> nameAppMap,
                                       List<AppJobDTO> appJobListDTOList,
                                       List<String> nameIamList,
                                       Map<String, MobileDatasourceInfo> datasourceMap) {
        StringBuilder errorSb = new StringBuilder();
        //数据源名称校验
        if (StringUtils.isEmpty(dataImportVo.getName())) {
            errorSb.append("“数据源名称”未填写").append(",");
        }
        if (StringUtils.isNotEmpty(dataImportVo.getName()) && dataImportVo.getName().length() > 500) {
            errorSb.append("“数据源名称”内容超过最大长度限制").append(",");
        }
        if (nameList.contains(dataImportVo.getName())) {
            errorSb.append("“数据源名称”重名").append(",");
        }
        AppLinkDTO appLinkDTO = null;
        //源应用校验
        if (StringUtils.isEmpty(dataImportVo.getAppName())) {
            errorSb.append("“源应用”未填写").append(",");
        }
        if (StringUtils.isNotEmpty(dataImportVo.getAppName())) {
            List<AppLinkDTO> appLinkList = nameAppMap.get(dataImportVo.getAppName());
            if (CollectionUtils.isEmpty(appLinkList)) {
                errorSb.append("“源应用”值错误").append(",");
            }
            //存在源应用名称重复
            if (CollectionUtils.isNotEmpty(appLinkList) && appLinkList.size() > 1) {
                errorSb.append("“源应用”名称重名").append(",");
            }
            //租户未授权此源应用权限
            if (CollectionUtils.isEmpty(appLinkList) && !nameIamList.contains(dataImportVo.getAppName())) {
                errorSb.append("租户未授权此源应用权限").append(",");
            }
            //获取校验成功时应用的
            if (CollectionUtils.isNotEmpty(appLinkList) && appLinkList.size() == 1) {
                appLinkDTO = appLinkList.get(0);
            }

        }
        //数据源分类
        if (StringUtils.isEmpty(dataImportVo.getCategory())) {
            errorSb.append("“数据源分类”未填写").append(",");
        }
        List<String> categoryNameList = initCategoryNameList();
        if (StringUtils.isNotEmpty(dataImportVo.getCategory()) && !categoryNameList.contains(dataImportVo.getCategory())) {
            errorSb.append("“数据源分类”值错误").append(",");
        }
        //校验鼎捷雅典娜APP必须选择作业集成
        if (StringUtils.isNotEmpty(dataImportVo.getAppName())
                && dataImportVo.getAppName().equals(VirtualApplicationEnum.ATHENA_APP.getName())
                && StringUtils.isNotEmpty(dataImportVo.getCategory())
                && !dataImportVo.getCategory().equals(Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal())) {
            errorSb.append("源应用为“鼎捷雅典娜APP”时，仅支持“作业集成”").append(",");
        }
        //状态校验
        if (StringUtils.isEmpty(dataImportVo.getValidStatus())) {
            errorSb.append("“状态”未填写").append(",");
        }
        List<String> validStatusList = initValidStatusList();
        if (StringUtils.isNotEmpty(dataImportVo.getValidStatus()) && !validStatusList.contains(dataImportVo.getValidStatus())) {
            errorSb.append("“状态”值错误").append(",");
        }

        //数据源备注校验
        if (StringUtils.isNotBlank(dataImportVo.getRemark()) && dataImportVo.getRemark().length() > 100) {
            errorSb.append("“数据源备注”内容超过最大长度限制").append(",");
        }
        //应用集成/三方待办集成校验
        if (StringUtils.isNotEmpty(dataImportVo.getCategory()) && !dataImportVo.getCategory().equals(Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal())) {
            if (StringUtils.isNotEmpty(dataImportVo.getJobType()) && StringUtils.isNotEmpty(dataImportVo.getJobVal())) {
                errorSb.append("“数据源分类”选择了“" + dataImportVo.getCategory() + "”，“作业填写方式”、“作业值”不需要填写").append(",");
            } else if (StringUtils.isNotEmpty(dataImportVo.getJobType())) {
                errorSb.append("“数据源分类”选择了“" + dataImportVo.getCategory() + "”，“作业填写方式”不需要填写").append(",");
            } else if (StringUtils.isNotEmpty(dataImportVo.getJobVal())) {
                errorSb.append("“数据源分类”选择了“" + dataImportVo.getCategory() + "”，“作业值”不需要填写").append(",");
            }
        }
        //作业集成校验
        if (StringUtils.isNotEmpty(dataImportVo.getCategory()) && dataImportVo.getCategory().equals(Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal())) {
            //作业值校验
            if (StringUtils.isEmpty(dataImportVo.getJobVal()) && StringUtils.isEmpty(dataImportVo.getJobType())) {
                errorSb.append("“数据源分类”选择了“作业集成”，“作业填写方式”、“作业值”都未填写").append(",");
                return errorSb;
            }
            if (StringUtils.isEmpty(dataImportVo.getJobType())) {
                errorSb.append("“数据源分类”选择了“作业集成”，作业填写方式未填写").append(",");
            }
            List<String> jobTypeList = initJobTypeList();
            if (StringUtils.isNotEmpty(dataImportVo.getJobType()) && !jobTypeList.contains(dataImportVo.getJobType())) {
                errorSb.append("作业填写方式值错误").append(",");
            }
            //校验鼎捷雅典娜APP必须选择作业集成，且是 作业名称集成
            if(StringUtils.isNotEmpty(dataImportVo.getAppName())
                    && dataImportVo.getAppName().equals(VirtualApplicationEnum.ATHENA_APP.getName())
                    && StringUtils.isNotEmpty(dataImportVo.getJobType())
                    && !dataImportVo.getJobType().equals(Constants.JobTypeEnum.JOB_TYPE_NAME.getVal())){
                errorSb.append("源应用为“鼎捷雅典娜APP”时，作业填写方式仅支持“作业名称”").append(",");
            }
            //作业值校验
            if (StringUtils.isEmpty(dataImportVo.getJobVal())) {
                errorSb.append("数据源分类”选择了“作业集成”，作业值未填写").append(",");
                return errorSb;
            }
            if (StringUtils.isNotEmpty(dataImportVo.getJobVal()) && dataImportVo.getJobVal().length() > 500) {
                errorSb.append("“作业值”内容超过最大长度限制").append(",");
            }

            //如果是作业填写方式=“作业名称”，作业名称，校验作业在该应用下是否存在
            if (StringUtils.isNotEmpty(dataImportVo.getJobType())
                    && StringUtils.isNotEmpty(dataImportVo.getJobVal())
                    && dataImportVo.getJobType().equals(Constants.JobTypeEnum.JOB_TYPE_NAME.getVal())) {
                //如果是IAM应用，需要校验作业是否存在
                if (null != appLinkDTO && appLinkDTO.getDataSource().equals(ApplicationTypeEnum.IAM_APPLICATION.getType())) {
                    //根据应用名称将应用作业转Map
                    Map<String, AppJobDTO> appJobListMap = appJobListDTOList.stream().collect(Collectors.toMap(AppJobDTO::getAppCode, Function.identity(), (a, b) -> a));
                    AppJobDTO appJobDTO = appJobListMap.get(appLinkDTO.getPrimaryId());
                    if (null == appJobListMap || null == appJobDTO) {
                        errorSb.append("作业值错误").append(",");
                        return errorSb;
                    }
                    List<AppJobDTO.Job> jobList = appJobDTO.getData();
                    if (CollectionUtils.isEmpty(jobList)) {
                        errorSb.append("作业值错误").append(",");
                        return errorSb;
                    }
                    //将作业按code转换Lsit
                    List<String> jobCodeList = jobList.stream().map(AppJobDTO.Job::getCode).collect(Collectors.toList());
                    //将作业按名称转换Lsit
                    List<String> jobNameList = jobList.stream().map(AppJobDTO.Job::getName).collect(Collectors.toList());
                    if (!jobNameList.contains(dataImportVo.getJobVal()) && !jobCodeList.contains(dataImportVo.getJobVal())) {
                        errorSb.append("作业值错误").append(",");
                        return errorSb;
                    }
                }
                //如果是非IAM应用，根据作业名称或者作业编码 校验作业是否存在
                if (null != appLinkDTO
                        && !appLinkDTO.getDataSource().equals(ApplicationTypeEnum.IAM_APPLICATION.getType())
                        && !appLinkDTO.getDataSource().equals(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType())) {
                    List<SyncJobInfo> jobInfoList = syncJobInfoMapper.selByNameCode(appLinkDTO.getAppId(), dataImportVo.getJobVal());
                    if (CollectionUtils.isEmpty(jobInfoList)) {
                        errorSb.append("作业值错误").append(",");
                        return errorSb;
                    }
                    if (CollectionUtils.isNotEmpty(jobInfoList) && jobInfoList.size() > 1) {
                        errorSb.append("作业值重复").append(",");
                        return errorSb;
                    }
                }
                //如果是虚拟应用-鼎捷雅典娜APP，根据作业名称 校验作业是否存在
                if (null != appLinkDTO
                        && appLinkDTO.getDataSource().equals(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType())
                        && appLinkDTO.getPrimaryId().equals(VirtualApplicationEnum.ATHENA_APP.getPrimaryId())) {
                    MobileDatasourceInfo datasourceInfo = datasourceMap.get(dataImportVo.getJobVal());
                    if (null == datasourceInfo) {
                        errorSb.append("作业值错误").append(",");
                        return errorSb;
                    }
                }
            }
        }
        return errorSb;
    }

    /**
     * 初始化分类Map,key:名称，val:枚举值
     *
     * @return
     */
    public Map<String, Integer> initCategoryMap() {
        Map<String, Integer> categoryMap = new HashMap<>();
        categoryMap.put(Constants.DataCategoryNameEnum.CATEGORY_TODO_NAME.getVal(), Constants.DataCategoryEnum.CATEGORY_TODO.getVal());
        categoryMap.put(Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal(), Constants.DataCategoryEnum.CATEGORY_WORK.getVal());
        categoryMap.put(Constants.DataCategoryNameEnum.CATEGORY_APP_NAME.getVal(), Constants.DataCategoryEnum.CATEGORY_APP.getVal());
        return categoryMap;
    }

    /**
     * 初始化状态Map,key:名称，val:枚举值
     *
     * @return
     */
    public Map<String, Integer> initStatusMap() {
        Map<String, Integer> statusMap = new HashMap<>();
        statusMap.put(Constants.ValidStatusNameEnum.VALID_STATUS_ON.getVal(), Constants.VALID_STATUS_ENABLE);
        statusMap.put(Constants.ValidStatusNameEnum.VALID_STATUS_OFF.getVal(), Constants.VALID_STATUS_UNUSABLE);
        return statusMap;
    }

    /**
     * 初始化分类Map,key:枚举值，val:名称
     *
     * @return
     */
    public Map<Integer, String> initCategoryValMap() {
        Map<Integer, String> categoryMap = new HashMap<>();
        categoryMap.put(Constants.DataCategoryEnum.CATEGORY_TODO.getVal(), Constants.DataCategoryNameEnum.CATEGORY_TODO_NAME.getVal());
        categoryMap.put(Constants.DataCategoryEnum.CATEGORY_WORK.getVal(), Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal());
        categoryMap.put(Constants.DataCategoryEnum.CATEGORY_APP.getVal(), Constants.DataCategoryNameEnum.CATEGORY_APP_NAME.getVal());
        return categoryMap;
    }

    /**
     * 初始化状态Map,key:枚举值，val:名称
     *
     * @return
     */
    public Map<Integer, String> initStatusValMap() {
        Map<Integer, String> statusMap = new HashMap<>();
        statusMap.put(Constants.DataCategoryEnum.CATEGORY_TODO.getVal(), Constants.ValidStatusNameEnum.VALID_STATUS_OFF.getVal());
        statusMap.put(Constants.DataCategoryEnum.CATEGORY_REPORT.getVal(), Constants.ValidStatusNameEnum.VALID_STATUS_ON.getVal());
        return statusMap;
    }

    /**
     * 初始化分类集合
     *
     * @return
     */
    public List<String> initCategoryNameList() {
        List<String> categoryNameList = new ArrayList<>();
        categoryNameList.add(Constants.DataCategoryNameEnum.CATEGORY_TODO_NAME.getVal());
        categoryNameList.add(Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal());
        categoryNameList.add(Constants.DataCategoryNameEnum.CATEGORY_APP_NAME.getVal());
        return categoryNameList;
    }

    /**
     * 初始化状态集合
     *
     * @return
     */
    public List<String> initValidStatusList() {
        List<String> validStatusList = new ArrayList<>();
        validStatusList.add(Constants.ValidStatusNameEnum.VALID_STATUS_ON.getVal());
        validStatusList.add(Constants.ValidStatusNameEnum.VALID_STATUS_OFF.getVal());
        return validStatusList;
    }

    /**
     * 初始化作业类型集合
     *
     * @return
     */
    public List<String> initJobTypeList() {
        List<String> jobTypeList = new ArrayList<>();
        jobTypeList.add(Constants.JobTypeEnum.JOB_TYPE_NAME.getVal());
        jobTypeList.add(Constants.JobTypeEnum.JOB_TYPE_CALLBACK.getVal());
        return jobTypeList;
    }

    @Override
    public PageInfoResp<LabelSystemDataImport> queryImportRecord(QueryImportRecordReq queryImportRecordReq) {
        QueryWrapper<LabelSystemDataImport> condition = new QueryWrapper<>();
        if (StringUtils.isBlank(queryImportRecordReq.getStartTime()) || StringUtils.isBlank(queryImportRecordReq.getEndTime())) {
            String currentDate = DateUtils.getNowTime(DateUtils.DATE_TIME_NORMAL_FORMATTER);
            condition.ge("create_time", DateUtils.addDate(currentDate, DateUtils.DATE_TIME_NORMAL_FORMATTER, -1, DateUtils.YEAR));
            condition.le("create_time", currentDate);
        } else {
            condition.ge("create_time", queryImportRecordReq.getStartTime());
            condition.le("create_time", queryImportRecordReq.getEndTime());
        }
        if (StringUtils.isNotEmpty(queryImportRecordReq.getUserIdName())) {
            condition.and(i -> i.like("create_user_name", queryImportRecordReq.getUserIdName()).or().like("create_user_id", queryImportRecordReq.getUserIdName()));
        }
        condition.orderByDesc("create_time");
        PageInfoResp<LabelSystemDataImport> pageInfoResp = new PageInfoResp<>();
        pageInfoResp.setPageNo(queryImportRecordReq.getPageNum());
        pageInfoResp.setPageSize(queryImportRecordReq.getPageSize());
        pageInfoResp.setTotalPages(0);
        pageInfoResp.setTotalRecords(0);

        Page<LabelSystemDataImport> pageResult = labelSystemDataImportMapper.selectPage(new Page<>(queryImportRecordReq.getPageNum(), queryImportRecordReq.getPageSize()), condition);
        if (pageResult != null && CollectionUtils.isNotEmpty(pageResult.getRecords())) {
            // 拼接文件预览链接
            pageResult.getRecords().forEach(m-> m.setFileUrl(envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + m.getFileId().trim()));
            pageInfoResp.setList(pageResult.getRecords());
            pageInfoResp.setTotalPages(Integer.parseInt(String.valueOf(pageResult.getPages())));
            pageInfoResp.setTotalRecords(Integer.parseInt(String.valueOf(pageResult.getTotal())));
        }
        else {
            pageInfoResp.setList(Lists.newArrayList());
        }
        return pageInfoResp;
    }

    @Override
    public List<SystemDataExportVo> exportReport() {
        List<SystemDataExportVo> excelVoList = Lists.newArrayList();
        //查询导出的数据源数据
        List<LabelSystemData> systemDataList = getExportData();
        if (CollectionUtils.isEmpty(systemDataList)) {
            return excelVoList;
        }
        //初始化分类map
        Map<Integer, String> categoryMap = initCategoryValMap();
        //初始化状态map
        Map<Integer, String> statusMap = initStatusValMap();
        //根据源应用来源（ 0：CS、1：BS、2：平台预设、3：雅典娜应用）拆分数据
        LabelSystemDataAppVo systemDataAppVo = getSsoAppMap(systemDataList);
        //CS应用
        Map<Long, ErpSsoInfo> erpInfoMap = systemDataAppVo.getErpInfoMap();
        //BS应用
        Map<Long, ThirdSsoInfo> thirdSsoInfoMap = systemDataAppVo.getThirdSsoInfoMap();
        //预设应用
        //  Map<Long, PreinstalledApplication> preInfoMap = systemDataAppVo.getPreInfoMap();
        //雅典娜应用
        Map<String, TenantAppDTO> athenaInfoMap = systemDataAppVo.getAthenaInfoMap();

        //从km查询租户下所有应用作业信息
        List<AppJobDTO> appJobListDTOList = kmService.queryAppJobList();
        //查询租户下预设应用信息
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        List<PreinstalledApplication> preInstalledAppList = preinstalledApplicationService.queryPreinstalledAppList(user);
        Map<Long, PreinstalledApplication> preinstalledApplicationMap = preInstalledAppList.stream().collect(Collectors.toMap(PreinstalledApplication::getId, Function.identity(), (a, b) -> a));

        //判断是否有鼎捷雅典娜APP作业
        List<LabelSystemData> systemDataAppList = systemDataList.stream()
                .filter(x -> VirtualApplicationEnum.ATHENA_APP.getPrimaryId().equals(x.getAppCode()))
                .filter(x -> x.getDataType().equals(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType()))
                .collect(Collectors.toList());
        Map<Long, MobileDatasourceInfo> datasourceMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(systemDataAppList)) {
            //移动应用作业
            CustomApplicationsListPageReq customApplicationReq = new CustomApplicationsListPageReq();
            customApplicationReq.setStatus(Constants.VALID_STATUS_ENABLE);
            List<MobileDatasourceInfo> datasourceInfoList = mobileDatasourceInfoService.queryDatasourceInfo(customApplicationReq);
            datasourceMap = datasourceInfoList.stream().collect(Collectors.toMap(MobileDatasourceInfo::getId, y -> y, (a, b) -> a));
        }
        for (LabelSystemData systemData : systemDataList) {
            SystemDataExportVo dataExportVo = new SystemDataExportVo();
            dataExportVo.setName(systemData.getName());
            dataExportVo.setRemark(systemData.getRemark());
            dataExportVo.setCategory(categoryMap.get(systemData.getDataCategory()));
            dataExportVo.setValidStatus(statusMap.get(systemData.getValidStatus()));
            //获取应用名称
            String appName = addAppIDName(erpInfoMap, thirdSsoInfoMap, athenaInfoMap, systemData, false, preinstalledApplicationMap);
            dataExportVo.setAppName(appName);
            String jobType = "";
            String jobVal = "";
            //作业集成
            if (Constants.DataCategoryEnum.CATEGORY_WORK.getVal().equals(systemData.getDataCategory())) {
                //作业回调地址不为空，则说明是按作业回到地址方式导入,是否需要自定义作业（0：不需要；1：需要）
                if (null != systemData.getIsJob() && systemData.getIsJob().intValue() == 1) {
                    jobType = Constants.JobTypeEnum.JOB_TYPE_CALLBACK.getVal();
                    jobVal = systemData.getCallBackUrl();
                } else {
                    jobType = Constants.JobTypeEnum.JOB_TYPE_NAME.getVal();
                    //如果是作业，查询作业名称
                    if (StringUtils.isNotEmpty(systemData.getWorkCode())) {
                        jobVal = getWorkName(systemData, appJobListDTOList, datasourceMap);
                    }
                }
            }
            dataExportVo.setJobType(jobType);
            dataExportVo.setJobVal(jobVal);
            excelVoList.add(dataExportVo);
        }
        return excelVoList;
    }

    /**
     * 根据AppId获取作业名称
     *
     * @param appId
     * @return
     */
    public Map<String, String> getWorkCodeMap(String appId) {
        Map<String, String> appWorkMap = new HashMap<>();
        if (StringUtils.isEmpty(appId)) {
            return appWorkMap;
        }
        //从作业同步数据获取作业名称
        List<SyncJobInfo> syncJobInfoList = syncJobInfoMapper.selectList(getJobCondition(appId, ""));
        if (CollectionUtils.isNotEmpty(syncJobInfoList)) {
            for (SyncJobInfo syncJobInfo : syncJobInfoList) {
                String key = syncJobInfo.getAppId() + "-" + syncJobInfo.getJobCode();
                appWorkMap.put(key, syncJobInfo.getJobName());
            }
        }
        return appWorkMap;
    }

    /**
     * 查询导出的数据源数据
     *
     * @return
     */
    public List<LabelSystemData> getExportData() {
        QueryWrapper<LabelSystemData> condition = new QueryWrapper<>();
        List<Integer> categoryList = new ArrayList<>();
        categoryList.add(Constants.DataCategoryEnum.CATEGORY_TODO.getVal());
        categoryList.add(Constants.DataCategoryEnum.CATEGORY_WORK.getVal());
        categoryList.add(Constants.DataCategoryEnum.CATEGORY_APP.getVal());
        condition.in("data_category", categoryList);
        condition.orderByDesc("modify_time");
        return labelSystemDataMapper.selectList(condition);
    }


    @Override
    public List<SystemDataJobExportVo> exportJobList() {
        List<SystemDataJobExportVo> dataJobExportVoList = new ArrayList<>();
        //查询租户下SSO应用
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        //如果预设里有的 以预设表里的为准，删除重复的
        List<AppLinkDTO> appLinkListDTO = appLinkService.queryManageList(user);
        //IAM应用名称
        List<String> nameIamList = new ArrayList<>();
        appLinkListDTO = filterRepeatApp(appLinkListDTO, nameIamList);
        if (CollectionUtils.isEmpty(appLinkListDTO)) {
            return dataJobExportVoList;
        }
        //IAM应用编码
        Map<String, AppLinkDTO> codeIamMap = new HashMap<>();
        //IAM 数据
        List<AppLinkDTO> iamLinkList = appLinkListDTO.stream().filter(x -> x.getDataSource().equals(ApplicationTypeEnum.IAM_APPLICATION.getType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(iamLinkList)) {
            codeIamMap = iamLinkList.stream().collect(Collectors.toMap(AppLinkDTO::getCode, Function.identity(), (a, b) -> a));
        }
        List<String> ssoAppIdList = appLinkListDTO.stream().map(AppLinkDTO::getApplicationAppId).collect(Collectors.toList());
        List<SyncJobInfo> syncJobInfoList = syncJobInfoMapper.selByAppId(ssoAppIdList);
        Map<String, AppLinkDTO> appInfoMap = appLinkListDTO.stream().collect(Collectors.toMap(AppLinkDTO::getApplicationAppId, Function.identity(), (a, b) -> a));

        //从km查询租户下所有应用作业信息
        List<AppJobDTO> appJobListDTOList = kmService.queryAppJobList();
        //组装已集成的KM作业
        for (AppJobDTO appJobListDTO : appJobListDTOList) {
            //如果该应用没有权限，跳过
            AppLinkDTO appLinkDTO = codeIamMap.get(appJobListDTO.getAppCode());
            if (null == appLinkDTO) {
                continue;
            }
            List<AppJobDTO.Job> jobList = appJobListDTO.getData();
            for (AppJobDTO.Job job : jobList) {
                SystemDataJobExportVo jobExportVo = new SystemDataJobExportVo();
                jobExportVo.setAppName(appLinkDTO.getName());
                jobExportVo.setJobName(job.getName());
                jobExportVo.setJobId(job.getCode());
                dataJobExportVoList.add(jobExportVo);
            }
        }
        //组装已集成作业
        for (SyncJobInfo syncJobInfo : syncJobInfoList) {
            AppLinkDTO appLinkDTO = appInfoMap.get(syncJobInfo.getAppId());
            if (null == appLinkDTO) {
                continue;
            }
            SystemDataJobExportVo jobExportVo = new SystemDataJobExportVo();
            jobExportVo.setAppName(appLinkDTO.getName());
            jobExportVo.setJobName(syncJobInfo.getJobName());
            jobExportVo.setJobId(syncJobInfo.getJobCode());
            dataJobExportVoList.add(jobExportVo);
        }
        Comparator comparator = Collator.getInstance(Locale.CHINA);
        Collections.sort(dataJobExportVoList, (o1, o2) -> comparator.compare(o1.getAppName(), o2.getAppName()));
        return dataJobExportVoList;
    }

    @Override
    public List<LabelSystemData> getDataByWork(Integer dataType, String appCode,List<String> workCodeList) {
        return labelSystemDataMapper.getDataByWork(dataType,appCode,workCodeList);
    }

    /**
     * 根据组件id查询数据源信息
     *
     * @param componentSource 组件来源  0：自定义组件 1：预设组件
     * @param systemId 组件id
     * @param tenantId 租户id
     * @return 返回
     */
    @Override
    public List<LabelSystemData> querySystemDataBySystemId(Integer componentSource, List<Long> systemId, String tenantId){
        return labelSystemDataMapper.querySystemDataBySystemId(componentSource, systemId, tenantId);
    }

}
