package com.digiwin.athena.semc.service.portal.impl;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.*;
import com.digiwin.athena.semc.common.enums.ComponentSourceEnum;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.*;
import com.digiwin.athena.semc.entity.bench.JobBenchCustom;
import com.digiwin.athena.semc.entity.menu.CustomizedMenuTemplate;
import com.digiwin.athena.semc.entity.portal.*;
import com.digiwin.athena.semc.mapper.bench.JobBenchCustomMapper;
import com.digiwin.athena.semc.mapper.menu.CustomizedMenuTemplateMapper;
import com.digiwin.athena.semc.mapper.portal.*;
import com.digiwin.athena.semc.proxy.km.service.KmService;
import com.digiwin.athena.semc.proxy.trans.service.TranslateService;
import com.digiwin.athena.semc.service.cache.RedisLock;
import com.digiwin.athena.semc.service.portal.LabelSystemPreService;
import com.digiwin.athena.semc.service.portal.RelatedAppServiceWrapper;
import com.digiwin.athena.semc.service.workbench.constant.WorkBenchConstant;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.InterceptorIgnoreUtil;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.common.AuthSystemLabelReq;
import com.digiwin.athena.semc.vo.common.BizObjAuthRelBatchSystemVo;
import com.digiwin.athena.semc.vo.portal.LabelSystemAllVo;
import com.digiwin.athena.semc.vo.portal.LabelSystemPreCustomVo;
import com.digiwin.athena.semc.vo.portal.LabelSystemPreQueryVO;
import com.digiwin.athena.semc.vo.portal.ValidLabelRelVO;
import com.google.gson.Gson;
import io.github.linpeilie.Converter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;


@Slf4j
@Service
public class LabelSystemPreServiceImpl extends ServiceImpl<LabelSystemPreMapper, LabelSystemPre> implements LabelSystemPreService {

    @Autowired
    private RelatedAppServiceWrapper relatedAppServiceWrapper;

    @Autowired
    MessageUtils messageUtils;
    @Autowired
    LabelSystemPreMapper labelSystemPreMapper;
    @Autowired
    LabelSystemSourceMapper labelSystemSourceMapper;
    @Autowired
    LabelSystemDataMapper labelSystemDataMapper;
    @Autowired
    LabelSystemCustomMapper labelSystemCustomMapper;
    @Autowired
    PortalLayoutCustomMapper portalLayoutCustomMapper;
    @Autowired
    TransactionTemplate transactionTemplate;

    @Autowired
    JobBenchCustomMapper jobBenchCustomMapper;
    @Autowired
    PortalInfoContentMapper portalInfoContentMapper;

    @Autowired
    CustomizedMenuTemplateMapper customizedMenuTemplateMapper;

    @Resource
    private TranslateService translateService;

    @Resource
    private Converter converter;

    @Resource
    private PortalInfoMapper portalInfoMapper;

    @Autowired
    private KmService kmService;

    @Override
    public ResultPageBean pageQuery(LabelSystemPreQueryReq labelSystemPreQueryReq) {
        ResultPageBean resultPageBean;
        if(Objects.isNull(labelSystemPreQueryReq.getClientType())){
            labelSystemPreQueryReq.setClientType(0);
        }
        if (0 == labelSystemPreQueryReq.getClientType()) {
            try {
                this.initPreData(0);
                LambdaQueryWrapper<LabelSystemPre> queryPreWrapper = new LambdaQueryWrapper<>();
                queryPreWrapper.eq(LabelSystemPre::getTenantId, AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                // 预设组件名支持多语言
                String locale = LocaleContextHolder.getLocale().toString();
                if (Constants.ZH_TW_LOCALE.equals(locale)) {
                    queryPreWrapper.like(!StringUtils.isEmpty(labelSystemPreQueryReq.getQueryCondition().getName()), LabelSystemPre::getNameTw,
                            labelSystemPreQueryReq.getQueryCondition().getName());
                } else {
                    queryPreWrapper.like(!StringUtils.isEmpty(labelSystemPreQueryReq.getQueryCondition().getName()), LabelSystemPre::getName,
                            labelSystemPreQueryReq.getQueryCondition().getName());
                }
                queryPreWrapper.eq(!Objects.isNull(labelSystemPreQueryReq.getQueryCondition().getValidStatus()), LabelSystemPre::getValidStatus,
                        labelSystemPreQueryReq.getQueryCondition().getValidStatus());
                queryPreWrapper.in(!CollectionUtils.isEmpty(labelSystemPreQueryReq.getQueryCondition().getDataCategory()), LabelSystemPre::getDataCategory,
                        labelSystemPreQueryReq.getQueryCondition().getDataCategory());
                queryPreWrapper.eq(LabelSystemPre::getClientType, labelSystemPreQueryReq.getClientType());
                List<LabelSystemPreQueryVO> labelSystemPreQueryEmptyList = new LinkedList<>();
                // 查找预设组件信息
                List<LabelSystemPre> labelSystemPreList = labelSystemPreMapper.selectList(queryPreWrapper);
                if (!StringUtils.isEmpty(labelSystemPreQueryReq.getQueryCondition().getName())
                        && CollectionUtils.isEmpty(labelSystemPreList)) {
                    return ResultPageBean.success(ResponseBody.getInstance(labelSystemPreQueryEmptyList, PageInfo.getPageInfo(
                            labelSystemPreQueryReq.getPageNum(), labelSystemPreQueryReq.getPageSize(), labelSystemPreQueryEmptyList.size())));
                }
                if (!Objects.isNull(labelSystemPreQueryReq.getQueryCondition().getValidStatus())
                        && CollectionUtils.isEmpty(labelSystemPreList)) {
                    return ResultPageBean.success(ResponseBody.getInstance(labelSystemPreQueryEmptyList, PageInfo.getPageInfo(
                            labelSystemPreQueryReq.getPageNum(), labelSystemPreQueryReq.getPageSize(), labelSystemPreQueryEmptyList.size())));
                }
                if (!CollectionUtils.isEmpty(labelSystemPreQueryReq.getQueryCondition().getDataCategory())
                        && CollectionUtils.isEmpty(labelSystemPreList)) {
                    return ResultPageBean.success(ResponseBody.getInstance(labelSystemPreQueryEmptyList, PageInfo.getPageInfo(
                            labelSystemPreQueryReq.getPageNum(), labelSystemPreQueryReq.getPageSize(), labelSystemPreQueryEmptyList.size())));
                }
                if (CollectionUtils.isEmpty(labelSystemPreList)) {
                    List<LabelSystemPreQueryVO> labelSystemPreQueryVOList = labelSystemPreList.stream()
                            .map(item -> {
                                LabelSystemPreQueryVO labelSystemPreQueryVO = converter.convert(item, LabelSystemPreQueryVO.class);
                                labelSystemPreQueryVO.setComponentSource(1);
                                //需要卡死状态 且 不允许修改数据源的组件 更新信息返回空
                                if (Constants.IsUseDataNum.USE_DATA_TRUE.getVal().equals(item.getIsUseData())
                                        && Constants.IsEnableTrueNum.ENABLE_TRUE.getVal().equals(item.getIsEnableTrue())) {
                                    labelSystemPreQueryVO.setModifyUserId("");
                                    labelSystemPreQueryVO.setModifyTime("");
                                }
                                // this.assembleStatusData(labelSystemPreQueryVO, labelSystemPreList);

                                return labelSystemPreQueryVO;
                            }).collect(Collectors.toList());

                    resultPageBean = ResultPageBean.success(ResponseBody.getInstance(labelSystemPreQueryVOList, PageInfo.getPageInfo(
                            labelSystemPreQueryReq.getPageNum(), labelSystemPreQueryReq.getPageSize(), labelSystemPreQueryVOList.size())));
                } else {

                    Gson gson = new Gson();
                    // 查询数据源信息
                    List<JSONObject> labelSystemSourceList = labelSystemSourceMapper.listByCondition(
                            AppAuthContextHolder.getContext().getAuthoredUser().getTenantId(), 1,
                            labelSystemPreList.stream().map(LabelSystemPre::getId).collect(Collectors.toList()));

                    List<LabelSystemPreQueryVO.DataSourceInfo> dataSourceInfoList = new LinkedList<>();
                    labelSystemSourceList.forEach(item -> {
                        LabelSystemPreQueryVO.DataSourceInfo dataSourceInfo = gson.fromJson(JSON.toJSONString(item), LabelSystemPreQueryVO.DataSourceInfo.class);
                        dataSourceInfoList.add(dataSourceInfo);
                    });

                    Map<Long, List<LabelSystemPreQueryVO.DataSourceInfo>> map
                            = dataSourceInfoList.stream().collect(Collectors.groupingBy(LabelSystemPreQueryVO.DataSourceInfo::getSystemId));

                    List<LabelSystemPreQueryVO> labelSystemPreQueryVOList = labelSystemPreList.stream()
                            .map(item -> {
                                LabelSystemPreQueryVO labelSystemPreQueryVO = converter.convert(item, LabelSystemPreQueryVO.class);
                                List<LabelSystemPreQueryVO.DataSourceInfo> dataList = map.get(item.getId());
                                // 预设组件名支持多语言
                                if (Constants.ZH_TW_LOCALE.equals(locale) && StringUtils.isNotEmpty(item.getNameTw())) {
                                    labelSystemPreQueryVO.setName(item.getNameTw());
                                }
                                //固定组件的修改人 返回空
                                if (Constants.DataCategoryEnum.CATEGORY_CURRENCY.getVal().equals(item.getDataCategory())) {
                                    labelSystemPreQueryVO.setModifyUserId("");
                                    labelSystemPreQueryVO.setModifyTime("");
                                }
                                labelSystemPreQueryVO.setComponentSource(1);
                                labelSystemPreQueryVO.setDataSourceInfo(dataList);
                                return labelSystemPreQueryVO;
                            }).collect(Collectors.toList());

                    //如果是极简门户，需要过滤三方待办和轮播图组件
                    if (Constants.IS_LAYOUT.equals(labelSystemPreQueryReq.getIsLayout())) {
                        labelSystemPreQueryVOList = filterPortalLayout(labelSystemPreQueryVOList);
                    }
                    List<LabelSystemPreQueryVO> labelSystemPreQuerySortVO = labelSystemPreQueryVOList.stream()
                            .sorted(Comparator.comparing(LabelSystemPreQueryVO::getModifyTime).reversed()).collect(Collectors.toList());

                    resultPageBean = ResultPageBean.success(ResponseBody.getInstance(labelSystemPreQuerySortVO.stream()
                            .skip((labelSystemPreQueryReq.getPageNum() - 1) * labelSystemPreQueryReq.getPageSize().longValue())
                            .limit(labelSystemPreQueryReq.getPageSize()).collect(Collectors.toList()), PageInfo.getPageInfo(
                            labelSystemPreQueryReq.getPageNum(), labelSystemPreQueryReq.getPageSize(), labelSystemPreQuerySortVO.size())));
                }

            } catch (BizException bizException) {
                return ResultPageBean.bizException(BizException.getDefaultBizException(ErrorCodeConstant.LABEL_SYSTEM_PRE,
                        messageUtils.getMessage(I18NKey.SYSTEM_PRE)));
            } catch (Exception e) {
                log.error("Query System Pre Error", e);
                resultPageBean = ResultPageBean.sysException(new ServiceException(ErrorCodeConstant.LABEL_SYSTEM_PRE,
                        messageUtils.getMessage(I18NKey.SYSTEM_PRE)));
            }
        } else {
            List<LabelSystemPre> labelSystemPreList = initMobileLabelSystemPre();
            if (CollectionUtils.isNotEmpty(labelSystemPreQueryReq.getQueryCondition().getDataCategory())) {
                labelSystemPreList = labelSystemPreList.stream().filter(x -> labelSystemPreQueryReq.getQueryCondition().getDataCategory().contains(x.getDataCategory())).collect(Collectors.toList());
            }
            if (null != labelSystemPreQueryReq.getQueryCondition().getValidStatus()) {
                labelSystemPreList = labelSystemPreList.stream().filter(x -> labelSystemPreQueryReq.getQueryCondition().getValidStatus().equals(x.getValidStatus())).collect(Collectors.toList());
            }
            for (LabelSystemPre labelSystemPre : labelSystemPreList) {
                String name = translateService.translateTextCache(labelSystemPre.getName(), StringUtils.EMPTY);
                labelSystemPre.setName(name);
                labelSystemPre.setModifyUserId("");
                labelSystemPre.setModifyUserName("");
            }
            if (StringUtils.isNotEmpty(labelSystemPreQueryReq.getQueryCondition().getName())) {
                labelSystemPreList = labelSystemPreList.stream().filter(x -> x.getName().contains(labelSystemPreQueryReq.getQueryCondition().getName())).collect(Collectors.toList());
            }
            List<LabelSystemPreQueryVO> labelSystemPreQueryVOS = labelSystemPreList.stream()
                    .map(item -> {
                        LabelSystemPreQueryVO labelSystemPreQueryVO = converter.convert(item, LabelSystemPreQueryVO.class);
                        return labelSystemPreQueryVO;
                    }).collect(Collectors.toList());
            resultPageBean = ResultPageBean.success(ResponseBody.getInstance(labelSystemPreQueryVOS.stream()
                    .skip((labelSystemPreQueryReq.getPageNum() - 1) * labelSystemPreQueryReq.getPageSize().longValue())
                    .limit(labelSystemPreQueryReq.getPageSize()).collect(Collectors.toList()), PageInfo.getPageInfo(
                    labelSystemPreQueryReq.getPageNum(), labelSystemPreQueryReq.getPageSize(), labelSystemPreList.size())));
        }

        return resultPageBean;
    }

    @Override
    public List<LabelSystemPre> initMobileLabelSystemPre() {
        //查询租户的数据
        LambdaQueryWrapper<LabelSystemPre> labelSystemPreLambdaQueryWrapper = new LambdaQueryWrapper<>();
        labelSystemPreLambdaQueryWrapper.eq(LabelSystemPre::getTenantId, Utils.getTenantId()).eq(LabelSystemPre::getClientType, 1);
        List<LabelSystemPre> labelSystemPreList = labelSystemPreMapper.selectList(labelSystemPreLambdaQueryWrapper);
        //查询全局预设组件信息
        List<LabelSystemPre> overSystemPreList = InterceptorIgnoreUtil.handler(() -> labelSystemPreMapper.selectList(new LambdaQueryWrapper<LabelSystemPre>().eq(LabelSystemPre::getClientType, 1)));
        //待插入的预设组件
        List<LabelSystemPre> insertPreList = new ArrayList<>();
        //该租户下没有预设组件，初始化全局的组件给该租户
        if (CollectionUtils.isEmpty(labelSystemPreList)) {
            insertPreList.addAll(overSystemPreList);
        } else {
            //比较数据库预设和租户下的预设组件，将新增的初始化
            //将租户下预设组件的数据转map
            Map<Integer, LabelSystemPre> preListMap = labelSystemPreList.stream()
                    .collect(Collectors.toMap(LabelSystemPre::getDataCategory, Function.identity(), (a, b) -> a));

            for (LabelSystemPre overSystemPre : overSystemPreList) {
                //如果租户的组件中没有该全局的组件，则需要插入
                if (null == preListMap.get(overSystemPre.getDataCategory())) {
                    insertPreList.add(overSystemPre);
                }
            }
        }
        //初始化租户的预设组件数据
        if (CollectionUtils.isNotEmpty(insertPreList)) {
            labelSystemPreList = batchSavePreData(insertPreList, Utils.getTenantId());
        }
        //查询租户的数据
        labelSystemPreList = labelSystemPreMapper.selectList(labelSystemPreLambdaQueryWrapper);
        return labelSystemPreList;

    }


    /**
     * 过滤门户中已经添加的预设组件和三方待办 和轮播图组件
     *
     * @param labelSystemPreQueryVOList
     * @return
     */
    private List<LabelSystemPreQueryVO> filterPortalLayout(List<LabelSystemPreQueryVO> labelSystemPreQueryVOList) {
        LambdaQueryWrapper<PortalLayoutCustom> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(PortalLayoutCustom::getLabelType, 1);
        queryWrapper.eq(PortalLayoutCustom::getTenantId, AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        queryWrapper.eq(PortalLayoutCustom::getDelFlag, Constants.DEFAULT_CONFIGURED_FLAG_NO);
        List<PortalLayoutCustom> portalLayoutCustomList = portalLayoutCustomMapper.selectList(queryWrapper);

        portalLayoutCustomList.forEach(data -> {
            labelSystemPreQueryVOList.removeIf(e -> e.getId().equals(data.getLabelId()));
        });
        //过滤三方待办和轮播图组件
        List<LabelSystemPreQueryVO> labelSystemPreVOList = labelSystemPreQueryVOList.stream()
                .filter(e -> !e.getDataType().equals(Constants.DataTypeEnum.TYPE_THIRD_TODO.getVal()) && !e.getDataType().equals(Constants.DataTypeEnum.TYPE_CAROUSEL.getVal())).collect(Collectors.toList());
        return labelSystemPreVOList;
    }


    @Override
    @Transactional
    public ResponseEntity<?> updateDataSource(LabelSystemDataSourceUpdateReq labelSystemUpdateReq) {
        Map<Long, List<LabelSystemDataSourceUpdateReq.DataSourceInfo>> dataSourceMap = labelSystemUpdateReq.getDataSourceInfo().stream()
                .collect(Collectors.groupingBy(LabelSystemDataSourceUpdateReq.DataSourceInfo::getSystemId));

        // 判断组件的组件分类值与数据源分类值是否相同
        for (LabelSystemDataSourceUpdateReq.DataSourceInfo item : labelSystemUpdateReq.getDataSourceInfo()) {
            //数据源为空
            if (null == item.getDataId()) {
                continue;
            }
            LambdaQueryWrapper<LabelSystemData> queryWrapperData = new LambdaQueryWrapper<>();
            queryWrapperData.eq(LabelSystemData::getTenantId, AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            queryWrapperData.eq(LabelSystemData::getId, item.getDataId());
            LabelSystemData labelSystemData = labelSystemDataMapper.selectOne(queryWrapperData);
            if (1 == item.getComponentSource()) {
                LambdaQueryWrapper<LabelSystemPre> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(LabelSystemPre::getTenantId, AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                queryWrapper.eq(LabelSystemPre::getId, item.getSystemId());
                LabelSystemPre labelSystemPre = labelSystemPreMapper.selectOne(queryWrapper);
                if (!labelSystemData.getDataCategory().equals(labelSystemPre.getDataCategory())) {
                    String error = messageUtils.getMessage("error.message.system.pre.dara.fail");
                    return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.UPDATE_SYSTEM_DATA_SOURCE, error);
                }
            } else {
                LambdaQueryWrapper<LabelSystemCustom> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(LabelSystemCustom::getTenantId, AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                queryWrapper.eq(LabelSystemCustom::getId, item.getSystemId());
                LabelSystemCustom labelSystemCustom = labelSystemCustomMapper.selectOne(queryWrapper);
                if (!labelSystemData.getDataCategory().equals(labelSystemCustom.getDataCategory())) {
                    String error = messageUtils.getMessage("error.message.system.pre.dara.fail");
                    return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.UPDATE_SYSTEM_DATA_SOURCE, error);
                }
            }
        }
        try {
            //更新预设组件和自定义组件的更新人
            if (CollectionUtils.isNotEmpty(labelSystemUpdateReq.getDataSourceInfo())) {
                initUserName(labelSystemUpdateReq.getDataSourceInfo().get(0));
            }
            dataSourceMap.forEach((key, value) -> {
                LambdaUpdateWrapper<LabelSystemSource> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(LabelSystemSource::getTenantId, AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                updateWrapper.in(LabelSystemSource::getSystemId,
                        value.stream().map(LabelSystemDataSourceUpdateReq.DataSourceInfo::getSystemId)
                                .collect(Collectors.toList()));

                transactionTemplate.executeWithoutResult(new Consumer<TransactionStatus>() {
                    @Override
                    public void accept(TransactionStatus transactionStatus) {

                        labelSystemSourceMapper.delete(updateWrapper);
                        // 预设组件 ,自定义组件  重新建立关联关系
                        List<LabelSystemSource> labelSystemSourceList = new ArrayList<>();
                        for (LabelSystemDataSourceUpdateReq.DataSourceInfo dataSourceInfo : value) {
                            LabelSystemSource labelSystemSource = converter.convert(dataSourceInfo, LabelSystemSource.class);
                            ;
                            labelSystemSource.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                            labelSystemSource.setCreateTime(DateUtils.getNowTime(""));
                            labelSystemSource.setCreateUserId(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
                            if (null != dataSourceInfo.getDataId()) {
                                labelSystemSourceList.add(labelSystemSource);
                            }
                        }
                        if (CollectionUtils.isNotEmpty(labelSystemSourceList)) {
                            labelSystemSourceMapper.insertBatch(labelSystemSourceList);
                        }
                    }
                });
            });

        } catch (Exception e) {
            log.error("update dataSource error", e);
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.UPDATE_SYSTEM_DATA_SOURCE, messageUtils.getMessage(I18NKey.DATASOURCE));
        }

        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 更新预设组件和自定义组件的更新人
     *
     * @param dataSourceInfo
     */
    public void initUserName(LabelSystemDataSourceUpdateReq.DataSourceInfo dataSourceInfo) {
        String userName = AppAuthContextHolder.getContext().getAuthoredUser().getUserName();
        //自定义组件
        if (dataSourceInfo.getComponentSource().equals(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal())) {
            LabelSystemCustom labelSystemCustom = new LabelSystemCustom();
            labelSystemCustom.setId(dataSourceInfo.getSystemId());
            labelSystemCustom.setModifyUserName(userName);
            labelSystemCustomMapper.updateById(labelSystemCustom);
        }
        //预设组件
        if (dataSourceInfo.getComponentSource().equals(Constants.LabelTypeEnum.SYSTEM_PRE.getVal())) {
            LabelSystemPre labelSystemPre = new LabelSystemPre();
            labelSystemPre.setId(dataSourceInfo.getSystemId());
            labelSystemPre.setModifyUserName(userName);
            labelSystemPreMapper.updateById(labelSystemPre);
        }
    }

    /**
     * 校验自定义组件是否关联门户、菜单、作业工作台
     *
     * @param labelSystemUpdateValidReq 请求入参
     * @return 返回
     */
    @Override
    public ValidLabelRelVO validLabelRel(LabelSystemUpdateValidReq labelSystemUpdateValidReq) {
        ValidLabelRelVO validLabelRelVO = new ValidLabelRelVO();
        // 状态改为启用或者预设组件不校验，即停用自定义组件需要校验
        if (Constants.VALID_STATUS_ENABLE.equals(labelSystemUpdateValidReq.getValidStatus())
                || Constants.LabelTypeEnum.SYSTEM_PRE.getVal().equals(labelSystemUpdateValidReq.getComponentSource())) {
            return validLabelRelVO;
        }

        // 校验是否关联极简门户
        PortalLayoutCustom portalLayoutCustom = queryRelSimplePortal(labelSystemUpdateValidReq.getId(), labelSystemUpdateValidReq.getComponentSource());
        if (!ObjectUtils.isEmpty(portalLayoutCustom)) {
            validLabelRelVO.setSuccessFlag(Boolean.FALSE);
            validLabelRelVO.setSimpleRelFlag(Boolean.TRUE);
        }
        // 查询关联的经典门户
        List<PortalInfoContent> contentList = queryRelClassicalPortal(labelSystemUpdateValidReq.getId(), labelSystemUpdateValidReq.getComponentSource());
        if (CollectionUtils.isNotEmpty(contentList)) {
            validLabelRelVO.setSuccessFlag(Boolean.FALSE);
            List<String> portalNameList = contentList.stream().map(PortalInfoContent::getName).distinct().collect(Collectors.toList());
            validLabelRelVO.setClassicalNameList(portalNameList);
        }

        // 查询关联的自定义菜单模板
        List<CustomizedMenuTemplate> templateList = queryRelCustomMenu(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal(), labelSystemUpdateValidReq.getId());
        if (CollectionUtils.isNotEmpty(templateList)) {
            validLabelRelVO.setSuccessFlag(Boolean.FALSE);
            List<String> templateNameList = templateList.stream().map(CustomizedMenuTemplate::getTemplateName).collect(Collectors.toList());
            validLabelRelVO.setMenuNameList(templateNameList);
        }

        // 查询关联的作业工作台
        List<JobBenchCustom> jobBenchCustomList = queryRelJobBench(labelSystemUpdateValidReq.getId());
        if (CollectionUtils.isNotEmpty(jobBenchCustomList)) {
            validLabelRelVO.setSuccessFlag(Boolean.FALSE);
            List<String> jobBenchNameList = jobBenchCustomList.stream().map(JobBenchCustom::getNameZh).distinct().collect(Collectors.toList());
            validLabelRelVO.setJobBenchNameList(jobBenchNameList);
        }
        if (Objects.equals(1,labelSystemUpdateValidReq.getClientType())){
            List<Long> systemIdList = new ArrayList<>();
            systemIdList.add(labelSystemUpdateValidReq.getId());
            List<PortalInfoContent> portalInfoContentList = portalInfoContentMapper.selPortalConent(Utils.getTenantId(), systemIdList, Constants.PrtalMobileContentTypeEnum.H5_LINK.getVal(), null);
            if (CollectionUtils.isNotEmpty(portalInfoContentList)){
                validLabelRelVO.setSuccessFlag(Boolean.FALSE);
                List<String> portalNameList = portalInfoContentList.stream().map(PortalInfoContent::getName).distinct().collect(Collectors.toList());
                validLabelRelVO.setClassicalNameList(portalNameList);
            }
        }
        return validLabelRelVO;
    }

    @Override
    public ResponseEntity<?> updateValidStatus(Long id, Integer validStatus, Integer componentSource,Integer clientType) {
        try {
            // 更新自定义组件状态才校验，预设组件无需校验
            if (componentSource.equals(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal())) {
                // 查询自定义组件信息
                LabelSystemCustom labelSystemCustom = labelSystemCustomMapper.selectById(id);
                if (ObjectUtils.isEmpty(labelSystemCustom)) {
                    String error = String.format(messageUtils.getMessage("error.message.system.custom.not.exist"));
                    return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, error);
                }
                // 停用
                if (Constants.VALID_STATUS_UNUSABLE.equals(validStatus)) {
                    // 校验是否关联极简门户
                    PortalLayoutCustom portalLayoutCustom = queryRelSimplePortal(id, componentSource);
                    if (!ObjectUtils.isEmpty(portalLayoutCustom)) {
                        String error = messageUtils.getMessage("error.message.system.portal.layout.exist");
                        return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, error);
                    }
                    // 校验是否关联经典门户
                    List<PortalInfoContent> contentList = queryRelClassicalPortal(id, componentSource);
                    if (CollectionUtils.isNotEmpty(contentList)) {
                        String error = messageUtils.getMessage("error.message.jd.portal.layout.stop.error");
                        return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, error);
                    }
                    // 校验是否关联自定义菜单
                    List<CustomizedMenuTemplate> templateList = queryRelCustomMenu(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal(), id);
                    if (CollectionUtils.isNotEmpty(templateList)) {
                        String error = messageUtils.getMessage("error.message.jd.menu.stop.error");
                        return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, error);
                    }
                    // 校验是否关联作业工作台
                    List<JobBenchCustom> jobBenchCustomList = queryRelJobBench(id);
                    if (CollectionUtils.isNotEmpty(jobBenchCustomList)) {
                        String error = messageUtils.getMessage("error.message.job.system.data.stop.error");
                        return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
                    }

                    if (Objects.equals(1,clientType)){
                        List<Long> systemIdList = new ArrayList<>();
                        systemIdList.add(id);
                        List<PortalInfoContent> portalInfoContentList = portalInfoContentMapper.selPortalConent(Utils.getTenantId(), systemIdList,Constants.PrtalMobileContentTypeEnum.H5_LINK.getVal(), null);
                        if (CollectionUtils.isNotEmpty(portalInfoContentList)){
                            String error = messageUtils.getMessage("error.message.jd.portal.layout.stop.error");
                            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
                        }
                    }
                }

                // 启用的时候判断是否关联数据源，内嵌网页类型的组件不关联数据源，无需校验  移動端也走不進來
                if (Constants.VALID_STATUS_ENABLE.equals(validStatus) && !Constants.DataCategoryEnum.WEB_PAGE.getVal().equals(labelSystemCustom.getDataCategory()) && !Objects.equals(11,labelSystemCustom.getDataCategory())) {
                    List<JSONObject> jsonObjectList = labelSystemSourceMapper.listBySystemId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId(), id, componentSource);
                    if (CollectionUtils.isEmpty(jsonObjectList)) {
                        String error = messageUtils.getMessage("error.message.system.pre.incomplete.fail");
                        return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, error);
                    }
                }
            }
            // 预设组件
            if (ComponentSourceEnum.LABEL_SYSTEM_PRE.getCode().equals(componentSource)) {
                LabelSystemPre labelSystemPre = labelSystemPreMapper.selectById(id);
                labelSystemPre.setValidStatus(validStatus);
                labelSystemPre.setModifyUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
                labelSystemPreMapper.updateById(labelSystemPre);
            } else {    // 自定义组件
                LabelSystemCustom labelSystemCustom = labelSystemCustomMapper.selectById(id);
                if (Objects.equals(labelSystemCustom.getTenantId(),WorkBenchConstant.SYSTEM_TENANT)){
                    String error = messageUtils.getMessage("error.message.system.lable.custom.not.modify");
                    return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, error);
                }
                labelSystemCustom.setValidStatus(validStatus);
                labelSystemCustom.setModifyUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
                labelSystemCustomMapper.updateById(labelSystemCustom);
            }
        } catch (Exception e) {
            log.error("update validStatus error", e);
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, messageUtils.getMessage(I18NKey.VALID_STATUS));
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 根据组件id查询所属的菜单模板
     *
     * @param LabelType 组件类型 0：自定义组件、1：预设组件
     * @param id        组件id
     * @return 返回
     */
    private List<CustomizedMenuTemplate> queryRelCustomMenu(Integer LabelType, Long id) {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        return customizedMenuTemplateMapper.queryTempListByLabelId(LabelType, Collections.singletonList(id), tenantId);
    }

    /**
     * 查询关联的作业工作台
     *
     * @param id 组件id
     * @return 返回
     */
    private List<JobBenchCustom> queryRelJobBench(Long id) {
        List<Long> idList = new ArrayList<>();
        idList.add(id);
        return jobBenchCustomMapper.selectBySystem(idList);
    }

    /**
     * 查询关联的经典门户
     *
     * @param id              组件id
     * @param componentSource 组件类型 0：自定义组件、1：预设组件
     * @return 返回
     */
    private List<PortalInfoContent> queryRelClassicalPortal(Long id, Integer componentSource) {
        List<Long> systemIdList = new ArrayList<>();
        systemIdList.add(id);
        List<PortalInfoContent> contentList = portalInfoContentMapper.selPortalConent(Utils.getTenantId(), systemIdList, componentSource, null);
        if (CollectionUtils.isEmpty(contentList)) {
            contentList = new ArrayList<>();
        }
        //自定义组件需要校验门户中轮播图
        if (!Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal().equals(componentSource)) {
            return contentList;
        }
        //查询是否有门户中轮播图引用
        List<PortalInfoContent> contentAttrList = portalInfoContentMapper.selPortalConent(Utils.getTenantId(), new ArrayList<>(), null, Constants.DataTypeEnum.TYPE_CAROUSEL.getVal());
        if (CollectionUtils.isEmpty(contentAttrList)) {
            return contentList;
        }
        List<PortalInfoContent> contentCarList = filterWebCarousel(contentAttrList, id);
        if (CollectionUtils.isNotEmpty(contentCarList)) {
            contentList.addAll(contentCarList);
        }
        return contentList;
    }

    /**
     * 查询是否关联极简门户
     *
     * @param id              组件id
     * @param componentSource 组件类型 0：自定义组件、1：预设组件
     * @return 返回
     */
    private PortalLayoutCustom queryRelSimplePortal(Long id, Integer componentSource) {
        LambdaQueryWrapper<PortalLayoutCustom> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(PortalLayoutCustom::getLabelId, id);
        queryWrapper.eq(PortalLayoutCustom::getLabelType, componentSource);
        queryWrapper.eq(PortalLayoutCustom::getTenantId, AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        queryWrapper.eq(PortalLayoutCustom::getDelFlag, Constants.DEFAULT_CONFIGURED_FLAG_NO);
        return portalLayoutCustomMapper.selectOne(queryWrapper);
    }

    /**
     * 过滤轮播图组件是否引用自定义组件
     *
     * @param contentAttrList 门户中轮播图内容
     * @param systemId        自定义组件
     * @return
     */
    public List<PortalInfoContent> filterWebCarousel(List<PortalInfoContent> contentAttrList, Long systemId) {
        List<PortalInfoContent> contentAttrPortList = new ArrayList<>();
        for (PortalInfoContent contentAttr : contentAttrList) {
            //轮播图属性为空
            if (StringUtils.isEmpty(contentAttr.getContentAttr())) {
                continue;
            }
            //轮播图为空
            PortalContentCarousel carouselInfo = JSON.parseObject(contentAttr.getContentAttr(), PortalContentCarousel.class);
            if (null == carouselInfo) {
                continue;
            }
            if (CollectionUtils.isEmpty(carouselInfo.getImageList())) {
                continue;
            }
            Boolean isLink = false;
            //轮播图的图片集合
            for (PortalContentCarouselImage image : carouselInfo.getImageList()) {
                //跳转的类型为空，跳转目标为空
                if (null == image.getJumpType() || StringUtils.isEmpty(image.getJumpValue())) {
                    continue;
                }
                //跳转的目标不是应用、作业、业务待办组件
                if (Constants.WebLinkTypeEnum.APP.getVal().equals(image.getJumpType()) ||
                        Constants.WebLinkTypeEnum.JOB.getVal().equals(image.getJumpType()) ||
                        Constants.WebLinkTypeEnum.BUSINESS_TODO.getVal().equals(image.getJumpType())) {
                    //跳转的目标 是应用、作业、业务待办组件ID
                    if (image.getJumpValue().equals(systemId + "")) {
                        isLink = true;
                        break;
                    }
                }

            }
            if (isLink) {
                contentAttrPortList.add(contentAttr);
            }
        }
        return contentAttrPortList;
    }

    @Override
    @Transactional
    public List<LabelSystemPre> initPreData(Integer clientType) {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        //查询租户的数据
        List<LabelSystemPre> labelSystemPreList = getInitData(tenantId, clientType);
        RedisLock redisLock = new RedisLock(RedisConstant.LABEL_SYSTEM_PRE_LOCK + tenantId);
        //查询全局预设组件信息
        List<LabelSystemPre> overSystemPreList = getInitData("", clientType);
        //待插入的预设组件
        List<LabelSystemPre> insertPreList = new ArrayList<>();
        //该租户下没有预设组件，初始化全局的组件给该租户
        if (CollectionUtils.isEmpty(labelSystemPreList)) {
            insertPreList = overSystemPreList;
        } else {
            //比较数据库预设和租户下的预设组件，将新增的初始化
            //将租户下预设组件的数据转map
            Map<Integer, LabelSystemPre> preListMap = MapUtil.newHashMap();
            if (Constants.ClientTypeEnum.PC.getValue().equals(clientType)) {
                preListMap = labelSystemPreList.stream().collect(Collectors.toMap(LabelSystemPre::getDataType, Function.identity(), (a, b) -> a));
            } else if (Constants.ClientTypeEnum.MOBILE.getValue().equals(clientType)) {
                preListMap = labelSystemPreList.stream().collect(Collectors.toMap(LabelSystemPre::getDataCategory, Function.identity(), (a, b) -> a));
            }

            for (LabelSystemPre overSystemPre : overSystemPreList) {
                //如果租户的组件中没有该全局的组件，则需要插入
                if (Constants.ClientTypeEnum.PC.getValue().equals(clientType) && null == preListMap.get(overSystemPre.getDataType())) {
                    insertPreList.add(overSystemPre);
                } else if (Constants.ClientTypeEnum.MOBILE.getValue().equals(clientType) && null == preListMap.get(overSystemPre.getDataCategory())) {
                    insertPreList.add(overSystemPre);
                }
            }
        }
        //分布式锁
        try {
            //如果没有需要新增或者枷锁失败，则退出
            if (CollectionUtils.isEmpty(insertPreList) || !redisLock.lock()) {
                return getInitData(tenantId, clientType);
            }
        } catch (InterruptedException e) {
            return labelSystemPreList;
        }

        try {
            //初始化租户的预设组件数据
            labelSystemPreList = batchSavePreData(insertPreList, tenantId);
            //查询租户的数据
            labelSystemPreList = getInitData(tenantId, clientType);
            return labelSystemPreList;
        } catch (Exception e) {
            log.error("LabelSystemPre initPreData error", e);
        } finally {
            redisLock.unlock();
        }
        return labelSystemPreList;
    }

    @Override
    public LabelSystemPre getPreSystemID(Integer dataType) {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        LambdaQueryWrapper<LabelSystemPre> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(LabelSystemPre::getTenantId, tenantId);
        queryWrapper.eq(LabelSystemPre::getDataType, dataType);
        queryWrapper.eq(LabelSystemPre::getClientType, Constants.ClientTypeEnum.PC.getValue());
        List<LabelSystemPre> labelSystemPreList = labelSystemPreMapper.selectList(queryWrapper);
        if (CollectionUtils.isNotEmpty(labelSystemPreList)) {
            return labelSystemPreList.get(0);
        }
        return null;
    }

    @Override
    public LabelSystemPreCustomVo queryAllSystem(LabelSystemAllVo req) {
        LabelSystemPreCustomVo preCustomVo = queryAllSystemLabel(req);
        // 预设组件过滤掉三方待办
        if (CollectionUtils.isNotEmpty(preCustomVo.getPresetList())) {
            List<LabelSystemAllVo> presetList = preCustomVo.getPresetList().stream()
                    .filter(e -> !Constants.DataTypeEnum.TYPE_THIRD_TODO.getVal().equals(e.getDataType())).collect(Collectors.toList());
            preCustomVo.setPresetList(presetList);
        }
        return preCustomVo;
    }

    /**
     * 初始化默认布局涉及的组件
     *
     * @param clientType 门户端 PC端：0，移动端：1
     * @return 返回
     */
    @Override
    public List<LabelSystemPre> initDefPortal(List<Integer> dataCategoryList, Integer clientType) {
        //先初始化预设组件
        List<LabelSystemPre> preList = initPreData(clientType);
        if (CollectionUtils.isNotEmpty(dataCategoryList)) {
            preList = preList.stream().filter(item -> dataCategoryList.contains(item.getDataType())).collect(Collectors.toList());
        }
        return preList;
    }

    /**
     * 初始化租户预设组件
     *
     * @param labelSystemPreList
     * @param tenantId
     * @return
     */
    public List<LabelSystemPre> batchSavePreData(List<LabelSystemPre> labelSystemPreList, String tenantId) {
        List<LabelSystemPre> systemPreTenantList = new ArrayList<>();
        for (LabelSystemPre labelSystemPre : labelSystemPreList) {
            labelSystemPre.setTenantId(tenantId);
            labelSystemPre.setId(null);
            labelSystemPre.setCreateTime(DateUtils.getNowTime(""));
            labelSystemPre.setModifyTime(DateUtils.getNowTime(""));
            labelSystemPreMapper.insert(labelSystemPre);
            labelSystemPre.setId(labelSystemPre.getId());
            systemPreTenantList.add(labelSystemPre);
        }
        return systemPreTenantList;
    }

    /**
     * 查询租户为空的数据
     *
     * @return
     */
    public List<LabelSystemPre> getInitData(String tenantId, Integer clientType) {
        QueryWrapper queryWrapper = new QueryWrapper<LabelSystemPre>();
        if (ObjectUtil.isNotEmpty(clientType)) {
            queryWrapper.eq("client_type", clientType);
        }
        if (StringUtils.isNotEmpty(tenantId)) {
            queryWrapper.eq("tenant_id", tenantId);
        } else {
            queryWrapper.isNull("tenant_id");
        }
        List<LabelSystemPre> labelSystemPreList = labelSystemPreMapper.selectList(queryWrapper);
        return labelSystemPreList;
    }

    @Override
    @Transactional
    public Integer editToDoData(LabelSystemPre req) {
        //单个租户场景--主要用于预区
        if (StringUtils.isNotEmpty(req.getTenantId())) {
            //查询该租户下的预设组件数据
            List<LabelSystemPre> preSystemList = getInitData(req.getTenantId(), Constants.ClientTypeEnum.PC.getValue());
            //待办
            List<LabelSystemPre> toDoList = preSystemList.stream().filter(e -> e.getDataType().equals(Constants.DataTypeEnum.TYPE_TODO.getVal())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(toDoList)) {
                return null;
            }
            //更新待办的属性
            LabelSystemPre systemPreTenant = toDoList.get(0);
            systemPreTenant.setName("待办");
            systemPreTenant.setValidStatus(Constants.VALID_STATUS_ENABLE);
            systemPreTenant.setDataCategory(Constants.DataCategoryEnum.CATEGORY_CURRENCY.getVal());
            systemPreTenant.setIsEnableTrue(Constants.IsEnableTrueNum.ENABLE_TRUE.getVal());
            systemPreTenant.setIsUseData(Constants.IsUseDataNum.USE_DATA_FALSE.getVal());
            labelSystemPreMapper.updateById(systemPreTenant);
            //三方待办
            List<LabelSystemPre> thirdToDoList = preSystemList.stream().filter(e -> e.getDataType().equals(Constants.DataTypeEnum.TYPE_THIRD_TODO.getVal())).collect(Collectors.toList());
            //三方待办ID
            Long thirdToDoID = null;
            if (CollectionUtils.isNotEmpty(thirdToDoList)) {
                thirdToDoID = thirdToDoList.get(0).getId();
            }
            if (CollectionUtils.isEmpty(thirdToDoList)) {
                //插入三方待办
                LabelSystemPre systemThridToDo = new LabelSystemPre();
                systemThridToDo.setName("三方待办");
                systemThridToDo.setDataCategory(Constants.DataCategoryEnum.CATEGORY_TODO.getVal());
                systemThridToDo.setDataType(Constants.DataTypeEnum.TYPE_THIRD_TODO.getVal());
                systemThridToDo.setIsEnableTrue(Constants.IsEnableTrueNum.ENABLE_FALSE.getVal());
                systemThridToDo.setIsUseData(Constants.IsUseDataNum.USE_DATA_TRUE.getVal());
                systemThridToDo.setTenantId(req.getTenantId());
                systemThridToDo.setValidStatus(toDoList.get(0).getValidStatus());
                systemThridToDo.setCreateTime(systemPreTenant.getCreateTime());
                systemThridToDo.setCreateUserId(systemPreTenant.getCreateUserId());
                systemThridToDo.setCreateUserName(systemPreTenant.getCreateUserName());
                systemThridToDo.setModifyTime(systemPreTenant.getModifyTime());
                systemThridToDo.setModifyUserName(systemPreTenant.getModifyUserName());
                systemThridToDo.setModifyUserId(systemPreTenant.getModifyUserId());
                labelSystemPreMapper.insert(systemThridToDo);
                thirdToDoID = systemThridToDo.getId();
            }
            //删除三方待办的数据源关联关系
            labelSystemSourceMapper.delBySystemId(thirdToDoID, ComponentSourceEnum.LABEL_SYSTEM_PRE.getCode());
            //查询待办关联的数据源
            List<LabelSystemSource> systemSourceList = labelSystemSourceMapper.queryByCountDataId(systemPreTenant.getId(), ComponentSourceEnum.LABEL_SYSTEM_PRE.getCode());
            if (CollectionUtils.isEmpty(systemSourceList)) {
                return null;
            }
            //插入三方待办对应的数据源关联关系
            for (LabelSystemSource systemSource : systemSourceList) {
                systemSource.setSystemId(thirdToDoID);
                systemSource.setId(null);
                labelSystemSourceMapper.insert(systemSource);
            }
            return null;
        }
        //全部租户场景--主要用于正式区
        //查询预设组件中一共有多少租户id
        List<String> tenantIdList = labelSystemPreMapper.queryPreSystemTenant();
        for (String tenantId : tenantIdList) {
            //查询该租户下的预设组件数据
            List<LabelSystemPre> preSystemList = getInitData(tenantId, Constants.ClientTypeEnum.PC.getValue());
            //待办
            List<LabelSystemPre> toDoList = preSystemList.stream().filter(e -> e.getDataType().equals(Constants.DataTypeEnum.TYPE_TODO.getVal())).collect(Collectors.toList());
            //三方待办
            List<LabelSystemPre> thirdToDoList = preSystemList.stream().filter(e -> e.getDataType().equals(Constants.DataTypeEnum.TYPE_THIRD_TODO.getVal())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(toDoList)) {
                continue;
            }
            //待办ID
            Long toDoID = toDoList.get(0).getId();
            //更新待办的属性
            LabelSystemPre systemPreTenant = toDoList.get(0);
            systemPreTenant.setName("待办");
            systemPreTenant.setValidStatus(Constants.VALID_STATUS_ENABLE);
            systemPreTenant.setDataCategory(Constants.DataCategoryEnum.CATEGORY_CURRENCY.getVal());
            systemPreTenant.setIsEnableTrue(Constants.IsEnableTrueNum.ENABLE_TRUE.getVal());
            systemPreTenant.setIsUseData(Constants.IsUseDataNum.USE_DATA_FALSE.getVal());
            labelSystemPreMapper.updateById(systemPreTenant);
            //三方待办ID
            Long thirdToDoID = null;
            if (CollectionUtils.isNotEmpty(thirdToDoList)) {
                thirdToDoID = thirdToDoList.get(0).getId();
            }
            if (CollectionUtils.isEmpty(thirdToDoList)) {
                //不带租户的三方待办数据
                LabelSystemPre thirdToDoPre = labelSystemPreMapper.getInitByDataType(Constants.DataTypeEnum.TYPE_THIRD_TODO.getVal());
                if (null == thirdToDoPre) {
                    LabelSystemPre systemPreNoTen = new LabelSystemPre();
                    systemPreNoTen.setTenantId(null);
                    systemPreNoTen.setName("三方待办");
                    systemPreNoTen.setDataCategory(Constants.DataCategoryEnum.CATEGORY_TODO.getVal());
                    systemPreNoTen.setDataType(Constants.DataTypeEnum.TYPE_THIRD_TODO.getVal());
                    systemPreNoTen.setValidStatus(Constants.VALID_STATUS_UNUSABLE);
                    systemPreNoTen.setIsEnableTrue(Constants.IsEnableTrueNum.ENABLE_FALSE.getVal());
                    systemPreNoTen.setIsUseData(Constants.IsUseDataNum.USE_DATA_TRUE.getVal());
                    labelSystemPreMapper.insert(systemPreNoTen);
                    thirdToDoPre = systemPreNoTen;
                }
                //初始化租户的三方待办
                thirdToDoPre.setTenantId(tenantId);
                thirdToDoPre.setId(null);
                thirdToDoPre.setValidStatus(toDoList.get(0).getValidStatus());
                thirdToDoPre.setCreateTime(toDoList.get(0).getCreateTime());
                thirdToDoPre.setCreateUserId(toDoList.get(0).getCreateUserId());
                thirdToDoPre.setCreateUserName(toDoList.get(0).getCreateUserName());
                thirdToDoPre.setModifyTime(toDoList.get(0).getModifyTime());
                thirdToDoPre.setModifyUserName(toDoList.get(0).getModifyUserName());
                thirdToDoPre.setModifyUserId(toDoList.get(0).getModifyUserId());
                labelSystemPreMapper.insert(thirdToDoPre);
                thirdToDoID = thirdToDoPre.getId();
            }
            if (null == toDoID || null == thirdToDoID) {
                continue;
            }
            //删除三方待办的数据源关联关系
            labelSystemSourceMapper.delBySystemId(thirdToDoID, ComponentSourceEnum.LABEL_SYSTEM_PRE.getCode());
            //查询待办关联的数据源
            List<LabelSystemSource> systemSourceList = labelSystemSourceMapper.queryByCountDataId(systemPreTenant.getId(), ComponentSourceEnum.LABEL_SYSTEM_PRE.getCode());
            if (CollectionUtils.isEmpty(systemSourceList)) {
                continue;
            }
            //插入三方待办对应的数据源关联关系
            for (LabelSystemSource systemSource : systemSourceList) {
                systemSource.setSystemId(thirdToDoID);
                systemSource.setId(null);
                labelSystemSourceMapper.insert(systemSource);
            }
            //删除原待办的数据源关联关系
            labelSystemSourceMapper.delBySystemId(toDoID, ComponentSourceEnum.LABEL_SYSTEM_PRE.getCode());
        }
        //修改不带租户的待办
        List<LabelSystemPre> preSystemList = getInitData("", Constants.ClientTypeEnum.PC.getValue());
        //待办
        List<LabelSystemPre> toDoListAll = preSystemList.stream().filter(e -> e.getDataType().equals(Constants.DataTypeEnum.TYPE_TODO.getVal())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(toDoListAll)) {
            return null;
        }
        //更新待办的属性
        LabelSystemPre systemPreAll = toDoListAll.get(0);
        systemPreAll.setName("待办");
        systemPreAll.setValidStatus(Constants.VALID_STATUS_ENABLE);
        systemPreAll.setDataCategory(Constants.DataCategoryEnum.CATEGORY_CURRENCY.getVal());
        systemPreAll.setIsEnableTrue(Constants.IsEnableTrueNum.ENABLE_TRUE.getVal());
        systemPreAll.setIsUseData(Constants.IsUseDataNum.USE_DATA_FALSE.getVal());
        labelSystemPreMapper.updateById(systemPreAll);
        return null;
    }

    @Override
    public Page<BizObjAuthRelBatchSystemVo> pageListPre(List<Long> idList, AuthSystemLabelReq req) {
        LambdaQueryWrapper<LabelSystemPre> queryPreWrapper = new LambdaQueryWrapper<>();
        String locale = LocaleContextHolder.getLocale().toString();
        if (Constants.ZH_TW_LOCALE.equals(locale)) {
            queryPreWrapper.like(StringUtils.isNotEmpty(req.getName()), LabelSystemPre::getNameTw, req.getName());
        } else {
            queryPreWrapper.like(StringUtils.isNotEmpty(req.getName()), LabelSystemPre::getName, req.getName());
        }
        queryPreWrapper.in(CollectionUtils.isNotEmpty(idList), LabelSystemPre::getId, idList);
        //根据名称正序排序
        queryPreWrapper.last("ORDER BY cast(name as char character set gbk ) ASC,id desc");
        Page<LabelSystemPre> systemPrePage = labelSystemPreMapper.selectPage(new Page<>(req.getPageNum(), req.getPageSize()), queryPreWrapper);
        List<BizObjAuthRelBatchSystemVo> relBatchSystemVoList = new ArrayList<>();
        Page<BizObjAuthRelBatchSystemVo> relBatchSystemVoPage = new Page<>();
        for (LabelSystemPre systemPre : systemPrePage.getRecords()) {
            BizObjAuthRelBatchSystemVo systemVo = new BizObjAuthRelBatchSystemVo();
            systemVo.setLabelId(systemPre.getId());
            if (Constants.ZH_TW_LOCALE.equals(locale) && StringUtils.isNotEmpty(systemPre.getNameTw())) {
                systemVo.setLabelName(systemPre.getNameTw());
            }
            systemVo.setLabelName(systemPre.getName());
            systemVo.setLabelType(Constants.LabelTypeEnum.SYSTEM_PRE.getVal());
            relBatchSystemVoList.add(systemVo);
        }
        relBatchSystemVoPage.setRecords(relBatchSystemVoList);
        relBatchSystemVoPage.setTotal(systemPrePage.getTotal());
        return relBatchSystemVoPage;
    }

    /**
     * 根据名称或分类查询预设组件和自定义组件列表
     *
     * @param req 请求入参
     * @return 返回
     */
    @Override
    public LabelSystemPreCustomVo queryAllSystemLabel(LabelSystemAllVo req) {
        String tenantVersion = kmService.queryTenantVersion();
        LabelSystemPreCustomVo preCustomVo = new LabelSystemPreCustomVo();
        // 自定义组件列表
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        Set<String> tenantIds = new HashSet<>(Arrays.asList(tenantId, WorkBenchConstant.SYSTEM_TENANT));
        tenantIds.remove(WorkBenchConstant.SYSTEM_TENANT);
        //查询租户自定义
        List<LabelSystemAllVo> customList = labelSystemPreMapper.queryCustomSystem(tenantIds, req.getName(), req.getDataCategoryList(),req.getClientType());
        for (LabelSystemAllVo labelSystemAllVo : customList){
            labelSystemAllVo.setLabelTypeSource(0);
        }
        preCustomVo.setCustomList(customList);
        List<LabelSystemAllVo> isvcustomList = new ArrayList<>();
        //查询isv自定义
        Set<Long> ids = getLableSysTemCustomIds(tenantVersion,req.getClientType());
        //租户自定义部件
        if (CollectionUtils.isNotEmpty(ids)) {
            List<LabelSystemCustom> labelSystemCustoms = labelSystemCustomMapper.selectBatchIds(ids);
            if (CollectionUtils.isNotEmpty(labelSystemCustoms)) {
                for (LabelSystemCustom labelSystemCustom : labelSystemCustoms) {
                    LabelSystemAllVo labelSystemAllVo = new LabelSystemAllVo();
                    labelSystemAllVo.setId(labelSystemCustom.getComponentDesignerId());
                    labelSystemAllVo.setName(labelSystemCustom.getNameZh());
                    labelSystemAllVo.setDataCategory(labelSystemCustom.getDataCategory());
                    labelSystemAllVo.setDataType(null);
                    labelSystemAllVo.setClientType(labelSystemCustom.getClientType());
                    labelSystemAllVo.setClassicsIcon(labelSystemCustom.getClassicsIcon());
                    labelSystemAllVo.setIcon(labelSystemCustom.getIcon());
                    labelSystemAllVo.setContentType(0);
                    labelSystemAllVo.setContentConfig(labelSystemCustom.getContentConfig());
                    labelSystemAllVo.setModifyTime(labelSystemCustom.getModifyTime());
                    labelSystemAllVo.setLabelTypeSource(1);
                    isvcustomList.add(labelSystemAllVo);
                }
            }
        }
        preCustomVo.setIsvList(isvcustomList);
        List<LabelSystemAllVo> allCustomList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(preCustomVo.getCustomList())){
            allCustomList.addAll(preCustomVo.getCustomList());
        }
        if (CollectionUtils.isNotEmpty(preCustomVo.getIsvList())){
            allCustomList.addAll(isvcustomList);
        }
        preCustomVo.setAllCustomList(allCustomList);
        // 预设组件列表
        List<LabelSystemAllVo> preLabelList;
        String locale = LocaleContextHolder.getLocale().toString();
        if (Constants.ZH_TW_LOCALE.equals(locale)) {
            preLabelList = labelSystemPreMapper.queryPreSystem(tenantId, null, req.getName(), req.getPreDateTypeList(),req.getClientType());
            preLabelList.forEach(item -> {
                if (StringUtils.isNotEmpty(item.getNameTw())) {
                    item.setName(item.getNameTw());
                }
            });
        } else {
            preLabelList = labelSystemPreMapper.queryPreSystem(tenantId, req.getName(), null, req.getPreDateTypeList(),req.getClientType());
        }
        preCustomVo.setPresetList(preLabelList);
        return preCustomVo;
    }

    private Set<Long> getLableSysTemCustomIds(String tenantVersion,Integer clientType) {
        List<Long> isddds = relatedAppServiceWrapper.queryCurrTenantPortalList(tenantVersion);
        if (CollectionUtils.isEmpty(isddds)){
            return Collections.emptySet();
        }
        LambdaQueryWrapper<PortalInfo> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(PortalInfo::getVersion,tenantVersion).in(CollectionUtils.isNotEmpty(isddds),PortalInfo::getPortalDesignerId,isddds);
        queryWrapper.eq(PortalInfo::getClientType,clientType);
        List<PortalInfo> portalInfoList = InterceptorIgnoreUtil.handler(() -> portalInfoMapper.selectList(queryWrapper));
        List<Long> portalIds = new ArrayList<>();
        for (PortalInfo portalInfo : portalInfoList){
            Long id = portalInfo.getId();
            portalIds.add(id);
        }
        if (CollectionUtils.isEmpty(portalIds)){
            return Collections.emptySet();
        }
        LambdaQueryWrapper<PortalInfoContent> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        if (Objects.equals(0,clientType)){
            lambdaQueryWrapper.in(PortalInfoContent::getContentType,0);
        }else{
            lambdaQueryWrapper.in(PortalInfoContent::getContentType,11);
        }
        lambdaQueryWrapper.in(PortalInfoContent::getLabelTypeSource,1).in(CollectionUtils.isNotEmpty(portalIds),PortalInfoContent::getPortalId,portalIds);
        List<PortalInfoContent> portalInfoContents = InterceptorIgnoreUtil.handler(() -> portalInfoContentMapper.selectList(lambdaQueryWrapper));
        List<Long> contentIds = new ArrayList<>();
        for (PortalInfoContent portalInfoContent : portalInfoContents){
            Long contentId = portalInfoContent.getContentId();
            contentIds.add(contentId);
        }
        if (CollectionUtils.isEmpty(contentIds)){
            return Collections.emptySet();
        }
        LambdaQueryWrapper<LabelSystemCustom> labelSystemCustomLambdaQueryWrapper = new LambdaQueryWrapper<>();
        labelSystemCustomLambdaQueryWrapper.in(CollectionUtils.isNotEmpty(contentIds),LabelSystemCustom::getComponentDesignerId,contentIds).eq(LabelSystemCustom::getVersion,tenantVersion);
        List<LabelSystemCustom> labelSystemCustoms = labelSystemCustomMapper.selectList(labelSystemCustomLambdaQueryWrapper);
        Set<Long> collect = labelSystemCustoms.stream().map(e -> e.getId()).collect(Collectors.toSet());
        return collect;
    }
}