package com.digiwin.athena.semc.service.portal.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.dto.portal.SaveSystemReq;
import com.digiwin.athena.semc.entity.portal.LabelSystem;
import com.digiwin.athena.semc.mapper.portal.LabelSystemMapper;
import com.digiwin.athena.semc.service.portal.ILabelSystemService;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

@Service
public class LabelSystemServiceImpl extends ServiceImpl<LabelSystemMapper, LabelSystem> implements ILabelSystemService {

    @Autowired
    LabelSystemMapper labelSystemMapper;

    /**
     * 保存组件应用系统列表
     *
     * @param saveSystemReq 请求实体
     * @return
     */
    @Override
    @Transactional
    public Long saveLabelSystem(SaveSystemReq saveSystemReq) {
        List<SaveSystemReq.SystemReq> delSystemList = saveSystemReq.getDelSystemList();
        if (CollectionUtils.isNotEmpty(delSystemList)) {
            List<Long> idList = delSystemList.stream().map(SaveSystemReq.SystemReq::getId).collect(Collectors.toList());
            labelSystemMapper.deleteBatchIds(idList);
        }
        List<SaveSystemReq.SystemReq> addSystemList = saveSystemReq.getAddSystemList();
        if (CollectionUtils.isNotEmpty(addSystemList)) {
            List<LabelSystem> systemList = Lists.newArrayList();
            addSystemList.forEach(x -> {
                LabelSystem labelSystem = new LabelSystem();
                labelSystem.setLabelId(saveSystemReq.getLabelId());
                labelSystem.setTabFlag(saveSystemReq.getTabFlag());
                labelSystem.setTabName(Constants.SystemTabEnum.parseNameByCode(saveSystemReq.getTabFlag()));
                labelSystem.setMiddleSystemName(x.getMiddleSystemName());
                labelSystem.setMiddleSystemUid(x.getMiddleSystemUid());
                labelSystem.setSystemName(x.getSystemName());
                systemList.add(labelSystem);
            });
            this.saveBatch(systemList);
        }
        List<SaveSystemReq.SystemReq> updateSystemList = saveSystemReq.getUpdateSystemList();
        if (CollectionUtils.isNotEmpty(updateSystemList)) {
            List<LabelSystem> systemList = Lists.newArrayList();
            updateSystemList.forEach(x -> {
                LabelSystem labelSystem = new LabelSystem();
                labelSystem.setId(x.getId());
                labelSystem.setMiddleSystemName(x.getMiddleSystemName());
                labelSystem.setMiddleSystemUid(x.getMiddleSystemUid());
                labelSystem.setSystemName(x.getSystemName());
                systemList.add(labelSystem);
            });
            this.updateBatchById(systemList);
        }
        return saveSystemReq.getLabelId();
    }

    /**
     * 查询组件配置的应用系统
     *
     * @param labelId 组件id
     * @param tabFlag 页签标识
     * @return 系统列表
     */
    @Override
    public List<LabelSystem> querySystemList(Long labelId, String tabFlag) {
        QueryWrapper<LabelSystem> condition = new QueryWrapper<>();
        if (labelId != null) {
            condition.eq("label_id", labelId);
        }
        if (StringUtils.isNotBlank(tabFlag)) {
            condition.eq("tab_flag", tabFlag);
        }
        return labelSystemMapper.selectList(condition);
    }
}