package com.digiwin.athena.semc.service.portal.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.entity.portal.LabelSystemPre;
import com.digiwin.athena.semc.entity.portal.LabelSystemSource;
import com.digiwin.athena.semc.mapper.portal.LabelSystemSourceMapper;
import com.digiwin.athena.semc.service.portal.LabelSystemPreService;
import com.digiwin.athena.semc.service.portal.LabelSystemSourceService;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import lombok.extern.slf4j.Slf4j;


@Slf4j
@Service
public class LabelSystemSourceServiceImpl extends ServiceImpl<LabelSystemSourceMapper, LabelSystemSource> implements LabelSystemSourceService {

    @Autowired
    LabelSystemSourceMapper labelSystemSourceMapper;

    @Autowired
    LabelSystemPreService labelSystemPreService;

    @Override
    public List<Long> selectBySystem(Long systemId, Integer componentSource) {
        LambdaQueryWrapper<LabelSystemSource> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(systemId != null, LabelSystemSource::getSystemId, systemId);
        queryWrapper.eq(componentSource != null, LabelSystemSource::getComponentSource, componentSource);
        queryWrapper.select(LabelSystemSource::getDataId);
        List<LabelSystemSource> systemSourceList = labelSystemSourceMapper.selectList(queryWrapper);
        if (CollectionUtils.isEmpty(systemSourceList)) {
            return new ArrayList<>();
        }
        List<Long> dataIdList = systemSourceList.stream().map(LabelSystemSource::getDataId).distinct().collect(Collectors.toList());
        return dataIdList;
    }

    @Override
    public List<Long> selectPreSystem(Integer dataType, Integer componentSource) {
         //根据类型查询预设组件id
        LabelSystemPre systemPre = labelSystemPreService.getPreSystemID(dataType);
        if(null == systemPre){
            return new ArrayList<>();
        }
        return selectBySystem(systemPre.getId(), componentSource);
    }
}