package com.digiwin.athena.semc.service.portal.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.appcore.util.Md5Utils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.dto.message.EmailCompanyMappingDeleteReq;
import com.digiwin.athena.semc.dto.message.EmailCompanyMappingReq;
import com.digiwin.athena.semc.dto.message.EmailCompanyMappingSaveOrUpdateReq;
import com.digiwin.athena.semc.entity.message.EmailCompanyMapping;
import com.digiwin.athena.semc.mapper.message.EmailCompanyMappingMapper;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.service.portal.MessageEmailConfigService;
import io.github.linpeilie.Converter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author CR-7
 * create: 2024-05-14 10:23
 * Description:  智奇邮件配置
 */
@Slf4j
@Service
public class MessageEmailConfigServiceImpl implements MessageEmailConfigService {

    @Resource
    IamService iamService;
    @Resource
    RestTemplate restTemplate;
    @Resource
    EmailCompanyMappingMapper emailCompanyMappingMapper;
    @Resource
    private Converter converter;


    @Override
    public ResponseEntity<?> listMailMessageConfig(EmailCompanyMappingReq emailCompanyMappingReq) {
        LambdaQueryWrapper<EmailCompanyMapping> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.like(StringUtils.isNotEmpty(emailCompanyMappingReq.getCompanyName()),
                EmailCompanyMapping::getCompanyName,emailCompanyMappingReq.getCompanyName());
        List<EmailCompanyMapping> listMailMessageConfig = emailCompanyMappingMapper.selectList(queryWrapper);
        return ResponseEntityWrapper.wrapperOk(listMailMessageConfig.stream()
                .sorted(Comparator.comparing(EmailCompanyMapping::getModifyTime)
                        .reversed()).collect(Collectors.toList()));
    }


    @Override
    public ResponseEntity<?> saveOrUpdate(EmailCompanyMappingSaveOrUpdateReq saveReq) {
        List<EmailCompanyMapping> listMailMessageConfig = emailCompanyMappingMapper.selectList(new LambdaQueryWrapper<>());;
        EmailCompanyMapping emailCompanyMappings = converter.convert(saveReq, EmailCompanyMapping.class);
        if (ObjectUtils.isEmpty(saveReq.getId())) {
            for (EmailCompanyMapping emailCompanyMapping : listMailMessageConfig) {
                if (emailCompanyMapping.getCompanyName().equals(saveReq.getCompanyName())) {
                    return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.COMPANY_NAME_REPEAT, "公司名称不可重名!");
                }

                if (emailCompanyMapping.getEmailSuffix().equals(saveReq.getEmailSuffix())) {
                    return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.EMAIL_SUFFIX, "邮箱后缀不可重名!");
                }

                if (emailCompanyMapping.getCorpId().equals(saveReq.getCorpId())) {
                    return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.CORP_ID, "corpid不可重名!");
                }

                if (emailCompanyMapping.getCorpSecret().equals(saveReq.getCorpSecret())) {
                    return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.CORP_SECRET, "corpsecret不可重名!");
                }
            }

            if (listMailMessageConfig.size() == Constants.EMAIL_COUNT) {
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.ZHIQI_EMAIL_COUNT, "新建失败,最多新建30条!");
            }
            emailCompanyMappingMapper.insert(emailCompanyMappings);
        } else {
            List<EmailCompanyMapping> listMailMessageConfigFilter = listMailMessageConfig.stream()
                    .filter(item->!item.getId().equals(saveReq.getId())).collect(Collectors.toList());
            for (EmailCompanyMapping emailCompanyMapping : listMailMessageConfigFilter) {
                if (emailCompanyMapping.getCompanyName().equals(saveReq.getCompanyName())) {
                    return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.COMPANY_NAME_REPEAT, "公司名称不可重名!");
                }

                if (emailCompanyMapping.getEmailSuffix().equals(saveReq.getEmailSuffix())) {
                    return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.EMAIL_SUFFIX, "邮箱后缀不可重名!");
                }

                if (emailCompanyMapping.getCorpId().equals(saveReq.getCorpId())) {
                    return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.CORP_ID, "corpid不可重名!");
                }

                if (emailCompanyMapping.getCorpSecret().equals(saveReq.getCorpSecret())) {
                    return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.CORP_SECRET, "corpsecret不可重名!");
                }
            }
            emailCompanyMappingMapper.updateById(emailCompanyMappings);
        }

        return ResponseEntityWrapper.wrapperOk();
    }



    @Override
    public ResponseEntity<?> delete(EmailCompanyMappingDeleteReq deleteReq) {
        return ResponseEntityWrapper.wrapperOk(emailCompanyMappingMapper.deleteBatchIds(deleteReq.getIdList()));
    }


    @Override
    public ResponseEntity<?> getUnreadCount() {
        try {
            LambdaQueryWrapper<EmailCompanyMapping> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(EmailCompanyMapping::getEmailSuffix,iamService.getIamEmail().get(1));
            EmailCompanyMapping emailCompanyMapping = emailCompanyMappingMapper.selectOne(queryWrapper);
            if (ObjectUtils.isEmpty(emailCompanyMapping)) {
                return ResponseEntityWrapper.wrapperOk(0);
            }

            // 获取access_token
            String token = null;
            String uuid = UUID.randomUUID().toString();
            long ts = System.currentTimeMillis();
            String sign = Md5Utils.encodeMd5(emailCompanyMapping.getCorpId() + "_" + uuid + "_" + ts + "_" + emailCompanyMapping.getCorpSecret()).toLowerCase();
            String urlToken = Constants.DOMAIN + "/token?corpId=" + emailCompanyMapping.getCorpId() + "&uuid=" + uuid + "&ts=" + ts + "&sign=" + sign;

            Map<String, Object> mapToken = new HashMap<>();
            mapToken.put("corp_id", emailCompanyMapping.getCorpId());
            mapToken.put("secret", emailCompanyMapping.getCorpSecret());
            HttpEntity<Map<String, Object>> requestEntity = new HttpEntity<>(mapToken, new HttpHeaders());
            ResponseEntity<Map> response = restTemplate.exchange(urlToken, HttpMethod.GET, requestEntity, Map.class);
            if (null != response.getBody()) {
                Map<String, Object> map = (Map<String, Object>) response.getBody().get("data");
                token = map.get("accessToken").toString();
                log.info("获取到的token, token:{}", token);
            }

            // 获取邮件未读数
            Map<String, Object> mapBody = new HashMap<>();
            mapBody.put("username", iamService.getIamEmail().get(0));
            String signs = Md5Utils.encodeMd5(JSON.toJSONString(mapBody) + "_" + emailCompanyMapping.getCorpId() + "_" + uuid + "_" + ts + "_" + token + "_" + emailCompanyMapping.getCorpSecret()).toLowerCase();
            String url = Constants.DOMAIN + "/api/mailbox/getUnreadSumOfInbox?access_token=" + token + "&corpid=" + emailCompanyMapping.getCorpId() + "&uuid=" + uuid + "&ts=" + ts + "&sign=" + signs;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);

            HttpEntity<Map<String, Object>> request = new HttpEntity<>(mapBody, headers);
            ResponseEntity<Map> responseEntity = restTemplate.exchange(url, HttpMethod.POST, request, Map.class);
            log.info("获取到的 resp:{}", JSON.toJSONString(responseEntity.getBody()));
            if (null == responseEntity.getBody()) {
                return ResponseEntityWrapper.wrapperOk(0);
            }
            Map<String, Object> map = (Map<String, Object>) responseEntity.getBody().get("data");
            if (null == map) {
                return ResponseEntityWrapper.wrapperOk(0);
            }
            log.info("获取到的未读邮件数, sum:{}", map.get("sum").toString());
            return ResponseEntityWrapper.wrapperOk(map.get("sum").toString());
        } catch (Exception e) {
            log.error("获取未读邮件数错误", e);
        }

        return ResponseEntityWrapper.wrapperOk(0);
    }

}
