package com.digiwin.athena.semc.service.portal.impl;

import com.google.common.collect.Lists;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.BizException;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.enums.EAIServiceNameEnum;
import com.digiwin.athena.semc.common.enums.IfNotIntegerEnum;
import com.digiwin.athena.semc.common.enums.SourceEnum;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.LabelSystemDataDto;
import com.digiwin.athena.semc.dto.portal.LabelSystemPreReq;
import com.digiwin.athena.semc.dto.portal.NoticePageQueryReq;
import com.digiwin.athena.semc.dto.portal.NoticePageQueryResp;
import com.digiwin.athena.semc.entity.portal.Notice;
import com.digiwin.athena.semc.mapper.portal.NoticeMapper;
import com.digiwin.athena.semc.proxy.esp.service.ESPService;
import com.digiwin.athena.semc.proxy.tripartite.service.TripartiteService;
import com.digiwin.athena.semc.service.portal.LabelSystemDataService;
import com.digiwin.athena.semc.service.portal.NoticeService;

import net.sf.json.JSONArray;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import javax.annotation.Resource;

/**
 * 通知公告服务实现类
 *
 * @author sunyfa
 * @since 2022-12-06 13:48:51
 */
@Service
public class NoticeServiceImpl extends ServiceImpl<NoticeMapper, Notice> implements NoticeService {

    @Autowired
    LabelSystemDataService labelSystemDataService;

    @Resource
    private ESPService espService;

    @Autowired
    TripartiteService tripartiteService;


    @Override
    public List<Notice> handleEspResult(Map<String, Object> result, NoticePageQueryReq.EaiSysInfo eaiSysInfo,
        String qryCondition, NoticePageQueryResp noticePageQueryResp) {
        Object espNoticeList = result.get("notice_list");

        QueryWrapper<Notice> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("app_name", eaiSysInfo.getAppName());
        queryWrapper.eq("notice_user", AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
        queryWrapper.eq("tenant_id", AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());

        List<Notice> filteredNoticeList = Lists.newArrayList();

        if (Objects.isNull(espNoticeList)) {
            noticePageQueryResp.setRed(false);
            noticePageQueryResp.setTotalUnreadCount(0);
            noticePageQueryResp.setTotalResults(0);
        } else {
            Integer totalResults = result.get("total_results") == null ? 0 : Integer.parseInt(result.get("total_results").toString());
            noticePageQueryResp.setTotalResults(totalResults);

            // 查詢當前租戶的當前用戶當前系統的通知公告
            List<Notice> existNoticeList = list(queryWrapper);

            Map<String, Notice> existNoticeMap = new HashMap<>();

            if (CollectionUtils.isNotEmpty(existNoticeList)) {
                existNoticeMap = existNoticeList.stream().collect(Collectors.toMap(Notice::getExternalNoticeId, a -> a, (k1, k2) -> k1));
            }

            List<Notice> insertNoticeList = Lists.newArrayList();

            JSONArray array = JSONArray.fromObject(espNoticeList);
            for (Object json : array) {
                Notice notice = com.alibaba.fastjson.JSONObject.parseObject(json.toString(), Notice.class);

                if (existNoticeMap.containsKey(notice.getExternalNoticeId())) {
                    BeanUtils.copyProperties(existNoticeMap.get(notice.getExternalNoticeId()), notice);
                    notice.setIsNew(IfNotIntegerEnum.NO.getValue());
                } else {
                    notice.setNoticeSource(SourceEnum.EXTERNAL.getSource());
                    notice.setAppName(eaiSysInfo.getAppName());
                    notice.setNoticeUser(AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
                    notice.setIsRead(IfNotIntegerEnum.NO.getValue());
                    notice.setIsNew(IfNotIntegerEnum.YES.getValue());
                    insertNoticeList.add(notice);
                }

                if (IfNotIntegerEnum.NO.getValue().equals(notice.getIsRead())) {
                    noticePageQueryResp.setRed(true);
                    noticePageQueryResp.setTotalUnreadCount(noticePageQueryResp.getTotalUnreadCount() + 1);
                }

                if ((StringUtils.isEmpty(qryCondition))
                        || (StringUtils.isNotEmpty(qryCondition) && notice.getNoticeTitle().contains(qryCondition))) {
                    filteredNoticeList.add(notice);
                }
                notice.setEaiSysName(eaiSysInfo.getEaiSysName());
                notice.setEaiSysUid(eaiSysInfo.getEaiSysUid());
                notice.setAppToken(eaiSysInfo.getAppToken());
                notice.setAppName(eaiSysInfo.getAppName());
            }

            // 保存新增的數據
            if (CollectionUtils.isNotEmpty(insertNoticeList)) {
                saveBatch(insertNoticeList);
            }
        }
        return filteredNoticeList;
    }

    /**
     * 查询公司新闻数据
     *
     * @param noticePageQueryReq 请求参数
     * @return 返回对象
     */
    @Override
    public ResultPageBean pageQueryNotice(LabelSystemPreReq noticePageQueryReq) {
        // 查询数据源信息和sso信息
        LabelSystemDataDto labelSystemDataDto = labelSystemDataService.getSystemDataSso(noticePageQueryReq.getId());
        if (null == labelSystemDataDto) {
            return ResultPageBean.bizException(BizException.getDefaultBizException(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, "数据源不存在"));
        }

        Map<String, Object> result;
        Map<String, String> extHeader = new HashMap<>();
        extHeader.put("digi-userToken", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        // 混合云模式，走esp-互联网中台-三方地端服务
        if (Constants.DataModelEnum.MODEL_HYBRID_CLOUD.getVal().equals(labelSystemDataDto.getDataModel())) {
            // 通过ESP查询三方系统的待办数据,需要支持分页和通知公布时间倒序
            result = espService.queryByEsp(labelSystemDataDto.getMiddleSystemName(),
                    labelSystemDataDto.getMiddleSystemUid(), EAIServiceNameEnum.NOTICE.getServiceName(), extHeader, null, noticePageQueryReq.getQryCondition(),
                    PageInfo.getPageInfo(noticePageQueryReq.getPageNum(), noticePageQueryReq.getPageSize()));
        }
        // 非混合云模式,需要支持分页和通知公布时间倒序
        else {
            result = tripartiteService.selectDataPagePost(labelSystemDataDto.getRestUrl(), noticePageQueryReq,labelSystemDataDto.getAppToken());
        }

        // 处理返回结果
        NoticePageQueryReq.EaiSysInfo eaiSys = new NoticePageQueryReq.EaiSysInfo();
        eaiSys.setAppName(labelSystemDataDto.getAppCode());
        eaiSys.setAppToken(labelSystemDataDto.getAppToken());
        eaiSys.setUserBindFlag(labelSystemDataDto.getUserBindFlag());
        NoticePageQueryResp noticePageQueryResp = new NoticePageQueryResp();

        List<Notice> noticeList = handleEspResult(result, eaiSys, noticePageQueryReq.getQryCondition(), noticePageQueryResp);
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();

        noticeList.forEach(x -> x.setNoticeUrl(x.getNoticeUrl() +
                (x.getNoticeUrl().contains("?") ? "&" : "?") + "appToken=" + eaiSys.getAppToken() + "&tenantId=" + tenantId + "&bindMode=" + eaiSys.getUserBindFlag()));
        noticePageQueryResp.setNoticeList(noticeList);

        // 构建返回对象
        ResultPageBean resultPageBean = ResultPageBean.success(ResponseBody.getInstance(noticePageQueryResp, PageInfo.getPageInfo(
                noticePageQueryReq.getPageNum(), noticePageQueryReq.getPageSize(), noticePageQueryResp.getTotalResults())));
        return resultPageBean;
    }
}
