package com.digiwin.athena.semc.service.portal.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.entity.portal.*;
import com.digiwin.athena.semc.mapper.portal.*;
import com.digiwin.athena.semc.service.portal.*;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.List;

/**
 * 用户使用门户行为记录/统计
 */
@Service
@Slf4j
public class PortalCountDayServiceImpl extends ServiceImpl<PortalCountDayMapper, PortalCountDay> implements PortalCountDayService {

    @Autowired
    private PortalCountDayMapper portalCountDayMapper;

    @Autowired
    private PortalCountMonthMapper portalCountMonthMapper;


    @Override
    public Integer addUserRecord(PortalCountDay req) {
        //获取当前时间的年月日
        String ymd = DateUtils.getCurrentDateYMD();
        String ymStr = DateUtils.getCurrentDateYM();
        String[] ymStrList = ymStr.split("-");
        //判断当天数据是否存在，查询用户+租户+当前时间
        PortalCountDay portalCountDay = selCountDay(ymd, req.getPortalType());
        //数据库不存在当天数据
        if (null == portalCountDay) {
            //获取初始化当日数据
            PortalCountDay portalCountDayAdd = initPortalCountDay(ymd, req.getPortalType());
            portalCountDayMapper.insert(portalCountDayAdd);
            //给月统计增加使用次数和天数
            //判断当月数据是否存在，查询用户+租户+当前月
            PortalCountMonth portalCountMonth = selCountMonth(ymStrList);
            //数据库不存在当天数据
            if (null == portalCountMonth) {
                //获取初始化当月数据
                PortalCountMonth initPortalCountMonth = initPortalCountMonth(ymStrList, req.getPortalType());
                portalCountMonthMapper.insert(initPortalCountMonth);
            }//更新月统计的使用次数和天数
            else {
                //极简门户次数+1
                if (Constants.PortalTypeEnum.SIMPLE.getFlag().equals(req.getPortalType())) {
                    portalCountMonth.setMiniCount(1 + portalCountMonth.getMiniCount());
                }//经典门户次数+1
                if (Constants.PortalTypeEnum.CONVENTIONAL.getFlag().equals(req.getPortalType())) {
                    portalCountMonth.setClassCount(1 + portalCountMonth.getClassCount());
                }
                //统计这个月的使用天数
                Integer days = portalCountDayMapper.countDays(Utils.getUserId(),DateUtils.getCurrentDateYYYYMM());
                portalCountMonth.setDayNum(days);
                portalCountMonth.setModifyTime(DateUtils.getNowTime(""));
                portalCountMonth.setModifyUserId(Utils.getUserId());
                portalCountMonthMapper.updateById(portalCountMonth);
            }

        }

        //取最近的用户名称和租户名称，判断是否变更用户名称和租户名称
        PortalCountDay portalCounUser = selCountDay("", null);
        if (null != portalCounUser) {
            //判断用户名称或者租户名称是否有修改,有修改，则修改日表和月表中的用户名称或者租户名称
            if (!portalCounUser.getCreateUserName().equals(Utils.getUserName()) ||
                    !portalCounUser.getTenantName().equals(Utils.getTenantName())
            ) {
                //更新日表的租户和登录用户名称
                updateaCountDay();
                //更新月表的租户和登录用户名称
                updateCountMonth();
            }

        }
        return null;
    }




    /**
     *更新日表的租户和登录用户名称
     * @return
     */
    public Integer updateaCountDay() {
        PortalCountDay portalCountDay=new PortalCountDay();
        portalCountDay.setTenantName(Utils.getTenantName());
        portalCountDay.setCreateUserName(Utils.getUserName());
        portalCountDay.setModifyTime(DateUtils.getNowTime(""));
        QueryWrapper<PortalCountDay> condition = new QueryWrapper<>();
        condition.eq("create_user_id", Utils.getUserId());
        portalCountDayMapper.update(portalCountDay,condition);
        return null;
    }

    /**
     *更新月表的租户和登录用户名称
     * @return
     */
    public Integer updateCountMonth() {
        PortalCountMonth portalCountMonth=new PortalCountMonth();
        portalCountMonth.setTenantName(Utils.getTenantName());
        portalCountMonth.setCreateUserName(Utils.getUserName());
        portalCountMonth.setModifyTime(DateUtils.getNowTime(""));
        QueryWrapper<PortalCountMonth> condition = new QueryWrapper<>();
        condition.eq("create_user_id", Utils.getUserId());
        portalCountMonthMapper.update(portalCountMonth,condition);
        return null;
    }

    /**
     *查询用户使用风格统计日表
     * @param ymd 当前日期年月日
     * @param portalType 门户类型（0：极简门户；1：经典门户）
     * @return
     */
    public PortalCountDay selCountDay(String ymd,Integer portalType) {
        QueryWrapper<PortalCountDay> condition = new QueryWrapper<>();
        if (null != portalType) {
            condition.eq("portal_type", portalType);
        }
        if (StringUtils.isNotEmpty(ymd)) {
            condition.eq("ymd", Integer.parseInt(ymd));
        }
        condition.eq("create_user_id", Utils.getUserId());
        condition.orderByDesc("id").last("limit 1");
        List<PortalCountDay> portalCountDayList = portalCountDayMapper.selectList(condition);
        if (CollectionUtils.isNotEmpty(portalCountDayList)) {
            return portalCountDayList.get(0);
        }
        return null;
    }

    /**
     *查询用户使用风格统计月表
     * @param ymStrList 当前日期年月
     * @return
     */
    public PortalCountMonth selCountMonth(String[] ymStrList) {
        QueryWrapper<PortalCountMonth> condition = new QueryWrapper<>();
        if (null != ymStrList && ymStrList.length > 0) {
            condition.eq("data_year", ymStrList[0]);
            condition.eq("data_month", ymStrList[1]);
        }
        condition.eq("create_user_id", Utils.getUserId());
        List<PortalCountMonth> portalCountMonthList = portalCountMonthMapper.selectList(condition);
        if (CollectionUtils.isNotEmpty(portalCountMonthList)) {
            return portalCountMonthList.get(0);
        }
        return null;
    }


    /**
     *初始化用户风格统计的日数据
     * @param ymd 当前日期年月日
     * @param portalType 门户类型（0：极简门户；1：经典门户）
     * @return
     */
    public PortalCountDay initPortalCountDay(String ymd,Integer portalType) {
        PortalCountDay portalCountDay = new PortalCountDay();
        portalCountDay.setYmd(Integer.parseInt(ymd));
        portalCountDay.setCreateUserName(Utils.getUserName());
        portalCountDay.setCreateTime(DateUtils.getNowTime(""));
        portalCountDay.setPortalType(portalType);
        portalCountDay.setTenantId(Utils.getTenantId());
        portalCountDay.setTenantName(Utils.getTenantName());
        return portalCountDay;
    }

    /**
     * 初始化用户风格统计的月数据
     * @param ymStrList
     * @param portalType
     * @return
     */
    public PortalCountMonth initPortalCountMonth(String[] ymStrList,Integer portalType) {
        PortalCountMonth portalCountMonth = new PortalCountMonth();
        //极简门户次数+1
        if(Constants.PortalTypeEnum.SIMPLE.getFlag().equals(portalType)){
            portalCountMonth.setMiniCount(1);
        }
        //经典门户次数+1
        if(Constants.PortalTypeEnum.CONVENTIONAL.getFlag().equals(portalType)){
            portalCountMonth.setClassCount(1);
        }
        portalCountMonth.setDataYear(ymStrList[0]);
        portalCountMonth.setDataMonth(ymStrList[1]);
        portalCountMonth.setDayNum(1);
        portalCountMonth.setCreateUserId(Utils.getUserId());
        portalCountMonth.setCreateUserName(Utils.getUserName());
        portalCountMonth.setCreateTime(DateUtils.getNowTime(""));
        portalCountMonth.setTenantId(Utils.getTenantId());
        portalCountMonth.setTenantName(Utils.getTenantName());
        return portalCountMonth;
    }

}
