package com.digiwin.athena.semc.service.portal.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.entity.portal.PortalDeployMessage;
import com.digiwin.athena.semc.mapper.portal.PortalDeployMessageMapper;
import com.digiwin.athena.semc.service.portal.PortalDeployMessageService;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * Created by changcong 21064
 * Date 2025/9/17 17:01
 * Description
 */
@Slf4j
@Service
public class PortalDeployMessageServiceImpl extends ServiceImpl<PortalDeployMessageMapper, PortalDeployMessage> implements PortalDeployMessageService {

    @Override
    public Map<Long,Boolean> getUnReadMessage(List<Long> portalIds, Integer source) {
        if (CollectionUtils.isEmpty(portalIds)){
            return Collections.emptyMap();
        }
        Map map = Maps.newHashMap();
        for (Long portalId : portalIds){
            map.put(portalId,true);
        }
        long sid = AppAuthContextHolder.getContext().getAuthoredUser().getSid();
        LambdaQueryWrapper<PortalDeployMessage> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(PortalDeployMessage::getSource,source).eq(PortalDeployMessage::getUserSid,sid).in(CollectionUtils.isNotEmpty(portalIds),PortalDeployMessage::getPortalId,portalIds);
        List<PortalDeployMessage> portalDeployMessages = baseMapper.selectList(lambdaQueryWrapper);
        if (CollectionUtils.isEmpty(portalDeployMessages)){
            return map;
        }
        for (PortalDeployMessage portalDeployMessage : portalDeployMessages){
            Long portalId = portalDeployMessage.getPortalId();
            map.put(portalId,false);
        }
        return map;
    }
}
