package com.digiwin.athena.semc.service.portal.impl;


import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.*;
import com.digiwin.athena.semc.common.enums.BizAuthTypeEnum;
import com.digiwin.athena.semc.common.enums.ComponentSourceEnum;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.mobile.*;
import com.digiwin.athena.semc.dto.portal.*;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.common.PlatformInitConfig;
import com.digiwin.athena.semc.entity.menu.CustomizedMenuTemplate;
import com.digiwin.athena.semc.entity.menu.CustomizedMenuWork;
import com.digiwin.athena.semc.entity.mobile.*;
import com.digiwin.athena.semc.entity.news.NewsAnnouncementAut;
import com.digiwin.athena.semc.entity.portal.*;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.common.PlatformInitConfigMapper;
import com.digiwin.athena.semc.mapper.menu.CustomizedMenuTemplateMapper;
import com.digiwin.athena.semc.mapper.menu.CustomizedMenuWorkMapper;
import com.digiwin.athena.semc.mapper.mobile.*;
import com.digiwin.athena.semc.mapper.portal.*;
import com.digiwin.athena.semc.proxy.km.service.KmService;
import com.digiwin.athena.semc.proxy.trans.service.TranslateService;
import com.digiwin.athena.semc.service.cache.RedisLock;
import com.digiwin.athena.semc.service.menu.CustomizedMenuWorkService;
import com.digiwin.athena.semc.service.mobile.MobilePortalService;
import com.digiwin.athena.semc.service.mobile.MobileUserAuthService;
import com.digiwin.athena.semc.service.news.NewsAnnouncementAuthService;
import com.digiwin.athena.semc.service.portal.*;
import com.digiwin.athena.semc.service.workbench.constant.PublishSourceEnum;
import com.digiwin.athena.semc.service.workbench.constant.WorkBenchConstant;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.InterceptorIgnoreUtil;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.common.UserAuthSystemLabelVo;
import com.digiwin.athena.semc.vo.menu.CustomizedMenuWorkResp;
import com.digiwin.athena.semc.vo.mobile.BallResp;
import com.digiwin.athena.semc.vo.mobile.MobilePortalInfoContentResp;
import com.digiwin.athena.semc.vo.portal.PortalInfoAuthReq;
import com.digiwin.athena.semc.vo.portal.PortalInfoAuthResp;
import com.digiwin.athena.semc.vo.portal.PortalUserAuthResp;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.linpeilie.Converter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.text.Collator;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


@Slf4j
@Service
public class PortalInfoServiceImpl extends ServiceImpl<PortalInfoMapper, PortalInfo> implements PortalInfoService {

    @Resource
    MessageUtils messageUtils;

    @Resource
    PortalInfoMapper portalInfoMapper;

    @Autowired
    MobilePortalInfoMapper mobilePortalInfoMapper;

    @Autowired
    MobilePortalPreviewMapper mobilePortalPreviewMapper;

    @Resource
    PortalInfoContentMapper portalInfoContentMapper;

    @Resource
    PortalInfoAuthMapper portalInfoAuthMapper;

    @Resource
    private EnvProperties envProperties;

    @Resource
    LabelSystemPreService labelSystemPreService;

    @Resource
    LabelSystemAuthService labelSystemAuthService;

    @Resource
    PortalInfoUseMapper portalInfoUseMapper;

    @Resource
    private TranslateService translateService;

    @Autowired
    LabelSystemPreMapper labelSystemPreMapper;

    @Autowired
    LabelSystemCustomMapper labelSystemCustomMapper;

    @Resource
    LabelSystemDataMapper labelSystemDataMapper;

    @Resource
    private MobileUserAuthService mobileUserAuthService;

    @Resource
    private PlatformInitConfigMapper platformInitConfigMapper;

    @Autowired
    LabelSystemAuthMapper labelSystemAuthMapper;

    @Resource
    private NewsAnnouncementAuthService newsAnnouncementAuthService;

    @Resource
    private MobilePortalService mobilePortalService;

    @Resource
    private Converter converter;

    @Autowired
    private KmService kmService;

    @Autowired
    private RelatedAppServiceWrapper relatedAppServiceWrapper;

    @Autowired
    private WorkbenchImageService workbenchImageService;

    @Autowired
    private MobilePortalInfoContentMapper mobilePortalInfoContentMapper;
    @Autowired
    private MobilePortalInfoAuthMapper mobilePortalInfoAuthMapper;
    @Resource
    private CustomizedMenuWorkService customizedMenuWorkService;

    @Resource
    private CustomizedMenuWorkMapper customizedMenuWorkMapper;

    @Resource
    private CustomizedMenuTemplateMapper customizedMenuTemplateMapper;
    @Resource
    private MobilePortalInfoUseMapper mobilePortalInfoUseMapper;
    @Autowired
    private MobilePortalTypeUserMapper mobilePortalTypeUserMapper;

    @Autowired
    private PortalDeployMessageService portalDeployMessageService;

    @Resource
    private MobileApplicatonColumnMapper applicatonColumnMapper;

    @Resource
    private MobileDatasourceInfoMapper mobileCustomApplicationMapper;

    @Resource
    private LabelSystemClickService labelSystemClickService;

    @Override
    public List<PortalInfo> checkPortal(PortalInfo req) {
        QueryWrapper<PortalInfo> condition = new QueryWrapper<>();
        condition.eq("client_type", req.getClientType());
        if (StringUtils.isNotEmpty(req.getName())) {
            condition.eq("name", req.getName());
        }
        if (null != req.getId()) {
            condition.ne("id", req.getId());
        }
        if (Constants.ClientTypeTypeEnum.MOBILE.getFlag().equals(req.getClientType())) {
            if (null != req.getPortalType()) {
                condition.eq("portal_type", req.getPortalType());
            }
        }

        // 非默认门户
        //  condition.eq("default_flag", 0);
        return portalInfoMapper.selectList(condition);
    }

    @Override
    public boolean checkISVPortal(List<Long> portalIds) {
        return InterceptorIgnoreUtil.handler(() -> this.lambdaQuery().in(PortalInfo::getId, portalIds).eq(PortalInfo::getPublishSource, PublishSourceEnum.ISV.name()).exists());
    }

    @Override
    @Transactional
    public Integer savePortal(PortalInfo req) {
        req.setModifyTime(DateUtils.getNowTime(""));
        req.setTenantId(Utils.getTenantId());
        req.setModifyUserName(Utils.getUserName());
        // 默认给未发布
        if (null == req.getStatus()) {
            req.setStatus(Constants.ReleaseEnum.NO_RELEASE.getVal());
        }
        // 门户保存
        if (null == req.getId()) {
            req.setPublishSource(PublishSourceEnum.TENANT.name());
            req.setCreateTime(DateUtils.getNowTime(""));
            req.setCreateUserName(Utils.getUserName());
            portalInfoMapper.insert(req);
        } else {
            portalInfoMapper.updateById(req);
            PortalInfo dbPort = portalInfoMapper.selectById(req.getId());
            req.setDefaultFlag(dbPort.getDefaultFlag());
        }
        // 删除布局内容
        delPortalContent(req.getId(), null);
        // 保存涉及布局内容
        if (CollectionUtils.isNotEmpty(req.getContentList())) {
            savePortalContent(req);
        }
        return null;
    }

    /**
     * 保存布局内容
     *
     * @param req
     */
    public void savePortalContent(PortalInfo req) {
        if (null == req.getId()) {
            return;
        }
        if (1 == req.getClientType()) {
            // 移动端保存
            this.savePortalContentForMobile(req);
            return;
        }
        for (PortalInfoContent content : req.getContentList()) {
            // 轮播图保存
            if (null != content.getDataType()
                    && Constants.DataTypeEnum.TYPE_CAROUSEL.getVal().equals(content.getDataType())
                    && null != content.getCarouselInfo()
            ) {
                content.setContentAttr(JSON.toJSONString(content.getCarouselInfo()));
            }
            content.setPortalId(req.getId());
            content.setTenantId(req.getTenantId());
            portalInfoContentMapper.insert(content);
        }
    }

    private void savePortalContentForMobile(PortalInfo req) {
        for (PortalInfoContent content : req.getContentList()) {
            // 轮播图保存
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_CAROUSEL.getVal().equals(content.getContentType())) {
                content.setContentAttr(JSON.toJSONString(content.getContentConfig()));
            }
            // 公告保存
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_NEWS.getVal().equals(content.getContentType())) {
                content.setContentAttr(JSON.toJSONString(content.getContentConfig()));
            }
            // 标题组件保存
            if (Constants.PrtalMobileContentTypeEnum.TITLE.getVal().equals(content.getContentType())) {
                content.setContentAttr(JSON.toJSONString(content.getContentConfig()));
            }
            // 分割线保存
            if (Constants.PrtalMobileContentTypeEnum.DIVIDER.getVal().equals(content.getContentType())) {
                content.setContentAttr(JSON.toJSONString(content.getContentConfig()));
            }
            // 图标组件保存
            if (Constants.PrtalMobileContentTypeEnum.PICTURE.getVal().equals(content.getContentType())) {
                content.setContentAttr(JSON.toJSONString(content.getContentConfig()));
            }
            // 业务入口组件保存
            if (Constants.PrtalMobileContentTypeEnum.BUSINESS_ENTRANCE.getVal().equals(content.getContentType())) {
                content.setContentAttr(JSON.toJSONString(content.getContentConfig()));
            }
            // 金刚区组件保存
            if (Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal().equals(content.getContentType())) {
                content.setContentAttr(JSON.toJSONString(content.getContentConfig()));
            }
            if (Constants.PrtalMobileContentTypeEnum.H5_LINK.getVal().equals(content.getContentType())) {
                // H5外链
                content.setContentAttr(JSON.toJSONString(content.getContentConfig()));
            }
            content.setPortalId(req.getId());
            content.setTenantId(req.getTenantId());
            content.setParentId(0L);
            content.setId(null);
            portalInfoContentMapper.insert(content);
        }
    }

    /**
     * 删除布局内容
     *
     * @param portalId
     */
    public void delPortalContent(Long portalId, List<Long> portalIdList) {
        QueryWrapper<PortalInfoContent> condition = new QueryWrapper<>();
        if (null != portalId) {
            condition.eq("portal_id", portalId);
        }
        if (CollectionUtils.isNotEmpty(portalIdList)) {
            condition.in("portal_id", portalIdList);
        }
        InterceptorIgnoreUtil.handler(() -> portalInfoContentMapper.delete(condition));
    }


    /**
     * 查询布局内容
     *
     * @param portalId
     */
    public List<PortalInfoContent> selPortalContent(Long portalId) {
        QueryWrapper<PortalInfoContent> condition = new QueryWrapper<>();
        if (null != portalId) {
            condition.eq("portal_id", portalId);
        }
        return InterceptorIgnoreUtil.handler(() -> portalInfoContentMapper.selectList(condition));
    }

    /**
     * 管理后台-查询门户列表
     *
     * @param req 请求对象
     * @return 返回
     */
    @Override
    public ResultPageBean pageQuery(PortalInfoQueryReq req) {
        List<PortalInfo> portalInfoList;
        // 查询租户版本
        String tenantVersion = kmService.queryTenantVersion();
        // 移动端自定义二级页列表
        if (Constants.MobilePortalTypeEnum.CUSTOM_PORTAL.getFlag().equals(req.getPortalType())) {
            // 落日工作台需求中门户数据只插入pc端门户表，所以需要查询pc门户表中的自定义页面门户
            portalInfoList = getListPortal(req);
            List<MobilePortalInfo> listMobilePortalList = mobilePortalService.getListMobilePortal(req);
            for (MobilePortalInfo mobilePortalInfo : listMobilePortalList) {
                PortalInfo pcPortalInfo = mobilePortalConvertToPortal(mobilePortalInfo);
                portalInfoList.add(pcPortalInfo);
            }
        } else { // pc、移动端门户列表
            // 初始化通用布局
            initDefPortal(req.getClientType());


            req.setVersion(tenantVersion);

            // 查询门户列表
            portalInfoList = getListPortal(req);

            // 如果有isv门户，则判断是否有权限访问
            boolean flag = portalInfoList.stream().anyMatch(x -> PublishSourceEnum.ISV.name().equals(x.getPublishSource()));
            if (flag) {
                List<Long> desPortalIds = relatedAppServiceWrapper.queryCurrTenantPortalList(tenantVersion);
                portalInfoList.removeIf(portalInfo -> PublishSourceEnum.ISV.name().equals(portalInfo.getPublishSource()) && !desPortalIds.contains(portalInfo.getPortalDesignerId()));

                // 赋值门户来源
                portalInfoList.forEach(x -> {
                    if (PublishSourceEnum.ISV.name().equals(x.getPublishSource())) {
                        x.setPortalTypeSource(Constants.LabelOrPoralSourceEnum.ISV.getFlag());
                    }
                });
            }

            // 查询移动端现有的门户列表，该部分门户存储在原有移动端门户表中
            if (Constants.ClientTypeEnum.MOBILE.getValue().equals(req.getClientType())) {
                List<MobilePortalInfo> listMobilePortalList = mobilePortalService.getListMobilePortal(req);
                for (MobilePortalInfo mobilePortalInfo : listMobilePortalList) {
                    PortalInfo pcPortalInfo = mobilePortalConvertToPortal(mobilePortalInfo);
                    portalInfoList.add(pcPortalInfo);
                }
            }
        }

        // 组装缩略图地址
        for (PortalInfo portalInfo : portalInfoList) {
            if (StringUtils.isNotEmpty(portalInfo.getPortalImgId())) {
                String portalImgUrl = envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + portalInfo.getPortalImgId();
                portalInfo.setPortalImgUrl(portalImgUrl);
            }
        }

        // 判断是否有”更新“标签
        List<PortalInfo> collect2 = portalInfoList.stream().filter(e -> PublishSourceEnum.ISV.name().equals(e.getPublishSource())).collect(Collectors.toList());
        Set<Long> collect = collect2.stream().map(e -> e.getPortalDesignerId()).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(collect)) {

        } else {
            LambdaQueryWrapper<PortalDeployMessage> portalDeployMessageLambdaQueryWrapper = new LambdaQueryWrapper();
            LambdaQueryWrapper<PortalDeployMessage> in = portalDeployMessageLambdaQueryWrapper.eq(PortalDeployMessage::getSource, 1).in(CollectionUtils.isNotEmpty(collect), PortalDeployMessage::getPortalId, collect)
                    .eq(PortalDeployMessage::getVersion, tenantVersion).eq(PortalDeployMessage::getUserSid, Utils.getUserSid()).eq(PortalDeployMessage::getClientType, req.getClientType());
            List<PortalDeployMessage> portalDeployMessages = InterceptorIgnoreUtil.handler(() -> portalDeployMessageService.getBaseMapper().selectList(in));
            if (CollectionUtils.isEmpty(portalDeployMessages)) {
                for (PortalInfo portalInfo : collect2) {
                    portalInfo.setChanged(1);
                }
            }
            if (CollectionUtils.isNotEmpty(portalDeployMessages)) {
                Set<Long> collect1 = portalDeployMessages.stream().map(e -> e.getPortalId()).collect(Collectors.toSet());
                for (PortalInfo portalInfo : collect2) {
                    if (!collect1.contains(portalInfo.getPortalDesignerId())) {
                        portalInfo.setChanged(1);
                    }
                }
            }
        }

        ResultPageBean resultPageBean = ResultPageBean.success(ResponseBody.getInstance(portalInfoList.stream()
                .skip((req.getPageNum() - 1) * req.getPageSize().longValue())
                .limit(req.getPageSize()).collect(Collectors.toList()), PageInfo.getPageInfo(
                req.getPageNum(), req.getPageSize(), portalInfoList.size())));
        return resultPageBean;
    }

    /**
     * 移动门户转为pc门户
     *
     * @param mobilePortalInfo 移动门户
     * @return 返回
     */
    private static PortalInfo mobilePortalConvertToPortal(MobilePortalInfo mobilePortalInfo) {
        PortalInfo pcPortalInfo = new PortalInfo();
        pcPortalInfo.setId(mobilePortalInfo.getId());
        pcPortalInfo.setPortalTypeSource(Constants.PortalTypeSourceEnum.TENANT.getFlag());
        pcPortalInfo.setClientType(Constants.ClientTypeTypeEnum.MOBILE.getFlag());
        pcPortalInfo.setPortalType(mobilePortalInfo.getPortalType());
        pcPortalInfo.setTitle(mobilePortalInfo.getTitle());
        pcPortalInfo.setBgColor(mobilePortalInfo.getBgColor());
        pcPortalInfo.setPortalDesignerId(null);
        pcPortalInfo.setWorkbenchAppCode(null);
        pcPortalInfo.setParentId(0L);
        pcPortalInfo.setTemplateId(null);
        pcPortalInfo.setDefaultFlag(mobilePortalInfo.getDefaultFlag());
        pcPortalInfo.setName(mobilePortalInfo.getName());
        pcPortalInfo.setPortalDesc(mobilePortalInfo.getPortalDesc());
        pcPortalInfo.setMenuTemplateId(null);
        pcPortalInfo.setStatus(mobilePortalInfo.getStatus());
        pcPortalInfo.setPortalContent(mobilePortalInfo.getPortalContent());
        pcPortalInfo.setPortalImgId(mobilePortalInfo.getPortalImgId());
        pcPortalInfo.setTenantId(mobilePortalInfo.getTenantId());
        pcPortalInfo.setCreateUserName(mobilePortalInfo.getName());
        pcPortalInfo.setCreateTime(mobilePortalInfo.getCreateTime());
        pcPortalInfo.setModifyUserName(mobilePortalInfo.getModifyUserName());
        pcPortalInfo.setModifyTime(mobilePortalInfo.getModifyTime());
        pcPortalInfo.setModifyUserId(mobilePortalInfo.getModifyUserId());
        pcPortalInfo.setPublishSource(PublishSourceEnum.TENANT.name());
        pcPortalInfo.setOldPortalFlag(Boolean.TRUE);
        return pcPortalInfo;
    }

    /**
     * 初始化通用布局
     *
     * @param clientType 门户端 PC端：0，移动端：1
     * @return 返回
     */
    public PortalInfo initDefPortal(Integer clientType) {
        RedisLock redisLock = new RedisLock(String.format(RedisConstant.TEMP_PORT_INFO_LOCK, Utils.getTenantId()));
        // 先查询租户的默认门户是否存在
        String tenantId = Utils.getTenantId();
        PortalInfo defPortalTent = InterceptorIgnoreUtil.handler(() -> portalInfoMapper.queryTentDefPortal(tenantId, clientType));
        // 开启分布式锁
        try {
            if (!redisLock.lock()) {
                return defPortalTent;
            }
        } catch (InterruptedException e) {
            return defPortalTent;
        }
        try {
            // 查询系统的默认门户
            PortalInfo defaultPortal = portalInfoMapper.queryDefaultPortal(clientType);
            // 已存在，则更新
            if (null != defPortalTent) {
                defPortalTent.setPortalImgId(defaultPortal.getPortalImgId());
                defPortalTent.setPortalContent(defaultPortal.getPortalContent()); // 该字段pc端使用,移动端不使用
                defPortalTent.setTemplateId(null); // 该字段pc端使用,移动端不使用
                portalInfoMapper.updateById(defPortalTent);
            } else {
                PortalInfo newDefPortalTent = new PortalInfo();
                BeanUtils.copyProperties(defaultPortal, newDefPortalTent);
                newDefPortalTent.setTemplateId(null); // 该字段pc端使用,移动端不使用该字段
                newDefPortalTent.setId(null);
                portalInfoMapper.insert(newDefPortalTent);
                defPortalTent = newDefPortalTent;
            }

            // 查询系统门户配置的内容
            // pc端因为表中组件类型做了区分，需要先查询预设组件
            if (Constants.ClientTypeEnum.PC.getValue().equals(clientType)) {
                List<PortalInfoContent> portalInfoContentList = portalInfoContentMapper.queryPortalCont(defaultPortal.getId(), Collections.singletonList(Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal()));
                List<Integer> dataTypeList = portalInfoContentList.stream().map(PortalInfoContent::getDataType).collect(Collectors.toList());

                // 查询该租户下的预设组件
                List<LabelSystemPre> preSystemList = labelSystemPreService.initDefPortal(dataTypeList, clientType);
                Map<Integer, LabelSystemPre> preInfoMap = preSystemList.stream().collect(Collectors.toMap(LabelSystemPre::getDataType, Function.identity(), (a, b) -> a));

                // 删除租户下布局内容
                delPortalContent(defPortalTent.getId(), null);
                for (PortalInfoContent contentInfo : portalInfoContentList) {
                    contentInfo.setId(null);
                    contentInfo.setTenantId(Utils.getTenantId());
                    contentInfo.setPortalId(defPortalTent.getId());
                    contentInfo.setContentId(preInfoMap.get(contentInfo.getDataType()).getId());
                    portalInfoContentMapper.insert(contentInfo);
                }
            } else {
                List<PortalInfoContent> portalInfoContentList = portalInfoContentMapper.queryPortalCont(defaultPortal.getId(), Lists.newArrayList());
                List<LabelSystemPre> preSystemList = labelSystemPreService.initDefPortal(Lists.newArrayList(), clientType);
                Map<Integer, LabelSystemPre> preInfoMap = preSystemList.stream().collect(Collectors.toMap(LabelSystemPre::getDataCategory, Function.identity(), (a, b) -> a));

                // 删除租户下布局内容
                delPortalContent(defPortalTent.getId(), null);

                for (PortalInfoContent contentInfo : portalInfoContentList) {
                    PortalInfoContent content = new PortalInfoContent();
                    BeanUtils.copyProperties(contentInfo, content);
                    content.setId(null);
                    content.setTenantId(Utils.getTenantId());
                    content.setPortalId(defPortalTent.getId());
                    // 除了金刚球，其他的获取预设组件ID
                    if (!contentInfo.getContentType().equals(Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal())) {
                        LabelSystemPre systemPre = preInfoMap.get(contentInfo.getContentType());
                        content.setContentId(systemPre == null ? null : systemPre.getId());
                    }
                    portalInfoContentMapper.insert(content);
                }
            }
        } catch (Exception e) {
            log.error("initDefPortal  error", e);
        } finally {
            redisLock.unlock();
        }
        return defPortalTent;
    }

    /**
     * 门户列表条件查询
     *
     * @param req
     * @return
     */
    public List<PortalInfo> getListPortal(PortalInfoQueryReq req) {
        QueryWrapper<PortalInfo> condition = new QueryWrapper<>();
        condition.eq("client_type", req.getClientType());
        if (StringUtils.isNotEmpty(req.getName())) {
            condition.like("name", req.getName());
        }
        if (null != req.getStatus()) {
            condition.eq("status", req.getStatus());
        }
        // 移动端会传该字段，pc端不传
        if (ObjectUtils.isNotEmpty(req.getPortalType())) {
            condition.eq("portal_type", req.getPortalType());
        }

        condition.and(x -> x.isNull("version").or().eq("version", req.getVersion()));

        Set<String> tenantIds = new HashSet<>(Arrays.asList(Utils.getTenantId(), WorkBenchConstant.SYSTEM_TENANT));
        condition.in("tenant_id", tenantIds);

        if (null == req.getSortType() || StringUtils.isEmpty(req.getOrderBy())) {
            condition.orderByDesc("default_flag").orderByDesc("modify_time");
        }
        if (null != req.getSortType() && req.getSortType().intValue() == 1) {
            if (StringUtils.isNotEmpty(req.getOrderBy()) && req.getOrderBy().equals("desc")) {
                condition.orderByDesc("default_flag").orderByDesc("create_time");
            }
            if (StringUtils.isNotEmpty(req.getOrderBy()) && req.getOrderBy().equals("asc")) {
                condition.orderByDesc("default_flag").orderByAsc("create_time");
            }
        }
        if (null != req.getSortType() && req.getSortType().intValue() == 2) {
            if (StringUtils.isNotEmpty(req.getOrderBy()) && req.getOrderBy().equals("desc")) {
                condition.orderByDesc("default_flag").orderByDesc("modify_time");
            }
            if (StringUtils.isNotEmpty(req.getOrderBy()) && req.getOrderBy().equals("asc")) {
                condition.orderByDesc("default_flag").orderByAsc("modify_time");
            }
        }
        return InterceptorIgnoreUtil.handler(() -> portalInfoMapper.selectList(condition));
    }

    @Override
    @Transactional
    public Integer updateBat(PortalInfoQueryReq req) {
        req.setModifyTime(DateUtils.getNowTime(""));
        req.setModifyUserId(Utils.getUserId());
        req.setModifyUserName(Utils.getUserName());

        // pc端
        if (CollectionUtils.isNotEmpty(req.getIdList())) {
            portalInfoMapper.updateBat(req.getIdList(), req);
        }
        // 移动端
        else if (CollectionUtils.isNotEmpty(req.getMobileIdReqList())) {
            // 落日工作台需求中门户数据只插入pc端门户表，所以需要判断是否是新的门户
            List<Long> newPortalIdList = req.getMobileIdReqList().stream().filter(x -> Boolean.FALSE.equals(x.getOldPortalFlag())).map(PortalInfoQueryReq.MobileIdReq::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(newPortalIdList)) {
                portalInfoMapper.updateBat(newPortalIdList, req);
            }
            // 如果是移动表的老门户，则需要更新老门户表
            List<Long> oldPortalIdList = req.getMobileIdReqList().stream().filter(x -> Boolean.TRUE.equals(x.getOldPortalFlag())).map(PortalInfoQueryReq.MobileIdReq::getId).collect(Collectors.toList());
            req.setIdList(oldPortalIdList);
            if (CollectionUtils.isNotEmpty(oldPortalIdList)) {
                mobilePortalService.updateBat(req);
            }
        }
        return null;
    }

    @Override
    @Transactional
    public Integer delBat(PortalInfoQueryReq req) {
        // pc端
        if (CollectionUtils.isNotEmpty(req.getIdList())) {
            // 删除门户
            portalInfoMapper.deleteBatchIds(req.getIdList());
            // 删除门户内容
            delPortalContent(null, req.getIdList());
            // 删除组件权限
            delPortalAuth(req.getIdList());
        }
        // 移动端
        else if (CollectionUtils.isNotEmpty(req.getMobileIdReqList())) {
            // 落日工作台需求中门户数据只插入pc端门户表，所以需要判断是否是新的门户
            List<Long> newPortalIdList = req.getMobileIdReqList().stream().filter(x -> Boolean.FALSE.equals(x.getOldPortalFlag())).map(PortalInfoQueryReq.MobileIdReq::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(newPortalIdList)) {
                // 删除门户
                portalInfoMapper.deleteBatchIds(newPortalIdList);
                // 删除门户内容
                delPortalContent(null, newPortalIdList);
                // 删除组件权限
                delPortalAuth(newPortalIdList);
                // 删除预览数据
                QueryWrapper<MobilePortalPreview> condition = new QueryWrapper<>();
                condition.in("mobile_portal_id", req.getIdList());
                mobilePortalPreviewMapper.delete(condition);
            }
            // 如果是移动表的老门户，则需要删除老门户表
            List<Long> oldPortalIdList = req.getMobileIdReqList().stream().filter(x -> Boolean.TRUE.equals(x.getOldPortalFlag())).map(PortalInfoQueryReq.MobileIdReq::getId).collect(Collectors.toList());
            req.setIdList(oldPortalIdList);
            if (CollectionUtils.isNotEmpty(oldPortalIdList)) {
                mobilePortalService.delBat(req);
            }
        }
        return null;
    }

    @Override
    @Transactional
    public Integer savePortalAuth(PortalInfoAuthReq req) {
        // 删除组件权限
        List<Long> portalIdList = new ArrayList<>();
        portalIdList.add(req.getId());
        delPortalAuth(portalIdList);
        // 保存权限
        for (PortalInfoAuthReq.AuthVO authVO : req.getAuthList()) {
            PortalInfoAuth portalInfoAuth = converter.convert(authVO, PortalInfoAuth.class);
            portalInfoAuth.setPortalId(req.getId());
            portalInfoAuth.setClientType(req.getClientType());
            portalInfoAuth.setPortalTypeSource(req.getPortalTypeSource());
            portalInfoAuthMapper.insert(portalInfoAuth);
        }
        return null;
    }

    @Override
    public PortalInfoAuthResp selectByPortalAuth(Long portalId) {
        PortalInfoAuthResp authResp = new PortalInfoAuthResp();
        List<Long> portalIdList = new ArrayList<>();
        portalIdList.add(portalId);
        List<PortalInfoAuth> authList = selectPortalAuth(portalIdList);
        if (CollectionUtils.isEmpty(authList)) {
            return authResp;
        }
        // 组织
        List<PortalInfoAuth> orgDataList = authList.stream().filter(item -> BizAuthTypeEnum.ORG.getValue().equals(item.getAuthType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orgDataList)) {
            authResp.setOrgDataList(orgDataList);
        }
        // 角色
        List<PortalInfoAuth> roleDataList = authList.stream().filter(item -> BizAuthTypeEnum.ROLE.getValue().equals(item.getAuthType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(roleDataList)) {
            authResp.setRoleDataList(roleDataList);
        }
        // 部门
        List<PortalInfoAuth> deptDataList = authList.stream().filter(item -> BizAuthTypeEnum.DEPARTMENT.getValue().equals(item.getAuthType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(deptDataList)) {
            authResp.setDeptDataList(deptDataList);
        }
        // 用户
        List<PortalInfoAuth> userDataList = authList.stream().filter(item -> BizAuthTypeEnum.USER.getValue().equals(item.getAuthType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(userDataList)) {
            authResp.setUserDataList(userDataList);
        }
        return authResp;
    }

    /**
     * 查询布局权限
     */
    public List<PortalInfoAuth> selectPortalAuth(List<Long> portalIdList) {
        QueryWrapper<PortalInfoAuth> condition = new QueryWrapper<>();
        if (CollectionUtils.isNotEmpty(portalIdList)) {
            condition.in("portal_id", portalIdList);
        }
        return portalInfoAuthMapper.selectList(condition);
    }

    /**
     * 删除布局权限
     */
    public void delPortalAuth(List<Long> portalIdList) {
        QueryWrapper<PortalInfoAuth> condition = new QueryWrapper<>();
        if (CollectionUtils.isNotEmpty(portalIdList)) {
            condition.in("portal_id", portalIdList);
        }
        portalInfoAuthMapper.delete(condition);
    }

    /**
     * 查询最近使用
     *
     * @param clientType 客户端类型 PC端：0，移动端：1
     */
    @Override
    public PortalInfoUse getUserUsePortal(Integer clientType) {
        QueryWrapper<PortalInfoUse> condition = new QueryWrapper<>();
        condition.orderByDesc("id");
        condition.eq("create_user_id", Utils.getUserId());
        condition.eq("client_type", clientType);
        List<PortalInfoUse> useList = portalInfoUseMapper.selectList(condition);
        if (CollectionUtils.isNotEmpty(useList)) {
            return useList.get(0);
        }
        return null;
    }


    @Override
    public List<PortalUserAuthResp> selectUserPortal(Integer clientType) {
        QueryWrapper<PortalInfoAuth> condition = new QueryWrapper<>();
        QueryWrapper wrapper = labelSystemAuthService.getUserAuthCon(condition);
        // 区分客户端
        wrapper.eq("client_type", clientType);

        // 获取登录用户权限内门户
        List<PortalInfoAuth> portalInfoAuthList = portalInfoAuthMapper.selectList(wrapper);
        List<MobilePortalInfoAuth> mobilePortalInfoAuths = new ArrayList<>();
        if (Constants.ClientTypeEnum.MOBILE.getValue().equals(clientType)) {
            // 兼容移动历史数据
            // 获取登录用户权限内门户
            mobilePortalInfoAuths = mobilePortalInfoAuthMapper.selectList(labelSystemAuthService.getUserAuthCon(new QueryWrapper<>()));
        }
        // 查询租户的默认门户
        PortalInfo defPortalTent = initDefPortal(clientType);
        // 返回值
        List<PortalUserAuthResp> userAuthRespList = new ArrayList<>();
        PortalUserAuthResp defPortal = converter.convert(defPortalTent, PortalUserAuthResp.class);
        String name = translateService.translateTextCache(defPortalTent.getName(), StringUtils.EMPTY);
        defPortal.setName(name);
        if (null != defPortal && Constants.GENERAL_MENU_TEMPLATE_ID.equals(defPortal.getMenuTemplateId())) {
            defPortal.setMenuGeneralFlag(Constants.GENERAL_MENU_FLAG_YES);
        }
        String version = kmService.queryTenantVersionWithDefault();
        String recentlyMsg = "";
        // 查询最近选择的门户
        PortalInfoUse usePortal = getUserUsePortal(clientType);
        if (usePortal == null && Constants.ClientTypeEnum.MOBILE.getValue().equals(clientType)) {
            // 兼容移动历史数据
            MobilePortalInfoUse mobilePortalInfoUse =
                    mobilePortalInfoUseMapper.selectOne(new LambdaQueryWrapper<MobilePortalInfoUse>()
                            .eq(MobilePortalInfoUse::getCreateUserId, Utils.getUserId()));
            if (mobilePortalInfoUse != null) {
                usePortal = new PortalInfoUse();
                usePortal.setId(mobilePortalInfoUse.getId());
                usePortal.setTenantId(mobilePortalInfoUse.getTenantId());
                usePortal.setClientType(Constants.ClientTypeEnum.MOBILE.getValue());
                usePortal.setPortalId(mobilePortalInfoUse.getMobilePortalId());
                usePortal.setPortalTypeSource(Constants.PortalTypeSourceEnum.TENANT.getFlag());
            }

        }
        PortalInfo usePortalInfo = null;
        // 校验最近使用的门户是否已被删除
        if (null != usePortal) {
            if (Constants.PortalTypeSourceEnum.ISV.getFlag().equals(usePortal.getPortalTypeSource())) {
                // isv门户，区分1.0版本和2.0版本
                LambdaQueryWrapper<PortalInfo> queryWrapper = new LambdaQueryWrapper<PortalInfo>()
                        .eq(PortalInfo::getPortalDesignerId, usePortal.getPortalId())
                        .eq(PortalInfo::getVersion, version);
                usePortalInfo = InterceptorIgnoreUtil.handler(() -> portalInfoMapper.selectOne(queryWrapper));
            } else {
                // 需使用clientType过滤, 兼容移动历史数据，防止不同客户端的门户ID相同
                LambdaQueryWrapper<PortalInfo> queryWrapper = new LambdaQueryWrapper<PortalInfo>()
                        .eq(PortalInfo::getId, usePortal.getPortalId())
                        .eq(PortalInfo::getClientType, clientType);
                usePortalInfo = InterceptorIgnoreUtil.handler(() -> portalInfoMapper.selectOne(queryWrapper));
                if (usePortalInfo == null && Constants.ClientTypeEnum.MOBILE.getValue().equals(clientType)) {
                    // 兼容移动历史数据
                    MobilePortalInfo mobilePortalInfo = mobilePortalInfoMapper.selectById(usePortal.getPortalId());
                    if (mobilePortalInfo != null) {
                        usePortalInfo = new PortalInfo();
                        BeanUtils.copyProperties(mobilePortalInfo, usePortalInfo);
                        usePortalInfo.setClientType(Constants.ClientTypeEnum.MOBILE.getValue());
                        usePortalInfo.setMenuTypeSource(Constants.MenuTypeSourceEnum.TENANT.getFlag());
                        usePortalInfo.setPublishSource(PublishSourceEnum.TENANT.name());
                        usePortalInfo.setVersionDefault(0);
                    }
                }
            }
            // 最近使用的门户被删除或者未发布
            if (null == usePortalInfo || usePortalInfo.getStatus().equals(Constants.ReleaseEnum.NO_RELEASE.getVal())) {
                recentlyMsg = messageUtils.getMessage("error.message.use.portal.recovery");
                defPortal.setRecentlyMsg(recentlyMsg);
            }
        }
        // 将默认门户加入职能门户列表
        // 权限内没有门户，返回默认门户
        boolean pc = Constants.ClientTypeEnum.PC.getValue().equals(clientType) && CollectionUtils.isEmpty(portalInfoAuthList);
        boolean mobile = Constants.ClientTypeEnum.MOBILE.getValue().equals(clientType) && (CollectionUtils.isEmpty(portalInfoAuthList) && CollectionUtils.isEmpty(mobilePortalInfoAuths));
        if (pc || mobile) {
            defPortal.setIsRecently(true);
            // 最近使用的门户不为空 且 最近使用的门户不等于通用门户
            if (null != usePortalInfo && !usePortalInfo.getId().equals(defPortalTent.getId())) {
                defPortal.setRecentlyMsg(messageUtils.getMessage("error.message.use.portal.recovery"));
            }
            userAuthRespList.add(defPortal);
            return userAuthRespList;
        }
        // 区分ISV、租户门户
        List<Long> isvPortalIds = portalInfoAuthList.stream().filter(r -> Constants.PortalTypeSourceEnum.ISV.getFlag().equals(r.getPortalTypeSource())).map(PortalInfoAuth::getPortalId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(isvPortalIds)) {
            // 当前租户有权限的isv门户
            List<Long> desPortalIds = relatedAppServiceWrapper.queryCurrTenantPortalList(version);
            // 权限内的isv门户
            List<Long> authIsvPortalIds = isvPortalIds.stream().filter(desPortalIds::contains).collect(Collectors.toList());
            // 权限外的isv门户 -- 权限删除
            List<Long> deleteIsvPortalIds = isvPortalIds.stream().filter(r -> !desPortalIds.contains(r)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(deleteIsvPortalIds)) {
                delPortalAuth(deleteIsvPortalIds);
            }
            isvPortalIds = authIsvPortalIds;
        }
        List<Long> tenantPortalIds = portalInfoAuthList.stream().filter(r -> !Constants.PortalTypeSourceEnum.ISV.getFlag().equals(r.getPortalTypeSource())).map(PortalInfoAuth::getPortalId).collect(Collectors.toList());
        List<PortalInfo> portalInfoList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(isvPortalIds)) {
            LambdaQueryWrapper<PortalInfo> queryWrapper = new LambdaQueryWrapper<PortalInfo>()
                    .in(PortalInfo::getPortalDesignerId, isvPortalIds)
                    .eq(PortalInfo::getVersion, version);
            portalInfoList.addAll(InterceptorIgnoreUtil.handler(() ->
                    portalInfoMapper.selectList(queryWrapper)));
        }
        if (CollectionUtils.isNotEmpty(tenantPortalIds)) {
            portalInfoList.addAll(InterceptorIgnoreUtil.handler(() -> portalInfoMapper.selectBatchIds(tenantPortalIds)));
        }
        if (CollectionUtils.isNotEmpty(mobilePortalInfoAuths)) {
            // 兼容移动历史数据
            List<Long> mobilePortalIds = mobilePortalInfoAuths.stream().map(MobilePortalInfoAuth::getMobilePortalId).collect(Collectors.toList());
            List<PortalInfo> mobilePortalInfoList = mobilePortalInfoMapper.selectBatchIds(mobilePortalIds)
                    .stream().map(x -> {
                        PortalInfo portalInfo = new PortalInfo();
                        BeanUtils.copyProperties(x, portalInfo);
                        portalInfo.setOldPortalFlag(true);
                        portalInfo.setClientType(Constants.ClientTypeEnum.MOBILE.getValue());
                        portalInfo.setMenuTypeSource(Constants.MenuTypeSourceEnum.TENANT.getFlag());
                        portalInfo.setPublishSource(PublishSourceEnum.TENANT.name());
                        return portalInfo;
                    }).collect(Collectors.toList());
            portalInfoList.addAll(mobilePortalInfoList);
        }
        List<Long> portalIds = portalInfoList.stream().map(PortalInfo::getId).collect(Collectors.toList());
        // 判断最近使用的是否在权限内，不在则组装提示语
        // 通用门户一直在权限内
        portalIds.add(defPortalTent.getId());
        if (null != usePortalInfo && !portalIds.contains(usePortalInfo.getId())) {
            recentlyMsg = messageUtils.getMessage("error.message.use.portal.recovery");
        }
        // 返回已启用的
        portalInfoList = portalInfoList.stream()
                .filter(x -> Constants.ReleaseEnum.RELEASED.getVal().equals(x.getStatus())
                        && Constants.MobilePortalTypeEnum.PORTAL.getFlag().equals(x.getPortalType()))
                .collect(Collectors.toList());
        if (CollectionUtils.isEmpty(portalInfoList)) {
            defPortal.setRecentlyMsg(recentlyMsg);
            defPortal.setIsRecently(true);
            userAuthRespList.add(defPortal);
            return userAuthRespList;
        }
        List<Long> relPortalIds = portalInfoList.stream().map(PortalInfo::getId).collect(Collectors.toList());
        defPortal.setRecentlyMsg(recentlyMsg);
        defPortal.setIsRecently(false);
        // 如果最近使用的是通用模版，则默认打开的也是通用模版
        if (null != usePortalInfo && usePortalInfo.getId().equals(defPortal.getId())) {
            defPortal.setIsRecently(true);
        }
        userAuthRespList.add(defPortal);
        // 翻译
        portalInfoList.forEach(x -> x.setName(translateService.translateTextCache(x.getName(), StringUtils.EMPTY)));
        Comparator<Object> cmp = Collator.getInstance(Locale.CHINA);
        // 按照首字母排序
        portalInfoList.sort((a, b) -> cmp.compare(a.getName(), b.getName()));
        for (int i = 0; i < portalInfoList.size(); i++) {
            PortalInfo portalInfo = portalInfoList.get(i);
            PortalUserAuthResp userPortal = new PortalUserAuthResp();
            BeanUtils.copyProperties(portalInfo, userPortal);
            userPortal.setPortalTypeSource(Constants.PortalTypeSourceEnum.TENANT.getFlag());
            if (WorkBenchConstant.SYSTEM_TENANT.equals(portalInfo.getTenantId())) {
                // isv -- 处理Id问题
                userPortal.setId(portalInfo.getPortalDesignerId());
                userPortal.setPortalTypeSource(Constants.PortalTypeSourceEnum.ISV.getFlag());
            }
            userPortal.setRecentlyMsg(recentlyMsg);
            userPortal.setIsRecently(false);

            if (null == usePortalInfo && i == 0) {
                userPortal.setIsRecently(true);
            }
            // 如果是通用菜单，则赋值标识
            if (null != userPortal && Constants.GENERAL_MENU_TEMPLATE_ID.equals(userPortal.getMenuTemplateId())) {
                userPortal.setMenuGeneralFlag(Constants.GENERAL_MENU_FLAG_YES);
            }

            // 最近使用的不在权限内，且不是通用模版，默认取非通用模版第一个
            if (null != usePortalInfo && i == 0 && !relPortalIds.contains(usePortalInfo.getId())
                    && !usePortalInfo.getId().equals(defPortal.getId())
            ) {
                userPortal.setIsRecently(true);
            }
            // 最近使用的在权限内，且不是通用模版
            if (null != usePortalInfo && usePortalInfo.getId().equals(portalInfoList.get(i).getId())
                    && !usePortalInfo.getId().equals(defPortal.getId())) {
                userPortal.setIsRecently(true);
            }
            // 门户已发布
            if (portalInfoList.get(i).getStatus().equals(Constants.ReleaseEnum.RELEASED.getVal())) {
                userAuthRespList.add(userPortal);
            }
        }
        List<PortalUserAuthResp> isvuserAuthRespList = userAuthRespList.stream().filter(e -> Objects.equals(1, e.getPortalTypeSource())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(isvuserAuthRespList)) {
            Set<Long> collect = isvuserAuthRespList.stream().map(e -> e.getId()).collect(Collectors.toSet());
            LambdaQueryWrapper<PortalDeployMessage> portalDeployMessageLambdaQueryWrapper = new LambdaQueryWrapper();
            LambdaQueryWrapper<PortalDeployMessage> in = portalDeployMessageLambdaQueryWrapper.eq(PortalDeployMessage::getSource, 2).in(CollectionUtils.isNotEmpty(collect), PortalDeployMessage::getPortalId, collect).
                    eq(PortalDeployMessage::getVersion, version).eq(PortalDeployMessage::getUserSid, Utils.getUserSid()).eq(PortalDeployMessage::getClientType, clientType);
            List<PortalDeployMessage> portalDeployMessages = InterceptorIgnoreUtil.handler(() -> portalDeployMessageService.getBaseMapper().selectList(in));
            if (CollectionUtils.isEmpty(portalDeployMessages)) {
                for (PortalUserAuthResp portalUserAuthResp : isvuserAuthRespList) {
                    if (Objects.equals(1, portalUserAuthResp.getPortalTypeSource())) {
                        portalUserAuthResp.setChanged(1);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(portalDeployMessages)) {
                Set<Long> collect1 = portalDeployMessages.stream().map(e -> e.getPortalId()).collect(Collectors.toSet());
                for (PortalUserAuthResp portalUserAuthResp : isvuserAuthRespList) {
                    if (Objects.equals(1, portalUserAuthResp.getPortalTypeSource()) && !collect1.contains(portalUserAuthResp.getId())) {
                        portalUserAuthResp.setChanged(1);
                    }
                }
            }
        }
        return userAuthRespList;
    }

    @Override
    @Transactional
    public ResponseEntity<?> getPortalInfo(PortalInfo portalInfo) {
        // 默认布局
        if (portalInfo.getDefaultFlag().equals(Constants.DEFAULT_CONFIGURED_FLAG_YES)) {
            portalInfo = initDefPortal(portalInfo.getClientType());
        }

        // 如果是通用菜单，则赋值标识
        if (Constants.GENERAL_MENU_TEMPLATE_ID.equals(portalInfo.getMenuTemplateId())) {
            portalInfo.setMenuGeneralFlag(Constants.GENERAL_MENU_FLAG_YES);
        }
        // 非默认布局，需要校验用户是否有该门户权限
        if (portalInfo.getDefaultFlag().equals(Constants.DEFAULT_CONFIGURED_FLAG_NO)) {
            QueryWrapper<PortalInfoAuth> condition = new QueryWrapper<>();
            // 获取登录用户权限内门户
            QueryWrapper wrapper = labelSystemAuthService.getUserAuthCon(condition);
            // 区分客户端
            wrapper.eq("client_type", portalInfo.getClientType());
            List<PortalInfoAuth> portalInfoAuthList = portalInfoAuthMapper.selectList(wrapper);
            List<Long> portalIds = portalInfoAuthList.stream().map(PortalInfoAuth::getPortalId).collect(Collectors.toList());
            String recentlyMsg = "";
            // 判断门户是否在权限内，不在则组装提示语
            if (!portalIds.contains(portalInfo.getId()) && !portalIds.contains(portalInfo.getPortalDesignerId())) {
                recentlyMsg = messageUtils.getMessage("error.message.choose.portal.recovery");
                portalInfo.setRecentlyMsg(recentlyMsg);
                return ResponseEntityWrapper.wrapperOk(portalInfo);
            }
        }
        // 查询内容信息
        List<PortalInfoContent> portalInfoContentList = selPortalContent(portalInfo.getId());
        if (CollectionUtils.isEmpty(portalInfoContentList)) {
            return ResponseEntityWrapper.wrapperOk(portalInfo);
        }
        // 预设组件
        LambdaQueryWrapper<LabelSystemPre> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(LabelSystemPre::getTenantId, Utils.getTenantId());
        wrapper.eq(LabelSystemPre::getClientType, Constants.ClientTypeTypeEnum.PC.getFlag());
        List<LabelSystemPre> systemPres = InterceptorIgnoreUtil.handler(() -> labelSystemPreMapper.selectList(wrapper));
        Map<Integer, LabelSystemPre> preIdMap = systemPres.stream()
                .collect(Collectors.toMap(LabelSystemPre::getDataType, Function.identity(), (a, b) -> a));

        // 自定义组件
        List<LabelSystemCustom> customList = new ArrayList<>();
        Map<Long, LabelSystemCustom> tenantCustomInfoMap = new HashMap<>();
        Map<Long, LabelSystemCustom> isvCustomInfoMap = new HashMap<>();
        // 查询轮播图中涉及的租户自定义组件ID
        List<Long> tenantCustomIds = buildCustomIdList(portalInfoContentList, Constants.LabelOrPoralSourceEnum.TENANT);
        if (CollectionUtils.isNotEmpty(tenantCustomIds)) {
            List<LabelSystemCustom> tenantCustomList = labelSystemCustomMapper.selectBatchIds(tenantCustomIds);
            tenantCustomInfoMap = tenantCustomList.stream().collect(Collectors.toMap(LabelSystemCustom::getId, Function.identity(), (a, b) -> a));
            customList.addAll(tenantCustomList);
        }
        // 查询轮播图中涉及的ISV自定义组件ID
        List<Long> isvCustomIds = buildCustomIdList(portalInfoContentList, Constants.LabelOrPoralSourceEnum.ISV);
        if (CollectionUtils.isNotEmpty(isvCustomIds)) {
            // 查询租户版本
            String tenantVersion = kmService.queryTenantVersionWithDefault();
            LambdaQueryWrapper<LabelSystemCustom> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.in(LabelSystemCustom::getComponentDesignerId, isvCustomIds);
            queryWrapper.eq(LabelSystemCustom::getVersion, tenantVersion);
            List<LabelSystemCustom> isvCustomList = labelSystemCustomMapper.selectList(queryWrapper);
            isvCustomInfoMap = isvCustomList.stream().collect(Collectors.toMap(LabelSystemCustom::getComponentDesignerId, Function.identity(), (a, b) -> a));
            customList.addAll(isvCustomList);
        }

        Map<Long, LabelSystemCustom> customInfoMap = new HashMap<>();
//        //自定义组件
//        List<PortalInfoContent> customDataList = portalInfoContentList.stream().filter(item -> Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal().equals(item.getContentType())).collect(Collectors.toList());
        // 没有权限的组件ID
        UserAuthSystemLabelVo authSystemLabelVo = new UserAuthSystemLabelVo();
        // 布局内容中涉及的自定义组件ID
//        List<Long> customIds = new ArrayList<>();
//        if (CollectionUtils.isNotEmpty(customDataList)) {
//            customIds = customDataList.stream().map(PortalInfoContent::getContentId).collect(Collectors.toList());
//        }
//        if (CollectionUtils.isNotEmpty(customIdsFormAttr)) {
//            customIds.addAll(customIdsFormAttr);
//        }
        if (CollectionUtils.isNotEmpty(customList)) {
//            List<LabelSystemCustom> customList = labelSystemCustomMapper.selectBatchIds(customIds);
            customInfoMap = customList.stream().collect(Collectors.toMap(LabelSystemCustom::getId, Function.identity(), (a, b) -> a));
            // 组件中的数据源
            HashSet<Long> customIdSet = new HashSet<>(customInfoMap.keySet());
            List<LabelSystemData> systemDataList = labelSystemDataMapper.queryBySystemIdList(customIdSet);
            // 过滤鼎捷雅典娜APP的作业权限，返回没有权限的组件ID
            authSystemLabelVo = mobileUserAuthService.buildSystemIdApp(systemDataList);
        }

//        List<PortalInfoContent> portalInfoContentRespList = new ArrayList<>();

        // 获取轮播图组件中链接的权限
        Map<String, Integer> linkMap = getWebLinkPermMap();
        // 组装图标和类型，名称翻译
        for (PortalInfoContent content : portalInfoContentList) {
            // 轮播图返回
            if (null != content.getDataType()
                    && Constants.DataTypeEnum.TYPE_CAROUSEL.getVal().equals(content.getDataType())) {
                PortalContentCarousel carouselInfo = JSON.parseObject(content.getContentAttr(), PortalContentCarousel.class);
                if (null == carouselInfo || CollectionUtils.isEmpty(carouselInfo.getImageList())) {
                    continue;
                }
                for (PortalContentCarouselImage image : carouselInfo.getImageList()) {
                    // 如果图标样式是图标，且 图标是上传dmc，组装返回url
                    String iconUrl = image.getContentIcon();
                    if (null != image.getImgType() &&
                            image.getImgType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())
                            && StringUtils.isNotEmpty(iconUrl)
                    ) {
                        iconUrl = envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + iconUrl;
                    }
                    // 如果图标样式是图标，且 图标是图标库，组装返回url
                    if (null != image.getImgType()
                            && image.getImgType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())
                            && StringUtils.isNotEmpty(iconUrl)
                    ) {
                        iconUrl = envProperties.getSemcWebUrl() + iconUrl;
                    }
                    image.setImageUrl(iconUrl);
                    String linkKey = image.getJumpType() + "-" + image.getJumpTarget();
                    image.setIsNeedCheckPerm(linkMap.get(linkKey));
                    // 跳转的目标是应用、作业、业务待办组件,取出回显的组件名称
                    if (Constants.WebLinkTypeEnum.APP.getVal().equals(image.getJumpType()) ||
                            Constants.WebLinkTypeEnum.JOB.getVal().equals(image.getJumpType()) ||
                            Constants.WebLinkTypeEnum.BUSINESS_TODO.getVal().equals(image.getJumpType())) {

                        LabelSystemCustom systemCustom;
                        // 区分ISV部件、租户部件
                        if (Constants.LabelOrPoralSourceEnum.ISV.getFlag().equals(image.getJumpSource())) {
                            systemCustom = isvCustomInfoMap.get(image.getJumpValue());
                        } else {
                            systemCustom = tenantCustomInfoMap.get(Long.parseLong(image.getJumpValue()));
                        }
                        if (null != systemCustom) {
                            image.setJumpName(systemCustom.getNameZh());
                        }

                    }
                }
                content.setCarouselInfo(carouselInfo);
            }
            // 预设部件才处理
            if (Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal().equals(content.getContentType())) {
                LabelSystemPre labelSystemPre = preIdMap.get(content.getDataType());
                Long contentId = Optional.ofNullable(labelSystemPre).map(LabelSystemPre::getId).orElse(null);
                if (contentId != null) {
                    content.setContentId(contentId);
                    content.setLabelTypeSource(Constants.LabelTypeSourceEnum.TENANT.getFlag());
                }
                content.setDataType(labelSystemPre == null ? null : labelSystemPre.getDataType());
                content.setDataCategory(labelSystemPre == null ? null : labelSystemPre.getDataCategory());
                content.setContentName(StringUtils.isEmpty(content.getContentName()) ? labelSystemPre == null ? "" : labelSystemPre.getName() : content.getContentName());
            }
            // 自定义组件
            if (Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal().equals(content.getContentType())) {
                content.setContentConfig(content.getContentAttr());
                // 鼎捷雅典娜APP 应用作业没有权限
                if (authSystemLabelVo.getNoPermSystemIdList().contains(content.getContentId())) {
                    continue;
                }
                LabelSystemCustom systemCustom;
                // 区分ISV部件、租户部件
                if (Constants.LabelOrPoralSourceEnum.ISV.getFlag().equals(content.getLabelTypeSource())) {
                    systemCustom = isvCustomInfoMap.get(content.getContentId());
                } else {
                    systemCustom = tenantCustomInfoMap.get(content.getContentId());
                }
                // 没有自定义组件
                if (systemCustom == null) {
                    continue;
                }
                content.setDataCategory(systemCustom.getDataCategory());
                content.setClassicsIcon(systemCustom.getClassicsIcon());
                content.setContentName(StringUtils.isEmpty(content.getContentName()) ? systemCustom.getNameZh() : content.getContentName());
                content.setWebLinkUrl(systemCustom.getLinkUrl());

                // 内嵌网页类型的组件，拼接链接参数
                if (Constants.DataCategoryEnum.WEB_PAGE.getVal().equals(systemCustom.getDataCategory())
                        && StringUtils.isNotBlank(systemCustom.getLinkParam())) {
                    StringBuilder stringBuilder = Utils.buildWebLinkUrl(systemCustom.getLinkParam());
                    String linkUrl = systemCustom.getLinkUrl() + "?" + stringBuilder;
                    content.setWebLinkUrl(linkUrl);
                }
            }
            if (StringUtils.isNotEmpty(content.getContentName())) {
                String name = translateService.translateTextCache(content.getContentName(), StringUtils.EMPTY);
                content.setContentName(name);
            }
//            portalInfoContentRespList.add(content);
        }
        portalInfo.setContentList(portalInfoContentList);
        return ResponseEntityWrapper.wrapperOk(portalInfo);
    }

    /**
     * 获取轮播图组件中跳转目标的权限
     *
     * @return
     */
    public Map<String, Integer> getWebLinkPermMap() {
        Map<String, Integer> linkMap = new HashMap<>();
        // 查询轮播图中链接选择项
        List<PortalSelectOptionRespDTO> optionRespDTOS = queryLinkList(null);
        for (PortalSelectOptionRespDTO optionRespDTO : optionRespDTOS) {
            String linkKey = optionRespDTO.getType() + "-";
            linkMap.put(linkKey, optionRespDTO.getIsNeedCheckPerm());
            if (CollectionUtils.isNotEmpty(optionRespDTO.getChildrenList())) {
                for (PortalSelectOptionRespDTO optionChildrenDTO : optionRespDTO.getChildrenList()) {
                    linkKey = optionRespDTO.getType() + "-" + optionChildrenDTO.getType();
                    linkMap.put(linkKey, optionChildrenDTO.getIsNeedCheckPerm());
                }
            }
        }
        return linkMap;
    }

    /**
     * 记录用户使用门户记录
     *
     * @param portId           门户 主键Id或 设计时Id
     * @param clientType       客户端类型 PC端：0，移动端：1
     * @param portalTypeSource 门户类型来源，0：租户门户，1：ISV门户
     */
    @Override
    @Transactional
    public void addUseRecord(Long portId, Integer clientType, Integer portalTypeSource) {
        // 先删除最新的
        QueryWrapper<PortalInfoUse> condition = new QueryWrapper<>();
        condition.eq("create_user_id", Utils.getUserId());
        condition.eq("client_type", clientType);
        portalInfoUseMapper.delete(condition);
        // 用户端查看门户详情，记录用户最近使用的门户
        PortalInfoUse infoUse = new PortalInfoUse();
        infoUse.setCreateUserId(Utils.getUserId());
        infoUse.setPortalId(portId);
        infoUse.setTenantId(Utils.getTenantId());
        infoUse.setClientType(clientType);
        infoUse.setPortalTypeSource(portalTypeSource);
        portalInfoUseMapper.insert(infoUse);
    }

    @Override
    @Transactional
    public void addUseRecordByMobile(AddUseRecordRequest req) {
        // 处理门户使用记录
        // 先删除历史的
        LambdaQueryWrapper<MobilePortalInfoUse> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(MobilePortalInfoUse::getCreateUserId, Utils.getUserId());
        mobilePortalInfoUseMapper.delete(wrapper);
        QueryWrapper<PortalInfoUse> condition = new QueryWrapper<>();
        condition.eq("create_user_id", Utils.getUserId());
        condition.eq("client_type", req.getClientType());
        portalInfoUseMapper.delete(condition);
        // 用户端查看门户详情，记录用户最近使用的门户
        PortalInfoUse infoUse = new PortalInfoUse();
        infoUse.setCreateUserId(Utils.getUserId());
        infoUse.setPortalId(req.getId());
        infoUse.setTenantId(Utils.getTenantId());
        infoUse.setClientType(req.getClientType());
        infoUse.setPortalTypeSource(req.getPortalTypeSource());
        portalInfoUseMapper.insert(infoUse);
    }

    /**
     * 解析门户内容获取轮播图中的组件ID
     *
     * @param portalInfoContentList 内容
     * @param labelTypeSource       部件类型来源，0：租户部件，1：ISV部件
     * @return
     */
    public List<Long> getPortalSystemId(List<PortalInfoContent> portalInfoContentList, Integer labelTypeSource) {
        List<Long> systemIdList = new ArrayList<>();
        for (PortalInfoContent contentAttr : portalInfoContentList) {
            // 不是轮播图或轮播图属性为空
            if (null == contentAttr.getDataType() || !Constants.DataTypeEnum.TYPE_CAROUSEL.getVal().equals(contentAttr.getDataType()) || StringUtils.isEmpty(contentAttr.getContentAttr())) {
                continue;
            }

            // 轮播图为空
            PortalContentCarousel carouselInfo = JSON.parseObject(contentAttr.getContentAttr(), PortalContentCarousel.class);
            if (null == carouselInfo || CollectionUtils.isEmpty(carouselInfo.getImageList())) {
                continue;
            }
            // 轮播图的图片集合
            for (PortalContentCarouselImage image : carouselInfo.getImageList()) {
                // 跳转的类型为空，跳转目标为空
                if (null == image.getJumpType() || StringUtils.isEmpty(image.getJumpValue()) || !labelTypeSource.equals(image.getJumpSource())) {
                    continue;
                }
                // 跳转的目标不是应用、作业、业务待办组件
                if (Constants.WebLinkTypeEnum.APP.getVal().equals(image.getJumpType()) ||
                        Constants.WebLinkTypeEnum.JOB.getVal().equals(image.getJumpType()) ||
                        Constants.WebLinkTypeEnum.BUSINESS_TODO.getVal().equals(image.getJumpType())) {
                    systemIdList.add(Long.parseLong(image.getJumpValue()));
                }
            }
        }
        return systemIdList;
    }

    /**
     * 获取pc或移动端门户详情
     *
     * @param portalInfo 门户内容
     * @return 返回
     */
    @Override
    public ResponseEntity<?> getPortalDetail(PortalInfo portalInfo) {
        PortalInfo portalInfoResp = new PortalInfo();
        if (Constants.ClientTypeEnum.PC.getValue().equals(portalInfo.getClientType())) {
            portalInfoResp = getPcPortalDetail(portalInfo);
        } else if (Constants.ClientTypeEnum.MOBILE.getValue().equals(portalInfo.getClientType())) {
            portalInfoResp = getMobilePortalDetail(portalInfo);
        }
        return ResponseEntityWrapper.wrapperOk(portalInfoResp);
    }

    /**
     * 获取PC端门户详情
     *
     * @param portalInfo 门户内容
     * @return 返回
     */
    public PortalInfo getPcPortalDetail(PortalInfo portalInfo) {
        // 如果是通用菜单，则赋值标识
        if (Constants.GENERAL_MENU_TEMPLATE_ID.equals(portalInfo.getMenuTemplateId())) {
            portalInfo.setMenuGeneralFlag(Constants.GENERAL_MENU_FLAG_YES);
        }
        // 查询内容信息
        List<PortalInfoContent> portalInfoContentList = portalInfoContentMapper.queryPortalCont(portalInfo.getId(), new ArrayList<>());
        if (CollectionUtils.isEmpty(portalInfoContentList)) {
            return portalInfo;
        }

        // 查询租户级预设组件
        Map<Long, LabelSystemPre> preInfoMap = new HashMap<>();
        List<PortalInfoContent> preDataList = portalInfoContentList.stream()
                .filter(item -> Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal().equals(item.getContentType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(preDataList)) {
            List<Long> preIds = preDataList.stream().map(PortalInfoContent::getContentId).collect(Collectors.toList());
            List<LabelSystemPre> preList = labelSystemPreMapper.selectBatchIds(preIds);
            preInfoMap = preList.stream().collect(Collectors.toMap(LabelSystemPre::getId, Function.identity(), (a, b) -> a));
        }

        // 查询ISV预设组件
        List<Integer> dataTypeList = portalInfoContentList.stream().filter(x -> Constants.LabelOrPoralSourceEnum.ISV.getFlag().equals(x.getLabelTypeSource())
                        && Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal().equals(x.getContentType()))
                .map(PortalInfoContent::getDataType).collect(Collectors.toList());

        Map<Integer, LabelSystemPre> dataCategoryMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(dataTypeList)) {
            LambdaQueryWrapper<LabelSystemPre> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(LabelSystemPre::getClientType, portalInfo.getClientType());
            queryWrapper.eq(LabelSystemPre::getTenantId, Utils.getTenantId());
            queryWrapper.in(LabelSystemPre::getDataType, dataTypeList);
            List<LabelSystemPre> labelSystemPreList = labelSystemPreMapper.selectList(queryWrapper);
            dataCategoryMap = labelSystemPreList.stream().collect(Collectors.toMap(LabelSystemPre::getDataType, Function.identity(), (a, b) -> a));
        }

        List<LabelSystemCustom> customList = Lists.newArrayList();
        // 查询轮播图中涉及的租户自定义组件ID
        List<Long> tenantCustomIds = buildCustomIdList(portalInfoContentList, Constants.LabelOrPoralSourceEnum.TENANT);
        if (CollectionUtils.isNotEmpty(tenantCustomIds)) {
            customList = labelSystemCustomMapper.selectBatchIds(tenantCustomIds);
        }

        // 查询轮播图中涉及的ISV自定义组件ID
        List<Long> isvCustomIds = buildCustomIdList(portalInfoContentList, Constants.LabelOrPoralSourceEnum.ISV);
        if (CollectionUtils.isNotEmpty(isvCustomIds)) {
            // 查询租户版本
            String tenantVersion = kmService.queryTenantVersion();
            LambdaQueryWrapper<LabelSystemCustom> wrapper = new LambdaQueryWrapper<>();
            wrapper.in(LabelSystemCustom::getComponentDesignerId, isvCustomIds);
            wrapper.eq(LabelSystemCustom::getVersion, tenantVersion);
            List<LabelSystemCustom> isvCustomList = InterceptorIgnoreUtil.handler(() -> labelSystemCustomMapper.selectList(wrapper));
            customList.addAll(isvCustomList);
        }

        Map<Long, LabelSystemCustom> customInfoMap = customList.stream().collect(Collectors.toMap(LabelSystemCustom::getId, Function.identity(), (a, b) -> a));
        // 组装图标和类型
        for (PortalInfoContent content : portalInfoContentList) {
            // 轮播图
            if (null != content.getDataType() && Constants.DataTypeEnum.TYPE_CAROUSEL.getVal().equals(content.getDataType())) {
                // 轮播图是放在门户内容中的
                PortalContentCarousel carouselInfo = JSON.parseObject(content.getContentAttr(), PortalContentCarousel.class);
                if (null == carouselInfo || CollectionUtils.isEmpty(carouselInfo.getImageList())) {
                    continue;
                }
                for (PortalContentCarouselImage image : carouselInfo.getImageList()) {
                    // 如果图标样式是图标，且 图标是上传dmc，组装返回url
                    String iconUrl = image.getContentIcon();
                    if (null != image.getImgType() && image.getImgType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag()) && StringUtils.isNotEmpty(iconUrl)) {
                        iconUrl = envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + iconUrl;
                    }
                    // 如果图标样式是图标，且 图标是图标库，组装返回url
                    if (null != image.getImgType() && image.getImgType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag()) && StringUtils.isNotEmpty(iconUrl)) {
                        iconUrl = envProperties.getSemcWebUrl() + iconUrl;
                    }
                    image.setImageUrl(iconUrl);

                    // 跳转的目标是应用、作业、业务待办组件
                    if (Constants.WebLinkTypeEnum.APP.getVal().equals(image.getJumpType()) ||
                            Constants.WebLinkTypeEnum.JOB.getVal().equals(image.getJumpType()) ||
                            Constants.WebLinkTypeEnum.BUSINESS_TODO.getVal().equals(image.getJumpType())) {
                        LabelSystemCustom systemCustom = customInfoMap.get(Long.parseLong(image.getJumpValue()));
                        if (null != systemCustom) {
                            image.setJumpName(systemCustom.getNameZh());
                        }
                    }
                }
                content.setCarouselInfo(carouselInfo);
            }
            // 预设组件
            if (ComponentSourceEnum.LABEL_SYSTEM_PRE.getCode().equals(content.getContentType())) {
                LabelSystemPre labelSystemPre = preInfoMap.get(content.getContentId());

                if (Constants.LabelOrPoralSourceEnum.TENANT.getFlag().equals(content.getLabelTypeSource())) {
                    labelSystemPre = preInfoMap.get(content.getContentId());
                } else if (Constants.LabelOrPoralSourceEnum.ISV.getFlag().equals(content.getLabelTypeSource())) {
                    labelSystemPre = dataCategoryMap.get(content.getDataType());
                }
                content.setDataType(labelSystemPre == null ? null : labelSystemPre.getDataType());
                content.setContentId(labelSystemPre == null ? content.getContentId() : labelSystemPre.getId());
            }
            // 自定义组件
            if (ComponentSourceEnum.LABEL_SYSTEM_CUSTOM.getCode().equals(content.getContentType())) {
                content.setContentConfig(content.getContentAttr());
                LabelSystemCustom systemCustom = customInfoMap.get(content.getContentId());
                if (systemCustom == null) {
                    continue;
                }
                content.setContentName(StringUtils.isEmpty(content.getContentName()) ? systemCustom.getNameZh() : content.getContentName());
                content.setClassicsIcon(systemCustom.getClassicsIcon());
                content.setDataCategory(systemCustom.getDataCategory());
                content.setWebLinkUrl(systemCustom.getLinkUrl());
                // 内嵌网页类型的组件，拼接链接参数
                if (Constants.DataCategoryEnum.WEB_PAGE.getVal().equals(systemCustom.getDataCategory())
                        && StringUtils.isNotBlank(systemCustom.getLinkParam())) {
                    StringBuilder stringBuilder = Utils.buildWebLinkUrl(systemCustom.getLinkParam());
                    String linkUrl = systemCustom.getLinkUrl() + "?" + stringBuilder;
                    content.setWebLinkUrl(linkUrl);
                }
            }
        }
        portalInfo.setContentList(portalInfoContentList);
        return portalInfo;
    }

    /**
     * 获取移动端门户详情
     *
     * @param portalInfo 门户内容
     * @return 返回
     */
    @Override
    public PortalInfo getMobilePortalDetail(PortalInfo portalInfo) {
        // 查询移动门户内容信息
        List<PortalInfoContent> portalInfoContentList = portalInfoContentMapper.queryPortalCont(portalInfo.getId(), new ArrayList<>());
        if (CollectionUtils.isEmpty(portalInfoContentList)) {
            return portalInfo;
        }

        // 查询租户级预设组件
        List<Long> preIds = portalInfoContentList.stream().map(PortalInfoContent::getContentId).collect(Collectors.toList());
        List<LabelSystemPre> preList = labelSystemPreMapper.selectBatchIds(preIds);
        Map<Long, LabelSystemPre> preInfoMap = preList.stream().collect(Collectors.toMap(LabelSystemPre::getId, Function.identity(), (a, b) -> a));


        // 查询ISV预设组件
        List<Integer> dataCategoryList = portalInfoContentList.stream().filter(x -> Constants.LabelOrPoralSourceEnum.ISV.getFlag().equals(x.getLabelTypeSource()))
                .map(PortalInfoContent::getContentType).collect(Collectors.toList());
        Map<Integer, LabelSystemPre> dataCategoryMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(dataCategoryList)) {
            LambdaQueryWrapper<LabelSystemPre> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(LabelSystemPre::getClientType, portalInfo.getClientType());
            queryWrapper.eq(LabelSystemPre::getTenantId, Utils.getTenantId());
            queryWrapper.in(LabelSystemPre::getDataCategory, dataCategoryList);
            List<LabelSystemPre> labelSystemPreList = labelSystemPreMapper.selectList(queryWrapper);
            dataCategoryMap = labelSystemPreList.stream().collect(Collectors.toMap(LabelSystemPre::getDataCategory, Function.identity(), (a, b) -> a));
        }

        // 返回预设组件名称并翻译
        for (PortalInfoContent portalInfoContent : portalInfoContentList) {
            LabelSystemPre labelSystemPre = new LabelSystemPre();
            if (Constants.LabelOrPoralSourceEnum.TENANT.getFlag().equals(portalInfoContent.getLabelTypeSource())) {
                labelSystemPre = preInfoMap.get(portalInfoContent.getContentId());
            } else if (Constants.LabelOrPoralSourceEnum.ISV.getFlag().equals(portalInfoContent.getLabelTypeSource())) {
                labelSystemPre = dataCategoryMap.get(portalInfoContent.getContentType());
            }
            String contentNamePre = labelSystemPre == null ? portalInfoContent.getContentName() : labelSystemPre.getName();
            String contentName = translateService.translateTextCache(contentNamePre, StringUtils.EMPTY);
            portalInfoContent.setContentName(contentName);

            // 金刚区，组装金刚球信息
            if (Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal().equals(portalInfoContent.getContentType())) {
                PortalContentKingKongDistrict kingKongDistrict = JSON.parseObject(portalInfoContent.getContentAttr(), PortalContentKingKongDistrict.class);
                for (PortalContentKingKongDistrictBall bill : kingKongDistrict.getBallList()) {
                    //  bill.setBallName(portalInfoContent.getContentName());
                    if (StringUtils.isNotBlank(bill.getContentIcon()) && ObjectUtils.isNotEmpty(bill.getIconType())) {
                        if (bill.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                            bill.setIconUrl(this.buildUrl(bill.getContentIcon(), portalInfoContent.getLabelTypeSource(), bill.getIconUrl()));
                        } else if (bill.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())) {
                            bill.setIconUrl(envProperties.getSemcWebUrl() + bill.getContentIcon());
                        }
                    }
                }
                portalInfoContent.setContentConfig(kingKongDistrict);
            }
            // 组装轮播图
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_CAROUSEL.getVal().equals(portalInfoContent.getContentType())) {
                MobilePortalContentCarousel carouselInfo = JSON.parseObject(portalInfoContent.getContentAttr(), MobilePortalContentCarousel.class);
                portalInfoContent.setContentConfig(carouselInfo);
            }
            // 组装公告
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_NEWS.getVal().equals(portalInfoContent.getContentType())) {
                MobilePortalContentNews newsInfo = JSON.parseObject(portalInfoContent.getContentAttr(), MobilePortalContentNews.class);
                if (newsInfo.getNewsLikeCountFlag() == null) {
                    newsInfo.setNewsLikeCountFlag(0);
                }
                portalInfoContent.setContentConfig(newsInfo);
            }
            // 组装标题
            if (Constants.PrtalMobileContentTypeEnum.TITLE.getVal().equals(portalInfoContent.getContentType())) {
                MobilePortalTitleInfoReqDTO titleInfo = JSON.parseObject(portalInfoContent.getContentAttr(), MobilePortalTitleInfoReqDTO.class);
                // 如果图标样式是图标，且 图标是上传dmc，组装返回url
                String iconUrl = titleInfo.getIcon();
                if (null != titleInfo.getIconType()
                        && titleInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())
                        && StringUtils.isNotEmpty(iconUrl)
                ) {
                    iconUrl = this.buildUrl(iconUrl, portalInfoContent.getLabelTypeSource(), titleInfo.getIconUrl());
                }
                // 如果图标样式是图标，且 图标是图标库，组装返回url
                if (null != titleInfo.getIconType()
                        && titleInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())
                        && StringUtils.isNotEmpty(iconUrl)
                ) {
                    iconUrl = envProperties.getSemcWebUrl() + iconUrl;
                }
                titleInfo.setIconUrl(iconUrl);
                portalInfoContent.setContentConfig(titleInfo);
            }
            // 组装分割线
            if (Constants.PrtalMobileContentTypeEnum.DIVIDER.getVal().equals(portalInfoContent.getContentType())) {
                MobilePortalDividerInfoReqDTO dividerInfo = JSON.parseObject(portalInfoContent.getContentAttr(), MobilePortalDividerInfoReqDTO.class);
                portalInfoContent.setContentConfig(dividerInfo);
            }
            // 图标组件保存
            if (Constants.PrtalMobileContentTypeEnum.PICTURE.getVal().equals(portalInfoContent.getContentType())) {
                MobilePortalImageInfoReqDTO imageCompInfo = JSON.parseObject(portalInfoContent.getContentAttr(), MobilePortalImageInfoReqDTO.class);
                if (null != imageCompInfo && StringUtils.isNotEmpty(imageCompInfo.getImageId())
                ) {
                    imageCompInfo.setImageUrl(this.buildUrl(imageCompInfo.getImageId(), portalInfoContent.getLabelTypeSource(), imageCompInfo.getImageUrl()));
                }
                portalInfoContent.setContentConfig(imageCompInfo);
            }
            // 业务入口组件保存
            if (Constants.PrtalMobileContentTypeEnum.BUSINESS_ENTRANCE.getVal().equals(portalInfoContent.getContentType())) {
                MobilePortalBusinessInfoReqDTO businessCompInfo = JSON.parseObject(portalInfoContent.getContentAttr(), MobilePortalBusinessInfoReqDTO.class);
                if (null != businessCompInfo && CollectionUtils.isNotEmpty(businessCompInfo.getImageList())) {
                    for (MobilePortalBusImageReqDTO image : businessCompInfo.getImageList()) {
                        image.setImageUrl(this.buildUrl(image.getImageId(), portalInfoContent.getLabelTypeSource(), image.getImageUrl()));
                    }
                }
                portalInfoContent.setContentConfig(businessCompInfo);
            }
            // H5外链
            if (Constants.PrtalMobileContentTypeEnum.H5_LINK.getVal().equals(portalInfoContent.getContentType())) {
                portalInfoContent.setContentConfig(JSON.parseObject(portalInfoContent.getContentAttr(), Object.class));
            }
        }
        portalInfo.setContentList(portalInfoContentList);
        return portalInfo;
    }

    private String buildUrl(String fileId, Integer labelTypeSource, String fullUrl) {
        String url = StringUtils.isEmpty(fileId) ? "" : envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + fileId;
        if (Constants.LabelTypeSourceEnum.ISV.getFlag().equals(labelTypeSource)) {
            // isv 部件
            if (StringUtils.isNotBlank(fullUrl) && fullUrl.startsWith("https://")) {
                url = fullUrl;
            }
        }
        return url;
    }

    @Override
    public PortalInfoUse getUserPortal() {
        LambdaQueryWrapper<PortalInfoUse> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(PortalInfoUse::getTenantId, Utils.getTenantId()).eq(PortalInfoUse::getCreateUserId, Utils.getUserId()).eq(PortalInfoUse::getClientType, 1);
        PortalInfoUse portalInfoUse = portalInfoUseMapper.selectOne(queryWrapper);
        if (Objects.nonNull(portalInfoUse)) {
            Long portalId = portalInfoUse.getPortalId();
            PortalInfo portalInfo = null;
            if (Constants.PortalTypeSourceEnum.ISV.getFlag().equals(portalInfoUse.getPortalTypeSource())) {
                // isv
                portalInfo = queryPortalInfoByDesignerId(portalId);
            } else {
                LambdaQueryWrapper<PortalInfo> portalInfoLambdaQueryWrapper = new LambdaQueryWrapper<PortalInfo>()
                        .eq(PortalInfo::getId, portalId)
                        .eq(PortalInfo::getClientType, Constants.ClientTypeTypeEnum.MOBILE.getFlag());
                portalInfo = InterceptorIgnoreUtil.handler(() -> portalInfoMapper.selectOne(portalInfoLambdaQueryWrapper));
            }
            if (Objects.nonNull(portalInfo)) {
                portalInfoUse.setVersionDefault(portalInfo.getVersionDefault());
                portalInfoUse.setName(portalInfo.getName());
            } else {
                MobilePortalInfo mobilePortalInfo = InterceptorIgnoreUtil.handler(() -> mobilePortalInfoMapper.selectById(portalId));
                if (Objects.nonNull(mobilePortalInfo)) {
                    portalInfoUse.setVersionDefault(0);
                    portalInfoUse.setName(mobilePortalInfo.getName());
                } else {
                    return null;
                }
            }
            String tenantVersion = kmService.queryTenantVersionWithDefault();
            if (Objects.equals(1, portalInfoUse.getPortalTypeSource())) {
                if (Objects.nonNull(portalInfo) && Objects.nonNull(portalInfo.getPortalDesignerId())) {
                    LambdaQueryWrapper<PortalDeployMessage> portalDeployMessageLambdaQueryWrapper = new LambdaQueryWrapper();
                    LambdaQueryWrapper<PortalDeployMessage> in = portalDeployMessageLambdaQueryWrapper.eq(PortalDeployMessage::getPortalId, portalInfo.getPortalDesignerId())
                            .eq(PortalDeployMessage::getVersion, tenantVersion).eq(PortalDeployMessage::getUserSid, Utils.getUserSid()).eq(PortalDeployMessage::getClientType, 1);
                    List<PortalDeployMessage> portalDeployMessages = InterceptorIgnoreUtil.handler(() -> portalDeployMessageService.getBaseMapper().selectList(in));
                    if (CollectionUtils.isEmpty(portalDeployMessages)) {
                        portalInfoUse.setChanged(1);
                    } else {
                        portalInfoUse.setChanged(0);
                    }
                }
            }
            return portalInfoUse;
        }
        // 兼容移动历史数据
        LambdaQueryWrapper<MobilePortalInfoUse> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(MobilePortalInfoUse::getCreateUserId, Utils.getUserId());
        MobilePortalInfoUse mobilePortalInfoUse = mobilePortalInfoUseMapper.selectOne(lambdaQueryWrapper);
        if (mobilePortalInfoUse != null) {
            portalInfoUse = new PortalInfoUse();
            portalInfoUse.setId(mobilePortalInfoUse.getId());
            portalInfoUse.setTenantId(mobilePortalInfoUse.getTenantId());
            portalInfoUse.setClientType(Constants.ClientTypeEnum.MOBILE.getValue());
            portalInfoUse.setPortalId(mobilePortalInfoUse.getMobilePortalId());
            portalInfoUse.setPortalTypeSource(Constants.PortalTypeSourceEnum.TENANT.getFlag());
            portalInfoUse.setVersionDefault(0);
            MobilePortalInfo portalInfo = InterceptorIgnoreUtil.handler(() -> mobilePortalInfoMapper.selectById(mobilePortalInfoUse.getMobilePortalId()));
            if (Objects.nonNull(portalInfo)) {
                portalInfoUse.setName(portalInfo.getName());
            } else {
                return null;
            }
        }
        return portalInfoUse;
    }

    @Override
    public PortalInfo getDefaultPortal() {
        LambdaQueryWrapper<PortalInfo> portalInfoLambdaQueryWrapper = new LambdaQueryWrapper<>();
        portalInfoLambdaQueryWrapper.eq(PortalInfo::getDefaultFlag, 1).eq(PortalInfo::getClientType, 1).eq(PortalInfo::getTenantId, Utils.getTenantId());
        PortalInfo portalInfo = InterceptorIgnoreUtil.handler(() -> portalInfoMapper.selectOne(portalInfoLambdaQueryWrapper));
        if (Objects.isNull(portalInfo)) {
            portalInfo = initDefPortal(Constants.ClientTypeEnum.MOBILE.getValue());
        }
        return portalInfo;
    }

    /**
     * 过滤出内容中的自定义组件id
     *
     * @param portalInfoContentList 内容
     * @param tenant                部件类型来源，0：租户部件，1：ISV部件
     * @return 返回
     */
    private List<Long> buildCustomIdList(List<PortalInfoContent> portalInfoContentList, Constants.LabelOrPoralSourceEnum tenant) {
        // 查询轮播图中涉及的自定义组件ID
        List<Long> tenantCustomIdsFormAttr = getPortalSystemId(portalInfoContentList, tenant.getFlag());
        // 布局内容中涉及的自定义组件ID
        List<Long> tenantCustomIds = portalInfoContentList.stream()
                .filter(item -> Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal().equals(item.getContentType())
                        && tenant.getFlag().equals(item.getLabelTypeSource())).map(PortalInfoContent::getContentId).collect(Collectors.toList());
        tenantCustomIds.addAll(tenantCustomIdsFormAttr);
        return tenantCustomIds;
    }

    @Override
    public PortalInfo getTempPortal(Long id) {
        PortalInfo portalInfo = InterceptorIgnoreUtil.handler(() -> portalInfoMapper.getPortalById(id));
        return portalInfo;
    }

    @Override
    public ResponseEntity<?> checkPortalInfo(PortalInfo portalInfo) {
        PortalInfoCheckResp checkResp = new PortalInfoCheckResp();
        checkResp.setIsHavePort(false);
        QueryWrapper<PortalInfoAuth> condition = new QueryWrapper<>();
        QueryWrapper wrapper = labelSystemAuthService.getUserAuthCon(condition);
        wrapper.eq("client_type", portalInfo.getClientType());
        // 获取登录用户权限内门户
        List<PortalInfoAuth> portalInfoAuthList = portalInfoAuthMapper.selectList(wrapper);
        List<Long> portalIds = portalInfoAuthList.stream().map(PortalInfoAuth::getPortalId).collect(Collectors.toList());
        // 判断门户是否在权限内 -- 组件Id或设计时Id
        if (portalIds.contains(portalInfo.getId()) || portalIds.contains(portalInfo.getPortalDesignerId())) {
            checkResp.setIsHavePort(true);
        } else {
            String msg = messageUtils.getMessage(I18NKey.PORTAL_NOT_AUTH);
            if (portalInfo.getPortalType().equals(Constants.MobilePortalTypeEnum.CUSTOM_PORTAL.getFlag())) {
                msg = messageUtils.getMessage(I18NKey.MOBILE_PORTAL_CUSTOM_DEL);
            }
            checkResp.setErrorMsg(msg);
        }
        return ResponseEntityWrapper.wrapperOk(checkResp);
    }

    /**
     * 查询菜单模板关联的门户
     *
     * @param menuTempIdList 菜单模板id
     * @return 返回
     */
    @Override
    public List<PortalInfo> queryPortalByMenuTempId(List<Long> menuTempIdList) {
        QueryWrapper<PortalInfo> portalInfoWrapper = new QueryWrapper<>();
        portalInfoWrapper.in("menu_template_id", menuTempIdList);
        portalInfoWrapper.select("id", "menu_template_id");
        List<PortalInfo> portalInfoList = portalInfoMapper.selectList(portalInfoWrapper);
        return portalInfoList;
    }

    @Override
    public List<PortalSelectOptionRespDTO> queryLinkList(Integer isvDesign) {
        List<PortalSelectOptionRespDTO> optionRespDTOS = new ArrayList<>();
        QueryWrapper<PlatformInitConfig> platformWrapper = new QueryWrapper<>();
        platformWrapper.eq("scene_code", Constants.SceneCodeEnum.PORTAL_SELECT_OPTION.getCode());
        PlatformInitConfig platformInitConfig = platformInitConfigMapper.selectOne(platformWrapper);
        if (null == platformInitConfig) {
            return optionRespDTOS;
        }
        optionRespDTOS = JSON.parseArray(platformInitConfig.getConfigValue(), PortalSelectOptionRespDTO.class);
        if (ObjectUtil.equals(isvDesign, Constants.LabelOrPoralSourceEnum.ISV.getFlag())) {
            return optionRespDTOS.stream()
                    .filter(e -> Constants.WebLinkTypeEnum.getTenantDesign().contains(e.getType()))
                    .collect(Collectors.toList());
        }
        return optionRespDTOS;
    }

    @Override
    public WebLinkPermissionDTO checkLinkPerm(WebLinkPermissionDTO req) {

        // 预设组件：作业工作台、行事历
        // 自定义组件：应用、作业
        if (req.getType().equals(Constants.WebLinkTypeEnum.JOB_BENCH.getVal())
                || req.getType().equals(Constants.WebLinkTypeEnum.CALENDAR.getVal())
                || req.getType().equals(Constants.WebLinkTypeEnum.APP.getVal())
                || req.getType().equals(Constants.WebLinkTypeEnum.JOB.getVal())
        ) {

            Integer labelType = Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal();

            // 预设组件
            if (req.getType().equals(Constants.WebLinkTypeEnum.JOB_BENCH.getVal())
                    || req.getType().equals(Constants.WebLinkTypeEnum.CALENDAR.getVal())
            ) {
                labelType = Constants.LabelTypeEnum.SYSTEM_PRE.getVal();
                // 获取预设组件的ID
                req.setJumpValue(getPreSystemId(req.getType()) + "");
            }
            if (StringUtils.isEmpty(req.getJumpValue())) {
                req.setIsHavePerm(Boolean.FALSE);
                return req;
            }
            QueryWrapper condition = new QueryWrapper<LabelSystemAuth>();
            // 查询租户下用户的权限内组件
            List<LabelSystemAuth> bizObjAuthRelList = labelSystemAuthMapper.selectList(labelSystemAuthService.getUserAuthCon(condition));
            Map<String, LabelSystemAuth> labelSystemAuthMap = bizObjAuthRelList.stream()
                    .collect(Collectors.toMap(value -> value.getLabelId() + "-" + value.getLabelType(), value -> value, (key1, key2) -> key1));

            String authKey = req.getJumpValue() + "-" + labelType;
            // 所有组件都没有权限
            if (null == labelSystemAuthMap) {
                req.setIsHavePerm(Boolean.FALSE);
            }
            // 该组件没有权限
            if (null == labelSystemAuthMap.get(authKey)) {
                req.setIsHavePerm(Boolean.FALSE);
            }
        }
        // 单条公告
        if (req.getType().equals(Constants.WebLinkTypeEnum.NEWS_ONE.getVal())) {
            if (StringUtils.isEmpty(req.getJumpValue())) {
                req.setIsHavePerm(Boolean.FALSE);
                return req;
            }
            List<NewsAnnouncementAut> autList = newsAnnouncementAuthService.queryAuthNewsListByNewsTypeIdList(new ArrayList<>());
            // 都没有权限
            if (CollectionUtils.isEmpty(autList)) {
                req.setIsHavePerm(Boolean.FALSE);
                return req;
            }
            // 公告id去重
            List<Long> newsIdDistinctList = autList.stream().map(NewsAnnouncementAut::getNewsId).distinct().collect(Collectors.toList());
            // 该公告不在权限内
            if (!newsIdDistinctList.contains(Long.parseLong(req.getJumpValue()))) {
                req.setIsHavePerm(Boolean.FALSE);
                return req;
            }
        }
        return req;
    }

    /**
     * 获取预设组件对应的ID
     *
     * @param type web链接类型: 0-常用功能；1-待办；2-友情链接；3-消息；4-作业工作台；
     *             5-常用；6-收藏；7-升级说明；8-行事历
     * @return
     */
    public Long getPreSystemId(Integer type) {
        // 数据类型（0：待办、1：三方报表、2：新闻公告、3：邮件、4：常用、5：收藏、6：全局资讯、7：绩效、8：作业工作台、9：行事历）
        List<Integer> dataTypeList = new ArrayList<>();
        // 作业工作台
        if (type.equals(Constants.WebLinkTypeEnum.JOB_BENCH.getVal())) {
            dataTypeList.add(Constants.DataTypeEnum.TYPE_JOB.getVal());
            type = Constants.DataTypeEnum.TYPE_JOB.getVal();
        }
        // 行事历
        if (type.equals(Constants.WebLinkTypeEnum.CALENDAR.getVal())) {
            dataTypeList.add(Constants.DataTypeEnum.TYPE_CALENDAR.getVal());
            type = Constants.DataTypeEnum.TYPE_CALENDAR.getVal();
        }
        // 预设组件类型：
        List<LabelSystemPre> preSystemList = labelSystemPreService.initDefPortal(dataTypeList, Constants.ClientTypeEnum.PC.getValue());
        Map<Integer, LabelSystemPre> preInfoMap = preSystemList.stream().collect(Collectors.toMap(LabelSystemPre::getDataType, Function.identity(), (a, b) -> a));
        if (null == preInfoMap || null == preInfoMap.get(type)) {
            return null;
        }
        return preInfoMap.get(type).getId();
    }

//    public List<PortalInfo> queryCurrUserPortals() {
//        // 去cac查询用户授权的应用列表
//        List<UserAppDTO> userApps = cacService.queryUserApp();
//        if (CollectionUtils.isEmpty(userApps)) {
//            return new ArrayList<>();
//        }
//
//        LocalDateTime nowTime = LocalDateTime.now();
//        Set<String> appCodes = userApps.stream()
//                .filter(userApp -> nowTime.isBefore(userApp.getExpiredTime()))
//                .map(UserAppDTO::getId)
//                .collect(Collectors.toSet());
//        if (CollectionUtils.isEmpty(appCodes)) {
//            return new ArrayList<>();
//        }
//
//        // 去KM查询租户版本
//        String tenantVersion = kmService.queryTenantVersion();
//        tenantVersion = StringUtils.isBlank(tenantVersion) ? EnvOperateEnum.SWITCH.getVersion() : tenantVersion;
//
//        // 去workbench_related_app表中查询工作台应用列表
//        List<String> portalDesIds = relatedAppService.queryPortalList(appCodes, tenantVersion);
//        if (CollectionUtils.isEmpty(portalDesIds)) {
//            return new ArrayList<>();
//        }
//
//        // todo 根据用户门户授权过滤门户设计时id
//        String userId = AppAuthContextHolder.getContext().getAuthoredUser().getUserId();
//
//
//        return this.lambdaQuery()
//                .in(PortalInfo::getPortalDesignerId, portalDesIds)
//                .eq(PortalInfo::getVersion, tenantVersion)
//                .list();
//    }

    /**
     * 根据ISV设计时门户id查询门户信息
     *
     * @param designerId isv设计时门户id
     * @return 返回
     */
    @Override
    public PortalInfo queryPortalInfoByDesignerId(Long designerId) {
        // 查询租户版本
        String tenantVersion = kmService.queryTenantVersionWithDefault();

        // 根据isv设计时门户id和版本查询门户
        LambdaQueryWrapper<PortalInfo> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(PortalInfo::getPortalDesignerId, designerId);
        queryWrapper.eq(PortalInfo::getVersion, tenantVersion);
        List<PortalInfo> portalInfoList = InterceptorIgnoreUtil.handler(() -> portalInfoMapper.selectList(queryWrapper));
        if (CollectionUtils.isNotEmpty(portalInfoList)) {
            return portalInfoList.get(0);
        }
        return null;
    }

    @Override
    @Transactional
    public ResponseEntity<?> copyPortal(Long portalId, Boolean oldPortalFlag) {
        Long newPortalId = null;
        if (Boolean.TRUE.equals(oldPortalFlag)) {
            // 旧门户 -- 移动侧
            MobilePortalInfo mobilePortalInfo = mobilePortalService.getById(portalId);
            if (null == mobilePortalInfo) {
                String recentlyMsg = messageUtils.getMessage("error.message.choose.portal.recovery");
                return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, recentlyMsg);
            }
            newPortalId = this.copyPortalOfOldPortalMobile(portalId, mobilePortalInfo);
        } else {
            // 新门户
            PortalInfo portalInfo = InterceptorIgnoreUtil.handler(() -> portalInfoMapper.selectById(portalId));
            if (null == portalInfo) {
                String recentlyMsg = messageUtils.getMessage("error.message.choose.portal.recovery");
                return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, recentlyMsg);
            }
            if (WorkBenchConstant.SYSTEM_TENANT.equals(portalInfo.getTenantId())) {
                // isv门户
                newPortalId = this.copyPortalOfIsvPortal(portalId, portalInfo);
            } else {
                // 租户门户
                newPortalId = this.copyPortalOfTenantPortal(portalId, portalInfo);
            }
        }
        // 获取新门户信息
        return ResponseEntityWrapperUtil.wrapperOk(newPortalId);
    }


    private Long copyPortalOfIsvPortal(Long portalId, PortalInfo portalInfo) {
        if (Constants.ClientTypeTypeEnum.PC.getFlag().equals(portalInfo.getClientType())) {
            return this.copyPortalOfPortalPc(Constants.PortalTypeSourceEnum.ISV, portalId, portalInfo);
        }
        return this.copyPortalOfPortalMobile(Constants.PortalTypeSourceEnum.ISV, portalId, portalInfo, Constants.ClientTypeTypeEnum.MOBILE);
    }

    private Long copyPortalOfTenantPortal(Long portalId, PortalInfo portalInfo) {
        if (Constants.ClientTypeTypeEnum.PC.getFlag().equals(portalInfo.getClientType())) {
            return this.copyPortalOfPortalPc(Constants.PortalTypeSourceEnum.TENANT, portalId, portalInfo);
        }
        return this.copyPortalOfPortalMobile(Constants.PortalTypeSourceEnum.TENANT, portalId, portalInfo, Constants.ClientTypeTypeEnum.MOBILE);
    }

    /**
     * 复制PC端 门户
     *
     * @param portalTypeSourceEnum 门户类型来源
     * @param oldPortalId          旧门户id
     * @param portalInfo           旧门户信息
     * @return 新门户id
     */
    private Long copyPortalOfPortalPc(Constants.PortalTypeSourceEnum portalTypeSourceEnum, Long oldPortalId, PortalInfo portalInfo) {
        Long templateId = null;
        if (Constants.PortalTypeSourceEnum.ISV == portalTypeSourceEnum) {
            // isv门户，拷贝ISV菜单
            templateId = this.copyIsvMenu(portalInfo.getName(), portalInfo.getMenuTemplateId());
            if (null != templateId) {
                portalInfo.setMenuTemplateId(templateId);
            } else {
                // isv 菜单创建失败
                portalInfo.setMenuTemplateId(null);
            }
            portalInfo.setMenuTypeSource(Constants.SourceEnum.TENANT.getFlag());
        }
        // 拷贝门户、门户内容、门户权限
        Long newPortalId = this.copyPortalOfPortalMobile(portalTypeSourceEnum, oldPortalId, portalInfo, Constants.ClientTypeTypeEnum.PC);
        if (templateId != null) {
            // isv更新菜单 关联门户Id
            CustomizedMenuTemplate template = new CustomizedMenuTemplate();
            template.setId(templateId);
            template.setPortalId(newPortalId);
            InterceptorIgnoreUtil.handler(() -> customizedMenuTemplateMapper.updateById(template));
        }
        return newPortalId;
    }

    /**
     * 拷贝isv菜单
     *
     * @param name           门户名称
     * @param menuDesignerId 设计时菜单id
     * @return 新菜单id
     */
    private Long copyIsvMenu(String name, Long menuDesignerId) {
        if (null == menuDesignerId) {
            return null;
        }
        // 查询租户版本
        String tenantVersion = kmService.queryTenantVersionWithDefault();
        LambdaQueryWrapper<CustomizedMenuTemplate> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(CustomizedMenuTemplate::getMenuDesignerId, menuDesignerId)
                .eq(CustomizedMenuTemplate::getVersion, tenantVersion);
        CustomizedMenuTemplate template = InterceptorIgnoreUtil.handler(() -> customizedMenuTemplateMapper.selectOne(wrapper));
        if (ObjectUtils.isEmpty(template)) {
            return null;
        }
        Long oldMenuTemplateId = template.getId();

        // 保存新菜单
        template.setId(null);
        // 置空 ISV参数
        template.setMenuDesignerId(null);
        template.setWorkbenchAppCode(null);
        template.setVersion(null);
        template.setCompileVersion(null);
        // 注意：租户复制ISV门户时，复制的菜单publish_source=ISV(因为不在菜单模块显示)，但menu_designer_id、version、compile_version、workbench_app_code都为null
        template.setPublishSource(template.getPublishSource());
        // 重置相关参数
        template.setTemplateStatus(Constants.ReleaseEnum.RELEASED.getVal());
        // isv菜单复制时。租户使用iSV的租户，不可使用当前租户，因为不在菜单模块显示
//        template.setTenantId(Utils.getTenantId());
        template.setCreateUserName(Utils.getUserName());
        template.setCreateTime(DateUtils.getNowTime(""));
        template.setModifyUserName(Utils.getUserName());
        template.setModifyTime(DateUtils.getNowTime(""));
        template.setModifyUserId(Utils.getUserId());
        // 重置名称
        int length = name.length();
        if (length > 27) {
            name = name.substring(0, 27);
        }
        template.setTemplateName(name + "-菜单");
        template.setTemplateNameTw(name + "-菜单");
        customizedMenuTemplateMapper.insert(template);
        Long newMenuTemplateId = template.getId();

        // 查询自定义菜单树
        // 查询菜单列表
        QueryWrapper<CustomizedMenuWork> condition = new QueryWrapper<>();
        condition.eq("template_id", oldMenuTemplateId);
        condition.orderByAsc("menu_order");
        condition.orderByAsc("id");
        List<CustomizedMenuWork> menuList = InterceptorIgnoreUtil.handler(() -> customizedMenuWorkMapper.selectList(condition));
        Map<Long, CustomizedMenuWork> menuWorkMap = menuList.stream().collect(Collectors.toMap(CustomizedMenuWork::getId, Function.identity(), (a, b) -> a));
        List<CustomizedMenuWorkResp> menuWorkRespList = customizedMenuWorkService.queryManageMenu(oldMenuTemplateId);
        // 遍历自定义菜单树，保存新菜单树
        for (CustomizedMenuWorkResp menuWorkResp : menuWorkRespList) {
            this.copyIsvMenuWork(menuWorkMap, menuWorkResp, newMenuTemplateId, null);
        }
        return newMenuTemplateId;
    }

    /**
     * 拷贝isv菜单项
     *
     * @param menuWorkResp      旧菜单项
     * @param newMenuTemplateId 新菜单id
     * @param parentId          父级菜单项id
     */
    private void copyIsvMenuWork(Map<Long, CustomizedMenuWork> menuWorkMap, CustomizedMenuWorkResp menuWorkResp, Long newMenuTemplateId, Long parentId) {
        CustomizedMenuWork menuWork = menuWorkMap.get(menuWorkResp.getId());
        menuWork.setId(null);
        menuWork.setTemplateId(newMenuTemplateId);
        menuWork.setParentId(parentId);
        // 重置相关参数
        menuWork.setTenantId(Utils.getTenantId());
        menuWork.setCreateUserId(Utils.getUserId());
        menuWork.setCreateTime(DateUtils.getNowTime(""));
        menuWork.setModifyTime(DateUtils.getNowTime(""));
        menuWork.setModifyUserId(Utils.getUserId());
        customizedMenuWorkService.save(menuWork);
        if (CollectionUtils.isNotEmpty(menuWorkResp.getChildren())) {
            for (CustomizedMenuWorkResp child : menuWorkResp.getChildren()) {
                this.copyIsvMenuWork(menuWorkMap, child, newMenuTemplateId, menuWork.getId());
            }
        }
    }

    /**
     * 复制移动端 门户
     *
     * @param portalTypeSourceEnum 门户类型来源
     * @param oldPortalId          旧门户id
     * @param portalInfo           旧门户信息
     * @return 新门户id
     */
    private Long copyPortalOfPortalMobile(Constants.PortalTypeSourceEnum portalTypeSourceEnum, Long
            oldPortalId, PortalInfo portalInfo, Constants.ClientTypeTypeEnum clientTypeEnum) {
        // 保存新门户信息
        portalInfo.setId(null);
        if (Constants.PortalTypeSourceEnum.ISV == portalTypeSourceEnum) {
            // 置空 ISV参数
            portalInfo.setPortalDesignerId(null);
            portalInfo.setWorkbenchAppCode(null);
            portalInfo.setVersion(null);
            portalInfo.setCompileVersion(null);
            portalInfo.setPublishSource(PublishSourceEnum.TENANT.name());
        }
        // 重置相关参数
        portalInfo.setTenantId(Utils.getTenantId());
        portalInfo.setStatus(Constants.ReleaseEnum.NO_RELEASE.getVal());
        portalInfo.setCreateUserName(Utils.getUserName());
        portalInfo.setCreateTime(DateUtils.getNowTime(""));
        portalInfo.setModifyUserName(Utils.getUserName());
        portalInfo.setModifyTime(DateUtils.getNowTime(""));
        portalInfo.setModifyUserId(Utils.getUserId());
        String name = portalInfo.getName();
        // 重置名称
        int length = name.length();
        if (length > 12) {
            name = name.substring(0, 12);
        }
        name = name + "_" + DateUtils.getNowTime(DateUtils.DATE_TIME_FORMATTER + Constants.MOBILE_PORTAL_COPY_NAME);
        portalInfo.setName(name);
        portalInfoMapper.insert(portalInfo);

        Long newPortalId = portalInfo.getId();
        // 查询旧门户内容
        LambdaQueryWrapper<PortalInfoContent> contentWrapper = new LambdaQueryWrapper<>();
        contentWrapper.eq(PortalInfoContent::getPortalId, oldPortalId);
        List<PortalInfoContent> contentList = InterceptorIgnoreUtil.handler(() -> portalInfoContentMapper.selectList(contentWrapper));

        // 获取预设部件
        LambdaQueryWrapper<LabelSystemPre> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(LabelSystemPre::getTenantId, Utils.getTenantId());
        wrapper.eq(LabelSystemPre::getClientType, clientTypeEnum.getFlag());
        List<LabelSystemPre> systemPres = InterceptorIgnoreUtil.handler(() -> labelSystemPreMapper.selectList(wrapper));
        Map<Integer, LabelSystemPre> preIdMap = null;
        if (Constants.ClientTypeTypeEnum.PC == clientTypeEnum) {
            preIdMap = systemPres.stream()
                    .collect(Collectors.toMap(LabelSystemPre::getDataType, Function.identity(), (a, b) -> a));
        } else {
            preIdMap = systemPres.stream()
                    .collect(Collectors.toMap(LabelSystemPre::getDataCategory, Function.identity(), (a, b) -> a));
        }

        // 保存新门户内容
        for (PortalInfoContent content : contentList) {
            content.setId(null);
            // 复制isv门户时，租户门户内容预设部件插入具体租户下的预设部件ID
            if (Constants.PortalTypeSourceEnum.ISV == portalTypeSourceEnum) {
                if (Constants.ClientTypeTypeEnum.PC == clientTypeEnum) {
                    // 预设部件才处理
                    if (ComponentSourceEnum.LABEL_SYSTEM_PRE.getCode().equals(content.getContentType())) {
                        Long contentId = Optional.ofNullable(preIdMap.get(content.getDataType())).map(LabelSystemPre::getId).orElse(null);
                        if (contentId != null) {
                            content.setContentId(contentId);
                            content.setLabelTypeSource(Constants.LabelTypeSourceEnum.TENANT.getFlag());
                        }
                    }
                } else {
                    // 预设部件才处理
                    if (Constants.PrtalMobileContentTypeEnum.isPreContent(content.getContentType())) {
                        Long contetnId = Optional.ofNullable(preIdMap.get(content.getContentType())).map(LabelSystemPre::getId).orElse(null);
                        if (contetnId != null) {
                            content.setContentId(contetnId);
                            content.setLabelTypeSource(Constants.LabelTypeSourceEnum.TENANT.getFlag());
                        }
                    }
                }
            }
            content.setTenantId(Utils.getTenantId());
            content.setPortalId(newPortalId);
            content.setCreateTime(DateUtils.getNowTime(""));
            portalInfoContentMapper.insert(content);
        }

        // 查询旧门户权限
        LambdaQueryWrapper<PortalInfoAuth> authWrapper = new LambdaQueryWrapper<>();
        authWrapper.eq(PortalInfoAuth::getPortalId, oldPortalId);
        List<PortalInfoAuth> portalAuthList = InterceptorIgnoreUtil.handler(() -> portalInfoAuthMapper.selectList(authWrapper));
        // 保存新门户权限
        for (PortalInfoAuth auth : portalAuthList) {
            auth.setId(null);
            if (Constants.PortalTypeSourceEnum.ISV == portalTypeSourceEnum) {
                // 重置 门户类型来源 为 租户
                auth.setPortalTypeSource(Constants.PortalTypeSourceEnum.TENANT.getFlag());
            }
            auth.setTenantId(Utils.getTenantId());
            auth.setPortalId(newPortalId);
            auth.setCreateTime(DateUtils.getNowTime(""));
            portalInfoAuthMapper.insert(auth);
        }
        return newPortalId;
    }

    /**
     * 旧门户复制 -- 移动端
     *
     * @param oldPortalId      旧门户id
     * @param mobilePortalInfo 旧门户信息
     * @return 新门户id
     */
    private Long copyPortalOfOldPortalMobile(Long oldPortalId, MobilePortalInfo mobilePortalInfo) {
        // 保存新门户信息
        PortalInfo pcPortalInfo = new PortalInfo();
        pcPortalInfo.setId(null);
        pcPortalInfo.setPortalTypeSource(Constants.PortalTypeSourceEnum.TENANT.getFlag());
        pcPortalInfo.setClientType(Constants.ClientTypeTypeEnum.MOBILE.getFlag());
        pcPortalInfo.setPortalType(mobilePortalInfo.getPortalType());
        pcPortalInfo.setTitle(mobilePortalInfo.getTitle());
        pcPortalInfo.setBgColor(mobilePortalInfo.getBgColor());
        pcPortalInfo.setPortalDesignerId(null);
        pcPortalInfo.setWorkbenchAppCode(null);
        pcPortalInfo.setParentId(0L);
        pcPortalInfo.setTemplateId(null);
        pcPortalInfo.setDefaultFlag(mobilePortalInfo.getDefaultFlag());
        pcPortalInfo.setName(mobilePortalInfo.getName());
        pcPortalInfo.setPortalDesc(mobilePortalInfo.getPortalDesc());
        pcPortalInfo.setMenuTemplateId(null);
        pcPortalInfo.setStatus(Constants.ReleaseEnum.NO_RELEASE.getVal());
        pcPortalInfo.setPortalContent(mobilePortalInfo.getPortalContent());
        pcPortalInfo.setPortalImgId(mobilePortalInfo.getPortalImgId());
        pcPortalInfo.setTenantId(mobilePortalInfo.getTenantId());
        pcPortalInfo.setCreateUserName(Utils.getUserName());
        pcPortalInfo.setCreateTime(DateUtils.getNowTime(""));
        pcPortalInfo.setModifyUserName(Utils.getUserName());
        pcPortalInfo.setModifyTime(DateUtils.getNowTime(""));
        pcPortalInfo.setModifyUserId(Utils.getUserId());
        pcPortalInfo.setPublishSource(PublishSourceEnum.TENANT.name());
        String name = mobilePortalInfo.getName();
        // 重置名称
        int length = name.length();
        if (length > 12) {
            name = name.substring(0, 12);
        }
        name = name + "_" + DateUtils.getNowTime(DateUtils.DATE_TIME_FORMATTER) + Constants.MOBILE_PORTAL_COPY_NAME;
        pcPortalInfo.setName(name);
        pcPortalInfo.setVersionDefault(0);
        portalInfoMapper.insert(pcPortalInfo);

        // 查询旧门户内容
        List<MobilePortalInfoContent> contentList = mobilePortalInfoContentMapper.queryMobiePortalCont(oldPortalId, new ArrayList<>());
        // 排除的内容ID集合
        List<Long> excludeContentId = new ArrayList<>();
        // 金刚区特殊处理
        Long newPortalId = pcPortalInfo.getId();
        // 金刚区特殊处理
        List<MobilePortalInfoContent> districList = contentList.stream().filter(r -> Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal().equals(r.getContentType())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(districList)) {
            for (MobilePortalInfoContent content : districList) {
                PortalContentKingKongDistrict kingKongDistrict = new PortalContentKingKongDistrict();
                kingKongDistrict.setIsNameShow(content.getIsNameShow());
                kingKongDistrict.setInteractionType(content.getInteractionType());
                kingKongDistrict.setCustomType(content.getCustomType());
                kingKongDistrict.setColumnNum(content.getColumnNum());
                kingKongDistrict.setLineNum(content.getLineNum());
                // 金刚区下级菜单
                List<MobilePortalInfoContent> child = contentList.stream()
                        .filter(r -> content.getId().equals(r.getParentId()))
                        .collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(child)) {
                    kingKongDistrict.setBallList(child.stream().map(r -> {
                        excludeContentId.add(r.getId());
                        PortalContentKingKongDistrictBall ball = new PortalContentKingKongDistrictBall();
                        ball.setBallName(r.getContentName());
                        ball.setIconType(r.getIconType());
                        ball.setContentIcon(r.getContentIcon());
                        ball.setIconUrl(r.getIconUrl());
                        ball.setJumpType(r.getJumpType());
                        ball.setJumpTarget(r.getJumpTarget());
                        ball.setCustomApplicationId(r.getCustomApplicationId());
                        return ball;
                    }).collect(Collectors.toList()));
                }
                // 保存金刚区下级菜单
                content.setContentAttr(JSON.toJSONString(kingKongDistrict));
            }
        }
        // 获取新的预设部件
        LambdaQueryWrapper<LabelSystemPre> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(LabelSystemPre::getTenantId, Utils.getTenantId());
        wrapper.eq(LabelSystemPre::getClientType, Constants.ClientTypeTypeEnum.MOBILE.getFlag());
        Map<Integer, Long> preIdMap = InterceptorIgnoreUtil.handler(() -> labelSystemPreMapper.selectList(wrapper)).stream()
                .collect(Collectors.toMap(LabelSystemPre::getDataCategory, LabelSystemPre::getId, (key1, key2) -> key2));
        // 保存新门户内容
        for (MobilePortalInfoContent content : contentList) {
            if (excludeContentId.contains(content.getId())) {
                // 排除金刚区的内容
                continue;
            }
            PortalInfoContent pcContent = new PortalInfoContent();
            pcContent.setId(null);
            pcContent.setParentId(0L);
            pcContent.setLabelTypeSource(Constants.LabelTypeSourceEnum.TENANT.getFlag());
            pcContent.setPortalId(newPortalId);
            pcContent.setContentId(preIdMap.get(content.getContentType()));
            pcContent.setContentType(content.getContentType());
            pcContent.setContentName(content.getContentName());
            pcContent.setTenantId(content.getTenantId());
            pcContent.setContentUuid(content.getContentUuid());
            pcContent.setContentAttr(content.getContentAttr());
            pcContent.setCreateTime(DateUtils.getNowTime(""));
            portalInfoContentMapper.insert(pcContent);
        }

        // 查询旧门户权限
        LambdaQueryWrapper<MobilePortalInfoAuth> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MobilePortalInfoAuth::getMobilePortalId, oldPortalId);
        List<MobilePortalInfoAuth> mobilePortalAuthList = InterceptorIgnoreUtil.handler(() -> mobilePortalInfoAuthMapper.selectList(queryWrapper));
        // 保存新门户权限内容
        for (MobilePortalInfoAuth mobilePortalAuth : mobilePortalAuthList) {
            PortalInfoAuth auth = new PortalInfoAuth();
            auth.setId(null);
            auth.setAuthId(mobilePortalAuth.getAuthId());
            auth.setAuthName(mobilePortalAuth.getAuthName());
            auth.setAuthType(mobilePortalAuth.getAuthType());
            auth.setTenantId(mobilePortalInfo.getTenantId());
            auth.setPortalId(newPortalId);
            auth.setPortalTypeSource(Constants.PortalTypeSourceEnum.TENANT.getFlag());
            auth.setCreateTime(DateUtils.getNowTime(""));
            portalInfoAuthMapper.insert(auth);
        }
        return newPortalId;
    }


    @Override
    public PortalInfo getUserMobilePortalInfo(UserPortalInfoRequest req) {
        PortalInfo result = new PortalInfo();
        List<PortalInfoContent> portalInfoContents = new ArrayList<>();
        String version = kmService.queryTenantVersionWithDefault();
        if (Constants.PortalTypeSourceEnum.ISV.getFlag().equals(req.getPortalTypeSource())) {
            // isv门户，区分1.0版本和2.0版本
            LambdaQueryWrapper<PortalInfo> queryWrapper = new LambdaQueryWrapper<PortalInfo>()
                    .eq(PortalInfo::getPortalDesignerId, req.getId())
                    .eq(PortalInfo::getVersion, version);
            result = InterceptorIgnoreUtil.handler(() -> portalInfoMapper.selectOne(queryWrapper));
            if (result != null) {
                // 查询内容信息
                portalInfoContents = portalInfoContentMapper.queryPortalCont(result.getId(), new ArrayList<>());
            }
        } else {
            // 需使用clientType过滤, 兼容移动历史数据，防止不同客户端的门户ID相同
            LambdaQueryWrapper<PortalInfo> queryWrapper = new LambdaQueryWrapper<PortalInfo>()
                    .eq(PortalInfo::getId, req.getId())
                    .eq(PortalInfo::getClientType, req.getClientType());
            result = InterceptorIgnoreUtil.handler(() -> portalInfoMapper.selectOne(queryWrapper));
            if (result != null) {
                // 查询内容信息
                portalInfoContents = portalInfoContentMapper.queryPortalCont(result.getId(), new ArrayList<>());
            }
            if (result == null && Constants.ClientTypeEnum.MOBILE.getValue().equals(req.getClientType())) {
                // 兼容移动历史数据
                MobilePortalInfo mobilePortalInfo = mobilePortalInfoMapper.selectById(req.getId());
                if (mobilePortalInfo != null) {
                    result = new PortalInfo();
                    BeanUtils.copyProperties(mobilePortalInfo, result);
                    result.setClientType(Constants.ClientTypeEnum.MOBILE.getValue());
                    result.setMenuTypeSource(Constants.MenuTypeSourceEnum.TENANT.getFlag());
                    result.setPublishSource(PublishSourceEnum.TENANT.name());

                    LambdaQueryWrapper<MobilePortalInfoContent> wrapper = new LambdaQueryWrapper<>();
                    wrapper.eq(MobilePortalInfoContent::getMobilePortalId, mobilePortalInfo.getId());
                    List<MobilePortalInfoContent> mobilePortalInfoContentsSql = mobilePortalInfoContentMapper.selectList(wrapper);
                    // 历史数据金刚区结构转换成新结构
                    // 金刚球
                    Map<Long, List<MobilePortalInfoContent>> ballMap = mobilePortalInfoContentsSql.stream()
                            .filter(x -> Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal().equals(x.getContentType()))
                            .collect(Collectors.groupingBy(MobilePortalInfoContent::getParentId));
                    // 排除金刚球的内容
                    portalInfoContents = mobilePortalInfoContentsSql.stream()
                            .filter(x -> !Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal().equals(x.getContentType()))
                            .map(r -> {
                                PortalInfoContent portalInfoContent = new PortalInfoContent();
                                BeanUtils.copyProperties(r, portalInfoContent);
                                portalInfoContent.setLabelTypeSource(Constants.LabelTypeSourceEnum.TENANT.getFlag());
                                if (Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal().equals(r.getContentType())) {
                                    // 金刚区
                                    PortalContentKingKongDistrict district = new PortalContentKingKongDistrict();
                                    district.setIsNameShow(r.getIsNameShow());
                                    district.setInteractionType(r.getInteractionType());
                                    district.setCustomType(r.getCustomType());
                                    district.setColumnNum(r.getColumnNum());
                                    district.setLineNum(r.getLineNum());
                                    // 金刚区下级菜单
                                    List<MobilePortalInfoContent> ballList = ballMap.get(r.getId());
                                    if (CollectionUtils.isNotEmpty(ballList)) {
                                        district.setBallList(ballList.stream().map(content -> {
                                            PortalContentKingKongDistrictBall ball = new PortalContentKingKongDistrictBall();
                                            ball.setBallName(content.getContentName());
                                            ball.setIconType(content.getIconType());
                                            ball.setContentIcon(content.getContentIcon());
                                            ball.setJumpType(content.getJumpType());
                                            ball.setJumpTarget(content.getJumpTarget());
                                            ball.setCustomApplicationId(content.getCustomApplicationId());
                                            // 构建跳转链接
                                            if (ObjectUtils.isNotEmpty(content.getIconType())) {
                                                if (content.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                                                    ball.setIconUrl(envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + ball.getContentIcon());
                                                } else if (content.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())) {
                                                    ball.setIconUrl(envProperties.getSemcWebUrl() + ball.getContentIcon());
                                                }
                                            }
                                            return ball;
                                        }).collect(Collectors.toList()));
                                    }
                                    portalInfoContent.setContentAttr(JSON.toJSONString(district));
                                }
                                return portalInfoContent;
                            }).collect(Collectors.toList());
                }
            }
        }

        if (ObjectUtils.isEmpty(result)) {
            return result;
        }
        if (CollectionUtils.isEmpty(portalInfoContents)) {
            return result;
        }

        List<PortalInfoContent> resultContentList = new ArrayList<>();
        for (PortalInfoContent content : portalInfoContents) {
            // 金刚球
            if (Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal().equals(content.getContentType())) {
                continue;
            }
            // 如果是金刚区则添加相关的金刚球
            if (Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal().equals(content.getContentType())) {
                PortalContentKingKongDistrict district = JSON.parseObject(content.getContentAttr(), PortalContentKingKongDistrict.class);
                if (Constants.DistrictCustomTypeEnum.TENANT_TYPE.getValue().equals(district.getCustomType())) {
                    List<PortalContentKingKongDistrictBall> ballList = district.getBallList();
                    // 过滤出有权限的应用列表
                    List<PortalContentKingKongDistrictBall> ballAuth = filterPermissionBallList(ballList);
                    ballAuth.forEach(ball -> {
                        // 构建跳转链接
                        if (ObjectUtils.isNotEmpty(ball.getIconType())) {
                            if (ball.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                                ball.setIconUrl(this.buildUrl(ball.getContentIcon(), content.getLabelTypeSource(), ball.getIconUrl()));
                            } else if (ball.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())) {
                                ball.setIconUrl(envProperties.getSemcWebUrl() + ball.getContentIcon());
                            }
                        }
                    });
                    district.setBallList(ballAuth);
                    content.setContentAttr(JSON.toJSONString(district));
                    resultContentList.add(content);
                }
                if (Constants.DistrictCustomTypeEnum.USER_TYPE.getValue().equals(district.getCustomType())) {
                    resultContentList.addAll(buildColumnDistrict(content));
                }
                continue;
            }
            // 组装轮播图
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_CAROUSEL.getVal().equals(content.getContentType())) {
                MobilePortalContentCarousel carouselInfo = JSON.parseObject(content.getContentAttr(), MobilePortalContentCarousel.class);
                for (MobilePortalContentCarouselImage image : carouselInfo.getImageList()) {
                    String icon = image.getContentIcon();
                    // 处理图标-图标库
                    if (null != image.getImgType()
                            && image.getImgType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())
                            && StringUtils.isNotEmpty(icon)
                    ) {
                        icon = envProperties.getSemcWebUrl() + icon;
                    }
                    image.setContentIcon(icon);
                }
                content.setContentAttr(JSON.toJSONString(carouselInfo));
            }
            // 组装公告
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_NEWS.getVal().equals(content.getContentType())) {
                MobilePortalContentNews newsInfo = JSON.parseObject(content.getContentAttr(), MobilePortalContentNews.class);
                if (null != newsInfo) {
                    if (newsInfo.getNewsLikeCountFlag() == null) {
                        newsInfo.setNewsLikeCountFlag(0);
                    }
                    // 如果选择的是二级，是以逗号分隔，则取第一个值作为一级公告类型ID，第二个值作为二级公告类型ID
                    if (StringUtils.isNotEmpty(newsInfo.getNewsTypeIdStr()) && newsInfo.getNewsTypeIdStr().contains(",")) {
                        String[] newsTypeIds = newsInfo.getNewsTypeIdStr().split(",");
                        if (newsTypeIds.length >= 2) {
                            newsInfo.setChildrenNewsTypeId(Integer.parseInt(newsTypeIds[1]));
                            newsInfo.setNewsTypeId(Integer.parseInt(newsTypeIds[0]));
                        }
                    }
                    // 只有一级
                    if (StringUtils.isNotEmpty(newsInfo.getNewsTypeIdStr()) && !newsInfo.getNewsTypeIdStr().contains(",")) {
                        newsInfo.setNewsTypeId(Integer.parseInt(newsInfo.getNewsTypeIdStr()));
                    }
                    content.setContentAttr(JSON.toJSONString(newsInfo));
                }
            }
            // 组装标题
            if (Constants.PrtalMobileContentTypeEnum.TITLE.getVal().equals(content.getContentType())) {
                MobilePortalTitleInfoReqDTO titleInfo = JSON.parseObject(content.getContentAttr(), MobilePortalTitleInfoReqDTO.class);
                // 如果图标样式是图标，且 图标是上传dmc，组装返回url
                String iconUrl = titleInfo.getIcon();
                if (null != titleInfo.getIconType() &&
                        titleInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())
                        && StringUtils.isNotEmpty(iconUrl)
                ) {
                    iconUrl = this.buildUrl(iconUrl, content.getLabelTypeSource(), titleInfo.getIconUrl());
                }
                // 如果图标样式是图标，且 图标是图标库，组装返回url
                if (null != titleInfo.getIconType()
                        && titleInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())
                        && StringUtils.isNotEmpty(iconUrl)
                ) {
                    iconUrl = envProperties.getSemcWebUrl() + iconUrl;
                }
                titleInfo.setIconUrl(iconUrl);
                content.setContentAttr(JSON.toJSONString(titleInfo));
            }
            // 组装分割线
            if (Constants.PrtalMobileContentTypeEnum.DIVIDER.getVal().equals(content.getContentType())) {
                MobilePortalDividerInfoReqDTO dividerInfo = JSON.parseObject(content.getContentAttr(), MobilePortalDividerInfoReqDTO.class);
                content.setContentAttr(JSON.toJSONString(dividerInfo));
            }
            // 图标组件保存
            if (Constants.PrtalMobileContentTypeEnum.PICTURE.getVal().equals(content.getContentType())) {
                MobilePortalImageInfoReqDTO imageCompInfo = JSON.parseObject(content.getContentAttr(), MobilePortalImageInfoReqDTO.class);
                if (null != imageCompInfo && StringUtils.isNotEmpty(imageCompInfo.getImageId())
                ) {
                    imageCompInfo.setImageUrl(this.buildUrl(imageCompInfo.getImageId(), content.getLabelTypeSource(), imageCompInfo.getImageUrl()));
                }
                content.setContentAttr(JSON.toJSONString(imageCompInfo));
            }
            // 业务入口组件保存
            if (Constants.PrtalMobileContentTypeEnum.BUSINESS_ENTRANCE.getVal().equals(content.getContentType())) {
                MobilePortalBusinessInfoReqDTO businessCompInfo = JSON.parseObject(content.getContentAttr(), MobilePortalBusinessInfoReqDTO.class);
                if (null != businessCompInfo && CollectionUtils.isNotEmpty(businessCompInfo.getImageList())) {
                    for (MobilePortalBusImageReqDTO image : businessCompInfo.getImageList()) {
                        image.setImageUrl(this.buildUrl(image.getImageId(), content.getLabelTypeSource(), image.getImageUrl()));
                    }
                }
                content.setContentAttr(JSON.toJSONString(businessCompInfo));
            }
            // H5外链
            if (Constants.PrtalMobileContentTypeEnum.H5_LINK.getVal().equals(content.getContentType())) {
                Map<String, Object> contentInfo = Optional.ofNullable(JSON.parseObject(content.getContentAttr(), Map.class)).orElse(new HashMap<>());
                if (Constants.LabelTypeSourceEnum.TENANT.getFlag().equals(content.getLabelTypeSource())) {
                    // 租户部件
                    AppLinkDTO appLinkDTO = labelSystemClickService.queryCustomJumpLink(content.getContentId());
                    //权限判断，有权限则处理
                    if (null != appLinkDTO && appLinkDTO.getIsHavePerm()) {
                        contentInfo.put("cloudwebsite", appLinkDTO.getCloudwebsite());
                    }
                } else {
                    // isv部件
                    contentInfo.put("cloudwebsite", envProperties.getHomePageUrl());
                }
                content.setContentAttr(JSON.toJSONString(contentInfo));
            }
            resultContentList.add(content);
        }
        result.setContentList(resultContentList);
        return result;
    }

    /**
     * 过滤出有权限的应用列表
     *
     * @param ballResps 应用列表
     * @return 返回
     */
    private List<PortalContentKingKongDistrictBall> filterPermissionBallList(List<PortalContentKingKongDistrictBall> ballResps) {
        // 不是自定义应用类型的金刚球不参与校验
        List<Long> notCustomApplicationIdList = ballResps.stream().filter(x ->
                        !Constants.BallJumpTypeEnum.SSO_CONFIGURATION.getValue().equals(x.getJumpType()))
                .map(PortalContentKingKongDistrictBall::getCustomApplicationId).collect(Collectors.toList());
        // 过滤出自定义应用，校验当前用户是否有应用权限
        List<Long> customApplicationIdList = ballResps.stream().filter(
                        x -> Constants.BallJumpTypeEnum.SSO_CONFIGURATION.getValue().equals(x.getJumpType()))
                .map(PortalContentKingKongDistrictBall::getCustomApplicationId).collect(Collectors.toList());
        List<Long> withPermissionList = mobileUserAuthService.validUserAppAuth(customApplicationIdList);

        // 最终应用权限列表
        return ballResps.stream().filter(x -> notCustomApplicationIdList.contains(x.getCustomApplicationId())
                || withPermissionList.contains(x.getCustomApplicationId())).collect(Collectors.toList());
    }

    /**
     * 组装自定义金刚区
     */
    private List<PortalInfoContent> buildColumnDistrict(PortalInfoContent mobileContent) {
        List<PortalInfoContent> result = new ArrayList<>();
        String userId = Utils.getUserId();
        LambdaQueryWrapper<MobileApplicatonColumn> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MobileApplicatonColumn::getCreateUserId, userId).eq(MobileApplicatonColumn::getStatus, Constants.VALID_STATUS_ENABLE)
                .orderByAsc(MobileApplicatonColumn::getOrderId).orderByAsc(MobileApplicatonColumn::getId);
        // 查询自定义栏目
        List<MobileApplicatonColumn> mobileApplicatonColumns = applicatonColumnMapper.selectList(queryWrapper);
        // 自定义应用栏目map
        Map<Long, List<MobileApplicatonColumn>> appMap = mobileApplicatonColumns.stream().filter(x -> !ObjectUtils.isEmpty(x.getParentId()))
                .collect(Collectors.groupingBy(MobileApplicatonColumn::getParentId));
        List<Long> customAppIds = mobileApplicatonColumns.stream().filter(x -> ObjectUtils.isNotEmpty(x.getCustomApplicationId())).map(MobileApplicatonColumn::getCustomApplicationId).collect(Collectors.toList());
        // 查询自定义应用
        Map<Long, MobileDatasourceInfo> customAppMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(customAppIds)) {
            List<MobileDatasourceInfo> mobileDatasourceInfos = mobileCustomApplicationMapper.selectList(new LambdaQueryWrapper<MobileDatasourceInfo>().eq(MobileDatasourceInfo::getStatus, Constants.VALID_STATUS_ENABLE).in(MobileDatasourceInfo::getId, customAppIds));
            customAppMap = mobileDatasourceInfos.stream().collect(Collectors.toMap(MobileDatasourceInfo::getId, Function.identity()));
        }

        // 遍历自定义应用栏
        for (MobileApplicatonColumn mobileApplicatonColumn : mobileApplicatonColumns) {
            if (ObjectUtils.isNotEmpty(mobileApplicatonColumn.getParentId()) || ObjectUtils.isNotEmpty(mobileApplicatonColumn.getCustomApplicationId())) {
                continue;
            }
            PortalInfoContent resp = new PortalInfoContent();
            resp.setColumnId(mobileApplicatonColumn.getId());
            resp.setContentId(mobileContent.getContentId());
            resp.setContentType(Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal());
            resp.setContentName(mobileApplicatonColumn.getName());
            resp.setContentUuid(UUID.randomUUID().toString().replaceAll("-", ""));
            resp.setTitle(mobileApplicatonColumn.getName());
            resp.setIsTitleShow(mobileApplicatonColumn.getIsNameShow());

            PortalContentKingKongDistrict district = new PortalContentKingKongDistrict();
            PortalContentKingKongDistrict mobileDistrict = JSON.parseObject(mobileContent.getContentAttr(), PortalContentKingKongDistrict.class);
            resp.setIsNameShow(mobileDistrict.getIsNameShow());
            district.setIsNameShow(mobileDistrict.getIsNameShow());
            district.setInteractionType(mobileDistrict.getInteractionType());
            district.setCustomType(Constants.DistrictCustomTypeEnum.USER_TYPE.getValue());
            district.setColumnNum(mobileDistrict.getColumnNum());
            district.setLineNum(mobileDistrict.getLineNum());
            List<PortalContentKingKongDistrictBall> ballRespList = new ArrayList<>();
            if (appMap.containsKey(mobileApplicatonColumn.getId())) {
                List<MobileApplicatonColumn> columns = appMap.get(mobileApplicatonColumn.getId());
                for (MobileApplicatonColumn column : columns) {
                    MobileDatasourceInfo mobileDatasourceInfo;
                    Long customApplicationId = column.getCustomApplicationId();
                    if (customAppMap.containsKey(customApplicationId)) {
                        mobileDatasourceInfo = customAppMap.get(customApplicationId);
                    } else {
                        continue;
                    }
                    PortalContentKingKongDistrictBall ballResp = new PortalContentKingKongDistrictBall();
                    ballResp.setBallName(mobileDatasourceInfo.getName());
                    ballResp.setJumpType(Constants.BallJumpTypeEnum.SSO_CONFIGURATION.getValue());
                    ballResp.setJumpTarget(ObjectUtils.isEmpty(mobileDatasourceInfo.getCallBackUrl()) ? "" : mobileDatasourceInfo.getCallBackUrl());
                    String icon = mobileDatasourceInfo.getIcon();
                    // 处理图标-图标库
                    if (null != mobileDatasourceInfo.getIconType()
                            && mobileDatasourceInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())) {
                        icon = envProperties.getSemcWebUrl() + icon;
                    }
                    // 处理图标-自定义
                    if (null != mobileDatasourceInfo.getIconType()
                            && mobileDatasourceInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                        icon = envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + icon;
                    }
                    ballResp.setIconUrl(icon);
                    ballResp.setCustomApplicationId(customApplicationId);
                    ballRespList.add(ballResp);
                }
            }
            district.setBallList(ballRespList);
            resp.setContentAttr(JSON.toJSONString(district));
            result.add(resp);
        }
        if (CollectionUtils.isEmpty(result)) {
            result.add(mobileContent);
            return result;
        }
        // 过滤出有权限的应用列表
        List<PortalContentKingKongDistrictBall> ballList = new ArrayList<>();
        result.forEach(x -> {
            PortalContentKingKongDistrict mobileDistrict = JSON.parseObject(x.getContentAttr(), PortalContentKingKongDistrict.class);
            ballList.addAll(mobileDistrict.getBallList());
        });
        List<PortalContentKingKongDistrictBall> withPermissionList = filterPermissionBallList(ballList);
        List<Long> customApplicationIdList = withPermissionList.stream().map(PortalContentKingKongDistrictBall::getCustomApplicationId).collect(Collectors.toList());
        for (PortalInfoContent content : result) {
            PortalContentKingKongDistrict mobileDistrict = JSON.parseObject(content.getContentAttr(), PortalContentKingKongDistrict.class);
            List<PortalContentKingKongDistrictBall> resultBallList = mobileDistrict.getBallList().stream().filter(x -> customApplicationIdList.contains(x.getCustomApplicationId())).collect(Collectors.toList());
            mobileDistrict.setBallList(resultBallList);
            content.setContentAttr(JSON.toJSONString(mobileDistrict));
        }
        return result;
    }


    @Override
    public PortalInfo getUserMobilePortalDetail(PortalInfo req) {
        List<PortalInfoContent> contentRespList = req.getContentList();
        // 查询内容信息
        if (CollectionUtils.isEmpty(contentRespList)) {
            return req;
        }
        // 非默认布局，需要校验用户是否有该门户权限
        if (req.getDefaultFlag().equals(Constants.DEFAULT_CONFIGURED_FLAG_NO)) {

            QueryWrapper<PortalInfoAuth> condition = new QueryWrapper<>();
            QueryWrapper wrapper = labelSystemAuthService.getUserAuthCon(condition);
            // 区分客户端
            wrapper.eq("client_type", req.getClientType());

            // 获取登录用户权限内门户
            List<PortalInfoAuth> portalInfoAuthList = portalInfoAuthMapper.selectList(wrapper);
            List<MobilePortalInfoAuth> mobilePortalInfoAuths = new ArrayList<>();
            if (Constants.ClientTypeEnum.MOBILE.getValue().equals(req.getClientType())) {
                // 兼容移动历史数据
                // 获取登录用户权限内门户
                mobilePortalInfoAuths = mobilePortalInfoAuthMapper.selectList(labelSystemAuthService.getUserAuthCon(new QueryWrapper<>()));
            }
            // 获取登录用户权限内门户
            List<Long> portalIds = portalInfoAuthList.stream().map(PortalInfoAuth::getPortalId).collect(Collectors.toList());
            List<Long> mobilePortalIds = mobilePortalInfoAuths.stream().map(MobilePortalInfoAuth::getMobilePortalId).collect(Collectors.toList());
            portalIds.addAll(mobilePortalIds);
            String recentlyMsg = "";
            // 判断门户是否在权限内，不在则组装提示语
            if (!portalIds.contains(req.getId()) && !portalIds.contains(req.getPortalDesignerId())) {
                recentlyMsg = messageUtils.getMessage("error.message.not.auth");
                if (req.getPortalType().equals(Constants.MobilePortalTypeEnum.CUSTOM_PORTAL.getFlag())) {
                    recentlyMsg = messageUtils.getMessage(I18NKey.MOBILE_PORTAL_CUSTOM_DEL);
                }
                req.setRecentlyMsg(recentlyMsg);
                return req;
            }
        }
        // 移动侧预设部件、自定义部件
        LambdaQueryWrapper<LabelSystemPre> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(LabelSystemPre::getTenantId, Utils.getTenantId());
        wrapper.eq(LabelSystemPre::getClientType, Constants.ClientTypeEnum.MOBILE.getValue());
        List<LabelSystemPre> systemPres = InterceptorIgnoreUtil.handler(() -> labelSystemPreMapper.selectList(wrapper));
        Map<Integer, LabelSystemPre> systemPreMap = systemPres.stream().collect(Collectors.toMap(LabelSystemPre::getDataCategory, Function.identity(), (a, b) -> a));

        // 组装图标和类型，名称翻译
        for (PortalInfoContent content : contentRespList) {
            // 预设组件
            // 预设部件才处理
            if (Constants.PrtalMobileContentTypeEnum.isPreContent(content.getContentType())) {
                Long contetnId = Optional.ofNullable(systemPreMap.get(content.getContentType())).map(LabelSystemPre::getId).orElse(null);
                if (contetnId != null) {
                    content.setContentId(contetnId);
                    content.setLabelTypeSource(Constants.LabelTypeSourceEnum.TENANT.getFlag());
                }
            }
            if (Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal().equals(content.getContentType()) ||
                    Constants.PrtalMobileContentTypeEnum.PRE_TASK.getVal().equals(content.getContentType()) ||
                    Constants.PrtalMobileContentTypeEnum.PRE_PROJECT.getVal().equals(content.getContentType())) {
                LabelSystemPre labelSystemPre = systemPreMap.get(content.getContentType());
                content.setContentName(StringUtils.isEmpty(content.getContentName()) ? labelSystemPre.getName() : content.getContentName());
            }
        }
        req.setContentList(contentRespList);
        return req;
    }

    @Override
    public PortalInfo getPreMobilePortal(Long id) {
        PortalInfo result = new PortalInfo();
        MobilePortalPreview mobilePortalPreview = InterceptorIgnoreUtil.handler(() -> mobilePortalPreviewMapper.selectById(id));
        if (mobilePortalPreview == null) {
            String recentlyMsg = messageUtils.getMessage("error.message.not.auth");
            result.setRecentlyMsg(recentlyMsg);
            return result;
        }
        if (null != mobilePortalPreview.getEndTime() && mobilePortalPreview.getEndTime().before(new Date())) {
            String recentlyMsg = messageUtils.getMessage("error.message.choose.qr.code.invalid");
            result.setRecentlyMsg(recentlyMsg);
            return result;
        }
        BeanUtils.copyProperties(mobilePortalPreview, result);

        String portalContentListJson = mobilePortalPreview.getPortalContentList();
        List<MobilePortalInfoContentResp> mobilePortalInfoContentResps = JsonUtils.jsonToObject(portalContentListJson, new TypeReference<List<MobilePortalInfoContentResp>>() {
        });
        if (CollectionUtils.isEmpty(mobilePortalInfoContentResps)) {
            return result;
        }

        List<PortalInfoContent> contentList = new ArrayList<>();
        for (MobilePortalInfoContentResp contentResp : mobilePortalInfoContentResps) {
            PortalInfoContent portalInfoContent = new PortalInfoContent();
            BeanUtils.copyProperties(contentResp, portalInfoContent);
            portalInfoContent.setLabelTypeSource(contentResp.getLabelTypeSource());
            contentList.add(portalInfoContent);

            // 如果是金刚区则添加相关的金刚球
            if (Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal().equals(contentResp.getContentType())) {
                // 新旧结构兼容
                PortalContentKingKongDistrict district = this.buildDistrict(portalInfoContent, contentResp);
                List<PortalContentKingKongDistrictBall> ballList = district.getBallList();
                List<PortalContentKingKongDistrictBall> ballAuthResp = filterPermissionBallList(ballList);
                ballAuthResp.forEach(item -> {
                    item.setContentIcon(StringUtils.isNotBlank(item.getContentIcon()) ? item.getContentIcon() : Constants.CONTENT_ICON_DEF);
                    if (ObjectUtils.isNotEmpty(item.getIconType())) {
                        if (item.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                            item.setIconUrl(this.buildUrl(item.getContentIcon(), contentResp.getLabelTypeSource(), item.getIconUrl()));
                        } else if (item.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())) {
                            item.setIconUrl(envProperties.getSemcWebUrl() + item.getContentIcon());
                        }
                    }
                });
                portalInfoContent.setContentAttr(JSON.toJSONString(district));
            }
            // 组装公告
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_NEWS.getVal().equals(contentResp.getContentType())) {
                MobilePortalContentNews newsInfo = JSON.parseObject(contentResp.getContentAttr(), MobilePortalContentNews.class);
                if (null != newsInfo) {
                    if (newsInfo.getNewsLikeCountFlag() == null) {
                        newsInfo.setNewsLikeCountFlag(0);
                    }
                    // 如果选择的是二级，是以逗号分隔，则取第一个值作为一级公告类型ID，第二个值作为二级公告类型ID
                    if (StringUtils.isNotEmpty(newsInfo.getNewsTypeIdStr()) && newsInfo.getNewsTypeIdStr().contains(",")) {
                        String[] newsTypeIds = newsInfo.getNewsTypeIdStr().split(",");
                        if (newsTypeIds.length >= 2) {
                            newsInfo.setChildrenNewsTypeId(Integer.parseInt(newsTypeIds[1]));
                            newsInfo.setNewsTypeId(Integer.parseInt(newsTypeIds[0]));
                        }
                    }
                    // 只有一级
                    if (StringUtils.isNotEmpty(newsInfo.getNewsTypeIdStr()) && !newsInfo.getNewsTypeIdStr().contains(",")) {
                        newsInfo.setNewsTypeId(Integer.parseInt(newsInfo.getNewsTypeIdStr()));
                    }
                    portalInfoContent.setContentAttr(JSON.toJSONString(newsInfo));
                }
            }
            // 组装轮播图
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_CAROUSEL.getVal().equals(contentResp.getContentType())) {
                MobilePortalContentCarousel carouselInfo = JSON.parseObject(contentResp.getContentAttr(), MobilePortalContentCarousel.class);
                if (Objects.isNull(carouselInfo)) {
                    continue;
                }
                if (CollectionUtils.isNotEmpty(carouselInfo.getImageList())) {
                    for (MobilePortalContentCarouselImage image : carouselInfo.getImageList()) {
                        String icon = image.getContentIcon();
                        // 处理图标-图标库
                        if (null != image.getImgType()
                                && image.getImgType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())
                                && StringUtils.isNotEmpty(icon)
                        ) {
                            icon = envProperties.getSemcWebUrl() + icon;
                        }
                        image.setContentIcon(icon);
                    }
                }
                portalInfoContent.setContentAttr(JSON.toJSONString(carouselInfo));
            }
            // 组装标题
            if (Constants.PrtalMobileContentTypeEnum.TITLE.getVal().equals(contentResp.getContentType())) {
                MobilePortalTitleInfoReqDTO titleInfo = JSON.parseObject(contentResp.getContentAttr(), MobilePortalTitleInfoReqDTO.class);
                // 如果图标样式是图标，且 图标是上传dmc，组装返回url
                String iconUrl = titleInfo.getIcon();
                if (null != titleInfo.getIconType()
                        && StringUtils.isNotEmpty(iconUrl)
                        && titleInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                    iconUrl = this.buildUrl(iconUrl, contentResp.getLabelTypeSource(), titleInfo.getIconUrl());
                }
                // 如果图标样式是图标，且 图标是图标库，组装返回url
                if (null != titleInfo.getIconType()
                        && StringUtils.isNotEmpty(iconUrl)
                        && titleInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())) {
                    iconUrl = envProperties.getSemcWebUrl() + iconUrl;
                }
                titleInfo.setIconUrl(iconUrl);
                portalInfoContent.setContentAttr(JSON.toJSONString(titleInfo));
            }
            // 组装分割线
            if (Constants.PrtalMobileContentTypeEnum.DIVIDER.getVal().equals(contentResp.getContentType())) {
                MobilePortalDividerInfoReqDTO dividerInfo = JSON.parseObject(contentResp.getContentAttr(), MobilePortalDividerInfoReqDTO.class);
                portalInfoContent.setContentAttr(JSON.toJSONString(dividerInfo));
            }
            // 图标组件保存
            if (Constants.PrtalMobileContentTypeEnum.PICTURE.getVal().equals(contentResp.getContentType())) {
                MobilePortalImageInfoReqDTO imageCompInfo = JSON.parseObject(contentResp.getContentAttr(), MobilePortalImageInfoReqDTO.class);
                if (null != imageCompInfo && StringUtils.isNotEmpty(imageCompInfo.getImageId())
                ) {
                    imageCompInfo.setImageUrl(this.buildUrl(imageCompInfo.getImageId(), contentResp.getLabelTypeSource(), imageCompInfo.getImageUrl()));
                }
                portalInfoContent.setContentAttr(JSON.toJSONString(imageCompInfo));
            }
            // 业务入口组件保存
            if (Constants.PrtalMobileContentTypeEnum.BUSINESS_ENTRANCE.getVal().equals(contentResp.getContentType())) {
                MobilePortalBusinessInfoReqDTO businessCompInfo = JSON.parseObject(contentResp.getContentAttr(), MobilePortalBusinessInfoReqDTO.class);
                if (null != businessCompInfo && CollectionUtils.isNotEmpty(businessCompInfo.getImageList())) {
                    for (MobilePortalBusImageReqDTO image : businessCompInfo.getImageList()) {
                        image.setImageUrl(this.buildUrl(image.getImageId(), contentResp.getLabelTypeSource(), image.getImageUrl()));
                    }
                }
                portalInfoContent.setContentAttr(JSON.toJSONString(businessCompInfo));
            }
            // H5外链
            if (Constants.PrtalMobileContentTypeEnum.H5_LINK.getVal().equals(contentResp.getContentType())) {
                Map<String, Object> contentInfo = Optional.ofNullable(JSON.parseObject(contentResp.getContentAttr(), Map.class)).orElse(new HashMap<>());
                if (Constants.LabelTypeSourceEnum.TENANT.getFlag().equals(contentResp.getLabelTypeSource())) {
                    // 租户部件
                    AppLinkDTO appLinkDTO = labelSystemClickService.queryCustomJumpLink(contentResp.getContentId());
                    //权限判断，有权限则处理
                    if (null != appLinkDTO && appLinkDTO.getIsHavePerm()) {
                        contentInfo.put("cloudwebsite", appLinkDTO.getCloudwebsite());
                    }
                } else {
                    // isv部件
                    contentInfo.put("cloudwebsite", envProperties.getHomePageUrl());
                }
                portalInfoContent.setContentAttr(JSON.toJSONString(contentInfo));
            }
        }
        result.setContentList(contentList);
        return result;
    }

    private PortalContentKingKongDistrict buildDistrict(PortalInfoContent portalInfoContent, MobilePortalInfoContentResp contentResp) {
        PortalContentKingKongDistrict district = JSON.parseObject(portalInfoContent.getContentAttr(), PortalContentKingKongDistrict.class);
        if (null == district) {
            // 兼容历史数据
            district = new PortalContentKingKongDistrict();
            district.setIsNameShow(contentResp.getIsNameShow());
            district.setInteractionType(contentResp.getInteractionType());
            district.setCustomType(contentResp.getCustomType());
            district.setColumnNum(contentResp.getColumnNum());
            district.setLineNum(contentResp.getLineNum());
            List<BallResp> ballList = contentResp.getBallList();
            if (CollectionUtils.isEmpty(ballList)) {
                return district;
            }
            List<PortalContentKingKongDistrictBall> balls = ballList.stream().map(ball -> {
                return PortalContentKingKongDistrictBall.builder()
                        .ballName(ball.getBallName())
                        .jumpType(ball.getJumpType())
                        .jumpTarget(ball.getJumpTarget())
                        .contentIcon(ball.getContentIcon())
                        .iconType(ball.getIconType())
                        .iconUrl(ball.getIconUrl())
                        .customApplicationId(ball.getCustomApplicationId())
                        .build();
            }).collect(Collectors.toList());
            district.setBallList(balls);
            return district;
        }
        // 新结构
        return district;
    }

}