package com.digiwin.athena.semc.service.portal.impl;


import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.I18NKey;
import com.digiwin.athena.semc.common.ResultBean;
import com.digiwin.athena.semc.dto.portal.PortalLayoutCustomReq;
import com.digiwin.athena.semc.entity.portal.LabelSystemPre;
import com.digiwin.athena.semc.entity.portal.PortalLayoutCustom;
import com.digiwin.athena.semc.mapper.portal.LabelSystemPreMapper;
import com.digiwin.athena.semc.mapper.portal.PortalLayoutCustomMapper;
import com.digiwin.athena.semc.service.portal.LabelSystemPreService;
import com.digiwin.athena.semc.service.portal.PortalLayoutCustomService;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.portal.PortalLayoutCustomCustomQueryVO;
import com.digiwin.athena.semc.vo.portal.PortalLayoutCustomCustomResultVO;
import com.digiwin.athena.semc.vo.portal.PortalLayoutCustomPreQueryVO;
import com.digiwin.athena.semc.vo.portal.PortalLayoutCustomVO;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;


@Slf4j
@Service
public class PortalLayoutCustomServiceImpl extends ServiceImpl<PortalLayoutCustomMapper, PortalLayoutCustom> implements PortalLayoutCustomService {



    @Resource
    MessageUtils messageUtils;
    @Resource
    PortalLayoutCustomMapper portalLayoutCustomMapper;
    @Resource
    LabelSystemPreService labelSystemPreService;
    @Resource
    LabelSystemPreMapper labelSystemPreMapper;


    @Override
    public ResultBean queryPortalLayout() {
        ResultBean resultBean = new ResultBean();
        List<Object> resultList = new LinkedList<>();
        //初始化门户
        initPortalLayout();
        List<PortalLayoutCustomPreQueryVO> portalLayoutCustomPreQueryVOList
                = portalLayoutCustomMapper.listPre(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        // 预设组件名支持多语言
        String locale = LocaleContextHolder.getLocale().toString();
        if (Constants.ZH_TW_LOCALE.equals(locale)) {
            portalLayoutCustomPreQueryVOList.forEach(item -> {
                if (StringUtils.isNotEmpty(item.getNameTw())) {
                    item.setName(item.getNameTw());
                }
            });
        }
        List<PortalLayoutCustomCustomQueryVO> portalLayoutCustomCustomQueryVOList
                = portalLayoutCustomMapper.listCustom(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());

        resultList.addAll(portalLayoutCustomPreQueryVOList);
        resultList.addAll(portalLayoutCustomCustomQueryVOList);

        List<PortalLayoutCustomCustomResultVO> resultSerialList = JSON.parseArray(JSON.toJSONString(resultList), PortalLayoutCustomCustomResultVO.class);

        resultBean.setResponse(resultSerialList.stream()
                .sorted(Comparator.comparing(PortalLayoutCustomCustomResultVO::getLabelIndex))
                .collect(Collectors.toList()));
        return resultBean;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity<?> save(PortalLayoutCustomReq portalLayoutCustomReq) {
        List<PortalLayoutCustomVO> portalLayoutCustomList = new LinkedList<>();
        try {

            List<PortalLayoutCustomReq.PortalLayoutCustomInfo> saveList = portalLayoutCustomReq.getPortalLayoutInfo().stream()
                    .filter(e -> Objects.isNull(e.getPortalLayoutId())).collect(Collectors.toList());

            List<PortalLayoutCustomReq.PortalLayoutCustomInfo> updateList = portalLayoutCustomReq.getPortalLayoutInfo().stream()
                    .filter(e -> Objects.nonNull(e.getPortalLayoutId())).collect(Collectors.toList());

            if(!CollectionUtils.isEmpty(saveList)) {
                LambdaQueryWrapper<PortalLayoutCustom> queryValidWrapper = new LambdaQueryWrapper<>();
                queryValidWrapper.eq(PortalLayoutCustom::getTenantId,Utils.getTenantId());
                queryValidWrapper.eq(PortalLayoutCustom::getDelFlag, Constants.DEFAULT_CONFIGURED_FLAG_NO);
                List<PortalLayoutCustom> portalLayoutCustomSum = portalLayoutCustomMapper.selectList(queryValidWrapper);
                if(portalLayoutCustomSum.size() + saveList.size() > Constants.COMPONENT_SIZE){
                    String error = messageUtils.getMessage("error.message.system.portal.num.fail");
                    return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SAVE_PORTAL_LABEL, error);
                }

                for (PortalLayoutCustomReq.PortalLayoutCustomInfo data : saveList) {
                    LambdaQueryWrapper<PortalLayoutCustom> queryWrapper = new LambdaQueryWrapper<>();
                    queryWrapper.eq(PortalLayoutCustom::getTenantId,AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                    queryWrapper.eq(PortalLayoutCustom::getLabelType,data.getComponentSource());
                    queryWrapper.eq(PortalLayoutCustom::getLabelId,data.getId());
                    queryWrapper.eq(PortalLayoutCustom::getDelFlag, Constants.DEFAULT_CONFIGURED_FLAG_NO);
                    List<PortalLayoutCustom> portalLayoutCustomValid = portalLayoutCustomMapper.selectList(queryWrapper);
                    if(!CollectionUtils.isEmpty(portalLayoutCustomValid)) {
                        String error = String.format(messageUtils.getMessage("error.message.system.portal.type.exist.fail"), data.getId(),data.getComponentSource());
                        return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SAVE_PORTAL_LABEL, error);
                    }

                    PortalLayoutCustomVO portalLayoutCustom = new PortalLayoutCustomVO();
                    portalLayoutCustom.setDefaultFlag(0);
                    //如果是预设组件中待办、数智视图、常用、收藏，给默认值1
                    if(Constants.COMPONENTSOURCE_TYPE.equals(data.getComponentSource())) {
                        LambdaQueryWrapper<LabelSystemPre> queryPreWrapper = new LambdaQueryWrapper<>();
                        queryPreWrapper.eq(LabelSystemPre::getId,data.getId());
                        LabelSystemPre labelSystemPre = labelSystemPreMapper.selectOne(queryPreWrapper);
                        if(Constants.DataTypeEnum.TYPE_TODO.getVal().equals(labelSystemPre.getDataType())){
                            portalLayoutCustom.setDefaultFlag(1);
                        }
                        if (Constants.DataTypeEnum.TYPE_INFO.getVal().equals(labelSystemPre.getDataType())) {
                            portalLayoutCustom.setDefaultFlag(1);
                        }
                        if (Constants.DataTypeEnum.TYPE_COLLECT.getVal().equals(labelSystemPre.getDataType())) {
                            portalLayoutCustom.setDefaultFlag(1);
                        }
                        if (Constants.DataTypeEnum.TYPE_USE.getVal().equals(labelSystemPre.getDataType())) {
                            portalLayoutCustom.setDefaultFlag(1);
                        }

                    }
                    portalLayoutCustom.setLabelType(data.getComponentSource());
                    portalLayoutCustom.setLabelId(data.getId());
                    portalLayoutCustom.setLabelIndex(data.getLabelIndex());
                    portalLayoutCustom.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                    portalLayoutCustom.setCreateUserId(AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
                    portalLayoutCustomList.add(portalLayoutCustom);
                }

                portalLayoutCustomMapper.insertBatch(portalLayoutCustomList);
            }

            if(!CollectionUtils.isEmpty(updateList)) {
                updateList.forEach(data->{
                    // 排序
                    PortalLayoutCustom portalLayoutCustom = new PortalLayoutCustom();
                    portalLayoutCustom.setId(data.getPortalLayoutId());
                    portalLayoutCustom.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                    portalLayoutCustom.setLabelIndex(data.getLabelIndex());
                    portalLayoutCustom.setModifyUserId(AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
                    portalLayoutCustomMapper.updateByCondition(portalLayoutCustom);
                });
            }

        } catch (Exception e) {
            log.error("save portal.layout.custom error", e);
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SAVE_PORTAL_LABEL, messageUtils.getMessage(I18NKey.SAVE_PORTAL_LAYOUT));
        }

        return ResponseEntityWrapper.wrapperOk();
    }


    @Override
    public ResponseEntity<?> delete(Long id) {
        try {
            PortalLayoutCustom portalLayoutCustom= portalLayoutCustomMapper.selectById(id);
            if (null == portalLayoutCustom) {
                String error = messageUtils.getMessage("error.message.portal.not.exist.error");
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, error);
            }
            //比较租户
            if (!portalLayoutCustom.getTenantId().equals(Utils.getTenantId())) {
                String error = messageUtils.getMessage("error.message.portal.tenant.id.error");
                return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, error);
            }
            //标记已删除
            portalLayoutCustom.setDelFlag(Constants.DEFAULT_CONFIGURED_FLAG_YES);
            portalLayoutCustomMapper.updateById(portalLayoutCustom);
        } catch (Exception e) {
            log.error("del portal.layout.custom error", e);
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SAVE_PORTAL_LABEL, messageUtils.getMessage(I18NKey.DELETE_PORTAL_LAYOUT));
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    @Override
    public List<PortalLayoutCustom> initPortalLayout() {
        QueryWrapper queryWrapper = new QueryWrapper<PortalLayoutCustom>();
        queryWrapper.orderByAsc("label_index");
        queryWrapper.eq("tenant_id", Utils.getTenantId());
        List<PortalLayoutCustom> portalLayoutCustomList = portalLayoutCustomMapper.selectList(queryWrapper);
        //不为空，则不需要初始化，返回未删除的布局内容
        if (CollectionUtils.isNotEmpty(portalLayoutCustomList)) {
            //过滤已删除的数据
            portalLayoutCustomList=portalLayoutCustomList.stream().filter(item -> Constants.DEFAULT_CONFIGURED_FLAG_NO.equals(item.getDelFlag())).collect(Collectors.toList());
            return portalLayoutCustomList;
        }
        List<LabelSystemPre> labelSystemPreList = labelSystemPreService.initPreData(Constants.ClientTypeEnum.PC.getValue());
        // 过滤出待办、数智视图、常用、收藏
        List<PortalLayoutCustomVO> portalLayoutCustomPreList = labelSystemPreList.stream()
                .filter(e -> e.getDataType().equals(Constants.DataTypeEnum.TYPE_TODO.getVal())
                        || e.getDataType().equals(Constants.DataTypeEnum.TYPE_USE.getVal())
                        || e.getDataType().equals(Constants.DataTypeEnum.TYPE_COLLECT.getVal())
                        || e.getDataType().equals(Constants.DataTypeEnum.TYPE_INFO.getVal())
                )
                .map(item -> {
                    PortalLayoutCustomVO portalLayoutCustom = new PortalLayoutCustomVO();
                    if (Constants.DataTypeEnum.TYPE_TODO.getVal().equals(item.getDataType())) {
                        portalLayoutCustom.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                        portalLayoutCustom.setLabelId(item.getId());
                        portalLayoutCustom.setLabelIndex(1);
                        portalLayoutCustom.setLabelType(1);
                        portalLayoutCustom.setDefaultFlag(1);
                    }
                    if (Constants.DataTypeEnum.TYPE_INFO.getVal().equals(item.getDataType())) {
                        portalLayoutCustom.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                        portalLayoutCustom.setLabelId(item.getId());
                        portalLayoutCustom.setLabelIndex(2);
                        portalLayoutCustom.setLabelType(1);
                        portalLayoutCustom.setDefaultFlag(1);
                    }
                    if (Constants.DataTypeEnum.TYPE_COLLECT.getVal().equals(item.getDataType())) {
                        portalLayoutCustom.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                        portalLayoutCustom.setLabelId(item.getId());
                        portalLayoutCustom.setLabelIndex(3);
                        portalLayoutCustom.setLabelType(1);
                        portalLayoutCustom.setDefaultFlag(1);
                    }
                    if (Constants.DataTypeEnum.TYPE_USE.getVal().equals(item.getDataType())) {
                        portalLayoutCustom.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                        portalLayoutCustom.setLabelId(item.getId());
                        portalLayoutCustom.setLabelIndex(4);
                        portalLayoutCustom.setLabelType(1);
                        portalLayoutCustom.setDefaultFlag(1);
                    }

                    return portalLayoutCustom;
                }).collect(Collectors.toList());

        portalLayoutCustomMapper.insertBatch(portalLayoutCustomPreList);
        //查询未删除的布局内容
        queryWrapper.eq("del_flag", Constants.DEFAULT_CONFIGURED_FLAG_NO);
        portalLayoutCustomList = portalLayoutCustomMapper.selectList(queryWrapper);
        return portalLayoutCustomList;
    }
}