package com.digiwin.athena.semc.service.portal.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.dto.portal.SaveLayoutReq;
import com.digiwin.athena.semc.entity.portal.PortalLayout;
import com.digiwin.athena.semc.mapper.portal.PortalLayoutMapper;
import com.digiwin.athena.semc.service.portal.IPortalLayoutService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
public class PortalLayoutServiceImpl extends ServiceImpl<PortalLayoutMapper, PortalLayout> implements IPortalLayoutService {

    @Autowired
    PortalLayoutMapper portalLayoutMapper;

    /**
     * 查询首页个性化展示组件
     *
     * @param labelId 组件id
     * @return
     */
    @Override
    public List<PortalLayout> queryPortalLayoutList(Long labelId) {
        QueryWrapper<PortalLayout> condition = new QueryWrapper<>();
        if (labelId != null) {
            condition.eq("label_id", labelId);
            condition.eq("default_flag", Constants.DEFAULT_CONFIGURED_FLAG_NO);
        }
        condition.orderByAsc("label_index");
        return portalLayoutMapper.selectList(condition);
    }

    /**
     * 保存首页个性化展示组件
     *
     * @param saveLayoutReq 请求实体
     * @return
     */
    @Override
    @Transactional
    public boolean savePortalLayout(SaveLayoutReq saveLayoutReq) {
        // 删除之前的配置
        QueryWrapper<PortalLayout> condition = new QueryWrapper<>();
        condition.eq("default_flag", Constants.DEFAULT_CONFIGURED_FLAG_NO);
        portalLayoutMapper.delete(condition);
        // 保存
        return this.saveBatch(saveLayoutReq.getLayoutList());
    }
}