package com.digiwin.athena.semc.service.portal.impl;

import com.google.common.collect.Lists;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.BizException;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.EAIServiceNameEnum;
import com.digiwin.athena.semc.common.enums.ProtocolTypeEnum;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.LabelSystemDataDto;
import com.digiwin.athena.semc.dto.portal.LabelSystemPreReq;
import com.digiwin.athena.semc.entity.portal.Report;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.portal.ReportMapper;
import com.digiwin.athena.semc.proxy.esp.service.ESPService;
import com.digiwin.athena.semc.proxy.tripartite.service.TripartiteService;
import com.digiwin.athena.semc.service.portal.LabelSystemDataService;
import com.digiwin.athena.semc.service.portal.ReportService;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import javax.annotation.Resource;

/**
 * 报表(Report)表服务实现类
 *
 * @author sunyfa
 * @since 2022-12-06 10:53:04
 */
@Service("reportService")
public class ReportServiceImpl extends ServiceImpl<ReportMapper, Report> implements ReportService {


    @Resource
    private ESPService espService;

    @Autowired
    LabelSystemDataService labelSystemDataService;

    @Autowired
    TripartiteService tripartiteService;

    @Resource
    EnvProperties envProperties;

    @Override
    public ResultPageBean pageQueryReport(LabelSystemPreReq req) {
        ResultPageBean resultPageBean = ResultPageBean.success(null);
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        Long tenantSid = AppAuthContextHolder.getContext().getAuthoredUser().getTenantSid();
        String token = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        //查询数据源信息和sso信息
        LabelSystemDataDto labelSystemDataDto = labelSystemDataService.getSystemDataSso(req.getId());
        if (null == labelSystemDataDto) {
            return ResultPageBean.bizException(BizException.getDefaultBizException(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, "数据源不存在"));
        }
        String appToken = StringUtils.isBlank(labelSystemDataDto.getAppToken()) ? envProperties.getAppToken() : labelSystemDataDto.getAppToken();
        Map<String, Object> result = new HashMap<>();
        Map<String, String> extHeader = new HashMap<>();
        extHeader.put("digi-userToken", token);
        extHeader.put("digi-appToken", appToken);
        //混合云模式，走esp-互联网中台-三方地端服务
        if (Constants.DataModelEnum.MODEL_HYBRID_CLOUD.getVal().equals(labelSystemDataDto.getDataModel())) {
            // 通过 EAI 调用三方接口获取报表数据
            result = espService.queryByEsp(labelSystemDataDto.getMiddleSystemName(), labelSystemDataDto.getMiddleSystemUid(),
                    EAIServiceNameEnum.REPORT.getServiceName(), extHeader, null, req.getQryCondition(),
                    PageInfo.getPageInfo(req.getPageNum(), req.getPageSize()));
        }//非混合云模式
        else {
            result = tripartiteService.selectDataPagePost(labelSystemDataDto.getRestUrl(),req,appToken);
        }
        if (ProtocolTypeEnum.OAUTH.getType() == labelSystemDataDto.getProtocolType()) {
            //解析结果
            if (Objects.nonNull(result.get("report_info_list"))) {
                Integer totalResults = Integer.parseInt(result.get("total_results").toString());
                JSONArray array = JSONArray.fromObject(result.get("report_info_list"));
                List<JSONObject> list = Lists.newArrayList();
                for (int i = 0; i < array.size(); i++) {
                    net.sf.json.JSONObject jsonObject = array.getJSONObject(i);
                    String reportUrl = jsonObject.getString("report_url");
                    jsonObject.put("report_url", reportUrl + (reportUrl.contains("?") ? "&" : "?") + "appToken=" + appToken + "&tenantId=" + tenantId + "&bindMode=" + labelSystemDataDto.getUserBindFlag());
                    list.add(jsonObject);
                }
                resultPageBean = ResultPageBean.success(ResponseBody.getInstance(list, PageInfo.getPageInfo(req.getPageNum(), req.getPageSize(), totalResults)));
            }
        }
        if (ProtocolTypeEnum.CAS.getType() == labelSystemDataDto.getProtocolType() && ApplicationTypeEnum.CS_APPLICATION.getType().equals(labelSystemDataDto.getDataType())){
            //解析结果
            if (Objects.nonNull(result.get("report_info_list"))) {
                Integer totalResults = Integer.parseInt(result.get("total_results").toString());
                JSONArray array = JSONArray.fromObject(result.get("report_info_list"));
                List<JSONObject> list = Lists.newArrayList();
                for (int i = 0; i < array.size(); i++) {
                    net.sf.json.JSONObject jsonObject = array.getJSONObject(i);
                    String reportUrl = jsonObject.getString("report_url");
//                    jsonObject.put("report_url", reportUrl + (reportUrl.contains("?") ? "&" : "?") + "appToken=" + labelSystemDataDto.getAppToken() + "&tenantId=" + tenantId + "&bindMode=" + labelSystemDataDto.getUserBindFlag()
//                    + "&cas_server=" + labelSystemDataDto.getCasServerUrl() + "&tenantSid=" + AESUtils.aesEncrypt(String.valueOf(tenantSid),AESUtils.CAS_AES_KEY));
                    jsonObject.put("report_url", reportUrl);
                    list.add(jsonObject);
                }
                resultPageBean = ResultPageBean.success(ResponseBody.getInstance(list, PageInfo.getPageInfo(req.getPageNum(), req.getPageSize(), totalResults)));
            }
        }
        if (ProtocolTypeEnum.CAS.getType() == labelSystemDataDto.getProtocolType() && ApplicationTypeEnum.BS_APPLICATION.getType().equals(labelSystemDataDto.getDataType())){
            //解析结果
            if (Objects.nonNull(result.get("report_info_list"))) {
                Integer totalResults = Integer.parseInt(result.get("total_results").toString());
                JSONArray array = JSONArray.fromObject(result.get("report_info_list"));
                List<JSONObject> list = Lists.newArrayList();
                for (int i = 0; i < array.size(); i++) {
                    net.sf.json.JSONObject jsonObject = array.getJSONObject(i);
                    jsonObject.put("report_url", labelSystemDataDto.getCasServerUrl());
                    list.add(jsonObject);
                }
                resultPageBean = ResultPageBean.success(ResponseBody.getInstance(list, PageInfo.getPageInfo(req.getPageNum(), req.getPageSize(), totalResults)));
            }
        }
        return resultPageBean;
    }
}

