package com.digiwin.athena.semc.service.portal.impl;

import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.ss.util.CellRangeAddress;

public class SystemCustomWriteHandler implements SheetWriteHandler {
    @Override
    public void beforeSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {

    }

    @Override
    public void afterSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
        Workbook workbook = writeWorkbookHolder.getWorkbook();
        Sheet sheet = workbook.getSheetAt(0);
        // 插入说明
        String word = "说明：\n" +
                "1、标*的为必填项；\n" +
                "2、数据源名称：该组件希望绑定的数据源名称";
        Row row0 = sheet.createRow(0);
        setRow(row0, workbook, word, (short) 900, (short)220, 0);

        // 合并
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 5));
    }

    private void setRow(Row row, Workbook workbook, String word, short height, short fontHeight, int cellNum) {
        row.setHeight(height);
        Cell cell = row.createCell(cellNum);
        cell.setCellValue(word);
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        cellStyle.setWrapText(true);
        Font font = workbook.createFont();
        //设置字体
        font.setFontName("宋体");
        font.setFontHeightInPoints((short)11);
        //加粗
        //font.setBold(true);
        font.setFontHeight(fontHeight);
      //  font.setColor(IndexedColors.BLACK.getIndex());
        cellStyle.setFont(font);
        cell.setCellStyle(cellStyle);
    }
}
