package com.digiwin.athena.semc.service.portal.impl;

import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.ss.util.CellRangeAddress;

public class SystemDataWriteHandler implements SheetWriteHandler {
    @Override
    public void beforeSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {

    }

    @Override
    public void afterSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
        Workbook workbook = writeWorkbookHolder.getWorkbook();
        Sheet sheet = workbook.getSheetAt(0);
        // 插入说明
        String word = "说明：\n" +
                "1、标*的为必填项；\n" +
                "2、如果数据源分类选择“作业集成”则“作业填写方式”需要选择一个枚举值\n" +
                "2.1 选择“作业名称”：则在“作业值”字段需要填写已经和我们打通了作业接口应用的作业名称\n" +
                "2.2 某些应用有多个作业名称相同的场景，此时作业值填写作业code\n" +
                "2.3 选择“作业回调地址”：指应用没有和我们打通作业接口，在“作业值”字段填写该应用的作业回调地址\n" +
                "3、如果数据源分类选择“应用集成”、“三方待办”，则“作业填写方式”和“作业值”都不用填写，保持为空";
        Row row0 = sheet.createRow(0);
        setRow(row0, workbook, word, (short) 2000, (short) 220, 0);
        // 合并
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 7));
    }

    private void setRow(Row row, Workbook workbook, String word, short height, short fontHeight, int cellNum) {
        row.setHeight(height);
        Cell cell = row.createCell(cellNum);
        cell.setCellValue(word);
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        cellStyle.setWrapText(true);
        Font font = workbook.createFont();
        //设置字体
        font.setFontName("宋体");
        font.setFontHeightInPoints((short)11);
        //加粗
        //font.setBold(true);
        font.setFontHeight(fontHeight);
        //font.setColor(IndexedColors.BLACK.getIndex());
        cellStyle.setFont(font);
        cell.setCellStyle(cellStyle);
    }
}
