package com.digiwin.athena.semc.service.portal.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.dto.message.DeleteMessageConfigReq;
import com.digiwin.athena.semc.dto.message.QueryThirdMessageConfigReq;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplication;
import com.digiwin.athena.semc.entity.portal.ThirdTodoConfig;
import com.digiwin.athena.semc.entity.sso.ErpSsoInfo;
import com.digiwin.athena.semc.entity.sso.ThirdSsoInfo;
import com.digiwin.athena.semc.mapper.portal.ThirdTodoConfigMapper;
import com.digiwin.athena.semc.service.portal.IPreinstalledApplicationService;
import com.digiwin.athena.semc.service.portal.ThirdTodoConfigService;
import com.digiwin.athena.semc.service.sso.IErpSsoInfoService;
import com.digiwin.athena.semc.service.sso.IThirdSsoInfoService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


@Service
@Slf4j
public class ThirdTodoConfigServiceImpl extends ServiceImpl<ThirdTodoConfigMapper, ThirdTodoConfig> implements ThirdTodoConfigService {

    @Autowired
    private ThirdTodoConfigMapper thirdTodoConfigMapper;

    @Resource
    private IPreinstalledApplicationService preinstalledApplicationService;

    @Autowired
    IErpSsoInfoService erpSsoInfoService;

    @Autowired
    IThirdSsoInfoService thirdSsoInfoService;

    @Override
    public Integer saveThirdToDo(ThirdTodoConfig req) {
        req.setModifyUserId(Utils.getUserId());
        req.setModifyTime(DateUtils.getNowTime(""));
        if(null == req.getId()){
            thirdTodoConfigMapper.insert(req);
        }else {
            thirdTodoConfigMapper.updateById(req);
        }
        return  null;
    }

    @Override
    public Integer delThirdToDo(DeleteMessageConfigReq req) {
        return thirdTodoConfigMapper.deleteBatchIds(req.getIdList());
    }

    @Override
    public PageInfoResp<ThirdTodoConfig> queryConfigPage(QueryThirdMessageConfigReq req) {
        QueryWrapper<ThirdTodoConfig> condition = new QueryWrapper<>();
        if (StringUtils.isNotBlank(req.getAppPrimaryId())) {
            condition.eq("app_primary_id", req.getAppPrimaryId());
        }
        if (req.getAppSource() != null) {
            condition.eq("app_source", req.getAppSource());
        }
        if (req.getValidStatus() != null) {
            condition.eq("valid_status", req.getValidStatus());
        }
        if (req.getDataGetType() != null) {
            condition.eq("data_get_type", req.getDataGetType());
        }
        condition.orderByDesc("modify_time");
        condition.eq("tenant_id", AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());

        // 查询
        PageInfoResp<ThirdTodoConfig> pageInfoResp = new PageInfoResp<>();
        Page<ThirdTodoConfig> pageResult = thirdTodoConfigMapper.selectPage(new Page<>(req.getPageNum(), req.getPageSize()), condition);
        if (pageResult == null || CollectionUtils.isEmpty(pageResult.getRecords())) {
            return pageInfoResp;
        }

        // 获取应用名称
        List<ThirdTodoConfig> toDoConfigList = pageResult.getRecords();
        //组装应用名称
        packageAppCodeName(toDoConfigList);
        pageInfoResp.setTotalPages(Integer.parseInt(String.valueOf(pageResult.getPages())));
        pageInfoResp.setPageNo(req.getPageNum());
        pageInfoResp.setPageSize(req.getPageSize());
        pageInfoResp.setTotalRecords(Integer.parseInt(String.valueOf(pageResult.getTotal())));
        pageInfoResp.setList(toDoConfigList);
        return pageInfoResp;
    }

    /**
     * 组装应用名称
     *
     * @param toDoConfigList 作业应用配置列表
     */
    public void packageAppCodeName(List<ThirdTodoConfig> toDoConfigList) {
        //根据源应用来源（ 0：CS、1：BS、2：平台预设、3：雅典娜应用）拆分数据
        //CS应用
        List<ThirdTodoConfig> csList = toDoConfigList.stream().filter(item -> ApplicationTypeEnum.CS_APPLICATION.getType().equals(item.getAppSource())).collect(Collectors.toList());
        List<String> csIdList = csList.stream().map(ThirdTodoConfig::getAppPrimaryId).collect(Collectors.toList());
        Map<Long, ErpSsoInfo> erpInfoMap = erpSsoInfoService.getErpInfoMap(csIdList);
        //BS应用
        List<ThirdTodoConfig> bsList = toDoConfigList.stream().filter(item -> ApplicationTypeEnum.BS_APPLICATION.getType().equals(item.getAppSource())).collect(Collectors.toList());
        List<String> bsIdList = bsList.stream().map(ThirdTodoConfig::getAppPrimaryId).collect(Collectors.toList());
        Map<Long, ThirdSsoInfo> thirdSsoInfoMap = thirdSsoInfoService.getSsoInfoMap(bsIdList);
        //预设应用
        Map<Long, PreinstalledApplication> preInfoMap = preinstalledApplicationService.getPreInfoMap();
        for (ThirdTodoConfig toDoConfig : toDoConfigList) {
            String appName = "";
            //cs
            if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(toDoConfig.getAppSource())) {
                ErpSsoInfo erpSsoInfo = erpInfoMap.get(Long.parseLong(toDoConfig.getAppPrimaryId()));
                if (null != erpSsoInfo) {
                    appName = erpSsoInfo.getName();
                }
            }
            //bs
            if (ApplicationTypeEnum.BS_APPLICATION.getType().equals(toDoConfig.getAppSource())) {
                ThirdSsoInfo thirdSsoInfo = thirdSsoInfoMap.get(Long.parseLong(toDoConfig.getAppPrimaryId()));
                if (thirdSsoInfo != null) {
                    appName = thirdSsoInfo.getAppName();
                }
            }
            //预设
            if (ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(toDoConfig.getAppSource())) {
                PreinstalledApplication preinstalledApplication = preInfoMap.get(Long.parseLong(toDoConfig.getAppPrimaryId()));
                if (null != preinstalledApplication) {
                    appName = preinstalledApplication.getApplicationName();
                }
            }
            toDoConfig.setAppName(appName);
        }
    }

    @Override
    public boolean validConfigExist(ThirdTodoConfig req) {
        QueryWrapper<ThirdTodoConfig> condition = new QueryWrapper<>();
        condition.eq("app_source", req.getAppSource());
        condition.eq("app_primary_id", req.getAppPrimaryId());
        if (req.getId() != null) {
            condition.ne("id", req.getId());
        }
        ThirdTodoConfig config = thirdTodoConfigMapper.selectOne(condition);
        if (null != config) {
            return true;
        }
        return false;
    }

    @Override
    public ThirdTodoConfig getToDoConfigBy(String appCode, String appId) {
        return thirdTodoConfigMapper.getToDoConfigBy(appCode,appId);
    }
}
