package com.digiwin.athena.semc.service.portal.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.entity.portal.TodoAppSort;
import com.digiwin.athena.semc.mapper.portal.TodoAppSortMapper;
import com.digiwin.athena.semc.service.portal.TodoAppSortService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service
@Slf4j
public class TodoAppSortServiceImpl extends ServiceImpl<TodoAppSortMapper, TodoAppSort> implements TodoAppSortService {

    @Override
    public List<TodoAppSort> getCurrentUserAppSort() {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        LambdaQueryWrapper<TodoAppSort> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TodoAppSort::getUserId, authoredUser.getUserId());
        queryWrapper.eq(TodoAppSort::getTenantId, authoredUser.getTenantId());
        List<TodoAppSort> list = list(queryWrapper);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        list.sort(Comparator.comparingInt(TodoAppSort::getAppSort));
        return list;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean save(List<String> appIdList) {
        if (CollectionUtils.isEmpty(appIdList)) {
            return false;
        }
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        String userId = authoredUser.getUserId();
        String tenantId = authoredUser.getTenantId();
        LambdaQueryWrapper<TodoAppSort> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TodoAppSort::getUserId, userId);
        queryWrapper.eq(TodoAppSort::getTenantId, tenantId);
        remove(queryWrapper);
        List<TodoAppSort> list = Lists.newArrayListWithExpectedSize(appIdList.size());
        for (int i = 0; i < appIdList.size(); i++) {
            TodoAppSort todoAppSort = new TodoAppSort();
            todoAppSort.setAppId(appIdList.get(i));
            todoAppSort.setAppSort(i);
            todoAppSort.setUserId(userId);
            todoAppSort.setTenantId(tenantId);
            todoAppSort.setCreateTime(DateUtil.now());
            list.add(todoAppSort);
        }
        saveBatch(list);
        return true;
    }

    @Override
    public List<LabelSystemData> sortLabelSystemData(List<LabelSystemData> labelSystemDataList) {
//应用排序（先按用户指定的顺序排序，后面的按应用名称进行排序）
        labelSystemDataList.sort(Comparator.comparing(LabelSystemData::getAppName));
        List<TodoAppSort> appSortList = getCurrentUserAppSort();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(appSortList)) {
            return labelSystemDataList;
        }
        List<LabelSystemData> appSortLSDList = Lists.newArrayList();
        Set<String> appSortAppIdSet = Sets.newTreeSet();
        Map<String, LabelSystemData> labelSystemDataMap = labelSystemDataList.stream().collect(Collectors.toMap(LabelSystemData::getAppId, Function.identity(), (a, b) -> a));
        appSortList.forEach(m -> {
            LabelSystemData labelSystemData = labelSystemDataMap.get(m.getAppId());
            if (null != labelSystemData) {
                appSortLSDList.add(labelSystemData);
                appSortAppIdSet.add(m.getAppId());
            }
        });
        List<LabelSystemData> resultList = Lists.newArrayList();
        resultList.addAll(appSortLSDList);
        /*labelSystemDataList.forEach(m -> {
            if (!appSortAppIdSet.contains(m.getAppId())) {
                resultList.add(m);
            }
        });*/
        for(LabelSystemData labelSystemData : labelSystemDataList){
            if (StringUtils.isBlank(labelSystemData.getAppId())){
                continue;
            }
            if (!appSortAppIdSet.contains(labelSystemData.getAppId())){
                resultList.add(labelSystemData);
            }
        }
        return resultList;
    }


}
