package com.digiwin.athena.semc.service.portal.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.configuration.mqtt.MqttGateway;
import com.digiwin.athena.semc.configuration.mqtt.MqttProperties;
import com.digiwin.athena.semc.dto.mq.MessageDO;
import com.digiwin.athena.semc.entity.portal.TodoList;
import com.digiwin.athena.semc.mapper.portal.TodoListMapper;
import com.digiwin.athena.semc.vo.portal.NoticeVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author CR-7
 * create: 2024-03-27 13:24
 * Description:  待办通知公共方法
 */
@Slf4j
@Component
public  class TodoNoticeMq {


    @Resource
    private MqttGateway mqttGateway;
    @Resource
    private MqttProperties mqttConfiguration;
    @Resource
    private TodoListMapper todoListMapper;

    /**
     * 待办有更新通知前端
     * @param noticeVO
     */
    public void sendMessageToMqtt(NoticeVO noticeVO, List<TodoList> todoList) {
        try {

            String topic = mqttConfiguration.getClientId() + "/" + mqttConfiguration.getServerName() + "/" + Constants.SEMC_TODO_USER;
            log.info("【sendMessageToMqtt-待办通知用户】topic:{}", topic);

            for(TodoList todo:todoList){
                MessageDO payload = new MessageDO();
                payload.setUserId(todo.getToDoUser());
                payload.setAppId(noticeVO.getAppId());
                payload.setAppName(noticeVO.getAppName());
                payload.setType(Constants.VALID_STATUS_UNUSABLE);
                String message = JSON.toJSONString(payload);
                mqttGateway.sendToMqtt(topic, 2, message);
                log.info("【sendMessageToMqtt-待办通知用户成功】topic:{}", topic);
            }
        } catch (Exception e) {
            log.info("【sendMessageMq-待办通知用户成功】e:{}", e);
        }
    }



    public List<TodoList> selectToDoBy(String appId,String toDoId){
        QueryWrapper queryWrapper = new QueryWrapper<TodoList>();
        //应用查询
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(appId)) {
            queryWrapper.eq("app_id", appId);
        }
        //外部待办唯一id
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(toDoId)) {
            queryWrapper.eq("to_do_id", toDoId);
        }
        return  todoListMapper.selectList(queryWrapper);
    }
}
