package com.digiwin.athena.semc.service.portal.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;

import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;

import com.digiwin.athena.semc.dto.portal.NoticeReq;
import com.digiwin.athena.semc.entity.portal.SyncToDoRecord;
import com.digiwin.athena.semc.entity.portal.TodoList;
import com.digiwin.athena.semc.entity.portal.TodoRead;
import com.digiwin.athena.semc.mapper.portal.SyncToDoRecordMapper;
import com.digiwin.athena.semc.service.cache.RedisLock;
import com.digiwin.athena.semc.service.portal.TodoListService;
import com.digiwin.athena.semc.service.portal.TodoNoticeService;
import com.digiwin.athena.semc.service.portal.TodoReadService;
import com.digiwin.athena.semc.util.AESUtils;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.vo.portal.NoticeVO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

import javax.annotation.Resource;
import java.util.List;


/**
 * @author CR-7
 * create: 2024-03-25 18:01
 * Description:
 */
@Slf4j
@Service
public class TodoNoticeServiceImpl implements TodoNoticeService {

    @Resource
    private TodoListService todoListService;
    @Resource
    private TodoReadService todoReadService;
    @Resource
    TodoNoticeMq todoNoticeMq;
    @Resource
    private SyncToDoRecordMapper syncToDoRecordMapper;



    @Override
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity<?> notice(NoticeReq noticeReq) {
        log.info("notice param:{}", JSON.toJSONString(noticeReq));
        String bodyJsonStr = noticeReq.getBodyJsonStr();
        if (StringUtils.isEmpty(bodyJsonStr)) {
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_MISSING_ERROR, "missing bodyJsonStr parameter");
        }
        // 解密
        String jsonBodyDecrypt = AESUtils.aesDecrypt(bodyJsonStr, Constants.SYNC_SECRET);
        NoticeVO noticeVO = JSON.parseObject(jsonBodyDecrypt, NoticeVO.class);
        //接收待办完结通知并通知前端
        return  noticeToDo(noticeVO,JSON.toJSONString(noticeReq),true);
    }

    /**
     * 接收待办完结通知并通知前端
     * @param noticeVO
     * @param reqJson 请求json字符串
     * @param isToWeb true：通知web端
     * @return
     */
    public ResponseEntity<?> noticeToDo(NoticeVO noticeVO,String reqJson,Boolean isToWeb){
        if (StringUtils.isEmpty(noticeVO.getBizId())) {
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_MISSING_ERROR, "missing bodyJsonStr parameter");
        }
        if (StringUtils.isEmpty(noticeVO.getAppId())) {
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_MISSING_ERROR, "missing bodyJsonStr parameter");
        }
        SyncToDoRecord toDoRecord=new SyncToDoRecord();
        toDoRecord.setAppId(noticeVO.getAppId());
        toDoRecord.setToDoId(noticeVO.getBizId());
        toDoRecord.setDataModel(1);
        toDoRecord.setReqJson(reqJson);
        toDoRecord.setSyncType(0);
        toDoRecord.setSyncStatus(0);
        List<TodoList> todoListDb = todoNoticeMq.selectToDoBy(noticeVO.getAppId(),noticeVO.getBizId());
        RedisLock redisLock = new RedisLock("thirdTodoNotice:"+noticeVO.getBizId());
        //分布式锁
        try {
            if(!redisLock.lock()){
                return ResponseEntityWrapper.wrapperOk();
            }
        } catch (InterruptedException e) {
            return ResponseEntityWrapper.wrapperOk();
        }
        // 删除待办,待办已读 数据
        try {
            LambdaUpdateWrapper<TodoList> updateTodoListWrapper = new LambdaUpdateWrapper<>();
            updateTodoListWrapper.eq(TodoList::getAppId,noticeVO.getAppId());
            updateTodoListWrapper.eq(TodoList::getToDoId,noticeVO.getBizId());
            todoListService.remove(updateTodoListWrapper);

            LambdaUpdateWrapper<TodoRead> updateTodoReadWrapper = new LambdaUpdateWrapper<>();
            updateTodoReadWrapper.eq(TodoRead::getAppId,noticeVO.getAppId());
            updateTodoReadWrapper.eq(TodoRead::getToDoId,noticeVO.getBizId());
            todoReadService.remove(updateTodoReadWrapper);
            if(isToWeb){
                // mqtt通知前端消息,事务同步器事务提交后发送mqtt消息
                TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronization() {
                    @Override
                    public void afterCommit() {
                        todoNoticeMq.sendMessageToMqtt(noticeVO,todoListDb);
                    }
                });
            }
        } catch (Exception e) {
            log.error("notice third.todo.notice   error", e);
            toDoRecord.setSyncStatus(1);
            toDoRecord.setRespJson(e.getMessage());
        } finally {
            redisLock.unlock();
        }
        syncToDoRecordMapper.addRecord(toDoRecord);
        return ResponseEntityWrapper.wrapperOk();
    }

    @Override
    public ResponseEntity<?> noticeBat(NoticeVO noticeReqList) {
         for(String bizId:noticeReqList.getBizIdList()){
             noticeReqList.setBizId(bizId);
             //接收待办完结通知并通知前端
             noticeToDo(noticeReqList,JSON.toJSONString(bizId),false);
         }
        return ResponseEntityWrapper.wrapperOk();
    }
}
