package com.digiwin.athena.semc.service.portal.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.dto.portal.TodoReadReq;
import com.digiwin.athena.semc.entity.portal.TodoList;
import com.digiwin.athena.semc.entity.portal.TodoRead;
import com.digiwin.athena.semc.mapper.portal.TodoListMapper;
import com.digiwin.athena.semc.mapper.portal.TodoReadMapper;
import com.digiwin.athena.semc.service.portal.TodoReadService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;

/**
 * @author CR-7
 * create: 2024-03-23 17:29
 * Description:
 */
@Slf4j
@Service
public class TodoReadServiceImpl extends ServiceImpl<TodoReadMapper, TodoRead> implements TodoReadService {


    @Resource
    TodoListMapper todoListMapper;

    @Resource
    TodoReadMapper todoReadMapper;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity<?> toRead(TodoReadReq todoReadReq) {
        LambdaQueryWrapper<TodoList> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TodoList::getId,todoReadReq.getId());
        TodoList todoList = todoListMapper.selectOne(queryWrapper);

        if (!ObjectUtils.isEmpty(todoList)) {
            TodoList entity = new TodoList();
            entity.setIsRead(1);
            entity.setId(todoReadReq.getId());
            todoListMapper.updateById(entity);

            log.info("待办id,id:{}",todoReadReq.getId());
            TodoRead todoRead = new TodoRead();
            todoRead.setToDoId(todoList.getToDoId());
            todoRead.setAccountId(todoList.getAccountId());
            todoRead.setToDoUser(todoList.getToDoUser());
            todoRead.setAppIdCode(todoList.getAppIdCode());
            todoRead.setAppId(todoList.getAppId());
            todoRead.setCreateUserId(AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
            return ResponseEntityWrapper.wrapperOk(todoReadMapper.insert(todoRead));
        }

        return null;
    }
}
