package com.digiwin.athena.semc.service.portal.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.configuration.mqtt.MqttGateway;
import com.digiwin.athena.semc.configuration.mqtt.MqttProperties;
import com.digiwin.athena.semc.dto.mq.MessageDO;
import com.digiwin.athena.semc.entity.portal.TodosRefreshSet;
import com.digiwin.athena.semc.mapper.portal.TodosRefreshSetMapper;
import com.digiwin.athena.semc.service.portal.TodosRefreshSetService;
import com.digiwin.athena.semc.util.DateUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


/**
 * 三方待办刷新频率设置
 */
@Service
@Slf4j
public class TodosRefreshSetServiceImpl extends ServiceImpl<TodosRefreshSetMapper, TodosRefreshSet> implements TodosRefreshSetService {

    @Autowired
    private MqttGateway mqttGateway;

    @Autowired
    private MqttProperties mqttConfiguration;

    @Autowired
    private  TodosRefreshSetMapper todosRefreshSetMapper;

    @Override
    public TodosRefreshSet getRefreshSet(String tenantId) {
        return todosRefreshSetMapper.selByTenantId(tenantId);
    }

    @Override
    @Transactional
    public int saveRefreshSet(TodosRefreshSet refreshSet) {
        TodosRefreshSet refreshSetDb = todosRefreshSetMapper.selByTenantId(refreshSet.getTenantId());
        if (null == refreshSetDb) {
            //通知前端配置有更新
            sendTodoMQ(refreshSet.getTenantId());
            return todosRefreshSetMapper.insert(refreshSet);
        }
        refreshSetDb.setTodoDetailTime(refreshSet.getTodoDetailTime());
        refreshSetDb.setTabsTime(refreshSet.getTabsTime());
        refreshSetDb.setModifyUserId(refreshSet.getModifyUserId());
        refreshSetDb.setModifyTime(DateUtils.getNowTime(""));
        refreshSetDb.setIsOpen(refreshSet.getIsOpen());
        int i =todosRefreshSetMapper.updateById(refreshSetDb);
        //通知前端配置有更新
        sendTodoMQ(refreshSetDb.getTenantId());
        return i;
    }

    /**
     * 通知前端配置有更新
     * @param tenantId
     */
    public void sendTodoMQ(String tenantId) {
        try {
            String topic = mqttConfiguration.getClientId() + "/" + mqttConfiguration.getServerName() + "/" + Constants.SEMC_TODO_TENANT + "/" +tenantId;
            log.info("【saveRefreshSet-通知租户设置变更通知开始】topic:{},message:{}", topic, tenantId);
            MessageDO payload = new MessageDO();
            payload.setTenantId(tenantId);
            //0：EFNET通知刷新；1：三方待办设置
            payload.setType(Constants.PRESCRIBED_ROUTE);
            String message = JSONObject.toJSONString(payload);
            mqttGateway.sendToMqtt(topic, 2, message);
            log.info("【saveRefreshSet-通知租户设置变更通知成功】topic:{},message:{}", topic, tenantId);
        } catch (Exception e) {
            log.info("【saveRefreshSet-通知租户设置变更通知异常】TenantId:{},e:{}", tenantId, e);
        }
    }
}
