package com.digiwin.athena.semc.service.portal.impl;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.dto.fineReport.FineReportConfigDTO;
import com.digiwin.athena.semc.entity.portal.TripartiteApplication;
import com.digiwin.athena.semc.mapper.portal.TripartiteApplicationMapper;
import com.digiwin.athena.semc.service.cache.CommonConfigService;
import com.digiwin.athena.semc.service.portal.TripartiteApplicationService;
import com.digiwin.athena.semc.util.Utils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * * 三方应用配置服务实现类
 *
 * @author sunqgz
 * @since 2024-08-11
 */
@Slf4j
@Service
public class TripartiteApplicationServiceImpl extends ServiceImpl<TripartiteApplicationMapper, TripartiteApplication> implements TripartiteApplicationService {

    @Resource
    TripartiteApplicationMapper tripartiteApplicationMapper;

    @Resource
    CommonConfigService commonConfigService;

    /**
     * 查询三方应用列表
     *
     * @return 返回
     */
    @Override
    public List<TripartiteApplication> queryTripartiteAppList() {
        // 查询三方应用列表
        List<TripartiteApplication> applicationList = tripartiteApplicationMapper.selectList(Wrappers.emptyWrapper());
        // 过滤出默认的三方应用
        List<TripartiteApplication> baseApplicationList = applicationList.stream().filter(x -> StringUtils.isBlank(x.getTenantId())).collect(Collectors.toList());

        // 过滤出当前租户下的三方应用，不在默认的列表中则需要初始化
        List<TripartiteApplication> tenantApplicationList = applicationList.stream().filter(x -> Utils.getTenantId().equals(x.getTenantId())).collect(Collectors.toList());
        List<String> tenantApplicationCodeList = tenantApplicationList.stream().map(TripartiteApplication::getApplicationCode).collect(Collectors.toList());
        List<TripartiteApplication> needInitializeList = baseApplicationList.stream().filter(x -> !tenantApplicationCodeList.contains(x.getApplicationCode())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(needInitializeList)) {
            needInitializeList.forEach(x -> {
                x.setId(null);
                x.setTenantId(Utils.getTenantId());
                tripartiteApplicationMapper.insert(x);
                tenantApplicationList.add(x);
            });
        }
        return tenantApplicationList;
    }

    /**
     * 查询当前租户的帆软应用配置
     *
     * @return 返回
     */
    @Override
    public FineReportConfigDTO queryFineReportConfig() {
        FineReportConfigDTO fineReportConfigDTO = commonConfigService.queryFineReportConfigCache(Utils.getTenantId());
        if (ObjectUtils.isEmpty(fineReportConfigDTO)) {
            LambdaQueryWrapper<TripartiteApplication> condition = new LambdaQueryWrapper<>();
            condition.eq(TripartiteApplication::getTenantId, Utils.getTenantId());
            List<TripartiteApplication> tripartiteApplicationList = tripartiteApplicationMapper.selectList(condition);
            if (CollectionUtils.isEmpty(tripartiteApplicationList)) {
                return null;
            }
            // 设置缓存
            TripartiteApplication tripartiteApplication = tripartiteApplicationList.get(0);
            fineReportConfigDTO = JSON.parseObject(tripartiteApplication.getApplicationConfig(), FineReportConfigDTO.class);
            commonConfigService.setFineReportConfigCache(fineReportConfigDTO, Utils.getTenantId());
        }
        return fineReportConfigDTO;
    }
}