package com.digiwin.athena.semc.service.portal.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.dto.portal.ActionFunctionResp;
import com.digiwin.athena.semc.entity.portal.ActionFunctionMapping;
import com.digiwin.athena.semc.mapper.portal.UserActionMapper;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.service.portal.IUserActionService;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @description 用户行为权限
 * @author: sungqz
 * @create: 2023-4-21
 */
@Service
public class UserActionServiceImpl extends ServiceImpl<UserActionMapper, ActionFunctionMapping> implements IUserActionService {

    @Resource
    private IamService iamService;

    @Autowired
    UserActionMapper userActionMapper;

    /**
     * 允许权限
     */
    private static final String ACCESS_ALLOW = "allow";

    /**
     * 功能侧，即功能的入口 0：前端 1：后端
     */
    private static final Integer FUNCTION_SIDE = 0;

    /**
     * 查询用户行为-功能映射列表
     *
     * @param authoredUser 用户信息
     * @return
     */
    @Override
    public List<ActionFunctionResp> queryUserFunctionList(AuthoredUser authoredUser) {
        List<ActionFunctionResp> functionRespList = Lists.newArrayList();
        // 调用IAM取得用户行为权限
        JSONArray jsonArray = iamService.queryUserPermissionV2(authoredUser);
        if (CollectionUtils.isEmpty(jsonArray)) {
            return functionRespList;
        }
        List<String> actionIdList = Lists.newArrayList();
        // 过滤出有权限的行为id
        for (int i = 0; i < jsonArray.size(); i++) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (StringUtils.equalsIgnoreCase(ACCESS_ALLOW, jsonObject.getString("effect"))) {
                actionIdList.add(jsonObject.getString("id"));
            }
        }
        if (CollectionUtils.isEmpty(actionIdList)) {
            return functionRespList;
        }

        // 查询行为对应的功能列表
        QueryWrapper<ActionFunctionMapping> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("function_side", FUNCTION_SIDE);
        queryWrapper.in("action_id", actionIdList);
        List<ActionFunctionMapping> functionMappingList = userActionMapper.selectList(queryWrapper);
        Map<String, List<ActionFunctionMapping>> actionIdMap = functionMappingList.stream().collect(Collectors.groupingBy(ActionFunctionMapping::getActionId));
        actionIdMap.forEach((k, v) -> {
            ActionFunctionResp actionFunctionResp = new ActionFunctionResp();
            actionFunctionResp.setActionId(k);
            actionFunctionResp.setActionName(v.get(0).getActionName());
            actionFunctionResp.setFunctionList(v);
            functionRespList.add(actionFunctionResp);
        });
        return functionRespList;
    }
}